/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.it.unimi.dsi.fastutil.booleans;

import com.gradle.maven.extension.internal.dep.it.unimi.dsi.fastutil.booleans.AbstractBooleanCollection;
import com.gradle.maven.extension.internal.dep.it.unimi.dsi.fastutil.booleans.BooleanArrays;
import com.gradle.maven.extension.internal.dep.it.unimi.dsi.fastutil.booleans.BooleanCollection;
import com.gradle.maven.extension.internal.dep.it.unimi.dsi.fastutil.booleans.BooleanConsumer;
import com.gradle.maven.extension.internal.dep.it.unimi.dsi.fastutil.booleans.BooleanIterator;
import com.gradle.maven.extension.internal.dep.it.unimi.dsi.fastutil.booleans.BooleanIterators;
import com.gradle.maven.extension.internal.dep.it.unimi.dsi.fastutil.booleans.BooleanList;
import com.gradle.maven.extension.internal.dep.it.unimi.dsi.fastutil.booleans.BooleanListIterator;
import com.gradle.maven.extension.internal.dep.it.unimi.dsi.fastutil.booleans.BooleanSpliterator;
import com.gradle.maven.extension.internal.dep.it.unimi.dsi.fastutil.booleans.BooleanSpliterators;
import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.RandomAccess;

public abstract class AbstractBooleanList
extends AbstractBooleanCollection
implements BooleanList {
    protected AbstractBooleanList() {
    }

    protected void ensureIndex(int n2) {
        if (n2 < 0) {
            throw new IndexOutOfBoundsException("Index (" + n2 + ") is negative");
        }
        if (n2 > this.size()) {
            throw new IndexOutOfBoundsException("Index (" + n2 + ") is greater than list size (" + this.size() + ")");
        }
    }

    protected void ensureRestrictedIndex(int n2) {
        if (n2 < 0) {
            throw new IndexOutOfBoundsException("Index (" + n2 + ") is negative");
        }
        if (n2 >= this.size()) {
            throw new IndexOutOfBoundsException("Index (" + n2 + ") is greater than or equal to list size (" + this.size() + ")");
        }
    }

    @Override
    public void add(int n2, boolean bl2) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean add(boolean bl2) {
        this.add(this.size(), bl2);
        return true;
    }

    @Override
    public boolean removeBoolean(int n2) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean set(int n2, boolean bl2) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(int n2, Collection<? extends Boolean> collection) {
        if (collection instanceof BooleanCollection) {
            return this.addAll(n2, (BooleanCollection)collection);
        }
        this.ensureIndex(n2);
        Iterator<? extends Boolean> iterator = collection.iterator();
        boolean bl2 = iterator.hasNext();
        while (iterator.hasNext()) {
            this.add(n2++, (boolean)iterator.next());
        }
        return bl2;
    }

    @Override
    public boolean addAll(Collection<? extends Boolean> collection) {
        return this.addAll(this.size(), collection);
    }

    @Override
    public BooleanListIterator iterator() {
        return this.listIterator();
    }

    @Override
    public BooleanListIterator listIterator() {
        return this.listIterator(0);
    }

    @Override
    public BooleanListIterator listIterator(int n2) {
        this.ensureIndex(n2);
        return new BooleanIterators.AbstractIndexBasedListIterator(0, n2){

            @Override
            protected final boolean get(int n2) {
                return AbstractBooleanList.this.getBoolean(n2);
            }

            @Override
            protected final void add(int n2, boolean bl2) {
                AbstractBooleanList.this.add(n2, bl2);
            }

            @Override
            protected final void set(int n2, boolean bl2) {
                AbstractBooleanList.this.set(n2, bl2);
            }

            @Override
            protected final void remove(int n2) {
                AbstractBooleanList.this.removeBoolean(n2);
            }

            @Override
            protected final int getMaxPos() {
                return AbstractBooleanList.this.size();
            }
        };
    }

    @Override
    public boolean contains(boolean bl2) {
        return this.indexOf(bl2) >= 0;
    }

    @Override
    public int indexOf(boolean bl2) {
        BooleanListIterator booleanListIterator = this.listIterator();
        while (booleanListIterator.hasNext()) {
            boolean bl3 = booleanListIterator.nextBoolean();
            if (bl2 != bl3) continue;
            return booleanListIterator.previousIndex();
        }
        return -1;
    }

    @Override
    public int lastIndexOf(boolean bl2) {
        BooleanListIterator booleanListIterator = this.listIterator(this.size());
        while (booleanListIterator.hasPrevious()) {
            boolean bl3 = booleanListIterator.previousBoolean();
            if (bl2 != bl3) continue;
            return booleanListIterator.nextIndex();
        }
        return -1;
    }

    @Override
    public BooleanList subList(int n2, int n3) {
        this.ensureIndex(n2);
        this.ensureIndex(n3);
        if (n2 > n3) {
            throw new IndexOutOfBoundsException("Start index (" + n2 + ") is greater than end index (" + n3 + ")");
        }
        return this instanceof RandomAccess ? new BooleanRandomAccessSubList(this, n2, n3) : new BooleanSubList(this, n2, n3);
    }

    @Override
    public void forEach(BooleanConsumer booleanConsumer) {
        if (this instanceof RandomAccess) {
            int n2 = this.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                booleanConsumer.accept(this.getBoolean(i2));
            }
        } else {
            BooleanList.super.forEach(booleanConsumer);
        }
    }

    @Override
    public void removeElements(int n2, int n3) {
        this.ensureIndex(n3);
        BooleanListIterator booleanListIterator = this.listIterator(n2);
        int n4 = n3 - n2;
        if (n4 < 0) {
            throw new IllegalArgumentException("Start index (" + n2 + ") is greater than end index (" + n3 + ")");
        }
        while (n4-- != 0) {
            booleanListIterator.nextBoolean();
            booleanListIterator.remove();
        }
    }

    @Override
    public void getElements(int n2, boolean[] blArray, int n3, int n4) {
        this.ensureIndex(n2);
        BooleanArrays.ensureOffsetLength(blArray, n3, n4);
        if (n2 + n4 > this.size()) {
            throw new IndexOutOfBoundsException("End index (" + (n2 + n4) + ") is greater than list size (" + this.size() + ")");
        }
        if (this instanceof RandomAccess) {
            int n5 = n2;
            while (n4-- != 0) {
                blArray[n3++] = this.getBoolean(n5++);
            }
        } else {
            BooleanListIterator booleanListIterator = this.listIterator(n2);
            while (n4-- != 0) {
                blArray[n3++] = booleanListIterator.nextBoolean();
            }
        }
    }

    @Override
    public void setElements(int n2, boolean[] blArray, int n3, int n4) {
        this.ensureIndex(n2);
        BooleanArrays.ensureOffsetLength(blArray, n3, n4);
        if (n2 + n4 > this.size()) {
            throw new IndexOutOfBoundsException("End index (" + (n2 + n4) + ") is greater than list size (" + this.size() + ")");
        }
        if (this instanceof RandomAccess) {
            for (int i2 = 0; i2 < n4; ++i2) {
                this.set(i2 + n2, blArray[i2 + n3]);
            }
        } else {
            BooleanListIterator booleanListIterator = this.listIterator(n2);
            int n5 = 0;
            while (n5 < n4) {
                booleanListIterator.nextBoolean();
                booleanListIterator.set(blArray[n3 + n5++]);
            }
        }
    }

    @Override
    public void clear() {
        this.removeElements(0, this.size());
    }

    @Override
    public int hashCode() {
        BooleanListIterator booleanListIterator = this.iterator();
        int n2 = 1;
        int n3 = this.size();
        while (n3-- != 0) {
            boolean bl2 = booleanListIterator.nextBoolean();
            n2 = 31 * n2 + (bl2 ? 1231 : 1237);
        }
        return n2;
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof List)) {
            return false;
        }
        List list = (List)object;
        int n2 = this.size();
        if (n2 != list.size()) {
            return false;
        }
        if (list instanceof BooleanList) {
            BooleanListIterator booleanListIterator = this.listIterator();
            BooleanListIterator booleanListIterator2 = ((BooleanList)list).listIterator();
            while (n2-- != 0) {
                if (booleanListIterator.nextBoolean() == booleanListIterator2.nextBoolean()) continue;
                return false;
            }
            return true;
        }
        BooleanListIterator booleanListIterator = this.listIterator();
        ListIterator listIterator = list.listIterator();
        while (n2-- != 0) {
            if (Objects.equals(booleanListIterator.next(), listIterator.next())) continue;
            return false;
        }
        return true;
    }

    @Override
    public int compareTo(List<? extends Boolean> list) {
        if (list == this) {
            return 0;
        }
        if (list instanceof BooleanList) {
            BooleanListIterator booleanListIterator = this.listIterator();
            BooleanListIterator booleanListIterator2 = ((BooleanList)list).listIterator();
            while (booleanListIterator.hasNext() && booleanListIterator2.hasNext()) {
                boolean bl2;
                boolean bl3 = booleanListIterator.nextBoolean();
                int n2 = Boolean.compare(bl3, bl2 = booleanListIterator2.nextBoolean());
                if (n2 == 0) continue;
                return n2;
            }
            return booleanListIterator2.hasNext() ? -1 : (booleanListIterator.hasNext() ? 1 : 0);
        }
        BooleanListIterator booleanListIterator = this.listIterator();
        ListIterator<? extends Boolean> listIterator = list.listIterator();
        while (booleanListIterator.hasNext() && listIterator.hasNext()) {
            int n3 = ((Comparable)booleanListIterator.next()).compareTo(listIterator.next());
            if (n3 == 0) continue;
            return n3;
        }
        return listIterator.hasNext() ? -1 : (booleanListIterator.hasNext() ? 1 : 0);
    }

    @Override
    public boolean rem(boolean bl2) {
        int n2 = this.indexOf(bl2);
        if (n2 == -1) {
            return false;
        }
        this.removeBoolean(n2);
        return true;
    }

    @Override
    public boolean[] toBooleanArray() {
        int n2 = this.size();
        if (n2 == 0) {
            return BooleanArrays.EMPTY_ARRAY;
        }
        boolean[] blArray = new boolean[n2];
        this.getElements(0, blArray, 0, n2);
        return blArray;
    }

    public boolean addAll(int n2, BooleanCollection booleanCollection) {
        this.ensureIndex(n2);
        BooleanIterator booleanIterator = booleanCollection.iterator();
        boolean bl2 = booleanIterator.hasNext();
        while (booleanIterator.hasNext()) {
            this.add(n2++, booleanIterator.nextBoolean());
        }
        return bl2;
    }

    @Override
    public boolean addAll(BooleanCollection booleanCollection) {
        return this.addAll(this.size(), booleanCollection);
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        BooleanListIterator booleanListIterator = this.iterator();
        int n2 = this.size();
        boolean bl2 = true;
        stringBuilder.append("[");
        while (n2-- != 0) {
            if (bl2) {
                bl2 = false;
            } else {
                stringBuilder.append(", ");
            }
            boolean bl3 = booleanListIterator.nextBoolean();
            stringBuilder.append(String.valueOf(bl3));
        }
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    public static class BooleanRandomAccessSubList
    extends BooleanSubList
    implements RandomAccess {
        public BooleanRandomAccessSubList(BooleanList booleanList, int n2, int n3) {
            super(booleanList, n2, n3);
        }

        @Override
        public BooleanList subList(int n2, int n3) {
            this.ensureIndex(n2);
            this.ensureIndex(n3);
            if (n2 > n3) {
                throw new IllegalArgumentException("Start index (" + n2 + ") is greater than end index (" + n3 + ")");
            }
            return new BooleanRandomAccessSubList(this, n2, n3);
        }
    }

    public static class BooleanSubList
    extends AbstractBooleanList
    implements Serializable {
        protected final BooleanList l;
        protected final int from;
        protected int to;

        public BooleanSubList(BooleanList booleanList, int n2, int n3) {
            this.l = booleanList;
            this.from = n2;
            this.to = n3;
        }

        private boolean assertRange() {
            assert (this.from <= this.l.size());
            assert (this.to <= this.l.size());
            assert (this.to >= this.from);
            return true;
        }

        @Override
        public boolean add(boolean bl2) {
            this.l.add(this.to, bl2);
            ++this.to;
            assert (this.assertRange());
            return true;
        }

        @Override
        public void add(int n2, boolean bl2) {
            this.ensureIndex(n2);
            this.l.add(this.from + n2, bl2);
            ++this.to;
            assert (this.assertRange());
        }

        @Override
        public boolean addAll(int n2, Collection<? extends Boolean> collection) {
            this.ensureIndex(n2);
            this.to += collection.size();
            return this.l.addAll(this.from + n2, collection);
        }

        @Override
        public boolean getBoolean(int n2) {
            this.ensureRestrictedIndex(n2);
            return this.l.getBoolean(this.from + n2);
        }

        @Override
        public boolean removeBoolean(int n2) {
            this.ensureRestrictedIndex(n2);
            --this.to;
            return this.l.removeBoolean(this.from + n2);
        }

        @Override
        public boolean set(int n2, boolean bl2) {
            this.ensureRestrictedIndex(n2);
            return this.l.set(this.from + n2, bl2);
        }

        @Override
        public int size() {
            return this.to - this.from;
        }

        @Override
        public void getElements(int n2, boolean[] blArray, int n3, int n4) {
            this.ensureIndex(n2);
            if (n2 + n4 > this.size()) {
                throw new IndexOutOfBoundsException("End index (" + n2 + n4 + ") is greater than list size (" + this.size() + ")");
            }
            this.l.getElements(this.from + n2, blArray, n3, n4);
        }

        @Override
        public void removeElements(int n2, int n3) {
            this.ensureIndex(n2);
            this.ensureIndex(n3);
            this.l.removeElements(this.from + n2, this.from + n3);
            this.to -= n3 - n2;
            assert (this.assertRange());
        }

        @Override
        public void setElements(int n2, boolean[] blArray, int n3, int n4) {
            this.ensureIndex(n2);
            this.l.setElements(this.from + n2, blArray, n3, n4);
            assert (this.assertRange());
        }

        @Override
        public BooleanListIterator listIterator(int n2) {
            this.ensureIndex(n2);
            return this.l instanceof RandomAccess ? new RandomAccessIter(n2) : new ParentWrappingIter(this.l.listIterator(n2 + this.from));
        }

        @Override
        public BooleanSpliterator spliterator() {
            return this.l instanceof RandomAccess ? new IndexBasedSpliterator(this.l, this.from, this.to) : super.spliterator();
        }

        @Override
        public BooleanList subList(int n2, int n3) {
            this.ensureIndex(n2);
            this.ensureIndex(n3);
            if (n2 > n3) {
                throw new IllegalArgumentException("Start index (" + n2 + ") is greater than end index (" + n3 + ")");
            }
            return new BooleanSubList(this, n2, n3);
        }

        @Override
        public boolean rem(boolean bl2) {
            int n2 = this.indexOf(bl2);
            if (n2 == -1) {
                return false;
            }
            --this.to;
            this.l.removeBoolean(this.from + n2);
            assert (this.assertRange());
            return true;
        }

        @Override
        public boolean addAll(int n2, BooleanCollection booleanCollection) {
            this.ensureIndex(n2);
            return super.addAll(n2, booleanCollection);
        }

        private final class RandomAccessIter
        extends BooleanIterators.AbstractIndexBasedListIterator {
            RandomAccessIter(int n2) {
                super(0, n2);
            }

            @Override
            protected final boolean get(int n2) {
                return BooleanSubList.this.l.getBoolean(BooleanSubList.this.from + n2);
            }

            @Override
            protected final void add(int n2, boolean bl2) {
                BooleanSubList.this.add(n2, bl2);
            }

            @Override
            protected final void set(int n2, boolean bl2) {
                BooleanSubList.this.set(n2, bl2);
            }

            @Override
            protected final void remove(int n2) {
                BooleanSubList.this.removeBoolean(n2);
            }

            @Override
            protected final int getMaxPos() {
                return BooleanSubList.this.to - BooleanSubList.this.from;
            }

            @Override
            public void add(boolean bl2) {
                super.add(bl2);
                assert (BooleanSubList.this.assertRange());
            }

            @Override
            public void remove() {
                super.remove();
                assert (BooleanSubList.this.assertRange());
            }
        }

        private class ParentWrappingIter
        implements BooleanListIterator {
            private BooleanListIterator parent;

            ParentWrappingIter(BooleanListIterator booleanListIterator) {
                this.parent = booleanListIterator;
            }

            @Override
            public int nextIndex() {
                return this.parent.nextIndex() - BooleanSubList.this.from;
            }

            @Override
            public int previousIndex() {
                return this.parent.previousIndex() - BooleanSubList.this.from;
            }

            @Override
            public boolean hasNext() {
                return this.parent.nextIndex() < BooleanSubList.this.to;
            }

            @Override
            public boolean hasPrevious() {
                return this.parent.previousIndex() >= BooleanSubList.this.from;
            }

            @Override
            public boolean nextBoolean() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                return this.parent.nextBoolean();
            }

            @Override
            public boolean previousBoolean() {
                if (!this.hasPrevious()) {
                    throw new NoSuchElementException();
                }
                return this.parent.previousBoolean();
            }

            @Override
            public void add(boolean bl2) {
                this.parent.add(bl2);
            }

            @Override
            public void set(boolean bl2) {
                this.parent.set(bl2);
            }

            @Override
            public void remove() {
                this.parent.remove();
            }
        }
    }

    static final class IndexBasedSpliterator
    extends BooleanSpliterators.LateBindingSizeIndexBasedSpliterator {
        final BooleanList l;

        IndexBasedSpliterator(BooleanList booleanList, int n2) {
            super(n2);
            this.l = booleanList;
        }

        IndexBasedSpliterator(BooleanList booleanList, int n2, int n3) {
            super(n2, n3);
            this.l = booleanList;
        }

        @Override
        protected final int getMaxPosFromBackingStore() {
            return this.l.size();
        }

        @Override
        protected final boolean get(int n2) {
            return this.l.getBoolean(n2);
        }

        @Override
        protected final IndexBasedSpliterator makeForSplit(int n2, int n3) {
            return new IndexBasedSpliterator(this.l, n2, n3);
        }
    }
}

