/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.io.netty.util.internal;

import com.gradle.maven.extension.internal.dep.io.netty.util.internal.ObjectUtil;
import com.gradle.maven.extension.internal.dep.io.netty.util.internal.ReflectionUtil;
import com.gradle.maven.extension.internal.dep.io.netty.util.internal.SystemPropertyUtil;
import com.gradle.maven.extension.internal.dep.io.netty.util.internal.logging.InternalLogger;
import com.gradle.maven.extension.internal.dep.io.netty.util.internal.logging.InternalLoggerFactory;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.concurrent.atomic.AtomicLong;
import sun.misc.Unsafe;

final class PlatformDependent0 {
    private static final InternalLogger logger;
    private static final long ADDRESS_FIELD_OFFSET;
    private static final long BYTE_ARRAY_BASE_OFFSET;
    private static final long INT_ARRAY_BASE_OFFSET;
    private static final long INT_ARRAY_INDEX_SCALE;
    private static final long LONG_ARRAY_BASE_OFFSET;
    private static final long LONG_ARRAY_INDEX_SCALE;
    private static final MethodHandle DIRECT_BUFFER_CONSTRUCTOR;
    private static final MethodHandle ALLOCATE_ARRAY_METHOD;
    private static final MethodHandle ALIGN_SLICE;
    private static final boolean IS_ANDROID;
    private static final int JAVA_VERSION;
    private static final Throwable EXPLICIT_NO_UNSAFE_CAUSE;
    private static final Throwable UNSAFE_UNAVAILABILITY_CAUSE;
    private static final boolean RUNNING_IN_NATIVE_IMAGE;
    private static final boolean IS_EXPLICIT_TRY_REFLECTION_SET_ACCESSIBLE;
    static final MethodHandle IS_VIRTUAL_THREAD_METHOD_HANDLE;
    static final Unsafe UNSAFE;
    private static final boolean UNALIGNED;
    private static final long BITS_MAX_DIRECT_MEMORY;

    private static MethodHandle getIsVirtualThreadMethodHandle() {
        try {
            MethodHandle methodHandle = MethodHandles.publicLookup().findVirtual(Thread.class, "isVirtual", MethodType.methodType(Boolean.TYPE));
            boolean bl2 = methodHandle.invokeExact(Thread.currentThread());
            return methodHandle;
        }
        catch (Throwable throwable) {
            if (logger.isTraceEnabled()) {
                logger.debug("Thread.isVirtual() is not available: ", throwable);
            } else {
                logger.debug("Thread.isVirtual() is not available: ", (Object)throwable.getMessage());
            }
            return null;
        }
    }

    static boolean isVirtualThread(Thread thread) {
        if (thread == null || IS_VIRTUAL_THREAD_METHOD_HANDLE == null) {
            return false;
        }
        try {
            return IS_VIRTUAL_THREAD_METHOD_HANDLE.invokeExact(thread);
        }
        catch (Throwable throwable) {
            if (throwable instanceof Error) {
                throw (Error)throwable;
            }
            throw new Error(throwable);
        }
    }

    static boolean isNativeImage() {
        return RUNNING_IN_NATIVE_IMAGE;
    }

    static boolean isExplicitNoUnsafe() {
        return EXPLICIT_NO_UNSAFE_CAUSE != null;
    }

    private static Throwable explicitNoUnsafeCause0() {
        boolean bl2 = SystemPropertyUtil.contains("com.gradle.maven.extension.internal.dep.io.netty.noUnsafe");
        boolean bl3 = SystemPropertyUtil.getBoolean("com.gradle.maven.extension.internal.dep.io.netty.noUnsafe", false);
        logger.debug("-Dio.netty.noUnsafe: {}", (Object)bl3);
        String string = "com.gradle.maven.extension.internal.dep.io.netty.noUnsafe";
        String string2 = "<unspecified>";
        String string3 = SystemPropertyUtil.get("sun.misc.unsafe.memory.access", string2);
        if (!bl2 && string2.equals(string3) && PlatformDependent0.javaVersion() >= 25) {
            string = "com.gradle.maven.extension.internal.dep.io.netty.noUnsafe=true by default on Java 25+";
            bl3 = true;
        } else if (!"allow".equals(string3) && !string2.equals(string3)) {
            string = "--sun-misc-unsafe-memory-access=" + string3;
            bl3 = true;
        }
        if (bl3) {
            String string4 = "sun.misc.Unsafe: unavailable (" + string + ')';
            logger.debug(string4);
            return new UnsupportedOperationException(string4);
        }
        String string5 = SystemPropertyUtil.contains("com.gradle.maven.extension.internal.dep.io.netty.tryUnsafe") ? "com.gradle.maven.extension.internal.dep.io.netty.tryUnsafe" : "org.jboss.netty.tryUnsafe";
        if (!SystemPropertyUtil.getBoolean(string5, true)) {
            String string6 = "sun.misc.Unsafe: unavailable (" + string5 + ')';
            logger.debug(string6);
            return new UnsupportedOperationException(string6);
        }
        return null;
    }

    static boolean isUnaligned() {
        return UNALIGNED;
    }

    static long bitsMaxDirectMemory() {
        return BITS_MAX_DIRECT_MEMORY;
    }

    static boolean hasUnsafe() {
        return UNSAFE != null;
    }

    static Throwable getUnsafeUnavailabilityCause() {
        return UNSAFE_UNAVAILABILITY_CAUSE;
    }

    static boolean unalignedAccess() {
        return UNALIGNED;
    }

    static void throwException(Throwable throwable) {
        PlatformDependent0.throwException0(throwable);
    }

    private static <E extends Throwable> void throwException0(Throwable throwable) throws E {
        throw throwable;
    }

    static boolean hasDirectBufferNoCleanerConstructor() {
        return DIRECT_BUFFER_CONSTRUCTOR != null;
    }

    static ByteBuffer reallocateDirectNoCleaner(ByteBuffer byteBuffer, int n2) {
        return PlatformDependent0.newDirectBuffer(UNSAFE.reallocateMemory(PlatformDependent0.directBufferAddress(byteBuffer), n2), n2);
    }

    static ByteBuffer allocateDirectNoCleaner(int n2) {
        return PlatformDependent0.newDirectBuffer(UNSAFE.allocateMemory(Math.max(1, n2)), n2);
    }

    static boolean hasAlignSliceMethod() {
        return ALIGN_SLICE != null;
    }

    static ByteBuffer alignSlice(ByteBuffer byteBuffer, int n2) {
        try {
            return ALIGN_SLICE.invokeExact(byteBuffer, n2);
        }
        catch (Throwable throwable) {
            PlatformDependent0.rethrowIfPossible(throwable);
            throw new LinkageError("ByteBuffer.alignedSlice not available", throwable);
        }
    }

    static boolean hasAllocateArrayMethod() {
        return ALLOCATE_ARRAY_METHOD != null;
    }

    static byte[] allocateUninitializedArray(int n2) {
        try {
            return (byte[])ALLOCATE_ARRAY_METHOD.invokeExact(Byte.TYPE, n2);
        }
        catch (Throwable throwable) {
            PlatformDependent0.rethrowIfPossible(throwable);
            throw new LinkageError("Unsafe.allocateUninitializedArray not available", throwable);
        }
    }

    static ByteBuffer newDirectBuffer(long l2, int n2) {
        ObjectUtil.checkPositiveOrZero(n2, "capacity");
        try {
            return DIRECT_BUFFER_CONSTRUCTOR.invokeExact(l2, n2);
        }
        catch (Throwable throwable) {
            PlatformDependent0.rethrowIfPossible(throwable);
            throw new LinkageError("DirectByteBuffer constructor not available", throwable);
        }
    }

    private static void rethrowIfPossible(Throwable throwable) {
        if (throwable instanceof Error) {
            throw (Error)throwable;
        }
        if (throwable instanceof RuntimeException) {
            throw (RuntimeException)throwable;
        }
    }

    static long directBufferAddress(ByteBuffer byteBuffer) {
        return PlatformDependent0.getLong(byteBuffer, ADDRESS_FIELD_OFFSET);
    }

    static long byteArrayBaseOffset() {
        return BYTE_ARRAY_BASE_OFFSET;
    }

    static Object getObject(Object object, long l2) {
        return UNSAFE.getObject(object, l2);
    }

    static int getInt(Object object, long l2) {
        return UNSAFE.getInt(object, l2);
    }

    static int getIntVolatile(Object object, long l2) {
        return UNSAFE.getIntVolatile(object, l2);
    }

    static void putOrderedInt(Object object, long l2, int n2) {
        UNSAFE.putOrderedInt(object, l2, n2);
    }

    static int getAndAddInt(Object object, long l2, int n2) {
        return UNSAFE.getAndAddInt(object, l2, n2);
    }

    static boolean compareAndSwapInt(Object object, long l2, int n2, int n3) {
        return UNSAFE.compareAndSwapInt(object, l2, n2, n3);
    }

    static void safeConstructPutInt(Object object, long l2, int n2) {
        UNSAFE.putInt(object, l2, n2);
        UNSAFE.storeFence();
    }

    private static long getLong(Object object, long l2) {
        return UNSAFE.getLong(object, l2);
    }

    static long objectFieldOffset(Field field) {
        return UNSAFE.objectFieldOffset(field);
    }

    static byte getByte(long l2) {
        return UNSAFE.getByte(l2);
    }

    static short getShort(long l2) {
        return UNSAFE.getShort(l2);
    }

    static int getInt(long l2) {
        return UNSAFE.getInt(l2);
    }

    static long getLong(long l2) {
        return UNSAFE.getLong(l2);
    }

    static byte getByte(byte[] byArray, int n2) {
        return UNSAFE.getByte(byArray, BYTE_ARRAY_BASE_OFFSET + (long)n2);
    }

    static short getShort(byte[] byArray, int n2) {
        return UNSAFE.getShort(byArray, BYTE_ARRAY_BASE_OFFSET + (long)n2);
    }

    static int getInt(byte[] byArray, int n2) {
        return UNSAFE.getInt(byArray, BYTE_ARRAY_BASE_OFFSET + (long)n2);
    }

    static long getLong(byte[] byArray, int n2) {
        return UNSAFE.getLong(byArray, BYTE_ARRAY_BASE_OFFSET + (long)n2);
    }

    static void putByte(long l2, byte by2) {
        UNSAFE.putByte(l2, by2);
    }

    static void putShort(long l2, short s2) {
        UNSAFE.putShort(l2, s2);
    }

    static void putInt(long l2, int n2) {
        UNSAFE.putInt(l2, n2);
    }

    static void putLong(long l2, long l3) {
        UNSAFE.putLong(l2, l3);
    }

    static void putByte(byte[] byArray, int n2, byte by2) {
        UNSAFE.putByte(byArray, BYTE_ARRAY_BASE_OFFSET + (long)n2, by2);
    }

    static void putByte(Object object, long l2, byte by2) {
        UNSAFE.putByte(object, l2, by2);
    }

    static void putShort(byte[] byArray, int n2, short s2) {
        UNSAFE.putShort(byArray, BYTE_ARRAY_BASE_OFFSET + (long)n2, s2);
    }

    static void putInt(byte[] byArray, int n2, int n3) {
        UNSAFE.putInt(byArray, BYTE_ARRAY_BASE_OFFSET + (long)n2, n3);
    }

    static void putLong(byte[] byArray, int n2, long l2) {
        UNSAFE.putLong(byArray, BYTE_ARRAY_BASE_OFFSET + (long)n2, l2);
    }

    static void putObject(Object object, long l2, Object object2) {
        UNSAFE.putObject(object, l2, object2);
    }

    static void copyMemory(long l2, long l3, long l4) {
        if (PlatformDependent0.javaVersion() <= 8) {
            PlatformDependent0.copyMemoryWithSafePointPolling(l2, l3, l4);
        } else {
            UNSAFE.copyMemory(l2, l3, l4);
        }
    }

    private static void copyMemoryWithSafePointPolling(long l2, long l3, long l4) {
        while (l4 > 0L) {
            long l5 = Math.min(l4, 0x100000L);
            UNSAFE.copyMemory(l2, l3, l5);
            l4 -= l5;
            l2 += l5;
            l3 += l5;
        }
    }

    static void copyMemory(Object object, long l2, Object object2, long l3, long l4) {
        if (PlatformDependent0.javaVersion() <= 8) {
            PlatformDependent0.copyMemoryWithSafePointPolling(object, l2, object2, l3, l4);
        } else {
            UNSAFE.copyMemory(object, l2, object2, l3, l4);
        }
    }

    private static void copyMemoryWithSafePointPolling(Object object, long l2, Object object2, long l3, long l4) {
        while (l4 > 0L) {
            long l5 = Math.min(l4, 0x100000L);
            UNSAFE.copyMemory(object, l2, object2, l3, l5);
            l4 -= l5;
            l2 += l5;
            l3 += l5;
        }
    }

    static void setMemory(long l2, long l3, byte by2) {
        UNSAFE.setMemory(l2, l3, by2);
    }

    static void setMemory(Object object, long l2, long l3, byte by2) {
        UNSAFE.setMemory(object, l2, l3, by2);
    }

    static boolean equals(byte[] byArray, int n2, byte[] byArray2, int n3, int n4) {
        long l2;
        int n5 = n4 & 7;
        long l3 = BYTE_ARRAY_BASE_OFFSET + (long)n2;
        long l4 = n3 - n2;
        if (n4 >= 8) {
            l2 = l3 + (long)n5;
            for (long i2 = l3 - 8L + (long)n4; i2 >= l2; i2 -= 8L) {
                if (UNSAFE.getLong(byArray, i2) == UNSAFE.getLong(byArray2, i2 + l4)) continue;
                return false;
            }
        }
        if (n5 >= 4 && UNSAFE.getInt(byArray, l2 = l3 + (long)(n5 -= 4)) != UNSAFE.getInt(byArray2, l2 + l4)) {
            return false;
        }
        l2 = l3 + l4;
        if (n5 >= 2) {
            return UNSAFE.getChar(byArray, l3) == UNSAFE.getChar(byArray2, l2) && (n5 == 2 || UNSAFE.getByte(byArray, l3 + 2L) == UNSAFE.getByte(byArray2, l2 + 2L));
        }
        return n5 == 0 || UNSAFE.getByte(byArray, l3) == UNSAFE.getByte(byArray2, l2);
    }

    static int hashCodeAscii(byte[] byArray, int n2, int n3) {
        int n4 = -1028477387;
        long l2 = BYTE_ARRAY_BASE_OFFSET + (long)n2;
        int n5 = n3 & 7;
        long l3 = l2 + (long)n5;
        for (long i2 = l2 - 8L + (long)n3; i2 >= l3; i2 -= 8L) {
            n4 = PlatformDependent0.hashCodeAsciiCompute(UNSAFE.getLong(byArray, i2), n4);
        }
        if (n5 == 0) {
            return n4;
        }
        int n6 = -862048943;
        if (n5 != 2 & n5 != 4 & n5 != 6) {
            n4 = n4 * -862048943 + PlatformDependent0.hashCodeAsciiSanitize(UNSAFE.getByte(byArray, l2));
            n6 = 461845907;
            ++l2;
        }
        if (n5 != 1 & n5 != 4 & n5 != 5) {
            n4 = n4 * n6 + PlatformDependent0.hashCodeAsciiSanitize(UNSAFE.getShort(byArray, l2));
            n6 = n6 == -862048943 ? 461845907 : -862048943;
            l2 += 2L;
        }
        if (n5 >= 4) {
            return n4 * n6 + PlatformDependent0.hashCodeAsciiSanitize(UNSAFE.getInt(byArray, l2));
        }
        return n4;
    }

    static int hashCodeAsciiCompute(long l2, int n2) {
        return n2 * -862048943 + PlatformDependent0.hashCodeAsciiSanitize((int)l2) * 461845907 + (int)((l2 & 0x1F1F1F1F00000000L) >>> 32);
    }

    static int hashCodeAsciiSanitize(int n2) {
        return n2 & 0x1F1F1F1F;
    }

    static int hashCodeAsciiSanitize(short s2) {
        return s2 & 0x1F1F;
    }

    static int hashCodeAsciiSanitize(byte by2) {
        return by2 & 0x1F;
    }

    static ClassLoader getClassLoader(final Class<?> clazz) {
        if (System.getSecurityManager() == null) {
            return clazz.getClassLoader();
        }
        return AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

            @Override
            public ClassLoader run() {
                return clazz.getClassLoader();
            }
        });
    }

    static ClassLoader getSystemClassLoader() {
        if (System.getSecurityManager() == null) {
            return ClassLoader.getSystemClassLoader();
        }
        return AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

            @Override
            public ClassLoader run() {
                return ClassLoader.getSystemClassLoader();
            }
        });
    }

    static int addressSize() {
        return UNSAFE.addressSize();
    }

    static void freeMemory(long l2) {
        UNSAFE.freeMemory(l2);
    }

    static boolean isAndroid() {
        return IS_ANDROID;
    }

    private static boolean isAndroid0() {
        String string = SystemPropertyUtil.get("java.vm.name");
        boolean bl2 = "Dalvik".equals(string);
        if (bl2) {
            logger.debug("Platform: Android");
        }
        return bl2;
    }

    private static boolean explicitTryReflectionSetAccessible0() {
        return SystemPropertyUtil.getBoolean("com.gradle.maven.extension.internal.dep.io.netty.tryReflectionSetAccessible", PlatformDependent0.javaVersion() < 9 || RUNNING_IN_NATIVE_IMAGE);
    }

    static boolean isExplicitTryReflectionSetAccessible() {
        return IS_EXPLICIT_TRY_REFLECTION_SET_ACCESSIBLE;
    }

    static int javaVersion() {
        return JAVA_VERSION;
    }

    private static int javaVersion0() {
        int n2 = PlatformDependent0.isAndroid() ? 6 : PlatformDependent0.majorVersionFromJavaSpecificationVersion();
        logger.debug("Java version: {}", (Object)n2);
        return n2;
    }

    static int majorVersionFromJavaSpecificationVersion() {
        return PlatformDependent0.majorVersion(SystemPropertyUtil.get("java.specification.version", "1.6"));
    }

    static int majorVersion(String string) {
        String[] stringArray = string.split("\\.");
        int[] nArray = new int[stringArray.length];
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            nArray[i2] = Integer.parseInt(stringArray[i2]);
        }
        if (nArray[0] == 1) {
            assert (nArray[1] >= 6);
            return nArray[1];
        }
        return nArray[0];
    }

    private PlatformDependent0() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        Object object;
        Unsafe unsafe;
        ByteBuffer byteBuffer;
        logger = InternalLoggerFactory.getInstance(PlatformDependent0.class);
        IS_ANDROID = PlatformDependent0.isAndroid0();
        JAVA_VERSION = PlatformDependent0.javaVersion0();
        EXPLICIT_NO_UNSAFE_CAUSE = PlatformDependent0.explicitNoUnsafeCause0();
        RUNNING_IN_NATIVE_IMAGE = SystemPropertyUtil.contains("org.graalvm.nativeimage.imagecode");
        IS_EXPLICIT_TRY_REFLECTION_SET_ACCESSIBLE = PlatformDependent0.explicitTryReflectionSetAccessible0();
        IS_VIRTUAL_THREAD_METHOD_HANDLE = PlatformDependent0.getIsVirtualThreadMethodHandle();
        final MethodHandles.Lookup lookup = MethodHandles.lookup();
        Field field = null;
        MethodHandle methodHandle = null;
        Throwable throwable = EXPLICIT_NO_UNSAFE_CAUSE;
        if (throwable != null) {
            byteBuffer = null;
            field = null;
            unsafe = null;
        } else {
            long l2;
            Object object2;
            Unsafe unsafe2;
            byteBuffer = ByteBuffer.allocateDirect(1);
            object = AccessController.doPrivileged(new PrivilegedAction<Object>(){

                @Override
                public Object run() {
                    try {
                        Field field = Unsafe.class.getDeclaredField("theUnsafe");
                        Throwable throwable = ReflectionUtil.trySetAccessible(field, false);
                        if (throwable != null) {
                            return throwable;
                        }
                        return field.get(null);
                    }
                    catch (IllegalAccessException | NoSuchFieldException | SecurityException exception) {
                        return exception;
                    }
                    catch (NoClassDefFoundError noClassDefFoundError) {
                        return noClassDefFoundError;
                    }
                }
            });
            if (object instanceof Throwable) {
                unsafe = null;
                throwable = (Throwable)object;
                if (logger.isTraceEnabled()) {
                    logger.debug("sun.misc.Unsafe.theUnsafe: unavailable", throwable);
                } else {
                    logger.debug("sun.misc.Unsafe.theUnsafe: unavailable: {}", (Object)throwable.getMessage());
                }
            } else {
                unsafe = (Unsafe)object;
                logger.debug("sun.misc.Unsafe.theUnsafe: available");
            }
            if (unsafe != null) {
                unsafe2 = unsafe;
                object2 = AccessController.doPrivileged(new PrivilegedAction<Object>(){

                    @Override
                    public Object run() {
                        try {
                            Class<?> clazz = unsafe2.getClass();
                            clazz.getDeclaredMethod("copyMemory", Object.class, Long.TYPE, Object.class, Long.TYPE, Long.TYPE);
                            if (PlatformDependent0.javaVersion() > 23) {
                                clazz.getDeclaredMethod("objectFieldOffset", Field.class);
                                clazz.getDeclaredMethod("staticFieldOffset", Field.class);
                                clazz.getDeclaredMethod("staticFieldBase", Field.class);
                                clazz.getDeclaredMethod("arrayBaseOffset", Class.class);
                                clazz.getDeclaredMethod("arrayIndexScale", Class.class);
                                clazz.getDeclaredMethod("allocateMemory", Long.TYPE);
                                clazz.getDeclaredMethod("reallocateMemory", Long.TYPE, Long.TYPE);
                                clazz.getDeclaredMethod("freeMemory", Long.TYPE);
                                clazz.getDeclaredMethod("setMemory", Long.TYPE, Long.TYPE, Byte.TYPE);
                                clazz.getDeclaredMethod("setMemory", Object.class, Long.TYPE, Long.TYPE, Byte.TYPE);
                                clazz.getDeclaredMethod("getBoolean", Object.class, Long.TYPE);
                                clazz.getDeclaredMethod("getByte", Long.TYPE);
                                clazz.getDeclaredMethod("getByte", Object.class, Long.TYPE);
                                clazz.getDeclaredMethod("getInt", Long.TYPE);
                                clazz.getDeclaredMethod("getInt", Object.class, Long.TYPE);
                                clazz.getDeclaredMethod("getLong", Long.TYPE);
                                clazz.getDeclaredMethod("getLong", Object.class, Long.TYPE);
                                clazz.getDeclaredMethod("putByte", Long.TYPE, Byte.TYPE);
                                clazz.getDeclaredMethod("putByte", Object.class, Long.TYPE, Byte.TYPE);
                                clazz.getDeclaredMethod("putInt", Long.TYPE, Integer.TYPE);
                                clazz.getDeclaredMethod("putInt", Object.class, Long.TYPE, Integer.TYPE);
                                clazz.getDeclaredMethod("putLong", Long.TYPE, Long.TYPE);
                                clazz.getDeclaredMethod("putLong", Object.class, Long.TYPE, Long.TYPE);
                                clazz.getDeclaredMethod("addressSize", new Class[0]);
                            }
                            if (PlatformDependent0.javaVersion() >= 23) {
                                long l2 = unsafe2.allocateMemory(8L);
                                unsafe2.putLong(l2, 42L);
                                unsafe2.freeMemory(l2);
                            }
                            return null;
                        }
                        catch (NoSuchMethodException | SecurityException | UnsupportedOperationException exception) {
                            return exception;
                        }
                    }
                });
                if (object2 == null) {
                    logger.debug("sun.misc.Unsafe base methods: all available");
                } else {
                    unsafe = null;
                    throwable = (Throwable)object2;
                    if (logger.isTraceEnabled()) {
                        logger.debug("sun.misc.Unsafe method unavailable:", throwable);
                    } else {
                        logger.debug("sun.misc.Unsafe method unavailable: {}", (Object)throwable.getMessage());
                    }
                }
            }
            if (unsafe != null) {
                unsafe2 = unsafe;
                object2 = AccessController.doPrivileged(new PrivilegedAction<Object>(){

                    @Override
                    public Object run() {
                        try {
                            Field field = Buffer.class.getDeclaredField("address");
                            long l2 = unsafe2.objectFieldOffset(field);
                            long l3 = unsafe2.getLong(byteBuffer, l2);
                            if (l3 == 0L) {
                                return null;
                            }
                            return field;
                        }
                        catch (NoSuchFieldException | SecurityException exception) {
                            return exception;
                        }
                    }
                });
                if (object2 instanceof Field) {
                    field = (Field)object2;
                    logger.debug("java.nio.Buffer.address: available");
                } else {
                    throwable = (Throwable)object2;
                    if (logger.isTraceEnabled()) {
                        logger.debug("java.nio.Buffer.address: unavailable", (Throwable)object2);
                    } else {
                        logger.debug("java.nio.Buffer.address: unavailable: {}", (Object)((Throwable)object2).getMessage());
                    }
                    unsafe = null;
                }
            }
            if (unsafe != null && (l2 = (long)unsafe.arrayIndexScale(byte[].class)) != 1L) {
                logger.debug("unsafe.arrayIndexScale is {} (expected: 1). Not using unsafe.", (Object)l2);
                throwable = new UnsupportedOperationException("Unexpected unsafe.arrayIndexScale");
                unsafe = null;
            }
        }
        UNSAFE_UNAVAILABILITY_CAUSE = throwable;
        UNSAFE = unsafe;
        if (unsafe == null) {
            ADDRESS_FIELD_OFFSET = -1L;
            BYTE_ARRAY_BASE_OFFSET = -1L;
            LONG_ARRAY_BASE_OFFSET = -1L;
            LONG_ARRAY_INDEX_SCALE = -1L;
            INT_ARRAY_BASE_OFFSET = -1L;
            INT_ARRAY_INDEX_SCALE = -1L;
            UNALIGNED = false;
            BITS_MAX_DIRECT_MEMORY = -1L;
            DIRECT_BUFFER_CONSTRUCTOR = null;
            ALLOCATE_ARRAY_METHOD = null;
        } else {
            Object object3;
            Object object4;
            boolean bl2;
            Object object5;
            Object object6;
            long l3 = -1L;
            try {
                Object object7 = AccessController.doPrivileged(new PrivilegedAction<Object>(){

                    @Override
                    public Object run() {
                        try {
                            Class<?> clazz = byteBuffer.getClass();
                            Constructor<?> constructor = PlatformDependent0.javaVersion() >= 21 ? clazz.getDeclaredConstructor(Long.TYPE, Long.TYPE) : clazz.getDeclaredConstructor(Long.TYPE, Integer.TYPE);
                            Throwable throwable = ReflectionUtil.trySetAccessible(constructor, true);
                            if (throwable != null) {
                                return throwable;
                            }
                            return lookup.unreflectConstructor(constructor).asType(MethodType.methodType(ByteBuffer.class, Long.TYPE, Integer.TYPE));
                        }
                        catch (Throwable throwable) {
                            return throwable;
                        }
                    }
                });
                if (object7 instanceof MethodHandle) {
                    l3 = UNSAFE.allocateMemory(1L);
                    try {
                        object6 = (MethodHandle)object7;
                        object5 = object6.invokeExact(l3, 1);
                        object = object6;
                        logger.debug("direct buffer constructor: available");
                    }
                    catch (Throwable throwable2) {
                        object = null;
                    }
                } else {
                    if (logger.isTraceEnabled()) {
                        logger.debug("direct buffer constructor: unavailable", (Throwable)object7);
                    } else {
                        logger.debug("direct buffer constructor: unavailable: {}", (Object)((Throwable)object7).getMessage());
                    }
                    object = null;
                }
            }
            finally {
                if (l3 != -1L) {
                    UNSAFE.freeMemory(l3);
                }
            }
            DIRECT_BUFFER_CONSTRUCTOR = object;
            ADDRESS_FIELD_OFFSET = PlatformDependent0.objectFieldOffset(field);
            BYTE_ARRAY_BASE_OFFSET = UNSAFE.arrayBaseOffset(byte[].class);
            INT_ARRAY_BASE_OFFSET = UNSAFE.arrayBaseOffset(int[].class);
            INT_ARRAY_INDEX_SCALE = UNSAFE.arrayIndexScale(int[].class);
            LONG_ARRAY_BASE_OFFSET = UNSAFE.arrayBaseOffset(long[].class);
            LONG_ARRAY_INDEX_SCALE = UNSAFE.arrayIndexScale(long[].class);
            object6 = new AtomicLong(-1L);
            object5 = AccessController.doPrivileged(new PrivilegedAction<Object>((AtomicLong)object6){
                final /* synthetic */ AtomicLong val$maybeMaxMemory;
                {
                    this.val$maybeMaxMemory = atomicLong;
                }

                @Override
                public Object run() {
                    try {
                        Object object;
                        Object object2;
                        Class<?> clazz = Class.forName("java.nio.Bits", false, PlatformDependent0.getSystemClassLoader());
                        int n2 = PlatformDependent0.javaVersion();
                        if (!PlatformDependent0.isNativeImage() && n2 >= 9) {
                            Object object3;
                            long l2;
                            object2 = n2 >= 11 ? "MAX_MEMORY" : "maxMemory";
                            try {
                                object = clazz.getDeclaredField((String)object2);
                                if (((Field)object).getType() == Long.TYPE) {
                                    l2 = UNSAFE.staticFieldOffset((Field)object);
                                    object3 = UNSAFE.staticFieldBase((Field)object);
                                    this.val$maybeMaxMemory.lazySet(UNSAFE.getLong(object3, l2));
                                }
                            }
                            catch (Throwable throwable) {
                                // empty catch block
                            }
                            object2 = n2 >= 11 ? "UNALIGNED" : "unaligned";
                            try {
                                object = clazz.getDeclaredField((String)object2);
                                if (((Field)object).getType() == Boolean.TYPE) {
                                    l2 = UNSAFE.staticFieldOffset((Field)object);
                                    object3 = UNSAFE.staticFieldBase((Field)object);
                                    return UNSAFE.getBoolean(object3, l2);
                                }
                            }
                            catch (NoSuchFieldException noSuchFieldException) {
                                // empty catch block
                            }
                        }
                        if ((object = ReflectionUtil.trySetAccessible((AccessibleObject)(object2 = clazz.getDeclaredMethod("unaligned", new Class[0])), true)) != null) {
                            return object;
                        }
                        return ((Method)object2).invoke(null, new Object[0]);
                    }
                    catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException | SecurityException | InvocationTargetException exception) {
                        return exception;
                    }
                }
            });
            if (object5 instanceof Boolean) {
                bl2 = (Boolean)object5;
                logger.debug("java.nio.Bits.unaligned: available, {}", (Object)bl2);
            } else {
                object4 = SystemPropertyUtil.get("os.arch", "");
                bl2 = ((String)object4).matches("^(i[3-6]86|x86(_64)?|x64|amd64)$");
                object3 = (Throwable)object5;
                if (logger.isTraceEnabled()) {
                    logger.debug("java.nio.Bits.unaligned: unavailable, {}", (Object)bl2, object3);
                } else {
                    logger.debug("java.nio.Bits.unaligned: unavailable, {}, {}", (Object)bl2, (Object)((Throwable)object3).getMessage());
                }
            }
            UNALIGNED = bl2;
            long l4 = BITS_MAX_DIRECT_MEMORY = ((AtomicLong)object6).get() >= 0L ? ((AtomicLong)object6).get() : -1L;
            if (PlatformDependent0.javaVersion() >= 9) {
                object4 = AccessController.doPrivileged(new PrivilegedAction<Object>(){

                    @Override
                    public Object run() {
                        try {
                            Class<?> clazz = PlatformDependent0.getClassLoader(PlatformDependent0.class).loadClass("jdk.internal.misc.Unsafe");
                            return lookup.findStatic(clazz, "getUnsafe", MethodType.methodType(clazz)).invoke();
                        }
                        catch (Throwable throwable) {
                            return throwable;
                        }
                    }
                });
                if (!(object4 instanceof Throwable) && (object4 = AccessController.doPrivileged(new PrivilegedAction<Object>(object3 = object4, lookup){
                    final /* synthetic */ Object val$finalInternalUnsafe;
                    final /* synthetic */ MethodHandles.Lookup val$lookup;
                    {
                        this.val$finalInternalUnsafe = object;
                        this.val$lookup = lookup;
                    }

                    @Override
                    public Object run() {
                        try {
                            Class<?> clazz = this.val$finalInternalUnsafe.getClass();
                            return this.val$lookup.findVirtual(clazz, "allocateUninitializedArray", MethodType.methodType(Object.class, Class.class, Integer.TYPE));
                        }
                        catch (Throwable throwable) {
                            return throwable;
                        }
                    }
                })) instanceof MethodHandle) {
                    try {
                        MethodHandle methodHandle2 = (MethodHandle)object4;
                        methodHandle2 = methodHandle2.bindTo(object3);
                        byte[] byArray = (byte[])methodHandle2.invokeExact(Byte.TYPE, 8);
                        assert (byArray.length == 8);
                        methodHandle = methodHandle2;
                    }
                    catch (Throwable throwable3) {
                        object4 = throwable3;
                    }
                }
                if (object4 instanceof Throwable) {
                    if (logger.isTraceEnabled()) {
                        logger.debug("jdk.internal.misc.Unsafe.allocateUninitializedArray(int): unavailable", (Throwable)object4);
                    } else {
                        logger.debug("jdk.internal.misc.Unsafe.allocateUninitializedArray(int): unavailable: {}", (Object)((Throwable)object4).getMessage());
                    }
                } else {
                    logger.debug("jdk.internal.misc.Unsafe.allocateUninitializedArray(int): available");
                }
            } else {
                logger.debug("jdk.internal.misc.Unsafe.allocateUninitializedArray(int): unavailable prior to Java9");
            }
            ALLOCATE_ARRAY_METHOD = methodHandle;
        }
        ALIGN_SLICE = PlatformDependent0.javaVersion() > 9 ? (MethodHandle)AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                try {
                    return MethodHandles.publicLookup().findVirtual(ByteBuffer.class, "alignedSlice", MethodType.methodType(ByteBuffer.class, Integer.TYPE));
                }
                catch (Throwable throwable) {
                    return null;
                }
            }
        }) : null;
        logger.debug("java.nio.DirectByteBuffer.<init>(long, {int,long}): {}", (Object)(DIRECT_BUFFER_CONSTRUCTOR != null ? "available" : "unavailable"));
    }
}

