/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.io.netty.handler.ssl;

import com.gradle.maven.extension.internal.dep.io.netty.buffer.ByteBufAllocator;
import com.gradle.maven.extension.internal.dep.io.netty.handler.ssl.OpenSslKeyMaterial;
import com.gradle.maven.extension.internal.dep.io.netty.handler.ssl.OpenSslKeyMaterialProvider;
import java.util.Iterator;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.net.ssl.X509KeyManager;

final class OpenSslCachingKeyMaterialProvider
extends OpenSslKeyMaterialProvider {
    private final int maxCachedEntries;
    private volatile boolean full;
    private final ConcurrentMap<String, OpenSslKeyMaterial> cache = new ConcurrentHashMap<String, OpenSslKeyMaterial>();

    OpenSslCachingKeyMaterialProvider(X509KeyManager x509KeyManager, String string, int n2) {
        super(x509KeyManager, string);
        this.maxCachedEntries = n2;
    }

    @Override
    OpenSslKeyMaterial chooseKeyMaterial(ByteBufAllocator byteBufAllocator, String string) throws Exception {
        OpenSslKeyMaterial openSslKeyMaterial = (OpenSslKeyMaterial)this.cache.get(string);
        if (openSslKeyMaterial == null) {
            openSslKeyMaterial = super.chooseKeyMaterial(byteBufAllocator, string);
            if (openSslKeyMaterial == null) {
                return null;
            }
            if (this.full) {
                return openSslKeyMaterial;
            }
            if (this.cache.size() > this.maxCachedEntries) {
                this.full = true;
                return openSslKeyMaterial;
            }
            OpenSslKeyMaterial openSslKeyMaterial2 = this.cache.putIfAbsent(string, openSslKeyMaterial);
            if (openSslKeyMaterial2 != null) {
                openSslKeyMaterial.release();
                openSslKeyMaterial = openSslKeyMaterial2;
            }
        }
        return openSslKeyMaterial.retain();
    }

    @Override
    void destroy() {
        do {
            Iterator iterator = this.cache.values().iterator();
            while (iterator.hasNext()) {
                ((OpenSslKeyMaterial)iterator.next()).release();
                iterator.remove();
            }
        } while (!this.cache.isEmpty());
    }
}

