/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.io.netty.handler.codec.http;

import com.gradle.maven.extension.internal.dep.io.netty.handler.codec.http.HttpHeaderNames;
import com.gradle.maven.extension.internal.dep.io.netty.handler.codec.http.HttpHeaderValues;
import com.gradle.maven.extension.internal.dep.io.netty.handler.codec.http.HttpHeaders;
import com.gradle.maven.extension.internal.dep.io.netty.handler.codec.http.HttpMessage;
import com.gradle.maven.extension.internal.dep.io.netty.handler.codec.http.HttpMethod;
import com.gradle.maven.extension.internal.dep.io.netty.handler.codec.http.HttpRequest;
import com.gradle.maven.extension.internal.dep.io.netty.handler.codec.http.HttpResponse;
import com.gradle.maven.extension.internal.dep.io.netty.handler.codec.http.HttpVersion;
import com.gradle.maven.extension.internal.dep.io.netty.util.AsciiString;
import com.gradle.maven.extension.internal.dep.io.netty.util.NetUtil;
import com.gradle.maven.extension.internal.dep.io.netty.util.internal.ObjectUtil;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public final class HttpUtil {
    private static final AsciiString CHARSET_EQUALS = AsciiString.of(HttpHeaderValues.CHARSET + "=");
    private static final AsciiString SEMICOLON = AsciiString.cached(";");
    private static final String COMMA_STRING = String.valueOf(',');

    public static boolean isKeepAlive(HttpMessage httpMessage) {
        return !httpMessage.headers().containsValue(HttpHeaderNames.CONNECTION, HttpHeaderValues.CLOSE, true) && (httpMessage.protocolVersion().isKeepAliveDefault() || httpMessage.headers().containsValue(HttpHeaderNames.CONNECTION, HttpHeaderValues.KEEP_ALIVE, true));
    }

    public static long getContentLength(HttpMessage httpMessage, long l2) {
        String string = httpMessage.headers().get(HttpHeaderNames.CONTENT_LENGTH);
        if (string != null) {
            return Long.parseLong(string);
        }
        long l3 = HttpUtil.getWebSocketContentLength(httpMessage);
        if (l3 >= 0L) {
            return l3;
        }
        return l2;
    }

    static int getWebSocketContentLength(HttpMessage httpMessage) {
        HttpResponse httpResponse;
        HttpHeaders httpHeaders = httpMessage.headers();
        if (httpMessage instanceof HttpRequest) {
            HttpRequest httpRequest = (HttpRequest)httpMessage;
            if (HttpMethod.GET.equals(httpRequest.method()) && httpHeaders.contains(HttpHeaderNames.SEC_WEBSOCKET_KEY1) && httpHeaders.contains(HttpHeaderNames.SEC_WEBSOCKET_KEY2)) {
                return 8;
            }
        } else if (httpMessage instanceof HttpResponse && (httpResponse = (HttpResponse)httpMessage).status().code() == 101 && httpHeaders.contains(HttpHeaderNames.SEC_WEBSOCKET_ORIGIN) && httpHeaders.contains(HttpHeaderNames.SEC_WEBSOCKET_LOCATION)) {
            return 16;
        }
        return -1;
    }

    public static boolean isContentLengthSet(HttpMessage httpMessage) {
        return httpMessage.headers().contains(HttpHeaderNames.CONTENT_LENGTH);
    }

    public static boolean is100ContinueExpected(HttpMessage httpMessage) {
        return HttpUtil.isExpectHeaderValid(httpMessage) && httpMessage.headers().contains(HttpHeaderNames.EXPECT, HttpHeaderValues.CONTINUE, true);
    }

    static boolean isUnsupportedExpectation(HttpMessage httpMessage) {
        if (!HttpUtil.isExpectHeaderValid(httpMessage)) {
            return false;
        }
        String string = httpMessage.headers().get(HttpHeaderNames.EXPECT);
        return string != null && !HttpHeaderValues.CONTINUE.toString().equalsIgnoreCase(string);
    }

    private static boolean isExpectHeaderValid(HttpMessage httpMessage) {
        return httpMessage instanceof HttpRequest && httpMessage.protocolVersion().compareTo(HttpVersion.HTTP_1_1) >= 0;
    }

    public static boolean isTransferEncodingChunked(HttpMessage httpMessage) {
        return httpMessage.headers().containsValue(HttpHeaderNames.TRANSFER_ENCODING, HttpHeaderValues.CHUNKED, true);
    }

    public static void setTransferEncodingChunked(HttpMessage httpMessage, boolean bl2) {
        if (bl2) {
            httpMessage.headers().set((CharSequence)HttpHeaderNames.TRANSFER_ENCODING, (Object)HttpHeaderValues.CHUNKED);
            httpMessage.headers().remove(HttpHeaderNames.CONTENT_LENGTH);
        } else {
            List<String> list = httpMessage.headers().getAll(HttpHeaderNames.TRANSFER_ENCODING);
            if (list.isEmpty()) {
                return;
            }
            ArrayList<String> arrayList = new ArrayList<String>(list);
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                CharSequence charSequence = (CharSequence)iterator.next();
                if (!HttpHeaderValues.CHUNKED.contentEqualsIgnoreCase(charSequence)) continue;
                iterator.remove();
            }
            if (arrayList.isEmpty()) {
                httpMessage.headers().remove(HttpHeaderNames.TRANSFER_ENCODING);
            } else {
                httpMessage.headers().set((CharSequence)HttpHeaderNames.TRANSFER_ENCODING, arrayList);
            }
        }
    }

    public static CharSequence getCharsetAsSequence(HttpMessage httpMessage) {
        String string = httpMessage.headers().get(HttpHeaderNames.CONTENT_TYPE);
        if (string != null) {
            return HttpUtil.getCharsetAsSequence(string);
        }
        return null;
    }

    public static CharSequence getCharsetAsSequence(CharSequence charSequence) {
        ObjectUtil.checkNotNull(charSequence, "contentTypeValue");
        int n2 = AsciiString.indexOfIgnoreCaseAscii(charSequence, CHARSET_EQUALS, 0);
        if (n2 == -1) {
            return null;
        }
        int n3 = n2 + CHARSET_EQUALS.length();
        if (n3 < charSequence.length()) {
            CharSequence charSequence2 = charSequence.subSequence(n3, charSequence.length());
            int n4 = AsciiString.indexOfIgnoreCaseAscii(charSequence2, SEMICOLON, 0);
            if (n4 == -1) {
                return charSequence2;
            }
            return charSequence2.subSequence(0, n4);
        }
        return null;
    }

    public static CharSequence getMimeType(HttpMessage httpMessage) {
        String string = httpMessage.headers().get(HttpHeaderNames.CONTENT_TYPE);
        if (string != null) {
            return HttpUtil.getMimeType(string);
        }
        return null;
    }

    public static CharSequence getMimeType(CharSequence charSequence) {
        ObjectUtil.checkNotNull(charSequence, "contentTypeValue");
        int n2 = AsciiString.indexOfIgnoreCaseAscii(charSequence, SEMICOLON, 0);
        if (n2 != -1) {
            return charSequence.subSequence(0, n2);
        }
        return charSequence.length() > 0 ? charSequence : null;
    }

    public static String formatHostnameForHttp(InetSocketAddress inetSocketAddress) {
        String string = NetUtil.getHostname(inetSocketAddress);
        if (NetUtil.isValidIpV6Address(string)) {
            if (!inetSocketAddress.isUnresolved()) {
                string = NetUtil.toAddressString(inetSocketAddress.getAddress());
            } else if (string.charAt(0) == '[' && string.charAt(string.length() - 1) == ']') {
                return string;
            }
            return '[' + string + ']';
        }
        return string;
    }

    public static long normalizeAndGetContentLength(List<? extends CharSequence> list, boolean bl2, boolean bl3) {
        boolean bl4;
        if (list.isEmpty()) {
            return -1L;
        }
        String string = list.get(0).toString();
        boolean bl5 = bl4 = list.size() > 1 || string.indexOf(44) >= 0;
        if (bl4 && !bl2) {
            if (bl3) {
                String string2 = null;
                for (CharSequence charSequence : list) {
                    String[] stringArray;
                    for (String string3 : stringArray = charSequence.toString().split(COMMA_STRING, -1)) {
                        String string4 = string3.trim();
                        if (string2 == null) {
                            string2 = string4;
                            continue;
                        }
                        if (string4.equals(string2)) continue;
                        throw new IllegalArgumentException("Multiple Content-Length values found: " + list);
                    }
                }
                string = string2;
            } else {
                throw new IllegalArgumentException("Multiple Content-Length values found: " + list);
            }
        }
        if (string.isEmpty() || !Character.isDigit(string.charAt(0))) {
            throw new IllegalArgumentException("Content-Length value is not a number: " + string);
        }
        try {
            long l2 = Long.parseLong(string);
            return ObjectUtil.checkPositiveOrZero(l2, "Content-Length value");
        }
        catch (NumberFormatException numberFormatException) {
            throw new IllegalArgumentException("Content-Length value is not a number: " + string, numberFormatException);
        }
    }

    static int validateToken(CharSequence charSequence) {
        if (charSequence instanceof AsciiString) {
            return HttpUtil.validateAsciiStringToken((AsciiString)charSequence);
        }
        return HttpUtil.validateCharSequenceToken(charSequence);
    }

    private static int validateAsciiStringToken(AsciiString asciiString) {
        byte[] byArray = asciiString.array();
        int n2 = asciiString.arrayOffset() + asciiString.length();
        for (int i2 = asciiString.arrayOffset(); i2 < n2; ++i2) {
            if (HttpUtil.isValidTokenChar(byArray[i2])) continue;
            return i2 - asciiString.arrayOffset();
        }
        return -1;
    }

    private static int validateCharSequenceToken(CharSequence charSequence) {
        int n2 = charSequence.length();
        for (int i2 = 0; i2 < n2; ++i2) {
            byte by2 = (byte)charSequence.charAt(i2);
            if (HttpUtil.isValidTokenChar(by2)) continue;
            return i2;
        }
        return -1;
    }

    private static boolean isValidTokenChar(byte by2) {
        if (by2 < 0) {
            return false;
        }
        if (by2 < 64) {
            return 0L != (0x3FF6CFA00000000L & 1L << by2);
        }
        return 0L != (0x57FFFFFFC7FFFFFEL & 1L << by2 - 64);
    }
}

