/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.io.netty.handler.codec.http;

import com.gradle.maven.extension.internal.dep.io.netty.handler.codec.http.HttpUtil;
import com.gradle.maven.extension.internal.dep.io.netty.util.AsciiString;

public final class HttpHeaderValidationUtil {
    public static int validateValidHeaderValue(CharSequence charSequence) {
        int n2 = charSequence.length();
        if (n2 == 0) {
            return -1;
        }
        if (charSequence instanceof AsciiString) {
            return HttpHeaderValidationUtil.verifyValidHeaderValueAsciiString((AsciiString)charSequence);
        }
        return HttpHeaderValidationUtil.verifyValidHeaderValueCharSequence(charSequence);
    }

    private static int verifyValidHeaderValueAsciiString(AsciiString asciiString) {
        int n2;
        byte[] byArray = asciiString.array();
        int n3 = byArray[n2 = asciiString.arrayOffset()] & 0xFF;
        if (n3 < 33 || n3 == 127) {
            return 0;
        }
        int n4 = n2 + asciiString.length();
        for (int i2 = n2 + 1; i2 < n4; ++i2) {
            n3 = byArray[i2] & 0xFF;
            if ((n3 >= 32 || n3 == 9) && n3 != 127) continue;
            return i2 - n2;
        }
        return -1;
    }

    private static int verifyValidHeaderValueCharSequence(CharSequence charSequence) {
        char c2 = charSequence.charAt(0);
        if (c2 < '!' || c2 == '\u007f') {
            return 0;
        }
        int n2 = charSequence.length();
        for (int i2 = 1; i2 < n2; ++i2) {
            c2 = charSequence.charAt(i2);
            if ((c2 >= ' ' || c2 == '\t') && c2 != '\u007f') continue;
            return i2;
        }
        return -1;
    }

    public static int validateToken(CharSequence charSequence) {
        return HttpUtil.validateToken(charSequence);
    }
}

