/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.io.netty.handler.codec.compression;

import com.gradle.maven.extension.internal.dep.io.netty.buffer.ByteBuf;
import com.gradle.maven.extension.internal.dep.io.netty.channel.ChannelHandlerContext;
import com.gradle.maven.extension.internal.dep.io.netty.handler.codec.ByteToMessageDecoder;
import com.gradle.maven.extension.internal.dep.io.netty.handler.codec.compression.DecompressionException;
import com.gradle.maven.extension.internal.dep.io.netty.util.internal.ObjectUtil;

public abstract class ZlibDecoder
extends ByteToMessageDecoder {
    protected final int maxAllocation;

    public ZlibDecoder(int n2) {
        this.maxAllocation = ObjectUtil.checkPositiveOrZero(n2, "maxAllocation");
    }

    protected ByteBuf prepareDecompressBuffer(ChannelHandlerContext channelHandlerContext, ByteBuf byteBuf, int n2) {
        if (byteBuf == null) {
            if (this.maxAllocation == 0) {
                return channelHandlerContext.alloc().heapBuffer(n2);
            }
            return channelHandlerContext.alloc().heapBuffer(Math.min(n2, this.maxAllocation), this.maxAllocation);
        }
        if (byteBuf.ensureWritable(n2, true) == 1) {
            this.decompressionBufferExhausted(byteBuf.duplicate());
            byteBuf.skipBytes(byteBuf.readableBytes());
            throw new DecompressionException("Decompression buffer has reached maximum size: " + byteBuf.maxCapacity());
        }
        return byteBuf;
    }

    protected void decompressionBufferExhausted(ByteBuf byteBuf) {
    }
}

