/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.io.netty.handler.codec.compression;

import com.gradle.maven.extension.internal.dep.io.netty.buffer.ByteBuf;
import com.gradle.maven.extension.internal.dep.io.netty.channel.ChannelHandlerContext;
import com.gradle.maven.extension.internal.dep.io.netty.handler.codec.ByteToMessageDecoder;
import com.gradle.maven.extension.internal.dep.io.netty.handler.codec.compression.DecompressionException;
import com.gradle.maven.extension.internal.dep.io.netty.handler.codec.compression.Snappy;
import java.util.List;

public class SnappyFrameDecoder
extends ByteToMessageDecoder {
    private final Snappy snappy = new Snappy();
    private final boolean validateChecksums;
    private boolean started;
    private boolean corrupted;
    private int numBytesToSkip;

    public SnappyFrameDecoder() {
        this(false);
    }

    public SnappyFrameDecoder(boolean bl2) {
        this.validateChecksums = bl2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    protected void decode(ChannelHandlerContext var1_1, ByteBuf var2_2, List<Object> var3_3) throws Exception {
        if (this.corrupted) {
            var2_2.skipBytes(var2_2.readableBytes());
            return;
        }
        if (this.numBytesToSkip != 0) {
            var4_4 = Math.min(this.numBytesToSkip, var2_2.readableBytes());
            var2_2.skipBytes(var4_4);
            this.numBytesToSkip -= var4_4;
            return;
        }
        try {
            var4_5 = var2_2.readerIndex();
            var5_7 = var2_2.readableBytes();
            if (var5_7 < 4) {
                return;
            }
            var6_8 = var2_2.getUnsignedByte(var4_5);
            var7_9 = SnappyFrameDecoder.mapChunkType((byte)var6_8);
            var8_10 = var2_2.getUnsignedMediumLE(var4_5 + 1);
            switch (1.$SwitchMap$io$netty$handler$codec$compression$SnappyFrameDecoder$ChunkType[var7_9.ordinal()]) {
                case 1: {
                    if (var8_10 != 6) {
                        throw new DecompressionException("Unexpected length of stream identifier: " + var8_10);
                    }
                    if (var5_7 < 10) break;
                    var2_2.skipBytes(4);
                    var9_11 = var2_2.readerIndex();
                    var2_2.skipBytes(6);
                    SnappyFrameDecoder.checkByte(var2_2.getByte(var9_11++), (byte)115);
                    SnappyFrameDecoder.checkByte(var2_2.getByte(var9_11++), (byte)78);
                    SnappyFrameDecoder.checkByte(var2_2.getByte(var9_11++), (byte)97);
                    SnappyFrameDecoder.checkByte(var2_2.getByte(var9_11++), (byte)80);
                    SnappyFrameDecoder.checkByte(var2_2.getByte(var9_11++), (byte)112);
                    SnappyFrameDecoder.checkByte(var2_2.getByte(var9_11), (byte)89);
                    this.started = true;
                    break;
                }
                case 2: {
                    if (!this.started) {
                        throw new DecompressionException("Received RESERVED_SKIPPABLE tag before STREAM_IDENTIFIER");
                    }
                    var2_2.skipBytes(4);
                    var10_12 = Math.min(var8_10, var2_2.readableBytes());
                    var2_2.skipBytes(var10_12);
                    if (var10_12 == var8_10) break;
                    this.numBytesToSkip = var8_10 - var10_12;
                    break;
                }
                case 3: {
                    throw new DecompressionException("Found reserved unskippable chunk type: 0x" + Integer.toHexString(var6_8));
                }
                case 4: {
                    if (!this.started) {
                        throw new DecompressionException("Received UNCOMPRESSED_DATA tag before STREAM_IDENTIFIER");
                    }
                    if (var8_10 > 65540) {
                        throw new DecompressionException("Received UNCOMPRESSED_DATA larger than 65540 bytes");
                    }
                    if (var5_7 < 4 + var8_10) {
                        return;
                    }
                    var2_2.skipBytes(4);
                    if (this.validateChecksums) {
                        var11_13 = var2_2.readIntLE();
                        Snappy.validateChecksum(var11_13, var2_2, var2_2.readerIndex(), var8_10 - 4);
                    } else {
                        var2_2.skipBytes(4);
                    }
                    var3_3.add(var2_2.readRetainedSlice(var8_10 - 4));
                    break;
                }
                case 5: {
                    if (!this.started) {
                        throw new DecompressionException("Received COMPRESSED_DATA tag before STREAM_IDENTIFIER");
                    }
                    if (var8_10 > 0xFFFFFF) {
                        throw new DecompressionException("Received COMPRESSED_DATA that contains chunk that exceeds 16777215 bytes");
                    }
                    if (var5_7 < 4 + var8_10) {
                        return;
                    }
                    var2_2.skipBytes(4);
                    var11_14 = var2_2.readIntLE();
                    var12_15 = this.snappy.getPreamble(var2_2);
                    if (var12_15 > 65536) {
                        throw new DecompressionException("Received COMPRESSED_DATA that contains uncompressed data that exceeds 65536 bytes");
                    }
                    var13_16 = var1_1.alloc().buffer(var12_15, 65536);
                    try {
                        if (!this.validateChecksums) ** GOTO lbl96
                        var14_17 = var2_2.writerIndex();
                        try {
                            var2_2.writerIndex(var2_2.readerIndex() + var8_10 - 4);
                            this.snappy.decode(var2_2, var13_16);
                        }
                        finally {
                            var2_2.writerIndex(var14_17);
                        }
                        Snappy.validateChecksum(var11_14, var13_16, 0, var13_16.writerIndex());
                        ** GOTO lbl97
lbl96:
                        // 1 sources

                        this.snappy.decode(var2_2.readSlice(var8_10 - 4), var13_16);
lbl97:
                        // 2 sources

                        var3_3.add(var13_16);
                        var13_16 = null;
                    }
                    finally {
                        if (var13_16 != null) {
                            var13_16.release();
                        }
                    }
                    this.snappy.reset();
                }
            }
        }
        catch (Exception var4_6) {
            this.corrupted = true;
            throw var4_6;
        }
    }

    private static void checkByte(byte by2, byte by3) {
        if (by2 != by3) {
            throw new DecompressionException("Unexpected stream identifier contents. Mismatched snappy protocol version?");
        }
    }

    private static ChunkType mapChunkType(byte by2) {
        if (by2 == 0) {
            return ChunkType.COMPRESSED_DATA;
        }
        if (by2 == 1) {
            return ChunkType.UNCOMPRESSED_DATA;
        }
        if (by2 == -1) {
            return ChunkType.STREAM_IDENTIFIER;
        }
        if ((by2 & 0x80) == 128) {
            return ChunkType.RESERVED_SKIPPABLE;
        }
        return ChunkType.RESERVED_UNSKIPPABLE;
    }

    private static enum ChunkType {
        STREAM_IDENTIFIER,
        COMPRESSED_DATA,
        UNCOMPRESSED_DATA,
        RESERVED_UNSKIPPABLE,
        RESERVED_SKIPPABLE;

    }
}

