/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.io.netty.handler.codec;

import com.gradle.maven.extension.internal.dep.io.netty.channel.ChannelHandlerContext;
import com.gradle.maven.extension.internal.dep.io.netty.channel.ChannelInboundHandlerAdapter;
import com.gradle.maven.extension.internal.dep.io.netty.handler.codec.CodecOutputList;
import com.gradle.maven.extension.internal.dep.io.netty.handler.codec.DecoderException;
import com.gradle.maven.extension.internal.dep.io.netty.util.ReferenceCountUtil;
import com.gradle.maven.extension.internal.dep.io.netty.util.internal.TypeParameterMatcher;
import java.util.List;

public abstract class MessageToMessageDecoder<I>
extends ChannelInboundHandlerAdapter {
    private final TypeParameterMatcher matcher;
    private boolean decodeCalled;
    private boolean messageProduced;

    protected MessageToMessageDecoder(Class<? extends I> clazz) {
        this.matcher = TypeParameterMatcher.get(clazz);
    }

    public boolean acceptInboundMessage(Object object) throws Exception {
        return this.matcher.match(object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void channelRead(ChannelHandlerContext channelHandlerContext, Object object) throws Exception {
        CodecOutputList codecOutputList;
        block17: {
            this.decodeCalled = true;
            codecOutputList = CodecOutputList.newInstance();
            try {
                if (this.acceptInboundMessage(object)) {
                    Object object2 = object;
                    try {
                        this.decode(channelHandlerContext, object2, codecOutputList);
                        break block17;
                    }
                    finally {
                        ReferenceCountUtil.release(object2);
                    }
                }
                codecOutputList.add(object);
            }
            catch (DecoderException decoderException) {
                try {
                    throw decoderException;
                    catch (Exception exception) {
                        throw new DecoderException(exception);
                    }
                }
                catch (Throwable throwable) {
                    try {
                        int n2 = codecOutputList.size();
                        this.messageProduced |= n2 > 0;
                        for (int i2 = 0; i2 < n2; ++i2) {
                            channelHandlerContext.fireChannelRead(codecOutputList.getUnsafe(i2));
                        }
                        throw throwable;
                    }
                    finally {
                        codecOutputList.recycle();
                    }
                }
            }
        }
        try {
            int n3 = codecOutputList.size();
            this.messageProduced |= n3 > 0;
            for (int i3 = 0; i3 < n3; ++i3) {
                channelHandlerContext.fireChannelRead(codecOutputList.getUnsafe(i3));
            }
            return;
        }
        finally {
            codecOutputList.recycle();
        }
    }

    @Override
    public void channelReadComplete(ChannelHandlerContext channelHandlerContext) throws Exception {
        if (!this.isSharable()) {
            if (this.decodeCalled && !this.messageProduced && !channelHandlerContext.channel().config().isAutoRead()) {
                channelHandlerContext.read();
            }
            this.decodeCalled = false;
            this.messageProduced = false;
        }
        channelHandlerContext.fireChannelReadComplete();
    }

    protected abstract void decode(ChannelHandlerContext var1, I var2, List<Object> var3) throws Exception;
}

