/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.io.netty.channel.nio;

import com.gradle.maven.extension.internal.dep.io.netty.channel.Channel;
import com.gradle.maven.extension.internal.dep.io.netty.channel.ChannelConfig;
import com.gradle.maven.extension.internal.dep.io.netty.channel.ChannelOutboundBuffer;
import com.gradle.maven.extension.internal.dep.io.netty.channel.ChannelPipeline;
import com.gradle.maven.extension.internal.dep.io.netty.channel.RecvByteBufAllocator;
import com.gradle.maven.extension.internal.dep.io.netty.channel.ServerChannel;
import com.gradle.maven.extension.internal.dep.io.netty.channel.nio.AbstractNioChannel;
import com.gradle.maven.extension.internal.dep.io.netty.channel.nio.NioIoOps;
import java.io.IOException;
import java.net.PortUnreachableException;
import java.nio.channels.SelectableChannel;
import java.util.ArrayList;
import java.util.List;

public abstract class AbstractNioMessageChannel
extends AbstractNioChannel {
    boolean inputShutdown;

    protected AbstractNioMessageChannel(Channel channel, SelectableChannel selectableChannel, int n2) {
        super(channel, selectableChannel, n2);
    }

    @Override
    protected AbstractNioChannel.AbstractNioUnsafe newUnsafe() {
        return new NioMessageUnsafe();
    }

    @Override
    protected void doBeginRead() throws Exception {
        if (this.inputShutdown) {
            return;
        }
        super.doBeginRead();
    }

    protected boolean continueReading(RecvByteBufAllocator.Handle handle) {
        return handle.continueReading();
    }

    @Override
    protected void doWrite(ChannelOutboundBuffer channelOutboundBuffer) throws Exception {
        Object object;
        int n2 = this.maxMessagesPerWrite();
        while (n2 > 0 && (object = channelOutboundBuffer.current()) != null) {
            try {
                boolean bl2 = false;
                for (int i2 = this.config().getWriteSpinCount() - 1; i2 >= 0; --i2) {
                    if (!this.doWriteMessage(object, channelOutboundBuffer)) continue;
                    bl2 = true;
                    break;
                }
                if (!bl2) break;
                --n2;
                channelOutboundBuffer.remove();
            }
            catch (Exception exception) {
                if (this.continueOnWriteError()) {
                    --n2;
                    channelOutboundBuffer.remove(exception);
                    continue;
                }
                throw exception;
            }
        }
        if (channelOutboundBuffer.isEmpty()) {
            this.removeAndSubmit(NioIoOps.WRITE);
        } else {
            this.addAndSubmit(NioIoOps.WRITE);
        }
    }

    protected boolean continueOnWriteError() {
        return false;
    }

    protected boolean closeOnReadError(Throwable throwable) {
        if (!this.isActive()) {
            return true;
        }
        if (throwable instanceof PortUnreachableException) {
            return false;
        }
        if (throwable instanceof IOException) {
            return !(this instanceof ServerChannel);
        }
        return true;
    }

    protected abstract int doReadMessages(List<Object> var1) throws Exception;

    protected abstract boolean doWriteMessage(Object var1, ChannelOutboundBuffer var2) throws Exception;

    private final class NioMessageUnsafe
    extends AbstractNioChannel.AbstractNioUnsafe {
        private final List<Object> readBuf = new ArrayList<Object>();

        private NioMessageUnsafe() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void read() {
            assert (AbstractNioMessageChannel.this.eventLoop().inEventLoop());
            ChannelConfig channelConfig = AbstractNioMessageChannel.this.config();
            ChannelPipeline channelPipeline = AbstractNioMessageChannel.this.pipeline();
            RecvByteBufAllocator.Handle handle = AbstractNioMessageChannel.this.unsafe().recvBufAllocHandle();
            handle.reset(channelConfig);
            boolean bl2 = false;
            Throwable throwable = null;
            try {
                int n2;
                try {
                    while ((n2 = AbstractNioMessageChannel.this.doReadMessages(this.readBuf)) != 0) {
                        if (n2 < 0) {
                            bl2 = true;
                        } else {
                            handle.incMessagesRead(n2);
                            if (AbstractNioMessageChannel.this.continueReading(handle)) continue;
                        }
                        break;
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                }
                n2 = this.readBuf.size();
                for (int i2 = 0; i2 < n2; ++i2) {
                    AbstractNioMessageChannel.this.readPending = false;
                    channelPipeline.fireChannelRead(this.readBuf.get(i2));
                }
                this.readBuf.clear();
                handle.readComplete();
                channelPipeline.fireChannelReadComplete();
                if (throwable != null) {
                    bl2 = AbstractNioMessageChannel.this.closeOnReadError(throwable);
                    channelPipeline.fireExceptionCaught(throwable);
                }
                if (bl2) {
                    AbstractNioMessageChannel.this.inputShutdown = true;
                    if (AbstractNioMessageChannel.this.isOpen()) {
                        this.close(this.voidPromise());
                    }
                }
            }
            finally {
                if (!AbstractNioMessageChannel.this.readPending && !channelConfig.isAutoRead()) {
                    this.removeReadOp();
                }
            }
        }
    }
}

