/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.io.netty.buffer;

import com.gradle.maven.extension.internal.dep.io.netty.buffer.PoolArena;
import com.gradle.maven.extension.internal.dep.io.netty.buffer.PoolChunk;
import com.gradle.maven.extension.internal.dep.io.netty.buffer.PooledByteBuf;
import com.gradle.maven.extension.internal.dep.io.netty.util.Recycler;
import com.gradle.maven.extension.internal.dep.io.netty.util.internal.MathUtil;
import com.gradle.maven.extension.internal.dep.io.netty.util.internal.ObjectPool;
import com.gradle.maven.extension.internal.dep.io.netty.util.internal.ObjectUtil;
import com.gradle.maven.extension.internal.dep.io.netty.util.internal.PlatformDependent;
import com.gradle.maven.extension.internal.dep.io.netty.util.internal.logging.InternalLogger;
import com.gradle.maven.extension.internal.dep.io.netty.util.internal.logging.InternalLoggerFactory;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Queue;
import java.util.concurrent.atomic.AtomicBoolean;

final class PoolThreadCache {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(PoolThreadCache.class);
    final PoolArena<byte[]> heapArena;
    final PoolArena<ByteBuffer> directArena;
    private final MemoryRegionCache<byte[]>[] smallSubPageHeapCaches;
    private final MemoryRegionCache<ByteBuffer>[] smallSubPageDirectCaches;
    private final MemoryRegionCache<byte[]>[] normalHeapCaches;
    private final MemoryRegionCache<ByteBuffer>[] normalDirectCaches;
    private final int freeSweepAllocationThreshold;
    private final AtomicBoolean freed = new AtomicBoolean();
    private final FreeOnFinalize freeOnFinalize;
    private int allocations;

    PoolThreadCache(PoolArena<byte[]> poolArena, PoolArena<ByteBuffer> poolArena2, int n2, int n3, int n4, int n5, boolean bl2) {
        ObjectUtil.checkPositiveOrZero(n4, "maxCachedBufferCapacity");
        this.freeSweepAllocationThreshold = n5;
        this.heapArena = poolArena;
        this.directArena = poolArena2;
        if (poolArena2 != null) {
            this.smallSubPageDirectCaches = PoolThreadCache.createSubPageCaches(n2, poolArena2.sizeClass.nSubpages);
            this.normalDirectCaches = PoolThreadCache.createNormalCaches(n3, n4, poolArena2);
            poolArena2.numThreadCaches.getAndIncrement();
        } else {
            this.smallSubPageDirectCaches = null;
            this.normalDirectCaches = null;
        }
        if (poolArena != null) {
            this.smallSubPageHeapCaches = PoolThreadCache.createSubPageCaches(n2, poolArena.sizeClass.nSubpages);
            this.normalHeapCaches = PoolThreadCache.createNormalCaches(n3, n4, poolArena);
            poolArena.numThreadCaches.getAndIncrement();
        } else {
            this.smallSubPageHeapCaches = null;
            this.normalHeapCaches = null;
        }
        if ((this.smallSubPageDirectCaches != null || this.normalDirectCaches != null || this.smallSubPageHeapCaches != null || this.normalHeapCaches != null) && n5 < 1) {
            throw new IllegalArgumentException("freeSweepAllocationThreshold: " + n5 + " (expected: > 0)");
        }
        this.freeOnFinalize = bl2 ? new FreeOnFinalize(this) : null;
    }

    private static <T> MemoryRegionCache<T>[] createSubPageCaches(int n2, int n3) {
        if (n2 > 0 && n3 > 0) {
            MemoryRegionCache[] memoryRegionCacheArray = new MemoryRegionCache[n3];
            for (int i2 = 0; i2 < memoryRegionCacheArray.length; ++i2) {
                memoryRegionCacheArray[i2] = new SubPageMemoryRegionCache(n2);
            }
            return memoryRegionCacheArray;
        }
        return null;
    }

    private static <T> MemoryRegionCache<T>[] createNormalCaches(int n2, int n3, PoolArena<T> poolArena) {
        if (n2 > 0 && n3 > 0) {
            int n4 = Math.min(poolArena.sizeClass.chunkSize, n3);
            ArrayList arrayList = new ArrayList();
            for (int i2 = poolArena.sizeClass.nSubpages; i2 < poolArena.sizeClass.nSizes && poolArena.sizeClass.sizeIdx2size(i2) <= n4; ++i2) {
                arrayList.add(new NormalMemoryRegionCache(n2));
            }
            return arrayList.toArray(new MemoryRegionCache[0]);
        }
        return null;
    }

    static int log2(int n2) {
        return 31 - Integer.numberOfLeadingZeros(n2);
    }

    boolean allocateSmall(PoolArena<?> poolArena, PooledByteBuf<?> pooledByteBuf, int n2, int n3) {
        return this.allocate(this.cacheForSmall(poolArena, n3), pooledByteBuf, n2);
    }

    boolean allocateNormal(PoolArena<?> poolArena, PooledByteBuf<?> pooledByteBuf, int n2, int n3) {
        return this.allocate(this.cacheForNormal(poolArena, n3), pooledByteBuf, n2);
    }

    private boolean allocate(MemoryRegionCache<?> memoryRegionCache, PooledByteBuf pooledByteBuf, int n2) {
        if (memoryRegionCache == null) {
            return false;
        }
        boolean bl2 = memoryRegionCache.allocate(pooledByteBuf, n2, this);
        if (++this.allocations >= this.freeSweepAllocationThreshold) {
            this.allocations = 0;
            this.trim();
        }
        return bl2;
    }

    boolean add(PoolArena<?> poolArena, PoolChunk poolChunk, ByteBuffer byteBuffer, long l2, int n2, PoolArena.SizeClass sizeClass) {
        int n3 = poolArena.sizeClass.size2SizeIdx(n2);
        MemoryRegionCache<?> memoryRegionCache = this.cache(poolArena, n3, sizeClass);
        if (memoryRegionCache == null) {
            return false;
        }
        if (this.freed.get()) {
            return false;
        }
        return memoryRegionCache.add(poolChunk, byteBuffer, l2, n2);
    }

    private MemoryRegionCache<?> cache(PoolArena<?> poolArena, int n2, PoolArena.SizeClass sizeClass) {
        switch (sizeClass) {
            case Normal: {
                return this.cacheForNormal(poolArena, n2);
            }
            case Small: {
                return this.cacheForSmall(poolArena, n2);
            }
        }
        throw new Error();
    }

    void free(boolean bl2) {
        if (this.freed.compareAndSet(false, true)) {
            int n2;
            if (this.freeOnFinalize != null) {
                this.freeOnFinalize.cache = null;
            }
            if ((n2 = PoolThreadCache.free(this.smallSubPageDirectCaches, bl2) + PoolThreadCache.free(this.normalDirectCaches, bl2) + PoolThreadCache.free(this.smallSubPageHeapCaches, bl2) + PoolThreadCache.free(this.normalHeapCaches, bl2)) > 0 && logger.isDebugEnabled()) {
                logger.debug("Freed {} thread-local buffer(s) from thread: {}", (Object)n2, (Object)Thread.currentThread().getName());
            }
            if (this.directArena != null) {
                this.directArena.numThreadCaches.getAndDecrement();
            }
            if (this.heapArena != null) {
                this.heapArena.numThreadCaches.getAndDecrement();
            }
        }
    }

    private static int free(MemoryRegionCache<?>[] memoryRegionCacheArray, boolean bl2) {
        if (memoryRegionCacheArray == null) {
            return 0;
        }
        int n2 = 0;
        for (MemoryRegionCache<?> memoryRegionCache : memoryRegionCacheArray) {
            n2 += PoolThreadCache.free(memoryRegionCache, bl2);
        }
        return n2;
    }

    private static int free(MemoryRegionCache<?> memoryRegionCache, boolean bl2) {
        if (memoryRegionCache == null) {
            return 0;
        }
        return memoryRegionCache.free(bl2);
    }

    void trim() {
        PoolThreadCache.trim(this.smallSubPageDirectCaches);
        PoolThreadCache.trim(this.normalDirectCaches);
        PoolThreadCache.trim(this.smallSubPageHeapCaches);
        PoolThreadCache.trim(this.normalHeapCaches);
    }

    private static void trim(MemoryRegionCache<?>[] memoryRegionCacheArray) {
        if (memoryRegionCacheArray == null) {
            return;
        }
        for (MemoryRegionCache<?> memoryRegionCache : memoryRegionCacheArray) {
            PoolThreadCache.trim(memoryRegionCache);
        }
    }

    private static void trim(MemoryRegionCache<?> memoryRegionCache) {
        if (memoryRegionCache == null) {
            return;
        }
        memoryRegionCache.trim();
    }

    private MemoryRegionCache<?> cacheForSmall(PoolArena<?> poolArena, int n2) {
        if (poolArena.isDirect()) {
            return PoolThreadCache.cache(this.smallSubPageDirectCaches, n2);
        }
        return PoolThreadCache.cache(this.smallSubPageHeapCaches, n2);
    }

    private MemoryRegionCache<?> cacheForNormal(PoolArena<?> poolArena, int n2) {
        int n3 = n2 - poolArena.sizeClass.nSubpages;
        if (poolArena.isDirect()) {
            return PoolThreadCache.cache(this.normalDirectCaches, n3);
        }
        return PoolThreadCache.cache(this.normalHeapCaches, n3);
    }

    private static <T> MemoryRegionCache<T> cache(MemoryRegionCache<T>[] memoryRegionCacheArray, int n2) {
        if (memoryRegionCacheArray == null || n2 >= memoryRegionCacheArray.length) {
            return null;
        }
        return memoryRegionCacheArray[n2];
    }

    private static final class FreeOnFinalize {
        private volatile PoolThreadCache cache;

        private FreeOnFinalize(PoolThreadCache poolThreadCache) {
            this.cache = poolThreadCache;
        }

        protected void finalize() throws Throwable {
            try {
                super.finalize();
            }
            finally {
                PoolThreadCache poolThreadCache = this.cache;
                this.cache = null;
                if (poolThreadCache != null) {
                    poolThreadCache.free(true);
                }
            }
        }
    }

    private static abstract class MemoryRegionCache<T> {
        private final int size;
        private final Queue<Entry<T>> queue;
        private final PoolArena.SizeClass sizeClass;
        private int allocations;
        private static final Recycler<Entry> RECYCLER = new Recycler<Entry>(){

            @Override
            protected Entry newObject(Recycler.Handle<Entry> handle) {
                return new Entry(handle);
            }
        };

        MemoryRegionCache(int n2, PoolArena.SizeClass sizeClass) {
            this.size = MathUtil.safeFindNextPositivePowerOfTwo(n2);
            this.queue = PlatformDependent.newFixedMpscUnpaddedQueue(this.size);
            this.sizeClass = sizeClass;
        }

        protected abstract void initBuf(PoolChunk<T> var1, ByteBuffer var2, long var3, PooledByteBuf<T> var5, int var6, PoolThreadCache var7);

        public final boolean add(PoolChunk<T> poolChunk, ByteBuffer byteBuffer, long l2, int n2) {
            Entry entry = MemoryRegionCache.newEntry(poolChunk, byteBuffer, l2, n2);
            boolean bl2 = this.queue.offer(entry);
            if (!bl2) {
                entry.unguardedRecycle();
            }
            return bl2;
        }

        public final boolean allocate(PooledByteBuf<T> pooledByteBuf, int n2, PoolThreadCache poolThreadCache) {
            Entry<T> entry = this.queue.poll();
            if (entry == null) {
                return false;
            }
            this.initBuf(entry.chunk, entry.nioBuffer, entry.handle, pooledByteBuf, n2, poolThreadCache);
            entry.unguardedRecycle();
            ++this.allocations;
            return true;
        }

        public final int free(boolean bl2) {
            return this.free(Integer.MAX_VALUE, bl2);
        }

        private int free(int n2, boolean bl2) {
            int n3;
            for (n3 = 0; n3 < n2; ++n3) {
                Entry<T> entry = this.queue.poll();
                if (entry == null) {
                    return n3;
                }
                this.freeEntry(entry, bl2);
            }
            return n3;
        }

        public final void trim() {
            int n2 = this.size - this.allocations;
            this.allocations = 0;
            if (n2 > 0) {
                this.free(n2, false);
            }
        }

        private void freeEntry(Entry entry, boolean bl2) {
            PoolChunk poolChunk = entry.chunk;
            long l2 = entry.handle;
            ByteBuffer byteBuffer = entry.nioBuffer;
            int n2 = entry.normCapacity;
            if (!bl2) {
                entry.recycle();
            }
            poolChunk.arena.freeChunk(poolChunk, l2, n2, this.sizeClass, byteBuffer, bl2);
        }

        private static Entry newEntry(PoolChunk<?> poolChunk, ByteBuffer byteBuffer, long l2, int n2) {
            Entry entry = RECYCLER.get();
            entry.chunk = poolChunk;
            entry.nioBuffer = byteBuffer;
            entry.handle = l2;
            entry.normCapacity = n2;
            return entry;
        }

        static final class Entry<T> {
            final Recycler.EnhancedHandle<Entry<?>> recyclerHandle;
            PoolChunk<T> chunk;
            ByteBuffer nioBuffer;
            long handle = -1L;
            int normCapacity;

            Entry(ObjectPool.Handle<Entry<?>> handle) {
                this.recyclerHandle = (Recycler.EnhancedHandle)handle;
            }

            void recycle() {
                this.chunk = null;
                this.nioBuffer = null;
                this.handle = -1L;
                this.recyclerHandle.recycle(this);
            }

            void unguardedRecycle() {
                this.chunk = null;
                this.nioBuffer = null;
                this.handle = -1L;
                this.recyclerHandle.unguardedRecycle(this);
            }
        }
    }

    private static final class NormalMemoryRegionCache<T>
    extends MemoryRegionCache<T> {
        NormalMemoryRegionCache(int n2) {
            super(n2, PoolArena.SizeClass.Normal);
        }

        @Override
        protected void initBuf(PoolChunk<T> poolChunk, ByteBuffer byteBuffer, long l2, PooledByteBuf<T> pooledByteBuf, int n2, PoolThreadCache poolThreadCache) {
            poolChunk.initBuf(pooledByteBuf, byteBuffer, l2, n2, poolThreadCache, true);
        }
    }

    private static final class SubPageMemoryRegionCache<T>
    extends MemoryRegionCache<T> {
        SubPageMemoryRegionCache(int n2) {
            super(n2, PoolArena.SizeClass.Small);
        }

        @Override
        protected void initBuf(PoolChunk<T> poolChunk, ByteBuffer byteBuffer, long l2, PooledByteBuf<T> pooledByteBuf, int n2, PoolThreadCache poolThreadCache) {
            poolChunk.initBufWithSubpage(pooledByteBuf, byteBuffer, l2, n2, poolThreadCache, true);
        }
    }
}

