/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.io.netty.buffer;

import com.gradle.maven.extension.internal.dep.io.netty.buffer.PoolChunk;
import com.gradle.maven.extension.internal.dep.io.netty.buffer.PoolChunkList;
import com.gradle.maven.extension.internal.dep.io.netty.buffer.PoolChunkListMetric;
import com.gradle.maven.extension.internal.dep.io.netty.buffer.PoolChunkMetric;
import com.gradle.maven.extension.internal.dep.io.netty.buffer.PoolSubpage;
import com.gradle.maven.extension.internal.dep.io.netty.buffer.PoolThreadCache;
import com.gradle.maven.extension.internal.dep.io.netty.buffer.PooledByteBuf;
import com.gradle.maven.extension.internal.dep.io.netty.buffer.PooledByteBufAllocator;
import com.gradle.maven.extension.internal.dep.io.netty.buffer.PooledDirectByteBuf;
import com.gradle.maven.extension.internal.dep.io.netty.buffer.PooledHeapByteBuf;
import com.gradle.maven.extension.internal.dep.io.netty.buffer.PooledUnsafeDirectByteBuf;
import com.gradle.maven.extension.internal.dep.io.netty.buffer.PooledUnsafeHeapByteBuf;
import com.gradle.maven.extension.internal.dep.io.netty.buffer.SizeClasses;
import com.gradle.maven.extension.internal.dep.io.netty.util.internal.CleanableDirectBuffer;
import com.gradle.maven.extension.internal.dep.io.netty.util.internal.PlatformDependent;
import com.gradle.maven.extension.internal.dep.io.netty.util.internal.StringUtil;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.atomic.LongAdder;
import java.util.concurrent.locks.ReentrantLock;

abstract class PoolArena<T> {
    private static final boolean HAS_UNSAFE = PlatformDependent.hasUnsafe();
    final PooledByteBufAllocator parent;
    final PoolSubpage<T>[] smallSubpagePools;
    private final PoolChunkList<T> q050;
    private final PoolChunkList<T> q025;
    private final PoolChunkList<T> q000;
    private final PoolChunkList<T> qInit;
    private final PoolChunkList<T> q075;
    private final PoolChunkList<T> q100;
    private final List<PoolChunkListMetric> chunkListMetrics;
    private long allocationsNormal;
    private final LongAdder allocationsSmall = new LongAdder();
    private final LongAdder allocationsHuge = new LongAdder();
    private final LongAdder activeBytesHuge = new LongAdder();
    private long deallocationsSmall;
    private long deallocationsNormal;
    private long pooledChunkAllocations;
    private long pooledChunkDeallocations;
    private final LongAdder deallocationsHuge = new LongAdder();
    final AtomicInteger numThreadCaches = new AtomicInteger();
    private final ReentrantLock lock = new ReentrantLock();
    final SizeClasses sizeClass;

    protected PoolArena(PooledByteBufAllocator pooledByteBufAllocator, SizeClasses sizeClasses) {
        assert (null != sizeClasses);
        this.parent = pooledByteBufAllocator;
        this.sizeClass = sizeClasses;
        this.smallSubpagePools = this.newSubpagePoolArray(sizeClasses.nSubpages);
        for (int i2 = 0; i2 < this.smallSubpagePools.length; ++i2) {
            this.smallSubpagePools[i2] = this.newSubpagePoolHead(i2);
        }
        this.q100 = new PoolChunkList(this, null, 100, Integer.MAX_VALUE, sizeClasses.chunkSize);
        this.q075 = new PoolChunkList<T>(this, this.q100, 75, 100, sizeClasses.chunkSize);
        this.q050 = new PoolChunkList<T>(this, this.q100, 50, 100, sizeClasses.chunkSize);
        this.q025 = new PoolChunkList<T>(this, this.q050, 25, 75, sizeClasses.chunkSize);
        this.q000 = new PoolChunkList<T>(this, this.q025, 1, 50, sizeClasses.chunkSize);
        this.qInit = new PoolChunkList<T>(this, this.q000, Integer.MIN_VALUE, 25, sizeClasses.chunkSize);
        this.q100.prevList(this.q075);
        this.q075.prevList(this.q050);
        this.q050.prevList(this.q025);
        this.q025.prevList(this.q000);
        this.q000.prevList(null);
        this.qInit.prevList(this.qInit);
        ArrayList<PoolChunkList<T>> arrayList = new ArrayList<PoolChunkList<T>>(6);
        arrayList.add(this.qInit);
        arrayList.add(this.q000);
        arrayList.add(this.q025);
        arrayList.add(this.q050);
        arrayList.add(this.q075);
        arrayList.add(this.q100);
        this.chunkListMetrics = Collections.unmodifiableList(arrayList);
    }

    private PoolSubpage<T> newSubpagePoolHead(int n2) {
        PoolSubpage poolSubpage = new PoolSubpage(n2);
        poolSubpage.prev = poolSubpage;
        poolSubpage.next = poolSubpage;
        return poolSubpage;
    }

    private PoolSubpage<T>[] newSubpagePoolArray(int n2) {
        return new PoolSubpage[n2];
    }

    abstract boolean isDirect();

    PooledByteBuf<T> allocate(PoolThreadCache poolThreadCache, int n2, int n3) {
        PooledByteBuf<T> pooledByteBuf = this.newByteBuf(n3);
        this.allocate(poolThreadCache, pooledByteBuf, n2);
        return pooledByteBuf;
    }

    private void allocate(PoolThreadCache poolThreadCache, PooledByteBuf<T> pooledByteBuf, int n2) {
        int n3 = this.sizeClass.size2SizeIdx(n2);
        if (n3 <= this.sizeClass.smallMaxSizeIdx) {
            this.tcacheAllocateSmall(poolThreadCache, pooledByteBuf, n2, n3);
        } else if (n3 < this.sizeClass.nSizes) {
            this.tcacheAllocateNormal(poolThreadCache, pooledByteBuf, n2, n3);
        } else {
            int n4 = this.sizeClass.directMemoryCacheAlignment > 0 ? this.sizeClass.normalizeSize(n2) : n2;
            this.allocateHuge(pooledByteBuf, n4);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void tcacheAllocateSmall(PoolThreadCache poolThreadCache, PooledByteBuf<T> pooledByteBuf, int n2, int n3) {
        boolean bl2;
        if (poolThreadCache.allocateSmall(this, pooledByteBuf, n2, n3)) {
            return;
        }
        PoolSubpage<T> poolSubpage = this.smallSubpagePools[n3];
        poolSubpage.lock();
        try {
            PoolSubpage poolSubpage2 = poolSubpage.next;
            boolean bl3 = bl2 = poolSubpage2 == poolSubpage;
            if (!bl2) {
                assert (poolSubpage2.doNotDestroy && poolSubpage2.elemSize == this.sizeClass.sizeIdx2size(n3)) : "doNotDestroy=" + poolSubpage2.doNotDestroy + ", elemSize=" + poolSubpage2.elemSize + ", sizeIdx=" + n3;
                long l2 = poolSubpage2.allocate();
                assert (l2 >= 0L);
                poolSubpage2.chunk.initBufWithSubpage(pooledByteBuf, null, l2, n2, poolThreadCache, false);
            }
        }
        finally {
            poolSubpage.unlock();
        }
        if (bl2) {
            this.lock();
            try {
                this.allocateNormal(pooledByteBuf, n2, n3, poolThreadCache);
            }
            finally {
                this.unlock();
            }
        }
        this.incSmallAllocation();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void tcacheAllocateNormal(PoolThreadCache poolThreadCache, PooledByteBuf<T> pooledByteBuf, int n2, int n3) {
        if (poolThreadCache.allocateNormal(this, pooledByteBuf, n2, n3)) {
            return;
        }
        this.lock();
        try {
            this.allocateNormal(pooledByteBuf, n2, n3, poolThreadCache);
            ++this.allocationsNormal;
        }
        finally {
            this.unlock();
        }
    }

    private void allocateNormal(PooledByteBuf<T> pooledByteBuf, int n2, int n3, PoolThreadCache poolThreadCache) {
        assert (this.lock.isHeldByCurrentThread());
        if (this.q050.allocate(pooledByteBuf, n2, n3, poolThreadCache) || this.q025.allocate(pooledByteBuf, n2, n3, poolThreadCache) || this.q000.allocate(pooledByteBuf, n2, n3, poolThreadCache) || this.qInit.allocate(pooledByteBuf, n2, n3, poolThreadCache) || this.q075.allocate(pooledByteBuf, n2, n3, poolThreadCache)) {
            return;
        }
        PoolChunk<T> poolChunk = this.newChunk(this.sizeClass.pageSize, this.sizeClass.nPSizes, this.sizeClass.pageShifts, this.sizeClass.chunkSize);
        PooledByteBufAllocator.onAllocateChunk(poolChunk, true);
        boolean bl2 = poolChunk.allocate(pooledByteBuf, n2, n3, poolThreadCache);
        assert (bl2);
        this.qInit.add(poolChunk);
        ++this.pooledChunkAllocations;
    }

    private void incSmallAllocation() {
        this.allocationsSmall.increment();
    }

    private void allocateHuge(PooledByteBuf<T> pooledByteBuf, int n2) {
        PoolChunk<T> poolChunk = this.newUnpooledChunk(n2);
        PooledByteBufAllocator.onAllocateChunk(poolChunk, false);
        this.activeBytesHuge.add(poolChunk.chunkSize());
        pooledByteBuf.initUnpooled(poolChunk, n2);
        this.allocationsHuge.increment();
    }

    void free(PoolChunk<T> poolChunk, ByteBuffer byteBuffer, long l2, int n2, PoolThreadCache poolThreadCache) {
        poolChunk.decrementPinnedMemory(n2);
        if (poolChunk.unpooled) {
            int n3 = poolChunk.chunkSize();
            this.destroyChunk(poolChunk);
            this.activeBytesHuge.add(-n3);
            this.deallocationsHuge.increment();
        } else {
            SizeClass sizeClass = PoolArena.sizeClass(l2);
            if (poolThreadCache != null && poolThreadCache.add(this, poolChunk, byteBuffer, l2, n2, sizeClass)) {
                return;
            }
            this.freeChunk(poolChunk, l2, n2, sizeClass, byteBuffer, false);
        }
    }

    private static SizeClass sizeClass(long l2) {
        return PoolChunk.isSubpage(l2) ? SizeClass.Small : SizeClass.Normal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void freeChunk(PoolChunk<T> poolChunk, long l2, int n2, SizeClass sizeClass, ByteBuffer byteBuffer, boolean bl2) {
        boolean bl3;
        this.lock();
        try {
            if (!bl2) {
                switch (sizeClass) {
                    case Normal: {
                        ++this.deallocationsNormal;
                        break;
                    }
                    case Small: {
                        ++this.deallocationsSmall;
                        break;
                    }
                    default: {
                        throw new Error();
                    }
                }
            }
            boolean bl4 = bl3 = !poolChunk.parent.free(poolChunk, l2, n2, byteBuffer);
            if (bl3) {
                ++this.pooledChunkDeallocations;
            }
        }
        finally {
            this.unlock();
        }
        if (bl3) {
            this.destroyChunk(poolChunk);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void reallocate(PooledByteBuf<T> pooledByteBuf, int n2) {
        int n3;
        PoolThreadCache poolThreadCache;
        int n4;
        int n5;
        Object t2;
        long l2;
        ByteBuffer byteBuffer;
        PoolChunk poolChunk;
        int n6;
        assert (n2 >= 0 && n2 <= pooledByteBuf.maxCapacity());
        PooledByteBuf<T> pooledByteBuf2 = pooledByteBuf;
        synchronized (pooledByteBuf2) {
            n6 = pooledByteBuf.length;
            if (n6 == n2) {
                return;
            }
            poolChunk = pooledByteBuf.chunk;
            byteBuffer = pooledByteBuf.tmpNioBuf;
            l2 = pooledByteBuf.handle;
            t2 = pooledByteBuf.memory;
            n5 = pooledByteBuf.offset;
            n4 = pooledByteBuf.maxLength;
            poolThreadCache = pooledByteBuf.cache;
            this.allocate(this.parent.threadCache(), pooledByteBuf, n2);
        }
        if (n2 > n6) {
            n3 = n6;
        } else {
            pooledByteBuf.trimIndicesToCapacity(n2);
            n3 = n2;
        }
        this.memoryCopy(t2, n5, pooledByteBuf, n3);
        this.free(poolChunk, byteBuffer, l2, n4, poolThreadCache);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long numActiveBytes() {
        long l2 = this.activeBytesHuge.sum();
        this.lock();
        try {
            for (int i2 = 0; i2 < this.chunkListMetrics.size(); ++i2) {
                for (PoolChunkMetric poolChunkMetric : this.chunkListMetrics.get(i2)) {
                    l2 += (long)poolChunkMetric.chunkSize();
                }
            }
        }
        finally {
            this.unlock();
        }
        return Math.max(0L, l2);
    }

    protected abstract PoolChunk<T> newChunk(int var1, int var2, int var3, int var4);

    protected abstract PoolChunk<T> newUnpooledChunk(int var1);

    protected abstract PooledByteBuf<T> newByteBuf(int var1);

    protected abstract void memoryCopy(T var1, int var2, PooledByteBuf<T> var3, int var4);

    protected abstract void destroyChunk(PoolChunk<T> var1);

    public String toString() {
        this.lock();
        try {
            StringBuilder stringBuilder = new StringBuilder().append("Chunk(s) at 0~25%:").append(StringUtil.NEWLINE).append(this.qInit).append(StringUtil.NEWLINE).append("Chunk(s) at 0~50%:").append(StringUtil.NEWLINE).append(this.q000).append(StringUtil.NEWLINE).append("Chunk(s) at 25~75%:").append(StringUtil.NEWLINE).append(this.q025).append(StringUtil.NEWLINE).append("Chunk(s) at 50~100%:").append(StringUtil.NEWLINE).append(this.q050).append(StringUtil.NEWLINE).append("Chunk(s) at 75~100%:").append(StringUtil.NEWLINE).append(this.q075).append(StringUtil.NEWLINE).append("Chunk(s) at 100%:").append(StringUtil.NEWLINE).append(this.q100).append(StringUtil.NEWLINE).append("small subpages:");
            PoolArena.appendPoolSubPages(stringBuilder, this.smallSubpagePools);
            stringBuilder.append(StringUtil.NEWLINE);
            String string = stringBuilder.toString();
            return string;
        }
        finally {
            this.unlock();
        }
    }

    private static void appendPoolSubPages(StringBuilder stringBuilder, PoolSubpage<?>[] poolSubpageArray) {
        for (int i2 = 0; i2 < poolSubpageArray.length; ++i2) {
            PoolSubpage<?> poolSubpage = poolSubpageArray[i2];
            if (poolSubpage.next == poolSubpage || poolSubpage.next == null) continue;
            stringBuilder.append(StringUtil.NEWLINE).append(i2).append(": ");
            PoolSubpage poolSubpage2 = poolSubpage.next;
            while (poolSubpage2 != null) {
                stringBuilder.append(poolSubpage2);
                poolSubpage2 = poolSubpage2.next;
                if (poolSubpage2 != poolSubpage) continue;
            }
        }
    }

    protected final void finalize() throws Throwable {
        try {
            super.finalize();
        }
        catch (Throwable throwable) {
            PoolArena.destroyPoolSubPages(this.smallSubpagePools);
            this.destroyPoolChunkLists(this.qInit, this.q000, this.q025, this.q050, this.q075, this.q100);
            throw throwable;
        }
        PoolArena.destroyPoolSubPages(this.smallSubpagePools);
        this.destroyPoolChunkLists(this.qInit, this.q000, this.q025, this.q050, this.q075, this.q100);
    }

    private static void destroyPoolSubPages(PoolSubpage<?>[] poolSubpageArray) {
        for (PoolSubpage<?> poolSubpage : poolSubpageArray) {
            poolSubpage.destroy();
        }
    }

    private void destroyPoolChunkLists(PoolChunkList<T> ... poolChunkListArray) {
        for (PoolChunkList<T> poolChunkList : poolChunkListArray) {
            poolChunkList.destroy(this);
        }
    }

    void lock() {
        this.lock.lock();
    }

    void unlock() {
        this.lock.unlock();
    }

    static final class DirectArena
    extends PoolArena<ByteBuffer> {
        DirectArena(PooledByteBufAllocator pooledByteBufAllocator, SizeClasses sizeClasses) {
            super(pooledByteBufAllocator, sizeClasses);
        }

        @Override
        boolean isDirect() {
            return true;
        }

        @Override
        protected PoolChunk<ByteBuffer> newChunk(int n2, int n3, int n4, int n5) {
            if (this.sizeClass.directMemoryCacheAlignment == 0) {
                CleanableDirectBuffer cleanableDirectBuffer = DirectArena.allocateDirect(n5);
                ByteBuffer byteBuffer = cleanableDirectBuffer.buffer();
                return new PoolChunk<ByteBuffer>(this, cleanableDirectBuffer, byteBuffer, byteBuffer, n2, n4, n5, n3);
            }
            CleanableDirectBuffer cleanableDirectBuffer = DirectArena.allocateDirect(n5 + this.sizeClass.directMemoryCacheAlignment);
            ByteBuffer byteBuffer = cleanableDirectBuffer.buffer();
            ByteBuffer byteBuffer2 = PlatformDependent.alignDirectBuffer(byteBuffer, this.sizeClass.directMemoryCacheAlignment);
            return new PoolChunk<ByteBuffer>(this, cleanableDirectBuffer, byteBuffer, byteBuffer2, n2, n4, n5, n3);
        }

        @Override
        protected PoolChunk<ByteBuffer> newUnpooledChunk(int n2) {
            if (this.sizeClass.directMemoryCacheAlignment == 0) {
                CleanableDirectBuffer cleanableDirectBuffer = DirectArena.allocateDirect(n2);
                ByteBuffer byteBuffer = cleanableDirectBuffer.buffer();
                return new PoolChunk<ByteBuffer>(this, cleanableDirectBuffer, byteBuffer, byteBuffer, n2);
            }
            CleanableDirectBuffer cleanableDirectBuffer = DirectArena.allocateDirect(n2 + this.sizeClass.directMemoryCacheAlignment);
            ByteBuffer byteBuffer = cleanableDirectBuffer.buffer();
            ByteBuffer byteBuffer2 = PlatformDependent.alignDirectBuffer(byteBuffer, this.sizeClass.directMemoryCacheAlignment);
            return new PoolChunk<ByteBuffer>(this, cleanableDirectBuffer, byteBuffer, byteBuffer2, n2);
        }

        private static CleanableDirectBuffer allocateDirect(int n2) {
            return PlatformDependent.allocateDirect(n2);
        }

        @Override
        protected void destroyChunk(PoolChunk<ByteBuffer> poolChunk) {
            PooledByteBufAllocator.onDeallocateChunk(poolChunk, !poolChunk.unpooled);
            poolChunk.cleanable.clean();
        }

        @Override
        protected PooledByteBuf<ByteBuffer> newByteBuf(int n2) {
            if (HAS_UNSAFE) {
                return PooledUnsafeDirectByteBuf.newInstance(n2);
            }
            return PooledDirectByteBuf.newInstance(n2);
        }

        @Override
        protected void memoryCopy(ByteBuffer byteBuffer, int n2, PooledByteBuf<ByteBuffer> pooledByteBuf, int n3) {
            if (n3 == 0) {
                return;
            }
            if (HAS_UNSAFE) {
                PlatformDependent.copyMemory(PlatformDependent.directBufferAddress(byteBuffer) + (long)n2, PlatformDependent.directBufferAddress((ByteBuffer)pooledByteBuf.memory) + (long)pooledByteBuf.offset, n3);
            } else {
                byteBuffer = byteBuffer.duplicate();
                ByteBuffer byteBuffer2 = pooledByteBuf.internalNioBuffer();
                byteBuffer.position(n2).limit(n2 + n3);
                byteBuffer2.position(pooledByteBuf.offset);
                byteBuffer2.put(byteBuffer);
            }
        }
    }

    static final class HeapArena
    extends PoolArena<byte[]> {
        private final AtomicReference<PoolChunk<byte[]>> lastDestroyedChunk = new AtomicReference();

        HeapArena(PooledByteBufAllocator pooledByteBufAllocator, SizeClasses sizeClasses) {
            super(pooledByteBufAllocator, sizeClasses);
        }

        private static byte[] newByteArray(int n2) {
            return PlatformDependent.allocateUninitializedArray(n2);
        }

        @Override
        boolean isDirect() {
            return false;
        }

        @Override
        protected PoolChunk<byte[]> newChunk(int n2, int n3, int n4, int n5) {
            PoolChunk poolChunk = this.lastDestroyedChunk.getAndSet(null);
            if (poolChunk != null) {
                assert (poolChunk.chunkSize == n5 && poolChunk.pageSize == n2 && poolChunk.maxPageIdx == n3 && poolChunk.pageShifts == n4);
                return poolChunk;
            }
            return new PoolChunk<byte[]>(this, null, null, HeapArena.newByteArray(n5), n2, n4, n5, n3);
        }

        @Override
        protected PoolChunk<byte[]> newUnpooledChunk(int n2) {
            return new PoolChunk<byte[]>(this, null, null, HeapArena.newByteArray(n2), n2);
        }

        @Override
        protected void destroyChunk(PoolChunk<byte[]> poolChunk) {
            PooledByteBufAllocator.onDeallocateChunk(poolChunk, !poolChunk.unpooled);
            if (!poolChunk.unpooled && this.lastDestroyedChunk.get() == null) {
                this.lastDestroyedChunk.set(poolChunk);
            }
        }

        @Override
        protected PooledByteBuf<byte[]> newByteBuf(int n2) {
            return HAS_UNSAFE ? PooledUnsafeHeapByteBuf.newUnsafeInstance(n2) : PooledHeapByteBuf.newInstance(n2);
        }

        @Override
        protected void memoryCopy(byte[] byArray, int n2, PooledByteBuf<byte[]> pooledByteBuf, int n3) {
            if (n3 == 0) {
                return;
            }
            System.arraycopy(byArray, n2, pooledByteBuf.memory, pooledByteBuf.offset, n3);
        }
    }

    static enum SizeClass {
        Small,
        Normal;

    }
}

