/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.io.netty.buffer;

import com.gradle.maven.extension.internal.dep.io.netty.buffer.AbstractBufferEvent;
import com.gradle.maven.extension.internal.dep.io.netty.buffer.AbstractByteBuf;
import com.gradle.maven.extension.internal.dep.io.netty.buffer.AbstractReferenceCountedByteBuf;
import com.gradle.maven.extension.internal.dep.io.netty.buffer.AdaptiveByteBufAllocator;
import com.gradle.maven.extension.internal.dep.io.netty.buffer.AllocateBufferEvent;
import com.gradle.maven.extension.internal.dep.io.netty.buffer.AllocateChunkEvent;
import com.gradle.maven.extension.internal.dep.io.netty.buffer.ByteBuf;
import com.gradle.maven.extension.internal.dep.io.netty.buffer.ByteBufAllocator;
import com.gradle.maven.extension.internal.dep.io.netty.buffer.ByteBufUtil;
import com.gradle.maven.extension.internal.dep.io.netty.buffer.ChunkInfo;
import com.gradle.maven.extension.internal.dep.io.netty.buffer.FreeBufferEvent;
import com.gradle.maven.extension.internal.dep.io.netty.buffer.FreeChunkEvent;
import com.gradle.maven.extension.internal.dep.io.netty.buffer.ReallocateBufferEvent;
import com.gradle.maven.extension.internal.dep.io.netty.buffer.ReturnChunkEvent;
import com.gradle.maven.extension.internal.dep.io.netty.util.ByteProcessor;
import com.gradle.maven.extension.internal.dep.io.netty.util.CharsetUtil;
import com.gradle.maven.extension.internal.dep.io.netty.util.IllegalReferenceCountException;
import com.gradle.maven.extension.internal.dep.io.netty.util.NettyRuntime;
import com.gradle.maven.extension.internal.dep.io.netty.util.Recycler;
import com.gradle.maven.extension.internal.dep.io.netty.util.ReferenceCounted;
import com.gradle.maven.extension.internal.dep.io.netty.util.concurrent.FastThreadLocal;
import com.gradle.maven.extension.internal.dep.io.netty.util.concurrent.FastThreadLocalThread;
import com.gradle.maven.extension.internal.dep.io.netty.util.concurrent.MpscIntQueue;
import com.gradle.maven.extension.internal.dep.io.netty.util.internal.AtomicReferenceCountUpdater;
import com.gradle.maven.extension.internal.dep.io.netty.util.internal.ObjectPool;
import com.gradle.maven.extension.internal.dep.io.netty.util.internal.ObjectUtil;
import com.gradle.maven.extension.internal.dep.io.netty.util.internal.PlatformDependent;
import com.gradle.maven.extension.internal.dep.io.netty.util.internal.ReferenceCountUpdater;
import com.gradle.maven.extension.internal.dep.io.netty.util.internal.SystemPropertyUtil;
import com.gradle.maven.extension.internal.dep.io.netty.util.internal.ThreadExecutorMap;
import com.gradle.maven.extension.internal.dep.io.netty.util.internal.UnsafeReferenceCountUpdater;
import com.gradle.maven.extension.internal.dep.io.netty.util.internal.VarHandleReferenceCountUpdater;
import java.io.IOException;
import java.io.InputStream;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.GatheringByteChannel;
import java.nio.channels.ScatteringByteChannel;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Queue;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import java.util.concurrent.atomic.LongAdder;
import java.util.concurrent.locks.StampedLock;
import java.util.function.IntSupplier;
import jdk.jfr.Event;

final class AdaptivePoolingAllocator {
    private static final int MAX_STRIPES = NettyRuntime.availableProcessors() * 2;
    private static final int CHUNK_REUSE_QUEUE = Math.max(2, SystemPropertyUtil.getInt("com.gradle.maven.extension.internal.dep.io.netty.allocator.chunkReuseQueueCapacity", NettyRuntime.availableProcessors() * 2));
    private static final int MAGAZINE_BUFFER_QUEUE_CAPACITY = SystemPropertyUtil.getInt("com.gradle.maven.extension.internal.dep.io.netty.allocator.magazineBufferQueueCapacity", 1024);
    private static final int[] SIZE_CLASSES = new int[]{32, 64, 128, 256, 512, 640, 1024, 1152, 2048, 2304, 4096, 4352, 8192, 8704, 16384, 16896};
    private static final int SIZE_CLASSES_COUNT = SIZE_CLASSES.length;
    private static final byte[] SIZE_INDEXES = new byte[SIZE_CLASSES[SIZE_CLASSES_COUNT - 1] / 32 + 1];
    private final ChunkAllocator chunkAllocator;
    private final ChunkRegistry chunkRegistry;
    private final MagazineGroup[] sizeClassedMagazineGroups;
    private final MagazineGroup largeBufferMagazineGroup;
    private final FastThreadLocal<MagazineGroup[]> threadLocalGroup;

    AdaptivePoolingAllocator(ChunkAllocator chunkAllocator, final boolean bl2) {
        this.chunkAllocator = ObjectUtil.checkNotNull(chunkAllocator, "chunkAllocator");
        this.chunkRegistry = new ChunkRegistry();
        this.sizeClassedMagazineGroups = AdaptivePoolingAllocator.createMagazineGroupSizeClasses(this, false);
        this.largeBufferMagazineGroup = new MagazineGroup(this, chunkAllocator, new HistogramChunkControllerFactory(true), false);
        this.threadLocalGroup = new FastThreadLocal<MagazineGroup[]>(){

            @Override
            protected MagazineGroup[] initialValue() {
                if (bl2 || ThreadExecutorMap.currentExecutor() != null) {
                    return AdaptivePoolingAllocator.createMagazineGroupSizeClasses(AdaptivePoolingAllocator.this, true);
                }
                return null;
            }

            @Override
            protected void onRemoval(MagazineGroup[] magazineGroupArray) throws Exception {
                if (magazineGroupArray != null) {
                    for (MagazineGroup magazineGroup : magazineGroupArray) {
                        magazineGroup.free();
                    }
                }
            }
        };
    }

    private static MagazineGroup[] createMagazineGroupSizeClasses(AdaptivePoolingAllocator adaptivePoolingAllocator, boolean bl2) {
        MagazineGroup[] magazineGroupArray = new MagazineGroup[SIZE_CLASSES.length];
        for (int i2 = 0; i2 < SIZE_CLASSES.length; ++i2) {
            int n2 = SIZE_CLASSES[i2];
            magazineGroupArray[i2] = new MagazineGroup(adaptivePoolingAllocator, adaptivePoolingAllocator.chunkAllocator, new SizeClassChunkControllerFactory(n2), bl2);
        }
        return magazineGroupArray;
    }

    private static Queue<Chunk> createSharedChunkQueue() {
        return PlatformDependent.newFixedMpmcQueue(CHUNK_REUSE_QUEUE);
    }

    ByteBuf allocate(int n2, int n3) {
        return this.allocate(n2, n3, Thread.currentThread(), null);
    }

    private AdaptiveByteBuf allocate(int n2, int n3, Thread thread, AdaptiveByteBuf adaptiveByteBuf) {
        AdaptiveByteBuf adaptiveByteBuf2 = null;
        if (n2 <= 0x100000) {
            MagazineGroup[] magazineGroupArray;
            int n4 = AdaptivePoolingAllocator.sizeClassIndexOf(n2);
            if (!FastThreadLocalThread.currentThreadWillCleanupFastThreadLocals() || (magazineGroupArray = this.threadLocalGroup.get()) == null) {
                magazineGroupArray = this.sizeClassedMagazineGroups;
            }
            adaptiveByteBuf2 = n4 < magazineGroupArray.length ? magazineGroupArray[n4].allocate(n2, n3, thread, adaptiveByteBuf) : this.largeBufferMagazineGroup.allocate(n2, n3, thread, adaptiveByteBuf);
        }
        if (adaptiveByteBuf2 == null) {
            adaptiveByteBuf2 = this.allocateFallback(n2, n3, thread, adaptiveByteBuf);
        }
        return adaptiveByteBuf2;
    }

    private static int sizeIndexOf(int n2) {
        return n2 + 31 >> 5;
    }

    static int sizeClassIndexOf(int n2) {
        int n3 = AdaptivePoolingAllocator.sizeIndexOf(n2);
        if (n3 < SIZE_INDEXES.length) {
            return SIZE_INDEXES[n3];
        }
        return SIZE_CLASSES_COUNT;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AdaptiveByteBuf allocateFallback(int n3, int n4, Thread thread, AdaptiveByteBuf adaptiveByteBuf) {
        Magazine magazine;
        ReferenceCounted referenceCounted;
        if (adaptiveByteBuf != null) {
            referenceCounted = adaptiveByteBuf.chunk;
            if (referenceCounted == null || referenceCounted == Magazine.MAGAZINE_FREED || (magazine = referenceCounted.currentMagazine()) == null) {
                magazine = this.getFallbackMagazine(thread);
            }
        } else {
            magazine = this.getFallbackMagazine(thread);
            adaptiveByteBuf = magazine.newBuffer();
        }
        referenceCounted = this.chunkAllocator.allocate(n3, n4);
        Chunk chunk = new Chunk((AbstractByteBuf)referenceCounted, magazine, false, n2 -> true);
        this.chunkRegistry.add(chunk);
        try {
            chunk.readInitInto(adaptiveByteBuf, n3, n3, n4);
        }
        finally {
            chunk.release();
        }
        return adaptiveByteBuf;
    }

    private Magazine getFallbackMagazine(Thread thread) {
        Magazine[] magazineArray = this.largeBufferMagazineGroup.magazines;
        return magazineArray[(int)thread.getId() & magazineArray.length - 1];
    }

    void reallocate(int n2, int n3, AdaptiveByteBuf adaptiveByteBuf) {
        AdaptiveByteBuf adaptiveByteBuf2 = this.allocate(n2, n3, Thread.currentThread(), adaptiveByteBuf);
        assert (adaptiveByteBuf2 == adaptiveByteBuf) : "Re-allocation created separate buffer instance";
    }

    protected void finalize() throws Throwable {
        try {
            super.finalize();
        }
        finally {
            this.free();
        }
    }

    private void free() {
        this.largeBufferMagazineGroup.free();
    }

    static {
        if (MAGAZINE_BUFFER_QUEUE_CAPACITY < 2) {
            throw new IllegalArgumentException("MAGAZINE_BUFFER_QUEUE_CAPACITY: " + MAGAZINE_BUFFER_QUEUE_CAPACITY + " (expected: >= " + 2 + ')');
        }
        int n2 = 0;
        for (int i2 = 0; i2 < SIZE_CLASSES_COUNT; ++i2) {
            int n3 = SIZE_CLASSES[i2];
            assert ((n3 & 5) == 0) : "Size class must be a multiple of 32";
            int n4 = AdaptivePoolingAllocator.sizeIndexOf(n3);
            Arrays.fill(SIZE_INDEXES, n2 + 1, n4 + 1, (byte)i2);
            n2 = n4;
        }
    }

    static interface ChunkAllocator {
        public AbstractByteBuf allocate(int var1, int var2);
    }

    static final class AdaptiveByteBuf
    extends AbstractReferenceCountedByteBuf {
        private final ObjectPool.Handle<AdaptiveByteBuf> handle;
        private int startIndex;
        private AbstractByteBuf rootParent;
        Chunk chunk;
        private int length;
        private int maxFastCapacity;
        private ByteBuffer tmpNioBuf;
        private boolean hasArray;
        private boolean hasMemoryAddress;

        AdaptiveByteBuf(ObjectPool.Handle<AdaptiveByteBuf> handle) {
            super(0);
            this.handle = ObjectUtil.checkNotNull(handle, "recyclerHandle");
        }

        void init(AbstractByteBuf abstractByteBuf, Chunk chunk, int n2, int n3, int n4, int n5, int n6, int n7) {
            AllocateBufferEvent allocateBufferEvent;
            this.startIndex = n4;
            this.chunk = chunk;
            this.length = n5;
            this.maxFastCapacity = n6;
            this.maxCapacity(n7);
            this.setIndex0(n2, n3);
            this.hasArray = abstractByteBuf.hasArray();
            this.hasMemoryAddress = abstractByteBuf.hasMemoryAddress();
            this.rootParent = abstractByteBuf;
            this.tmpNioBuf = null;
            if (PlatformDependent.isJfrEnabled() && AllocateBufferEvent.isEventEnabled() && (allocateBufferEvent = new AllocateBufferEvent()).shouldCommit()) {
                allocateBufferEvent.fill(this, AdaptiveByteBufAllocator.class);
                allocateBufferEvent.chunkPooled = chunk.pooled;
                Magazine magazine = chunk.magazine;
                allocateBufferEvent.chunkThreadLocal = magazine != null && magazine.allocationLock == null;
                allocateBufferEvent.commit();
            }
        }

        private AbstractByteBuf rootParent() {
            AbstractByteBuf abstractByteBuf = this.rootParent;
            if (abstractByteBuf != null) {
                return abstractByteBuf;
            }
            throw new IllegalReferenceCountException();
        }

        @Override
        public int capacity() {
            return this.length;
        }

        @Override
        public int maxFastWritableBytes() {
            return Math.min(this.maxFastCapacity, this.maxCapacity()) - this.writerIndex;
        }

        @Override
        public ByteBuf capacity(int n2) {
            Object object;
            if (this.length <= n2 && n2 <= this.maxFastCapacity) {
                this.ensureAccessible();
                this.length = n2;
                return this;
            }
            this.checkNewCapacity(n2);
            if (n2 < this.capacity()) {
                this.length = n2;
                this.trimIndicesToCapacity(n2);
                return this;
            }
            if (PlatformDependent.isJfrEnabled() && ReallocateBufferEvent.isEventEnabled() && ((Event)(object = new ReallocateBufferEvent())).shouldCommit()) {
                ((AbstractBufferEvent)object).fill(this, AdaptiveByteBufAllocator.class);
                ((ReallocateBufferEvent)object).newCapacity = n2;
                ((Event)object).commit();
            }
            object = this.chunk;
            AdaptivePoolingAllocator adaptivePoolingAllocator = ((Chunk)object).allocator;
            int n3 = this.readerIndex;
            int n4 = this.writerIndex;
            int n5 = this.startIndex;
            int n6 = this.length;
            AbstractByteBuf abstractByteBuf = this.rootParent();
            adaptivePoolingAllocator.reallocate(n2, this.maxCapacity(), this);
            abstractByteBuf.getBytes(n5, this, 0, n6);
            ((Chunk)object).releaseSegment(n5);
            this.readerIndex = n3;
            this.writerIndex = n4;
            return this;
        }

        @Override
        public ByteBufAllocator alloc() {
            return this.rootParent().alloc();
        }

        @Override
        public ByteOrder order() {
            return this.rootParent().order();
        }

        @Override
        public ByteBuf unwrap() {
            return null;
        }

        @Override
        public boolean isDirect() {
            return this.rootParent().isDirect();
        }

        @Override
        public int arrayOffset() {
            return this.idx(this.rootParent().arrayOffset());
        }

        @Override
        public boolean hasMemoryAddress() {
            return this.hasMemoryAddress;
        }

        @Override
        public long memoryAddress() {
            this.ensureAccessible();
            return this._memoryAddress();
        }

        @Override
        long _memoryAddress() {
            AbstractByteBuf abstractByteBuf = this.rootParent;
            return abstractByteBuf != null ? abstractByteBuf._memoryAddress() + (long)this.startIndex : 0L;
        }

        @Override
        public ByteBuffer nioBuffer(int n2, int n3) {
            this.checkIndex(n2, n3);
            return this.rootParent().nioBuffer(this.idx(n2), n3);
        }

        @Override
        public ByteBuffer internalNioBuffer(int n2, int n3) {
            this.checkIndex(n2, n3);
            return (ByteBuffer)this.internalNioBuffer().position(n2).limit(n2 + n3);
        }

        private ByteBuffer internalNioBuffer() {
            if (this.tmpNioBuf == null) {
                this.tmpNioBuf = this.rootParent().nioBuffer(this.startIndex, this.maxFastCapacity);
            }
            return (ByteBuffer)this.tmpNioBuf.clear();
        }

        @Override
        public ByteBuffer[] nioBuffers(int n2, int n3) {
            this.checkIndex(n2, n3);
            return this.rootParent().nioBuffers(this.idx(n2), n3);
        }

        @Override
        public boolean hasArray() {
            return this.hasArray;
        }

        @Override
        public byte[] array() {
            this.ensureAccessible();
            return this.rootParent().array();
        }

        @Override
        public int nioBufferCount() {
            return this.rootParent().nioBufferCount();
        }

        @Override
        protected byte _getByte(int n2) {
            return this.rootParent()._getByte(this.idx(n2));
        }

        @Override
        protected short _getShort(int n2) {
            return this.rootParent()._getShort(this.idx(n2));
        }

        @Override
        protected short _getShortLE(int n2) {
            return this.rootParent()._getShortLE(this.idx(n2));
        }

        @Override
        protected int _getUnsignedMedium(int n2) {
            return this.rootParent()._getUnsignedMedium(this.idx(n2));
        }

        @Override
        protected int _getUnsignedMediumLE(int n2) {
            return this.rootParent()._getUnsignedMediumLE(this.idx(n2));
        }

        @Override
        protected int _getInt(int n2) {
            return this.rootParent()._getInt(this.idx(n2));
        }

        @Override
        protected int _getIntLE(int n2) {
            return this.rootParent()._getIntLE(this.idx(n2));
        }

        @Override
        protected long _getLong(int n2) {
            return this.rootParent()._getLong(this.idx(n2));
        }

        @Override
        protected long _getLongLE(int n2) {
            return this.rootParent()._getLongLE(this.idx(n2));
        }

        @Override
        public ByteBuf getBytes(int n2, ByteBuf byteBuf, int n3, int n4) {
            this.checkIndex(n2, n4);
            this.rootParent().getBytes(this.idx(n2), byteBuf, n3, n4);
            return this;
        }

        @Override
        public ByteBuf getBytes(int n2, byte[] byArray, int n3, int n4) {
            this.checkIndex(n2, n4);
            this.rootParent().getBytes(this.idx(n2), byArray, n3, n4);
            return this;
        }

        @Override
        public ByteBuf getBytes(int n2, ByteBuffer byteBuffer) {
            this.checkIndex(n2, byteBuffer.remaining());
            this.rootParent().getBytes(this.idx(n2), byteBuffer);
            return this;
        }

        @Override
        protected void _setByte(int n2, int n3) {
            this.rootParent()._setByte(this.idx(n2), n3);
        }

        @Override
        protected void _setShort(int n2, int n3) {
            this.rootParent()._setShort(this.idx(n2), n3);
        }

        @Override
        protected void _setMedium(int n2, int n3) {
            this.rootParent()._setMedium(this.idx(n2), n3);
        }

        @Override
        protected void _setInt(int n2, int n3) {
            this.rootParent()._setInt(this.idx(n2), n3);
        }

        @Override
        protected void _setLong(int n2, long l2) {
            this.rootParent()._setLong(this.idx(n2), l2);
        }

        @Override
        public ByteBuf setBytes(int n2, byte[] byArray, int n3, int n4) {
            this.checkIndex(n2, n4);
            ByteBuffer byteBuffer = (ByteBuffer)this.internalNioBuffer().clear().position(n2);
            byteBuffer.put(byArray, n3, n4);
            return this;
        }

        @Override
        public ByteBuf setBytes(int n2, ByteBuf byteBuf, int n3, int n4) {
            this.checkIndex(n2, n4);
            ByteBuffer byteBuffer = (ByteBuffer)this.internalNioBuffer().clear().position(n2);
            byteBuffer.put(byteBuf.nioBuffer(n3, n4));
            return this;
        }

        @Override
        public ByteBuf setBytes(int n2, ByteBuffer byteBuffer) {
            this.checkIndex(n2, byteBuffer.remaining());
            ByteBuffer byteBuffer2 = (ByteBuffer)this.internalNioBuffer().clear().position(n2);
            byteBuffer2.put(byteBuffer);
            return this;
        }

        @Override
        public int getBytes(int n2, GatheringByteChannel gatheringByteChannel, int n3) throws IOException {
            ByteBuffer byteBuffer = this.internalNioBuffer().duplicate();
            byteBuffer.clear().position(n2).limit(n2 + n3);
            return gatheringByteChannel.write(byteBuffer);
        }

        @Override
        public int setBytes(int n2, InputStream inputStream, int n3) throws IOException {
            this.checkIndex(n2, n3);
            AbstractByteBuf abstractByteBuf = this.rootParent();
            if (abstractByteBuf.hasArray()) {
                return abstractByteBuf.setBytes(this.idx(n2), inputStream, n3);
            }
            byte[] byArray = ByteBufUtil.threadLocalTempArray(n3);
            int n4 = inputStream.read(byArray, 0, n3);
            if (n4 <= 0) {
                return n4;
            }
            this.setBytes(n2, byArray, 0, n4);
            return n4;
        }

        @Override
        public int setBytes(int n2, ScatteringByteChannel scatteringByteChannel, int n3) throws IOException {
            try {
                return scatteringByteChannel.read(this.internalNioBuffer(n2, n3).duplicate());
            }
            catch (ClosedChannelException closedChannelException) {
                return -1;
            }
        }

        @Override
        public int setCharSequence(int n2, CharSequence charSequence, Charset charset) {
            return this.setCharSequence0(n2, charSequence, charset, false);
        }

        private int setCharSequence0(int n2, CharSequence charSequence, Charset charset, boolean bl2) {
            if (charset.equals(CharsetUtil.UTF_8)) {
                int n3 = ByteBufUtil.utf8MaxBytes(charSequence);
                if (bl2) {
                    this.ensureWritable0(n3);
                    this.checkIndex0(n2, n3);
                } else {
                    this.checkIndex(n2, n3);
                }
                return ByteBufUtil.writeUtf8(this.rootParent(), this.idx(n2), n3, charSequence, charSequence.length());
            }
            if (charset.equals(CharsetUtil.US_ASCII) || charset.equals(CharsetUtil.ISO_8859_1)) {
                int n4 = charSequence.length();
                if (bl2) {
                    this.ensureWritable0(n4);
                    this.checkIndex0(n2, n4);
                } else {
                    this.checkIndex(n2, n4);
                }
                return ByteBufUtil.writeAscii(this.rootParent(), this.idx(n2), charSequence, n4);
            }
            byte[] byArray = charSequence.toString().getBytes(charset);
            if (bl2) {
                this.ensureWritable0(byArray.length);
            }
            this.setBytes(n2, byArray);
            return byArray.length;
        }

        @Override
        public int writeCharSequence(CharSequence charSequence, Charset charset) {
            int n2 = this.setCharSequence0(this.writerIndex, charSequence, charset, true);
            this.writerIndex += n2;
            return n2;
        }

        @Override
        public int forEachByte(int n2, int n3, ByteProcessor byteProcessor) {
            this.checkIndex(n2, n3);
            int n4 = this.rootParent().forEachByte(this.idx(n2), n3, byteProcessor);
            return this.forEachResult(n4);
        }

        @Override
        public ByteBuf setZero(int n2, int n3) {
            this.checkIndex(n2, n3);
            this.rootParent().setZero(this.idx(n2), n3);
            return this;
        }

        private int forEachResult(int n2) {
            if (n2 < this.startIndex) {
                return -1;
            }
            return n2 - this.startIndex;
        }

        @Override
        public boolean isContiguous() {
            return this.rootParent().isContiguous();
        }

        private int idx(int n2) {
            return n2 + this.startIndex;
        }

        @Override
        protected void deallocate() {
            Object object;
            if (PlatformDependent.isJfrEnabled() && FreeBufferEvent.isEventEnabled() && ((Event)(object = new FreeBufferEvent())).shouldCommit()) {
                ((AbstractBufferEvent)object).fill(this, AdaptiveByteBufAllocator.class);
                ((Event)object).commit();
            }
            if (this.chunk != null) {
                this.chunk.releaseSegment(this.startIndex);
            }
            this.tmpNioBuf = null;
            this.chunk = null;
            this.rootParent = null;
            if (this.handle instanceof Recycler.EnhancedHandle) {
                object = (Recycler.EnhancedHandle)this.handle;
                ((Recycler.EnhancedHandle)object).unguardedRecycle(this);
            } else {
                this.handle.recycle(this);
            }
        }
    }

    private static final class SizeClassedChunk
    extends Chunk {
        private final int segmentSize;
        private final MpscIntQueue freeList;

        SizeClassedChunk(AbstractByteBuf abstractByteBuf, Magazine magazine, boolean bl2, int n2, final int[] nArray, ChunkReleasePredicate chunkReleasePredicate) {
            super(abstractByteBuf, magazine, bl2, chunkReleasePredicate);
            this.segmentSize = n2;
            int n3 = nArray.length;
            assert (abstractByteBuf.capacity() / n2 == n3);
            assert (n3 > 0) : "Chunk must have a positive number of segments";
            this.freeList = MpscIntQueue.create(n3, -1);
            this.freeList.fill(n3, new IntSupplier(){
                int counter;

                @Override
                public int getAsInt() {
                    return nArray[this.counter++];
                }
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void readInitInto(AdaptiveByteBuf adaptiveByteBuf, int n2, int n3, int n4) {
            int n5 = this.freeList.poll();
            if (n5 == -1) {
                throw new IllegalStateException("Free list is empty");
            }
            this.allocatedBytes += this.segmentSize;
            SizeClassedChunk sizeClassedChunk = this;
            sizeClassedChunk.retain();
            try {
                adaptiveByteBuf.init(this.delegate, sizeClassedChunk, 0, 0, n5, n2, n3, n4);
                sizeClassedChunk = null;
            }
            finally {
                if (sizeClassedChunk != null) {
                    this.allocatedBytes -= this.segmentSize;
                    ((Chunk)sizeClassedChunk).releaseSegment(n5);
                }
            }
        }

        @Override
        public int remainingCapacity() {
            int n2 = super.remainingCapacity();
            if (n2 > this.segmentSize) {
                return n2;
            }
            int n3 = this.freeList.size() * this.segmentSize;
            if (n3 == n2) {
                return n2;
            }
            this.allocatedBytes = this.capacity() - n3;
            return n3;
        }

        @Override
        boolean releaseFromMagazine() {
            Magazine magazine = this.magazine;
            this.detachFromMagazine();
            if (!magazine.offerToQueue(this)) {
                return super.releaseFromMagazine();
            }
            return false;
        }

        @Override
        boolean releaseSegment(int n2) {
            boolean bl2 = this.release();
            boolean bl3 = this.freeList.offer(n2);
            assert (bl3) : "Unable to return segment " + n2 + " to free list";
            return bl2;
        }
    }

    private static class Chunk
    implements ChunkInfo,
    ReferenceCounted {
        private static final long REFCNT_FIELD_OFFSET;
        private static final AtomicIntegerFieldUpdater<Chunk> AIF_UPDATER;
        private static final Object REFCNT_FIELD_VH;
        private static final ReferenceCountUpdater<Chunk> updater;
        protected final AbstractByteBuf delegate;
        protected Magazine magazine;
        private final AdaptivePoolingAllocator allocator;
        private final ChunkReleasePredicate chunkReleasePredicate;
        private final int capacity;
        private final boolean pooled;
        protected int allocatedBytes;
        private volatile int refCnt;

        Chunk() {
            this.delegate = null;
            this.magazine = null;
            this.allocator = null;
            this.chunkReleasePredicate = null;
            this.capacity = 0;
            this.pooled = false;
        }

        Chunk(AbstractByteBuf abstractByteBuf, Magazine magazine, boolean bl2, ChunkReleasePredicate chunkReleasePredicate) {
            AllocateChunkEvent allocateChunkEvent;
            this.delegate = abstractByteBuf;
            this.pooled = bl2;
            this.capacity = abstractByteBuf.capacity();
            updater.setInitialValue(this);
            this.attachToMagazine(magazine);
            this.allocator = magazine.group.allocator;
            this.chunkReleasePredicate = chunkReleasePredicate;
            if (PlatformDependent.isJfrEnabled() && AllocateChunkEvent.isEventEnabled() && (allocateChunkEvent = new AllocateChunkEvent()).shouldCommit()) {
                allocateChunkEvent.fill(this, AdaptiveByteBufAllocator.class);
                allocateChunkEvent.pooled = bl2;
                allocateChunkEvent.threadLocal = magazine.allocationLock == null;
                allocateChunkEvent.commit();
            }
        }

        Magazine currentMagazine() {
            return this.magazine;
        }

        void detachFromMagazine() {
            if (this.magazine != null) {
                this.magazine.usedMemory.getAndAdd(-this.capacity);
                this.magazine = null;
            }
        }

        void attachToMagazine(Magazine magazine) {
            assert (this.magazine == null);
            this.magazine = magazine;
            magazine.usedMemory.getAndAdd(this.capacity);
        }

        @Override
        public Chunk touch(Object object) {
            return this;
        }

        @Override
        public int refCnt() {
            return updater.refCnt(this);
        }

        @Override
        public Chunk retain() {
            return updater.retain(this);
        }

        @Override
        public Chunk touch() {
            return this;
        }

        @Override
        public boolean release() {
            if (updater.release(this)) {
                this.deallocate();
                return true;
            }
            return false;
        }

        boolean releaseFromMagazine() {
            return this.release();
        }

        boolean releaseSegment(int n2) {
            return this.release();
        }

        private void deallocate() {
            Magazine magazine = this.magazine;
            int n2 = this.delegate.capacity();
            if (!this.pooled || this.chunkReleasePredicate.shouldReleaseChunk(n2) || magazine == null) {
                this.detachFromMagazine();
                this.onRelease();
                this.allocator.chunkRegistry.remove(this);
                this.delegate.release();
            } else {
                updater.resetRefCnt(this);
                this.delegate.setIndex(0, 0);
                this.allocatedBytes = 0;
                if (!magazine.trySetNextInLine(this)) {
                    this.detachFromMagazine();
                    if (!magazine.offerToQueue(this)) {
                        boolean bl2 = updater.release(this);
                        this.onRelease();
                        this.allocator.chunkRegistry.remove(this);
                        this.delegate.release();
                        assert (bl2);
                    } else {
                        this.onReturn(false);
                    }
                } else {
                    this.onReturn(true);
                }
            }
        }

        private void onReturn(boolean bl2) {
            ReturnChunkEvent returnChunkEvent;
            if (PlatformDependent.isJfrEnabled() && ReturnChunkEvent.isEventEnabled() && (returnChunkEvent = new ReturnChunkEvent()).shouldCommit()) {
                returnChunkEvent.fill(this, AdaptiveByteBufAllocator.class);
                returnChunkEvent.returnedToMagazine = bl2;
                returnChunkEvent.commit();
            }
        }

        private void onRelease() {
            FreeChunkEvent freeChunkEvent;
            if (PlatformDependent.isJfrEnabled() && FreeChunkEvent.isEventEnabled() && (freeChunkEvent = new FreeChunkEvent()).shouldCommit()) {
                freeChunkEvent.fill(this, AdaptiveByteBufAllocator.class);
                freeChunkEvent.pooled = this.pooled;
                freeChunkEvent.commit();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void readInitInto(AdaptiveByteBuf adaptiveByteBuf, int n2, int n3, int n4) {
            int n5 = this.allocatedBytes;
            this.allocatedBytes = n5 + n3;
            Chunk chunk = this;
            chunk.retain();
            try {
                adaptiveByteBuf.init(this.delegate, chunk, 0, 0, n5, n2, n3, n4);
                chunk = null;
            }
            finally {
                if (chunk != null) {
                    this.allocatedBytes = n5;
                    chunk.release();
                }
            }
        }

        public int remainingCapacity() {
            return this.capacity - this.allocatedBytes;
        }

        @Override
        public int capacity() {
            return this.capacity;
        }

        @Override
        public boolean isDirect() {
            return this.delegate.isDirect();
        }

        @Override
        public long memoryAddress() {
            return this.delegate._memoryAddress();
        }

        static {
            switch (ReferenceCountUpdater.updaterTypeOf(Chunk.class, "refCnt")) {
                case Atomic: {
                    AIF_UPDATER = AtomicIntegerFieldUpdater.newUpdater(Chunk.class, "refCnt");
                    REFCNT_FIELD_OFFSET = -1L;
                    REFCNT_FIELD_VH = null;
                    updater = new AtomicReferenceCountUpdater<Chunk>(){

                        @Override
                        protected AtomicIntegerFieldUpdater<Chunk> updater() {
                            return AIF_UPDATER;
                        }
                    };
                    break;
                }
                case Unsafe: {
                    AIF_UPDATER = null;
                    REFCNT_FIELD_OFFSET = ReferenceCountUpdater.getUnsafeOffset(Chunk.class, "refCnt");
                    REFCNT_FIELD_VH = null;
                    updater = new UnsafeReferenceCountUpdater<Chunk>(){

                        @Override
                        protected long refCntFieldOffset() {
                            return REFCNT_FIELD_OFFSET;
                        }
                    };
                    break;
                }
                case VarHandle: {
                    AIF_UPDATER = null;
                    REFCNT_FIELD_OFFSET = -1L;
                    REFCNT_FIELD_VH = PlatformDependent.findVarHandleOfIntField(MethodHandles.lookup(), Chunk.class, "refCnt");
                    updater = new VarHandleReferenceCountUpdater<Chunk>(){

                        @Override
                        protected VarHandle varHandle() {
                            return (VarHandle)REFCNT_FIELD_VH;
                        }
                    };
                    break;
                }
                default: {
                    throw new Error("Unknown updater type for Chunk");
                }
            }
        }
    }

    private static final class ChunkRegistry {
        private final LongAdder totalCapacity = new LongAdder();

        private ChunkRegistry() {
        }

        public void add(Chunk chunk) {
            this.totalCapacity.add(chunk.capacity());
        }

        public void remove(Chunk chunk) {
            this.totalCapacity.add(-chunk.capacity());
        }
    }

    private static final class Magazine {
        private static final AtomicReferenceFieldUpdater<Magazine, Chunk> NEXT_IN_LINE = AtomicReferenceFieldUpdater.newUpdater(Magazine.class, Chunk.class, "nextInLine");
        private static final Chunk MAGAZINE_FREED = new Chunk();
        private static final Recycler<AdaptiveByteBuf> EVENT_LOOP_LOCAL_BUFFER_POOL = new Recycler<AdaptiveByteBuf>(){

            @Override
            protected AdaptiveByteBuf newObject(Recycler.Handle<AdaptiveByteBuf> handle) {
                return new AdaptiveByteBuf(handle);
            }
        };
        private Chunk current;
        private volatile Chunk nextInLine;
        private final MagazineGroup group;
        private final ChunkController chunkController;
        private final AtomicLong usedMemory;
        private final StampedLock allocationLock;
        private final Queue<AdaptiveByteBuf> bufferQueue;
        private final ObjectPool.Handle<AdaptiveByteBuf> handle;
        private final Queue<Chunk> sharedChunkQueue;

        Magazine(MagazineGroup magazineGroup, boolean bl2, Queue<Chunk> queue, ChunkController chunkController) {
            this.group = magazineGroup;
            this.chunkController = chunkController;
            if (bl2) {
                this.allocationLock = new StampedLock();
                this.bufferQueue = PlatformDependent.newFixedMpmcQueue(MAGAZINE_BUFFER_QUEUE_CAPACITY);
                this.handle = new ObjectPool.Handle<AdaptiveByteBuf>(){

                    @Override
                    public void recycle(AdaptiveByteBuf adaptiveByteBuf) {
                        bufferQueue.offer(adaptiveByteBuf);
                    }
                };
            } else {
                this.allocationLock = null;
                this.bufferQueue = null;
                this.handle = null;
            }
            this.usedMemory = new AtomicLong();
            this.sharedChunkQueue = queue;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean tryAllocate(int n2, int n3, AdaptiveByteBuf adaptiveByteBuf, boolean bl2) {
            if (this.allocationLock == null) {
                return this.allocate(n2, n3, adaptiveByteBuf, bl2);
            }
            long l2 = this.allocationLock.tryWriteLock();
            if (l2 != 0L) {
                try {
                    boolean bl3 = this.allocate(n2, n3, adaptiveByteBuf, bl2);
                    return bl3;
                }
                finally {
                    this.allocationLock.unlockWrite(l2);
                }
            }
            return this.allocateWithoutLock(n2, n3, adaptiveByteBuf);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean allocateWithoutLock(int n2, int n3, AdaptiveByteBuf adaptiveByteBuf) {
            Chunk chunk = NEXT_IN_LINE.getAndSet(this, null);
            if (chunk == MAGAZINE_FREED) {
                this.restoreMagazineFreed();
                return false;
            }
            if (chunk == null) {
                chunk = this.sharedChunkQueue.poll();
                if (chunk == null) {
                    return false;
                }
                chunk.attachToMagazine(this);
            }
            boolean bl2 = false;
            int n4 = chunk.remainingCapacity();
            int n5 = this.chunkController.computeBufferCapacity(n2, n3, true);
            if (n4 >= n2) {
                chunk.readInitInto(adaptiveByteBuf, n2, Math.min(n4, n5), n3);
                bl2 = true;
            }
            try {
                if (n4 >= 256) {
                    this.transferToNextInLineOrRelease(chunk);
                    chunk = null;
                }
            }
            finally {
                if (chunk != null) {
                    chunk.releaseFromMagazine();
                }
            }
            return bl2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean allocate(int n2, int n3, AdaptiveByteBuf adaptiveByteBuf, boolean bl2) {
            int n4;
            int n5 = this.chunkController.computeBufferCapacity(n2, n3, bl2);
            Chunk chunk = this.current;
            if (chunk != null) {
                n4 = chunk.remainingCapacity();
                if (n4 > n5) {
                    chunk.readInitInto(adaptiveByteBuf, n2, n5, n3);
                    return true;
                }
                this.current = null;
                if (n4 >= n2) {
                    try {
                        chunk.readInitInto(adaptiveByteBuf, n2, n4, n3);
                        boolean bl3 = true;
                        return bl3;
                    }
                    finally {
                        chunk.releaseFromMagazine();
                    }
                }
                if (n4 < 256) {
                    chunk.releaseFromMagazine();
                } else {
                    this.transferToNextInLineOrRelease(chunk);
                }
            }
            assert (this.current == null);
            chunk = NEXT_IN_LINE.getAndSet(this, null);
            if (chunk != null) {
                if (chunk == MAGAZINE_FREED) {
                    this.restoreMagazineFreed();
                    return false;
                }
                n4 = chunk.remainingCapacity();
                if (n4 > n5) {
                    chunk.readInitInto(adaptiveByteBuf, n2, n5, n3);
                    this.current = chunk;
                    return true;
                }
                if (n4 >= n2) {
                    try {
                        chunk.readInitInto(adaptiveByteBuf, n2, n4, n3);
                        boolean bl4 = true;
                        return bl4;
                    }
                    finally {
                        chunk.releaseFromMagazine();
                    }
                }
                chunk.releaseFromMagazine();
            }
            if ((chunk = this.sharedChunkQueue.poll()) == null) {
                chunk = this.chunkController.newChunkAllocation(n2, this);
            } else {
                chunk.attachToMagazine(this);
                n4 = chunk.remainingCapacity();
                if (n4 == 0 || n4 < n2) {
                    if (n4 < 256) {
                        chunk.releaseFromMagazine();
                    } else {
                        this.transferToNextInLineOrRelease(chunk);
                    }
                    chunk = this.chunkController.newChunkAllocation(n2, this);
                }
            }
            this.current = chunk;
            try {
                n4 = chunk.remainingCapacity();
                assert (n4 >= n2);
                if (n4 > n5) {
                    chunk.readInitInto(adaptiveByteBuf, n2, n5, n3);
                    chunk = null;
                } else {
                    chunk.readInitInto(adaptiveByteBuf, n2, n4, n3);
                }
            }
            finally {
                if (chunk != null) {
                    chunk.releaseFromMagazine();
                    this.current = null;
                }
            }
            return true;
        }

        private void restoreMagazineFreed() {
            Chunk chunk = NEXT_IN_LINE.getAndSet(this, MAGAZINE_FREED);
            if (chunk != null && chunk != MAGAZINE_FREED) {
                chunk.releaseFromMagazine();
            }
        }

        private void transferToNextInLineOrRelease(Chunk chunk) {
            if (NEXT_IN_LINE.compareAndSet(this, null, chunk)) {
                return;
            }
            Chunk chunk2 = NEXT_IN_LINE.get(this);
            if (chunk2 != null && chunk2 != MAGAZINE_FREED && chunk.remainingCapacity() > chunk2.remainingCapacity() && NEXT_IN_LINE.compareAndSet(this, chunk2, chunk)) {
                chunk2.releaseFromMagazine();
                return;
            }
            chunk.releaseFromMagazine();
        }

        boolean trySetNextInLine(Chunk chunk) {
            return NEXT_IN_LINE.compareAndSet(this, null, chunk);
        }

        void free() {
            this.restoreMagazineFreed();
            long l2 = this.allocationLock != null ? this.allocationLock.writeLock() : 0L;
            try {
                if (this.current != null) {
                    this.current.releaseFromMagazine();
                    this.current = null;
                }
            }
            finally {
                if (this.allocationLock != null) {
                    this.allocationLock.unlockWrite(l2);
                }
            }
        }

        public AdaptiveByteBuf newBuffer() {
            AdaptiveByteBuf adaptiveByteBuf;
            if (this.handle == null) {
                adaptiveByteBuf = EVENT_LOOP_LOCAL_BUFFER_POOL.get();
            } else {
                adaptiveByteBuf = this.bufferQueue.poll();
                if (adaptiveByteBuf == null) {
                    adaptiveByteBuf = new AdaptiveByteBuf(this.handle);
                }
            }
            adaptiveByteBuf.resetRefCnt();
            adaptiveByteBuf.discardMarks();
            return adaptiveByteBuf;
        }

        boolean offerToQueue(Chunk chunk) {
            return this.group.offerToQueue(chunk);
        }

        public void initializeSharedStateIn(Magazine magazine) {
            this.chunkController.initializeSharedStateIn(magazine.chunkController);
        }
    }

    private static final class HistogramChunkController
    implements ChunkController,
    ChunkReleasePredicate {
        private static final int[] HISTO_BUCKETS = new int[]{16384, 24576, 32768, 49152, 65536, 98304, 131072, 196608, 262144, 393216, 524288, 786432, 0x100000, 0x1C0000, 0x200000, 0x300000};
        private final MagazineGroup group;
        private final boolean shareable;
        private final short[][] histos = new short[][]{new short[16], new short[16], new short[16], new short[16]};
        private final ChunkRegistry chunkRegistry;
        private short[] histo = this.histos[0];
        private final int[] sums = new int[16];
        private int histoIndex;
        private int datumCount;
        private int datumTarget = 9;
        private boolean hasHadRotation;
        private volatile int sharedPrefChunkSize = 131072;
        private volatile int localPrefChunkSize = 131072;
        private volatile int localUpperBufSize;

        private HistogramChunkController(MagazineGroup magazineGroup, boolean bl2) {
            this.group = magazineGroup;
            this.shareable = bl2;
            this.chunkRegistry = magazineGroup.allocator.chunkRegistry;
        }

        @Override
        public int computeBufferCapacity(int n2, int n3, boolean bl2) {
            if (!bl2) {
                this.recordAllocationSize(n2);
            }
            int n4 = n2 <= 32768 ? 65536 : n2 * 2;
            int n5 = Math.min(n4, this.localUpperBufSize);
            n5 = Math.max(n2, Math.min(n3, n5));
            return n5;
        }

        private void recordAllocationSize(int n2) {
            int n3;
            if (n2 == 0) {
                return;
            }
            int n4 = n3 = HistogramChunkController.sizeToBucket(n2);
            this.histo[n4] = (short)(this.histo[n4] + 1);
            if (this.datumCount++ == this.datumTarget) {
                this.rotateHistograms();
            }
        }

        static int sizeToBucket(int n2) {
            int n3 = HistogramChunkController.binarySearchInsertionPoint(Arrays.binarySearch(HISTO_BUCKETS, n2));
            return n3 >= HISTO_BUCKETS.length ? HISTO_BUCKETS.length - 1 : n3;
        }

        private static int binarySearchInsertionPoint(int n2) {
            if (n2 < 0) {
                n2 = -(n2 + 1);
            }
            return n2;
        }

        static int bucketToSize(int n2) {
            return HISTO_BUCKETS[n2];
        }

        private void rotateHistograms() {
            int n2;
            int n3;
            int n4;
            short[][] sArray = this.histos;
            for (n4 = 0; n4 < 16; ++n4) {
                this.sums[n4] = (sArray[0][n4] & 0xFFFF) + (sArray[1][n4] & 0xFFFF) + (sArray[2][n4] & 0xFFFF) + (sArray[3][n4] & 0xFFFF);
            }
            n4 = 0;
            int[] nArray = this.sums;
            int n5 = nArray.length;
            for (n3 = 0; n3 < n5; ++n3) {
                n2 = nArray[n3];
                n4 += n2;
            }
            int n6 = (int)((double)n4 * 0.99);
            for (n5 = 0; n5 < this.sums.length && this.sums[n5] <= n6; n6 -= this.sums[n5], ++n5) {
            }
            this.hasHadRotation = true;
            n3 = HistogramChunkController.bucketToSize(n5);
            n2 = Math.max(n3 * 8, 131072);
            this.localUpperBufSize = n3;
            this.localPrefChunkSize = n2;
            if (this.shareable) {
                for (Magazine magazine : this.group.magazines) {
                    HistogramChunkController histogramChunkController = (HistogramChunkController)magazine.chunkController;
                    n2 = Math.max(n2, histogramChunkController.localPrefChunkSize);
                }
            }
            if (this.sharedPrefChunkSize != n2) {
                this.datumTarget = Math.max(this.datumTarget >> 1, 1024);
                this.sharedPrefChunkSize = n2;
            } else {
                this.datumTarget = Math.min(this.datumTarget << 1, 65534);
            }
            this.histoIndex = this.histoIndex + 1 & 3;
            this.histo = this.histos[this.histoIndex];
            this.datumCount = 0;
            Arrays.fill(this.histo, (short)0);
        }

        int preferredChunkSize() {
            return this.sharedPrefChunkSize;
        }

        @Override
        public void initializeSharedStateIn(ChunkController chunkController) {
            int n2;
            HistogramChunkController histogramChunkController = (HistogramChunkController)chunkController;
            histogramChunkController.localPrefChunkSize = n2 = this.sharedPrefChunkSize;
            histogramChunkController.sharedPrefChunkSize = n2;
        }

        @Override
        public Chunk newChunkAllocation(int n2, Magazine magazine) {
            int n3 = Math.max(n2 * 8, this.preferredChunkSize());
            int n4 = n3 / 131072;
            if (131072 * n4 < n3) {
                n3 = 131072 * (1 + n4);
            }
            n3 = Math.min(n3, 0x800000);
            if (!this.hasHadRotation && this.sharedPrefChunkSize == 131072) {
                this.sharedPrefChunkSize = n3;
            }
            ChunkAllocator chunkAllocator = this.group.chunkAllocator;
            Chunk chunk = new Chunk(chunkAllocator.allocate(n3, n3), magazine, true, this);
            this.chunkRegistry.add(chunk);
            return chunk;
        }

        @Override
        public boolean shouldReleaseChunk(int n2) {
            int n3 = n2 / 131072;
            int n4 = this.preferredChunkSize();
            int n5 = n4 / 131072;
            int n6 = Math.abs(n3 - n5);
            return n6 != 0 && ThreadLocalRandom.current().nextDouble() * 20.0 < (double)n6;
        }
    }

    private static final class HistogramChunkControllerFactory
    implements ChunkControllerFactory {
        private final boolean shareable;

        private HistogramChunkControllerFactory(boolean bl2) {
            this.shareable = bl2;
        }

        @Override
        public ChunkController create(MagazineGroup magazineGroup) {
            return new HistogramChunkController(magazineGroup, this.shareable);
        }
    }

    private static final class SizeClassChunkController
    implements ChunkController {
        private final ChunkAllocator chunkAllocator;
        private final int segmentSize;
        private final int chunkSize;
        private final ChunkRegistry chunkRegistry;
        private final int[] segmentOffsets;

        private SizeClassChunkController(MagazineGroup magazineGroup, int n2, int n3, int[] nArray) {
            this.chunkAllocator = magazineGroup.chunkAllocator;
            this.segmentSize = n2;
            this.chunkSize = n3;
            this.chunkRegistry = magazineGroup.allocator.chunkRegistry;
            this.segmentOffsets = nArray;
        }

        @Override
        public int computeBufferCapacity(int n2, int n3, boolean bl2) {
            return Math.min(this.segmentSize, n3);
        }

        @Override
        public void initializeSharedStateIn(ChunkController chunkController) {
        }

        @Override
        public Chunk newChunkAllocation(int n3, Magazine magazine) {
            AbstractByteBuf abstractByteBuf = this.chunkAllocator.allocate(this.chunkSize, this.chunkSize);
            assert (abstractByteBuf.capacity() == this.chunkSize);
            SizeClassedChunk sizeClassedChunk = new SizeClassedChunk(abstractByteBuf, magazine, true, this.segmentSize, this.segmentOffsets, n2 -> false);
            this.chunkRegistry.add(sizeClassedChunk);
            return sizeClassedChunk;
        }
    }

    private static final class SizeClassChunkControllerFactory
    implements ChunkControllerFactory {
        private final int segmentSize;
        private final int chunkSize;
        private final int[] segmentOffsets;

        private SizeClassChunkControllerFactory(int n2) {
            this.segmentSize = ObjectUtil.checkPositive(n2, "segmentSize");
            this.chunkSize = Math.max(131072, n2 * 32);
            int n3 = this.chunkSize / n2;
            this.segmentOffsets = new int[n3];
            for (int i2 = 0; i2 < n3; ++i2) {
                this.segmentOffsets[i2] = i2 * n2;
            }
        }

        @Override
        public ChunkController create(MagazineGroup magazineGroup) {
            return new SizeClassChunkController(magazineGroup, this.segmentSize, this.chunkSize, this.segmentOffsets);
        }
    }

    private static interface ChunkReleasePredicate {
        public boolean shouldReleaseChunk(int var1);
    }

    private static interface ChunkController {
        public int computeBufferCapacity(int var1, int var2, boolean var3);

        public void initializeSharedStateIn(ChunkController var1);

        public Chunk newChunkAllocation(int var1, Magazine var2);
    }

    private static interface ChunkControllerFactory {
        public ChunkController create(MagazineGroup var1);
    }

    private static final class MagazineGroup {
        private final AdaptivePoolingAllocator allocator;
        private final ChunkAllocator chunkAllocator;
        private final ChunkControllerFactory chunkControllerFactory;
        private final Queue<Chunk> chunkReuseQueue;
        private final StampedLock magazineExpandLock;
        private final Magazine threadLocalMagazine;
        private volatile Magazine[] magazines;
        private volatile boolean freed;

        MagazineGroup(AdaptivePoolingAllocator adaptivePoolingAllocator, ChunkAllocator chunkAllocator, ChunkControllerFactory chunkControllerFactory, boolean bl2) {
            this.allocator = adaptivePoolingAllocator;
            this.chunkAllocator = chunkAllocator;
            this.chunkControllerFactory = chunkControllerFactory;
            this.chunkReuseQueue = AdaptivePoolingAllocator.createSharedChunkQueue();
            if (bl2) {
                this.magazineExpandLock = null;
                this.threadLocalMagazine = new Magazine(this, false, this.chunkReuseQueue, chunkControllerFactory.create(this));
            } else {
                this.magazineExpandLock = new StampedLock();
                this.threadLocalMagazine = null;
                Magazine[] magazineArray = new Magazine[1];
                for (int i2 = 0; i2 < magazineArray.length; ++i2) {
                    magazineArray[i2] = new Magazine(this, true, this.chunkReuseQueue, chunkControllerFactory.create(this));
                }
                this.magazines = magazineArray;
            }
        }

        public AdaptiveByteBuf allocate(int n2, int n3, Thread thread, AdaptiveByteBuf adaptiveByteBuf) {
            Magazine[] magazineArray;
            boolean bl2 = adaptiveByteBuf != null;
            Magazine magazine = this.threadLocalMagazine;
            if (magazine != null) {
                if (adaptiveByteBuf == null) {
                    adaptiveByteBuf = magazine.newBuffer();
                }
                boolean bl3 = magazine.tryAllocate(n2, n3, adaptiveByteBuf, bl2);
                assert (bl3) : "Allocation of threadLocalMagazine must always succeed";
                return adaptiveByteBuf;
            }
            long l2 = thread.getId();
            int n4 = 0;
            do {
                magazineArray = this.magazines;
                int n5 = magazineArray.length - 1;
                int n6 = (int)(l2 & (long)n5);
                int n7 = magazineArray.length << 1;
                for (int i2 = 0; i2 < n7; ++i2) {
                    Magazine magazine2 = magazineArray[n6 + i2 & n5];
                    if (adaptiveByteBuf == null) {
                        adaptiveByteBuf = magazine2.newBuffer();
                    }
                    if (!magazine2.tryAllocate(n2, n3, adaptiveByteBuf, bl2)) continue;
                    return adaptiveByteBuf;
                }
            } while (++n4 <= 3 && this.tryExpandMagazines(magazineArray.length));
            if (!bl2 && adaptiveByteBuf != null) {
                adaptiveByteBuf.release();
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean tryExpandMagazines(int n2) {
            if (n2 >= MAX_STRIPES) {
                return true;
            }
            long l2 = this.magazineExpandLock.tryWriteLock();
            if (l2 != 0L) {
                Magazine[] magazineArray;
                try {
                    magazineArray = this.magazines;
                    if (magazineArray.length >= MAX_STRIPES || magazineArray.length > n2 || this.freed) {
                        boolean bl2 = true;
                        return bl2;
                    }
                    Magazine[] magazineArray2 = magazineArray[0];
                    Magazine[] magazineArray3 = new Magazine[magazineArray.length * 2];
                    int n3 = magazineArray3.length;
                    for (int i2 = 0; i2 < n3; ++i2) {
                        Magazine magazine = new Magazine(this, true, this.chunkReuseQueue, this.chunkControllerFactory.create(this));
                        magazineArray2.initializeSharedStateIn(magazine);
                        magazineArray3[i2] = magazine;
                    }
                    this.magazines = magazineArray3;
                }
                finally {
                    this.magazineExpandLock.unlockWrite(l2);
                }
                for (Magazine magazine : magazineArray) {
                    magazine.free();
                }
            }
            return true;
        }

        boolean offerToQueue(Chunk chunk) {
            if (this.freed) {
                return false;
            }
            boolean bl2 = this.chunkReuseQueue.offer(chunk);
            if (this.freed && bl2) {
                this.freeChunkReuseQueue();
            }
            return bl2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void free() {
            this.freed = true;
            if (this.threadLocalMagazine != null) {
                this.threadLocalMagazine.free();
            } else {
                long l2 = this.magazineExpandLock.writeLock();
                try {
                    Magazine[] magazineArray;
                    for (Magazine magazine : magazineArray = this.magazines) {
                        magazine.free();
                    }
                }
                finally {
                    this.magazineExpandLock.unlockWrite(l2);
                }
            }
            this.freeChunkReuseQueue();
        }

        private void freeChunkReuseQueue() {
            Chunk chunk;
            while ((chunk = this.chunkReuseQueue.poll()) != null) {
                chunk.release();
            }
        }
    }
}

