/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.dev.failsafe.internal;

import com.gradle.maven.extension.internal.dep.dev.failsafe.ExecutionContext;
import com.gradle.maven.extension.internal.dep.dev.failsafe.event.EventListener;
import com.gradle.maven.extension.internal.dep.dev.failsafe.event.ExecutionAttemptedEvent;
import com.gradle.maven.extension.internal.dep.dev.failsafe.event.ExecutionCompletedEvent;
import com.gradle.maven.extension.internal.dep.dev.failsafe.event.ExecutionScheduledEvent;
import com.gradle.maven.extension.internal.dep.dev.failsafe.spi.ExecutionResult;
import java.time.Duration;

public interface EventHandler<R> {
    public void handle(ExecutionResult<R> var1, ExecutionContext<R> var2);

    public static <R> EventHandler<R> ofExecutionCompleted(EventListener<ExecutionCompletedEvent<R>> eventListener) {
        return eventListener == null ? null : (executionResult, executionContext) -> eventListener.acceptUnchecked(new ExecutionCompletedEvent(executionResult.getResult(), executionResult.getException(), executionContext));
    }

    public static <R> EventHandler<R> ofExecutionAttempted(EventListener<ExecutionAttemptedEvent<R>> eventListener) {
        return eventListener == null ? null : (executionResult, executionContext) -> eventListener.acceptUnchecked(new ExecutionAttemptedEvent(executionResult.getResult(), executionResult.getException(), executionContext));
    }

    public static <R> EventHandler<R> ofExecutionScheduled(EventListener<ExecutionScheduledEvent<R>> eventListener) {
        return eventListener == null ? null : (executionResult, executionContext) -> eventListener.acceptUnchecked(new ExecutionScheduledEvent(executionResult.getResult(), executionResult.getException(), Duration.ofNanos(executionResult.getDelay()), executionContext));
    }
}

