/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.com.google.common.util.concurrent;

import com.gradle.maven.extension.internal.dep.com.google.common.base.Preconditions;
import com.gradle.maven.extension.internal.dep.com.google.common.util.concurrent.AbstractFuture;
import com.gradle.maven.extension.internal.dep.com.google.common.util.concurrent.DirectExecutor;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;

public final class MoreExecutors {
    public static Executor directExecutor() {
        return DirectExecutor.INSTANCE;
    }

    static Executor rejectionPropagatingExecutor(Executor executor, AbstractFuture<?> abstractFuture) {
        Preconditions.checkNotNull(executor);
        Preconditions.checkNotNull(abstractFuture);
        if (executor == MoreExecutors.directExecutor()) {
            return executor;
        }
        return runnable -> {
            try {
                executor.execute(runnable);
            }
            catch (RejectedExecutionException rejectedExecutionException) {
                abstractFuture.setException(rejectedExecutionException);
            }
        };
    }
}

