/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.com.google.common.collect;

import com.gradle.maven.extension.internal.dep.com.google.common.collect.EmptyImmutableListMultimap;
import com.gradle.maven.extension.internal.dep.com.google.common.collect.ImmutableCollection;
import com.gradle.maven.extension.internal.dep.com.google.common.collect.ImmutableList;
import com.gradle.maven.extension.internal.dep.com.google.common.collect.ImmutableMap;
import com.gradle.maven.extension.internal.dep.com.google.common.collect.ImmutableMultimap;
import com.gradle.maven.extension.internal.dep.com.google.common.collect.ListMultimap;
import java.util.Collection;
import java.util.Comparator;
import java.util.Map;

public class ImmutableListMultimap<K, V>
extends ImmutableMultimap<K, V>
implements ListMultimap<K, V> {
    public static <K, V> ImmutableListMultimap<K, V> of() {
        return EmptyImmutableListMultimap.INSTANCE;
    }

    public static <K, V> Builder<K, V> builder() {
        return new Builder();
    }

    static <K, V> ImmutableListMultimap<K, V> fromMapBuilderEntries(Collection<? extends Map.Entry<K, ImmutableCollection.Builder<V>>> collection, Comparator<? super V> comparator) {
        if (collection.isEmpty()) {
            return ImmutableListMultimap.of();
        }
        ImmutableMap.Builder<K, ImmutableList<Object>> builder = new ImmutableMap.Builder<K, ImmutableList<Object>>(collection.size());
        int n2 = 0;
        for (Map.Entry<K, ImmutableCollection.Builder<V>> entry : collection) {
            K k2 = entry.getKey();
            ImmutableList.Builder builder2 = (ImmutableList.Builder)entry.getValue();
            ImmutableList<Object> immutableList = comparator == null ? builder2.build() : builder2.buildSorted(comparator);
            builder.put(k2, immutableList);
            n2 += immutableList.size();
        }
        return new ImmutableListMultimap(builder.buildOrThrow(), n2);
    }

    ImmutableListMultimap(ImmutableMap<K, ImmutableList<V>> immutableMap, int n2) {
        super(immutableMap, n2);
    }

    @Override
    public ImmutableList<V> get(K k2) {
        ImmutableList immutableList = (ImmutableList)this.map.get(k2);
        return immutableList == null ? ImmutableList.of() : immutableList;
    }

    public static final class Builder<K, V>
    extends ImmutableMultimap.Builder<K, V> {
        @Override
        public Builder<K, V> put(K k2, V v2) {
            super.put(k2, v2);
            return this;
        }

        @Override
        public Builder<K, V> putAll(K k2, Iterable<? extends V> iterable) {
            super.putAll(k2, iterable);
            return this;
        }

        @Override
        public ImmutableListMultimap<K, V> build() {
            return (ImmutableListMultimap)super.build();
        }
    }
}

