/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.datatype.jsr310.deser;

import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.annotation.JsonFormat;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.core.JsonParser;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.core.JsonToken;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.core.io.NumberInput;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.core.json.JsonReadFeature;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.core.util.JacksonFeatureSet;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.BeanProperty;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.DeserializationContext;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.DeserializationFeature;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.datatype.jsr310.DecimalUtils;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.datatype.jsr310.JavaTimeFeature;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.datatype.jsr310.deser.JSR310DateTimeDeserializerBase;
import java.io.IOException;
import java.math.BigDecimal;
import java.time.DateTimeException;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.Temporal;
import java.time.temporal.TemporalAccessor;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class InstantDeserializer<T extends Temporal>
extends JSR310DateTimeDeserializerBase<T> {
    private static final boolean DEFAULT_NORMALIZE_ZONE_ID = JavaTimeFeature.NORMALIZE_DESERIALIZED_ZONE_ID.enabledByDefault();
    private static final boolean DEFAULT_ALWAYS_ALLOW_STRINGIFIED_DATE_TIMESTAMPS = JavaTimeFeature.ALWAYS_ALLOW_STRINGIFIED_DATE_TIMESTAMPS.enabledByDefault();
    protected static final Pattern ISO8601_COLONLESS_OFFSET_REGEX = Pattern.compile("[+-][0-9]{4}(?=\\[|$)");
    public static final InstantDeserializer<Instant> INSTANT = new InstantDeserializer<Instant>(Instant.class, DateTimeFormatter.ISO_INSTANT, Instant::from, fromIntegerArguments -> Instant.ofEpochMilli(fromIntegerArguments.value), fromDecimalArguments -> Instant.ofEpochSecond(fromDecimalArguments.integer, fromDecimalArguments.fraction), null, true, DEFAULT_NORMALIZE_ZONE_ID, DEFAULT_ALWAYS_ALLOW_STRINGIFIED_DATE_TIMESTAMPS);
    public static final InstantDeserializer<OffsetDateTime> OFFSET_DATE_TIME = new InstantDeserializer<OffsetDateTime>(OffsetDateTime.class, DateTimeFormatter.ISO_OFFSET_DATE_TIME, OffsetDateTime::from, fromIntegerArguments -> OffsetDateTime.ofInstant(Instant.ofEpochMilli(fromIntegerArguments.value), fromIntegerArguments.zoneId), InstantDeserializer::decimalToOffsetDateTime, (offsetDateTime, zoneId) -> offsetDateTime.isEqual(OffsetDateTime.MIN) || offsetDateTime.isEqual(OffsetDateTime.MAX) ? offsetDateTime : offsetDateTime.withOffsetSameInstant(zoneId.getRules().getOffset(offsetDateTime.toLocalDateTime())), true, DEFAULT_NORMALIZE_ZONE_ID, DEFAULT_ALWAYS_ALLOW_STRINGIFIED_DATE_TIMESTAMPS);
    public static final InstantDeserializer<ZonedDateTime> ZONED_DATE_TIME = new InstantDeserializer<ZonedDateTime>(ZonedDateTime.class, DateTimeFormatter.ISO_ZONED_DATE_TIME, ZonedDateTime::from, fromIntegerArguments -> ZonedDateTime.ofInstant(Instant.ofEpochMilli(fromIntegerArguments.value), fromIntegerArguments.zoneId), fromDecimalArguments -> ZonedDateTime.ofInstant(Instant.ofEpochSecond(fromDecimalArguments.integer, fromDecimalArguments.fraction), fromDecimalArguments.zoneId), ZonedDateTime::withZoneSameInstant, false, DEFAULT_NORMALIZE_ZONE_ID, DEFAULT_ALWAYS_ALLOW_STRINGIFIED_DATE_TIMESTAMPS);
    protected final Function<FromIntegerArguments, T> fromMilliseconds;
    protected final Function<FromDecimalArguments, T> fromNanoseconds;
    protected final Function<TemporalAccessor, T> parsedToValue;
    protected final BiFunction<T, ZoneId, T> adjust;
    protected final boolean replaceZeroOffsetAsZ;
    protected final Boolean _adjustToContextTZOverride;
    protected final Boolean _readTimestampsAsNanosOverride;
    protected final boolean _normalizeZoneId;
    protected final boolean _alwaysAllowStringifiedDateTimestamps;

    private static OffsetDateTime decimalToOffsetDateTime(FromDecimalArguments fromDecimalArguments) {
        if (fromDecimalArguments.integer == OffsetDateTime.MIN.toEpochSecond() && fromDecimalArguments.fraction == OffsetDateTime.MIN.getNano()) {
            return OffsetDateTime.ofInstant(Instant.ofEpochSecond(OffsetDateTime.MIN.toEpochSecond(), OffsetDateTime.MIN.getNano()), OffsetDateTime.MIN.getOffset());
        }
        if (fromDecimalArguments.integer == OffsetDateTime.MAX.toEpochSecond() && fromDecimalArguments.fraction == OffsetDateTime.MAX.getNano()) {
            return OffsetDateTime.ofInstant(Instant.ofEpochSecond(OffsetDateTime.MAX.toEpochSecond(), OffsetDateTime.MAX.getNano()), OffsetDateTime.MAX.getOffset());
        }
        return OffsetDateTime.ofInstant(Instant.ofEpochSecond(fromDecimalArguments.integer, fromDecimalArguments.fraction), fromDecimalArguments.zoneId);
    }

    protected InstantDeserializer(Class<T> clazz, DateTimeFormatter dateTimeFormatter, Function<TemporalAccessor, T> function, Function<FromIntegerArguments, T> function2, Function<FromDecimalArguments, T> function3, BiFunction<T, ZoneId, T> biFunction, boolean bl2, boolean bl3, boolean bl4) {
        super(clazz, dateTimeFormatter);
        this.parsedToValue = function;
        this.fromMilliseconds = function2;
        this.fromNanoseconds = function3;
        this.adjust = biFunction == null ? (temporal, zoneId) -> temporal : biFunction;
        this.replaceZeroOffsetAsZ = bl2;
        this._adjustToContextTZOverride = null;
        this._readTimestampsAsNanosOverride = null;
        this._normalizeZoneId = bl3;
        this._alwaysAllowStringifiedDateTimestamps = bl4;
    }

    protected InstantDeserializer(InstantDeserializer<T> instantDeserializer, DateTimeFormatter dateTimeFormatter) {
        super(instantDeserializer.handledType(), dateTimeFormatter);
        this.parsedToValue = instantDeserializer.parsedToValue;
        this.fromMilliseconds = instantDeserializer.fromMilliseconds;
        this.fromNanoseconds = instantDeserializer.fromNanoseconds;
        this.adjust = instantDeserializer.adjust;
        this.replaceZeroOffsetAsZ = this._formatter == DateTimeFormatter.ISO_INSTANT;
        this._adjustToContextTZOverride = instantDeserializer._adjustToContextTZOverride;
        this._readTimestampsAsNanosOverride = instantDeserializer._readTimestampsAsNanosOverride;
        this._normalizeZoneId = instantDeserializer._normalizeZoneId;
        this._alwaysAllowStringifiedDateTimestamps = instantDeserializer._alwaysAllowStringifiedDateTimestamps;
    }

    protected InstantDeserializer(InstantDeserializer<T> instantDeserializer, DateTimeFormatter dateTimeFormatter, Boolean bl2) {
        super(instantDeserializer.handledType(), dateTimeFormatter, bl2);
        this.parsedToValue = instantDeserializer.parsedToValue;
        this.fromMilliseconds = instantDeserializer.fromMilliseconds;
        this.fromNanoseconds = instantDeserializer.fromNanoseconds;
        this.adjust = instantDeserializer.adjust;
        this.replaceZeroOffsetAsZ = this._formatter == DateTimeFormatter.ISO_INSTANT;
        this._adjustToContextTZOverride = instantDeserializer._adjustToContextTZOverride;
        this._readTimestampsAsNanosOverride = instantDeserializer._readTimestampsAsNanosOverride;
        this._normalizeZoneId = instantDeserializer._normalizeZoneId;
        this._alwaysAllowStringifiedDateTimestamps = instantDeserializer._alwaysAllowStringifiedDateTimestamps;
    }

    protected InstantDeserializer(InstantDeserializer<T> instantDeserializer, Boolean bl2, DateTimeFormatter dateTimeFormatter, JsonFormat.Shape shape, Boolean bl3, Boolean bl4) {
        super(instantDeserializer, bl2, dateTimeFormatter, shape);
        this.parsedToValue = instantDeserializer.parsedToValue;
        this.fromMilliseconds = instantDeserializer.fromMilliseconds;
        this.fromNanoseconds = instantDeserializer.fromNanoseconds;
        this.adjust = instantDeserializer.adjust;
        this.replaceZeroOffsetAsZ = instantDeserializer.replaceZeroOffsetAsZ;
        this._adjustToContextTZOverride = bl3;
        this._readTimestampsAsNanosOverride = bl4;
        this._normalizeZoneId = instantDeserializer._normalizeZoneId;
        this._alwaysAllowStringifiedDateTimestamps = instantDeserializer._alwaysAllowStringifiedDateTimestamps;
    }

    protected InstantDeserializer(InstantDeserializer<T> instantDeserializer, JacksonFeatureSet<JavaTimeFeature> jacksonFeatureSet) {
        super(instantDeserializer.handledType(), instantDeserializer._formatter);
        this.parsedToValue = instantDeserializer.parsedToValue;
        this.fromMilliseconds = instantDeserializer.fromMilliseconds;
        this.fromNanoseconds = instantDeserializer.fromNanoseconds;
        this.adjust = instantDeserializer.adjust;
        this.replaceZeroOffsetAsZ = instantDeserializer.replaceZeroOffsetAsZ;
        this._adjustToContextTZOverride = instantDeserializer._adjustToContextTZOverride;
        this._readTimestampsAsNanosOverride = instantDeserializer._readTimestampsAsNanosOverride;
        this._normalizeZoneId = jacksonFeatureSet.isEnabled(JavaTimeFeature.NORMALIZE_DESERIALIZED_ZONE_ID);
        this._alwaysAllowStringifiedDateTimestamps = jacksonFeatureSet.isEnabled(JavaTimeFeature.ALWAYS_ALLOW_STRINGIFIED_DATE_TIMESTAMPS);
    }

    @Override
    protected InstantDeserializer<T> withDateFormat(DateTimeFormatter dateTimeFormatter) {
        if (dateTimeFormatter == this._formatter) {
            return this;
        }
        return new InstantDeserializer<T>(this, dateTimeFormatter);
    }

    @Override
    protected InstantDeserializer<T> withLeniency(Boolean bl2) {
        return new InstantDeserializer<T>(this, this._formatter, bl2);
    }

    public InstantDeserializer<T> withFeatures(JacksonFeatureSet<JavaTimeFeature> jacksonFeatureSet) {
        if (this._normalizeZoneId == jacksonFeatureSet.isEnabled(JavaTimeFeature.NORMALIZE_DESERIALIZED_ZONE_ID) && this._alwaysAllowStringifiedDateTimestamps == jacksonFeatureSet.isEnabled(JavaTimeFeature.ALWAYS_ALLOW_STRINGIFIED_DATE_TIMESTAMPS)) {
            return this;
        }
        return new InstantDeserializer<T>(this, jacksonFeatureSet);
    }

    @Override
    protected JSR310DateTimeDeserializerBase<?> _withFormatOverrides(DeserializationContext deserializationContext, BeanProperty beanProperty, JsonFormat.Value value) {
        InstantDeserializer instantDeserializer = (InstantDeserializer)super._withFormatOverrides(deserializationContext, beanProperty, value);
        Boolean bl2 = value.getFeature(JsonFormat.Feature.ADJUST_DATES_TO_CONTEXT_TIME_ZONE);
        Boolean bl3 = value.getFeature(JsonFormat.Feature.READ_DATE_TIMESTAMPS_AS_NANOSECONDS);
        if (!Objects.equals(bl2, instantDeserializer._adjustToContextTZOverride) || !Objects.equals(bl3, instantDeserializer._readTimestampsAsNanosOverride)) {
            return new InstantDeserializer<T>(instantDeserializer, instantDeserializer._isLenient, instantDeserializer._formatter, instantDeserializer._shape, bl2, bl3);
        }
        return instantDeserializer;
    }

    @Override
    public T deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
        switch (jsonParser.currentTokenId()) {
            case 8: {
                return this._fromDecimal(deserializationContext, jsonParser.getDecimalValue());
            }
            case 7: {
                return this._fromLong(deserializationContext, jsonParser.getLongValue());
            }
            case 6: {
                return this._fromString(jsonParser, deserializationContext, jsonParser.getText());
            }
            case 12: {
                return (T)((Temporal)jsonParser.getEmbeddedObject());
            }
            case 3: {
                return (T)((Temporal)this._deserializeFromArray(jsonParser, deserializationContext));
            }
            case 1: {
                String string = deserializationContext.extractScalarFromObject(jsonParser, this, this.handledType());
                if (string == null) break;
                return this._fromString(jsonParser, deserializationContext, string);
            }
        }
        return (T)((Temporal)this._handleUnexpectedToken(deserializationContext, jsonParser, JsonToken.VALUE_STRING, JsonToken.VALUE_NUMBER_INT, JsonToken.VALUE_NUMBER_FLOAT));
    }

    protected boolean shouldAdjustToContextTimezone(DeserializationContext deserializationContext) {
        return this._adjustToContextTZOverride != null ? this._adjustToContextTZOverride.booleanValue() : deserializationContext.isEnabled(DeserializationFeature.ADJUST_DATES_TO_CONTEXT_TIME_ZONE);
    }

    protected boolean shouldReadTimestampsAsNanoseconds(DeserializationContext deserializationContext) {
        return this._readTimestampsAsNanosOverride != null ? this._readTimestampsAsNanosOverride.booleanValue() : deserializationContext.isEnabled(DeserializationFeature.READ_DATE_TIMESTAMPS_AS_NANOSECONDS);
    }

    protected int _countPeriods(String string, boolean bl2) {
        int n2 = 0;
        int n3 = 0;
        char c2 = string.charAt(n3);
        if (c2 == '-' || c2 == '+' && bl2) {
            ++n3;
        }
        int n4 = string.length();
        while (n3 < n4) {
            c2 = string.charAt(n3);
            if (c2 < '0' || c2 > '9') {
                if (c2 == '.') {
                    ++n2;
                } else {
                    return -1;
                }
            }
            ++n3;
        }
        return n2;
    }

    protected T _fromString(JsonParser jsonParser, DeserializationContext deserializationContext, String string) throws IOException {
        Temporal temporal;
        String string2 = string.trim();
        if (string2.length() == 0) {
            return (T)((Temporal)this._fromEmptyString(jsonParser, deserializationContext, string2));
        }
        if (this._alwaysAllowStringifiedDateTimestamps || this._formatter == DateTimeFormatter.ISO_INSTANT || this._formatter == DateTimeFormatter.ISO_OFFSET_DATE_TIME || this._formatter == DateTimeFormatter.ISO_ZONED_DATE_TIME) {
            int n2 = this._countPeriods(string2, jsonParser.isEnabled(JsonReadFeature.ALLOW_LEADING_PLUS_SIGN_FOR_NUMBERS.mappedFeature()));
            if (n2 >= 0) {
                try {
                    if (n2 == 0) {
                        return this._fromLong(deserializationContext, NumberInput.parseLong(string2));
                    }
                    if (n2 == 1) {
                        return this._fromDecimal(deserializationContext, NumberInput.parseBigDecimal(string2, false));
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            string2 = this.replaceZeroOffsetAsZIfNecessary(string2);
        }
        if (this._formatter == DateTimeFormatter.ISO_OFFSET_DATE_TIME || this._formatter == DateTimeFormatter.ISO_ZONED_DATE_TIME) {
            string2 = InstantDeserializer.addInColonToOffsetIfMissing(string2);
        }
        try {
            TemporalAccessor temporalAccessor = this._formatter.parse(string2);
            temporal = (Temporal)this.parsedToValue.apply(temporalAccessor);
            if (this.shouldAdjustToContextTimezone(deserializationContext)) {
                return (T)((Temporal)this.adjust.apply(temporal, this.getZone(deserializationContext)));
            }
        }
        catch (DateTimeException dateTimeException) {
            temporal = (Temporal)this._handleDateTimeException(deserializationContext, dateTimeException, string2);
        }
        return (T)temporal;
    }

    protected T _fromLong(DeserializationContext deserializationContext, long l2) {
        if (this.shouldReadTimestampsAsNanoseconds(deserializationContext)) {
            return (T)((Temporal)this.fromNanoseconds.apply(new FromDecimalArguments(l2, 0, this.getZone(deserializationContext))));
        }
        return (T)((Temporal)this.fromMilliseconds.apply(new FromIntegerArguments(l2, this.getZone(deserializationContext))));
    }

    protected T _fromDecimal(DeserializationContext deserializationContext, BigDecimal bigDecimal) {
        FromDecimalArguments fromDecimalArguments = DecimalUtils.extractSecondsAndNanos(bigDecimal, (l2, n2) -> new FromDecimalArguments((long)l2, (int)n2, this.getZone(deserializationContext)), true);
        return (T)((Temporal)this.fromNanoseconds.apply(fromDecimalArguments));
    }

    private ZoneId getZone(DeserializationContext deserializationContext) {
        if (this._valueClass == Instant.class) {
            return null;
        }
        ZoneId zoneId = deserializationContext.getTimeZone().toZoneId();
        return this._normalizeZoneId ? zoneId.normalized() : zoneId;
    }

    private String replaceZeroOffsetAsZIfNecessary(String string) {
        if (this.replaceZeroOffsetAsZ) {
            return InstantDeserializer.replaceZeroOffsetAsZ(string);
        }
        return string;
    }

    private static String replaceZeroOffsetAsZ(String string) {
        int n2 = string.lastIndexOf(43);
        if (n2 < 0) {
            return string;
        }
        int n3 = n2 + 1;
        int n4 = string.length() - n3;
        switch (n4) {
            case 2: {
                return string.regionMatches(n3, "00", 0, n4) ? string.substring(0, n2) + 'Z' : string;
            }
            case 4: {
                return string.regionMatches(n3, "0000", 0, n4) ? string.substring(0, n2) + 'Z' : string;
            }
            case 5: {
                return string.regionMatches(n3, "00:00", 0, n4) ? string.substring(0, n2) + 'Z' : string;
            }
        }
        return string;
    }

    private static String addInColonToOffsetIfMissing(String string) {
        int n2 = string.indexOf(84);
        if (n2 < 0 || n2 > string.length() - 1) {
            return string;
        }
        int n3 = string.indexOf(43, n2 + 1);
        if (n3 < 0) {
            n3 = string.indexOf(45, n2 + 1);
        }
        if (n3 < 0 || n3 > string.length() - 5) {
            return string;
        }
        int n4 = string.indexOf(58, n3);
        if (n4 == n3 + 3) {
            return string;
        }
        if (Character.isDigit(string.charAt(n3 + 1)) && Character.isDigit(string.charAt(n3 + 2)) && Character.isDigit(string.charAt(n3 + 3)) && Character.isDigit(string.charAt(n3 + 4))) {
            String string2 = string.substring(n3, n3 + 5);
            return string.substring(0, n3) + string2.substring(0, 3) + ':' + string2.substring(3) + string.substring(n3 + string2.length());
        }
        Matcher matcher = ISO8601_COLONLESS_OFFSET_REGEX.matcher(string);
        if (matcher.find()) {
            String string3 = matcher.group(0);
            return matcher.replaceFirst(string3.substring(0, 3) + ':' + string3.substring(3));
        }
        return string;
    }

    public static class FromDecimalArguments {
        public final long integer;
        public final int fraction;
        public final ZoneId zoneId;

        FromDecimalArguments(long l2, int n2, ZoneId zoneId) {
            this.integer = l2;
            this.fraction = n2;
            this.zoneId = zoneId;
        }
    }

    public static class FromIntegerArguments {
        public final long value;
        public final ZoneId zoneId;

        FromIntegerArguments(long l2, ZoneId zoneId) {
            this.value = l2;
            this.zoneId = zoneId;
        }
    }
}

