/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.node;

import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.core.JsonGenerator;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.core.JsonToken;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.core.type.WritableTypeId;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.JsonNode;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.SerializationFeature;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.SerializerProvider;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.cfg.JsonNodeFeature;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.node.ArrayNode;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.node.ContainerNode;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.node.JsonNodeType;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.node.MissingNode;
import java.io.IOException;
import java.io.Serializable;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Stream;

public class ObjectNode
extends ContainerNode<ObjectNode>
implements Serializable {
    protected final Map<String, JsonNode> _children = new LinkedHashMap<String, JsonNode>();

    public ObjectNode(JsonNodeFactory jsonNodeFactory) {
        super(jsonNodeFactory);
    }

    @Override
    public boolean isEmpty(SerializerProvider serializerProvider) {
        return this._children.isEmpty();
    }

    @Override
    public JsonNodeType getNodeType() {
        return JsonNodeType.OBJECT;
    }

    @Override
    public JsonToken asToken() {
        return JsonToken.START_OBJECT;
    }

    @Override
    public int size() {
        return this._children.size();
    }

    @Override
    public Iterator<JsonNode> elements() {
        return this._children.values().iterator();
    }

    @Override
    public JsonNode get(int n2) {
        return null;
    }

    @Override
    public JsonNode get(String string) {
        return this._children.get(string);
    }

    @Override
    public JsonNode path(String string) {
        JsonNode jsonNode = this._children.get(string);
        if (jsonNode != null) {
            return jsonNode;
        }
        return MissingNode.getInstance();
    }

    @Override
    public Set<Map.Entry<String, JsonNode>> properties() {
        return this._children.entrySet();
    }

    @Override
    public Stream<Map.Entry<String, JsonNode>> propertyStream() {
        return this._children.entrySet().stream();
    }

    @Override
    public void serialize(JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
        if (serializerProvider != null) {
            boolean bl2;
            boolean bl3 = !serializerProvider.isEnabled(SerializationFeature.WRITE_EMPTY_JSON_ARRAYS);
            boolean bl4 = bl2 = !serializerProvider.isEnabled(JsonNodeFeature.WRITE_NULL_PROPERTIES);
            if (bl3 || bl2) {
                jsonGenerator.writeStartObject(this);
                this.serializeFilteredContents(jsonGenerator, serializerProvider, bl3, bl2);
                jsonGenerator.writeEndObject();
                return;
            }
        }
        Map<String, JsonNode> map = this._contentsToSerialize(serializerProvider);
        jsonGenerator.writeStartObject(this, map.size());
        for (Map.Entry<String, JsonNode> entry : map.entrySet()) {
            jsonGenerator.writeFieldName(entry.getKey());
            entry.getValue().serialize(jsonGenerator, serializerProvider);
        }
        jsonGenerator.writeEndObject();
    }

    @Override
    public void serializeWithType(JsonGenerator jsonGenerator, SerializerProvider serializerProvider, TypeSerializer typeSerializer) throws IOException {
        boolean bl2 = false;
        boolean bl3 = false;
        if (serializerProvider != null) {
            bl2 = !serializerProvider.isEnabled(SerializationFeature.WRITE_EMPTY_JSON_ARRAYS);
            bl3 = !serializerProvider.isEnabled(JsonNodeFeature.WRITE_NULL_PROPERTIES);
        }
        WritableTypeId writableTypeId = typeSerializer.writeTypePrefix(jsonGenerator, typeSerializer.typeId(this, JsonToken.START_OBJECT));
        if (bl2 || bl3) {
            this.serializeFilteredContents(jsonGenerator, serializerProvider, bl2, bl3);
        } else {
            for (Map.Entry<String, JsonNode> entry : this._contentsToSerialize(serializerProvider).entrySet()) {
                JsonNode jsonNode = entry.getValue();
                jsonGenerator.writeFieldName(entry.getKey());
                jsonNode.serialize(jsonGenerator, serializerProvider);
            }
        }
        typeSerializer.writeTypeSuffix(jsonGenerator, writableTypeId);
    }

    protected void serializeFilteredContents(JsonGenerator jsonGenerator, SerializerProvider serializerProvider, boolean bl2, boolean bl3) throws IOException {
        for (Map.Entry<String, JsonNode> entry : this._contentsToSerialize(serializerProvider).entrySet()) {
            JsonNode jsonNode = entry.getValue();
            if (bl2 && jsonNode.isArray() && jsonNode.isEmpty(serializerProvider) || bl3 && jsonNode.isNull()) continue;
            jsonGenerator.writeFieldName(entry.getKey());
            jsonNode.serialize(jsonGenerator, serializerProvider);
        }
    }

    protected Map<String, JsonNode> _contentsToSerialize(SerializerProvider serializerProvider) {
        if (serializerProvider.isEnabled(JsonNodeFeature.WRITE_PROPERTIES_SORTED) && !this._children.isEmpty() && !(this._children instanceof TreeMap)) {
            return new TreeMap<String, JsonNode>(this._children);
        }
        return this._children;
    }

    public <T extends JsonNode> T set(String string, JsonNode jsonNode) {
        if (jsonNode == null) {
            jsonNode = this.nullNode();
        }
        return (T)this._put(string, jsonNode);
    }

    public JsonNode replace(String string, JsonNode jsonNode) {
        if (jsonNode == null) {
            jsonNode = this.nullNode();
        }
        return this._children.put(Objects.requireNonNull(string), jsonNode);
    }

    public ArrayNode putArray(String string) {
        ArrayNode arrayNode = this.arrayNode();
        this._put(string, arrayNode);
        return arrayNode;
    }

    public ObjectNode put(String string, String string2) {
        return this._put(string, string2 == null ? this.nullNode() : this.textNode(string2));
    }

    public ObjectNode put(String string, boolean bl2) {
        return this._put(string, this.booleanNode(bl2));
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (object instanceof ObjectNode) {
            return this._childrenEqual((ObjectNode)object);
        }
        return false;
    }

    protected boolean _childrenEqual(ObjectNode objectNode) {
        return this._children.equals(objectNode._children);
    }

    public int hashCode() {
        return this._children.hashCode();
    }

    protected ObjectNode _put(String string, JsonNode jsonNode) {
        this._children.put(Objects.requireNonNull(string), jsonNode);
        return this;
    }
}

