/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.deser.std;

import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.core.Base64Variants;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.DeserializationContext;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.JsonMappingException;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.deser.std.FromStringDeserializer;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.exc.InvalidFormatException;
import java.io.IOException;
import java.util.Arrays;
import java.util.UUID;

public class UUIDDeserializer
extends FromStringDeserializer<UUID> {
    static final int[] HEX_DIGITS;

    public UUIDDeserializer() {
        super(UUID.class);
    }

    @Override
    public Object getEmptyValue(DeserializationContext deserializationContext) {
        return new UUID(0L, 0L);
    }

    @Override
    protected UUID _deserialize(String string, DeserializationContext deserializationContext) throws IOException {
        if (string.length() != 36) {
            if (string.length() == 24) {
                string = this.convertFromUrlSafe(string);
                byte[] byArray = Base64Variants.getDefaultVariant().decode(string);
                return this._fromBytes(byArray, deserializationContext);
            }
            if (string.length() == 22) {
                string = this.convertToUrlSafe(string);
                byte[] byArray = Base64Variants.MODIFIED_FOR_URL.decode(string);
                return this._fromBytes(byArray, deserializationContext);
            }
            return this._badFormat(string, deserializationContext);
        }
        if (string.charAt(8) != '-' || string.charAt(13) != '-' || string.charAt(18) != '-' || string.charAt(23) != '-') {
            this._badFormat(string, deserializationContext);
        }
        long l2 = this.intFromChars(string, 0, deserializationContext);
        long l3 = (long)this.shortFromChars(string, 9, deserializationContext) << 16;
        long l4 = (l2 <<= 32) + (l3 |= (long)this.shortFromChars(string, 14, deserializationContext));
        int n2 = this.shortFromChars(string, 19, deserializationContext) << 16 | this.shortFromChars(string, 24, deserializationContext);
        l2 = n2;
        l3 = this.intFromChars(string, 28, deserializationContext);
        l3 = l3 << 32 >>> 32;
        long l5 = (l2 <<= 32) | l3;
        return new UUID(l4, l5);
    }

    @Override
    protected UUID _deserializeEmbedded(Object object, DeserializationContext deserializationContext) throws IOException {
        if (object instanceof byte[]) {
            return this._fromBytes((byte[])object, deserializationContext);
        }
        return (UUID)super._deserializeEmbedded(object, deserializationContext);
    }

    private UUID _badFormat(String string, DeserializationContext deserializationContext) throws IOException {
        return (UUID)deserializationContext.handleWeirdStringValue(this.handledType(), string, "UUID has to be represented by standard 36-char representation", new Object[0]);
    }

    int intFromChars(String string, int n2, DeserializationContext deserializationContext) throws JsonMappingException {
        return (this.byteFromChars(string, n2, deserializationContext) << 24) + (this.byteFromChars(string, n2 + 2, deserializationContext) << 16) + (this.byteFromChars(string, n2 + 4, deserializationContext) << 8) + this.byteFromChars(string, n2 + 6, deserializationContext);
    }

    int shortFromChars(String string, int n2, DeserializationContext deserializationContext) throws JsonMappingException {
        return (this.byteFromChars(string, n2, deserializationContext) << 8) + this.byteFromChars(string, n2 + 2, deserializationContext);
    }

    int byteFromChars(String string, int n2, DeserializationContext deserializationContext) throws JsonMappingException {
        int n3;
        char c2 = string.charAt(n2);
        char c3 = string.charAt(n2 + 1);
        if (c2 <= '\u007f' && c3 <= '\u007f' && (n3 = HEX_DIGITS[c2] << 4 | HEX_DIGITS[c3]) >= 0) {
            return n3;
        }
        if (c2 > '\u007f' || HEX_DIGITS[c2] < 0) {
            return this._badChar(string, n2, deserializationContext, c2);
        }
        return this._badChar(string, n2 + 1, deserializationContext, c3);
    }

    int _badChar(String string, int n2, DeserializationContext deserializationContext, char c2) throws JsonMappingException {
        throw deserializationContext.weirdStringException(string, this.handledType(), String.format("Non-hex character '%c' (value 0x%s), not valid for UUID String", Character.valueOf(c2), Integer.toHexString(c2)));
    }

    private UUID _fromBytes(byte[] byArray, DeserializationContext deserializationContext) throws JsonMappingException {
        if (byArray.length != 16) {
            throw InvalidFormatException.from(deserializationContext.getParser(), "Can only construct UUIDs from byte[16]; got " + byArray.length + " bytes", byArray, this.handledType());
        }
        return new UUID(UUIDDeserializer._long(byArray, 0), UUIDDeserializer._long(byArray, 8));
    }

    private String convertToUrlSafe(String string) {
        return string.replace('+', '-').replace('/', '_');
    }

    private String convertFromUrlSafe(String string) {
        return string.replace('-', '+').replace('_', '/');
    }

    private static long _long(byte[] byArray, int n2) {
        long l2 = (long)UUIDDeserializer._int(byArray, n2) << 32;
        long l3 = UUIDDeserializer._int(byArray, n2 + 4);
        l3 = l3 << 32 >>> 32;
        return l2 | l3;
    }

    private static int _int(byte[] byArray, int n2) {
        return byArray[n2] << 24 | (byArray[n2 + 1] & 0xFF) << 16 | (byArray[n2 + 2] & 0xFF) << 8 | byArray[n2 + 3] & 0xFF;
    }

    static {
        int n2;
        HEX_DIGITS = new int[127];
        Arrays.fill(HEX_DIGITS, -1);
        for (n2 = 0; n2 < 10; ++n2) {
            UUIDDeserializer.HEX_DIGITS[48 + n2] = n2;
        }
        for (n2 = 0; n2 < 6; ++n2) {
            UUIDDeserializer.HEX_DIGITS[97 + n2] = 10 + n2;
            UUIDDeserializer.HEX_DIGITS[65 + n2] = 10 + n2;
        }
    }
}

