/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.deser.std;

import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.annotation.JsonFormat;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.core.JsonParser;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.core.JsonToken;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.BeanProperty;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.DeserializationContext;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.DeserializationFeature;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.JavaType;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.JsonDeserializer;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.JsonMappingException;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.annotation.JacksonStdImpl;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.cfg.CoercionAction;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.cfg.CoercionInputShape;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.deser.ContextualDeserializer;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.deser.NullValueProvider;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.deser.ValueInstantiator;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.deser.std.ContainerDeserializerBase;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.jsontype.TypeDeserializer;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.type.LogicalType;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Objects;

@JacksonStdImpl
public final class StringCollectionDeserializer
extends ContainerDeserializerBase<Collection<String>>
implements ContextualDeserializer {
    private final JsonDeserializer<String> _valueDeserializer;
    private final ValueInstantiator _valueInstantiator;
    private final JsonDeserializer<Object> _delegateDeserializer;

    public StringCollectionDeserializer(JavaType javaType, JsonDeserializer<?> jsonDeserializer, ValueInstantiator valueInstantiator) {
        this(javaType, valueInstantiator, null, jsonDeserializer, jsonDeserializer, null);
    }

    private StringCollectionDeserializer(JavaType javaType, ValueInstantiator valueInstantiator, JsonDeserializer<?> jsonDeserializer, JsonDeserializer<?> jsonDeserializer2, NullValueProvider nullValueProvider, Boolean bl2) {
        super(javaType, nullValueProvider, bl2);
        this._valueDeserializer = jsonDeserializer2;
        this._valueInstantiator = valueInstantiator;
        this._delegateDeserializer = jsonDeserializer;
    }

    private StringCollectionDeserializer withResolved(JsonDeserializer<?> jsonDeserializer, JsonDeserializer<?> jsonDeserializer2, NullValueProvider nullValueProvider, Boolean bl2) {
        if (Objects.equals(this._unwrapSingle, bl2) && this._nullProvider == nullValueProvider && this._valueDeserializer == jsonDeserializer2 && this._delegateDeserializer == jsonDeserializer) {
            return this;
        }
        return new StringCollectionDeserializer(this._containerType, this._valueInstantiator, jsonDeserializer, jsonDeserializer2, nullValueProvider, bl2);
    }

    @Override
    public boolean isCachable() {
        return this._valueDeserializer == null && this._delegateDeserializer == null;
    }

    @Override
    public LogicalType logicalType() {
        return LogicalType.Collection;
    }

    @Override
    public JsonDeserializer<?> createContextual(DeserializationContext deserializationContext, BeanProperty beanProperty) throws JsonMappingException {
        JavaType javaType;
        Object object;
        JsonDeserializer<Object> jsonDeserializer = null;
        if (this._valueInstantiator != null) {
            object = this._valueInstantiator.getArrayDelegateCreator();
            if (object != null) {
                javaType = this._valueInstantiator.getArrayDelegateType(deserializationContext.getConfig());
                jsonDeserializer = this.findDeserializer(deserializationContext, javaType, beanProperty);
            } else {
                object = this._valueInstantiator.getDelegateCreator();
                if (object != null) {
                    javaType = this._valueInstantiator.getDelegateType(deserializationContext.getConfig());
                    jsonDeserializer = this.findDeserializer(deserializationContext, javaType, beanProperty);
                }
            }
        }
        object = this._valueDeserializer;
        javaType = this._containerType.getContentType();
        if (object == null) {
            if ((object = this.findConvertingContentDeserializer(deserializationContext, beanProperty, (JsonDeserializer<?>)object)) == null) {
                object = deserializationContext.findContextualValueDeserializer(javaType, beanProperty);
            }
        } else {
            object = deserializationContext.handleSecondaryContextualization((JsonDeserializer<?>)object, beanProperty, javaType);
        }
        Boolean bl2 = this.findFormatFeature(deserializationContext, beanProperty, Collection.class, JsonFormat.Feature.ACCEPT_SINGLE_VALUE_AS_ARRAY);
        NullValueProvider nullValueProvider = this.findContentNullProvider(deserializationContext, beanProperty, (JsonDeserializer<?>)object);
        if (this.isDefaultDeserializer((JsonDeserializer<?>)object)) {
            object = null;
        }
        return this.withResolved(jsonDeserializer, (JsonDeserializer<?>)object, nullValueProvider, bl2);
    }

    @Override
    public JsonDeserializer<Object> getContentDeserializer() {
        JsonDeserializer<Object> jsonDeserializer = this._valueDeserializer;
        return jsonDeserializer;
    }

    @Override
    public ValueInstantiator getValueInstantiator() {
        return this._valueInstantiator;
    }

    @Override
    public Collection<String> deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
        if (this._delegateDeserializer != null) {
            return StringCollectionDeserializer.castToCollection(this._valueInstantiator.createUsingDelegate(deserializationContext, this._delegateDeserializer.deserialize(jsonParser, deserializationContext)));
        }
        Collection<String> collection = StringCollectionDeserializer.castToCollection(this._valueInstantiator.createUsingDefault(deserializationContext));
        return this.deserialize(jsonParser, deserializationContext, collection);
    }

    @Override
    public Collection<String> deserialize(JsonParser jsonParser, DeserializationContext deserializationContext, Collection<String> collection) throws IOException {
        if (!jsonParser.isExpectedStartArrayToken()) {
            return this.handleNonArray(jsonParser, deserializationContext, collection);
        }
        if (this._valueDeserializer != null) {
            return this.deserializeUsingCustom(jsonParser, deserializationContext, collection, this._valueDeserializer);
        }
        try {
            while (true) {
                String string;
                if ((string = jsonParser.nextTextValue()) != null) {
                    collection.add(string);
                    continue;
                }
                JsonToken jsonToken = jsonParser.currentToken();
                if (jsonToken != JsonToken.END_ARRAY) {
                    if (jsonToken == JsonToken.VALUE_NULL) {
                        if (this._skipNullValues) {
                            continue;
                        }
                    } else {
                        string = this._parseString(jsonParser, deserializationContext, this._nullProvider);
                    }
                    if (string == null && (string = (String)this._nullProvider.getNullValue(deserializationContext)) == null && this._skipNullValues) continue;
                    collection.add(string);
                    continue;
                }
                break;
            }
        }
        catch (Exception exception) {
            throw JsonMappingException.wrapWithPath((Throwable)exception, collection, collection.size());
        }
        return collection;
    }

    private Collection<String> deserializeUsingCustom(JsonParser jsonParser, DeserializationContext deserializationContext, Collection<String> collection, JsonDeserializer<String> jsonDeserializer) throws IOException {
        try {
            while (true) {
                String string;
                if (jsonParser.nextTextValue() == null) {
                    JsonToken jsonToken = jsonParser.currentToken();
                    if (jsonToken == JsonToken.END_ARRAY) break;
                    if (jsonToken == JsonToken.VALUE_NULL) {
                        if (this._skipNullValues) continue;
                        string = null;
                    } else {
                        string = jsonDeserializer.deserialize(jsonParser, deserializationContext);
                    }
                } else {
                    string = jsonDeserializer.deserialize(jsonParser, deserializationContext);
                }
                if (string == null && (string = (String)this._nullProvider.getNullValue(deserializationContext)) == null && this._skipNullValues) continue;
                collection.add(string);
            }
        }
        catch (Exception exception) {
            throw JsonMappingException.wrapWithPath((Throwable)exception, collection, collection.size());
        }
        return collection;
    }

    @Override
    public Object deserializeWithType(JsonParser jsonParser, DeserializationContext deserializationContext, TypeDeserializer typeDeserializer) throws IOException {
        return typeDeserializer.deserializeTypedFromArray(jsonParser, deserializationContext);
    }

    private final Collection<String> handleNonArray(JsonParser jsonParser, DeserializationContext deserializationContext, Collection<String> collection) throws IOException {
        String string;
        boolean bl2;
        boolean bl3 = bl2 = this._unwrapSingle == Boolean.TRUE || this._unwrapSingle == null && deserializationContext.isEnabled(DeserializationFeature.ACCEPT_SINGLE_VALUE_AS_ARRAY);
        if (!bl2) {
            if (jsonParser.hasToken(JsonToken.VALUE_STRING)) {
                return (Collection)this._deserializeFromString(jsonParser, deserializationContext);
            }
            return StringCollectionDeserializer.castToCollection(deserializationContext.handleUnexpectedToken(this._containerType, jsonParser));
        }
        JsonDeserializer<String> jsonDeserializer = this._valueDeserializer;
        JsonToken jsonToken = jsonParser.currentToken();
        if (jsonToken == JsonToken.VALUE_NULL) {
            if (this._skipNullValues) {
                return collection;
            }
            string = null;
        } else {
            if (jsonParser.hasToken(JsonToken.VALUE_STRING)) {
                CoercionAction coercionAction;
                String string2 = jsonParser.getText();
                if (string2.isEmpty()) {
                    CoercionAction coercionAction2 = deserializationContext.findCoercionAction(this.logicalType(), this.handledType(), CoercionInputShape.EmptyString);
                    if (coercionAction2 != CoercionAction.Fail) {
                        return StringCollectionDeserializer.castToCollection(this._deserializeFromEmptyString(jsonParser, deserializationContext, coercionAction2, this.handledType(), "empty String (\"\")"));
                    }
                } else if (StringCollectionDeserializer._isBlank(string2) && (coercionAction = deserializationContext.findCoercionFromBlankString(this.logicalType(), this.handledType(), CoercionAction.Fail)) != CoercionAction.Fail) {
                    return StringCollectionDeserializer.castToCollection(this._deserializeFromEmptyString(jsonParser, deserializationContext, coercionAction, this.handledType(), "blank String (all whitespace)"));
                }
            }
            try {
                string = jsonDeserializer == null ? this._parseString(jsonParser, deserializationContext, this._nullProvider) : jsonDeserializer.deserialize(jsonParser, deserializationContext);
            }
            catch (Exception exception) {
                throw JsonMappingException.wrapWithPath((Throwable)exception, collection, collection.size());
            }
        }
        if (string == null && (string = (String)this._nullProvider.getNullValue(deserializationContext)) == null && this._skipNullValues) {
            return collection;
        }
        collection.add(string);
        return collection;
    }

    private static Collection<String> castToCollection(Object object) {
        if (object != null) {
            if (object.getClass() == ArrayList.class) {
                return (ArrayList)object;
            }
            if (object.getClass() == HashSet.class) {
                return (HashSet)object;
            }
        }
        return (Collection)object;
    }
}

