/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind;

import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.core.SerializableString;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.core.io.SerializedString;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.core.util.InternCache;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.cfg.MapperConfig;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.util.ClassUtil;
import java.io.Serializable;
import java.util.Objects;

public class PropertyName
implements Serializable {
    public static final PropertyName USE_DEFAULT = new PropertyName("", null);
    public static final PropertyName NO_NAME = new PropertyName(new String(""), null);
    protected final String _simpleName;
    protected final String _namespace;
    protected SerializableString _encodedSimple;

    public PropertyName(String string) {
        this(string, null);
    }

    public PropertyName(String string, String string2) {
        this._simpleName = ClassUtil.nonNullString(string);
        this._namespace = string2;
    }

    public static PropertyName construct(String string) {
        if (string == null || string.isEmpty()) {
            return USE_DEFAULT;
        }
        return new PropertyName(InternCache.instance.intern(string), null);
    }

    public static PropertyName construct(String string, String string2) {
        if (string == null) {
            string = "";
        }
        if (string2 == null && string.isEmpty()) {
            return USE_DEFAULT;
        }
        return new PropertyName(InternCache.instance.intern(string), string2);
    }

    public static PropertyName merge(PropertyName propertyName, PropertyName propertyName2) {
        if (propertyName == null) {
            return propertyName2;
        }
        if (propertyName2 == null) {
            return propertyName;
        }
        if (propertyName == NO_NAME) {
            return propertyName;
        }
        String string = PropertyName._nonEmpty(propertyName._namespace, propertyName2._namespace);
        String string2 = PropertyName._nonEmpty(propertyName._simpleName, propertyName2._simpleName);
        if (string == propertyName._namespace && string2 == propertyName._simpleName) {
            return propertyName;
        }
        if (string == propertyName2._namespace && string2 == propertyName2._simpleName) {
            return propertyName2;
        }
        return PropertyName.construct(string2, string);
    }

    private static String _nonEmpty(String string, String string2) {
        if (string == null) {
            return string2;
        }
        if (string2 == null) {
            return string;
        }
        if (string.isEmpty()) {
            return string2;
        }
        return string;
    }

    public PropertyName internSimpleName() {
        if (this._simpleName.isEmpty()) {
            return this;
        }
        String string = InternCache.instance.intern(this._simpleName);
        if (string == this._simpleName) {
            return this;
        }
        return new PropertyName(string, this._namespace);
    }

    public PropertyName withSimpleName(String string) {
        if (string == null) {
            string = "";
        }
        if (string.equals(this._simpleName)) {
            return this;
        }
        return new PropertyName(string, this._namespace);
    }

    public String getSimpleName() {
        return this._simpleName;
    }

    public SerializableString simpleAsEncoded(MapperConfig<?> mapperConfig) {
        SerializableString serializableString = this._encodedSimple;
        if (serializableString == null) {
            serializableString = mapperConfig == null ? new SerializedString(this._simpleName) : mapperConfig.compileString(this._simpleName);
            this._encodedSimple = serializableString;
        }
        return serializableString;
    }

    public String getNamespace() {
        return this._namespace;
    }

    public boolean hasSimpleName() {
        return !this._simpleName.isEmpty();
    }

    public boolean hasSimpleName(String string) {
        return this._simpleName.equals(string);
    }

    public boolean hasNamespace() {
        return this._namespace != null;
    }

    public boolean isEmpty() {
        return this._namespace == null && this._simpleName.isEmpty();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (object.getClass() != this.getClass()) {
            return false;
        }
        PropertyName propertyName = (PropertyName)object;
        if (this._simpleName == null ? propertyName._simpleName != null : !this._simpleName.equals(propertyName._simpleName)) {
            return false;
        }
        if (this._namespace == null) {
            return null == propertyName._namespace;
        }
        return this._namespace.equals(propertyName._namespace);
    }

    public int hashCode() {
        return Objects.hashCode(this._simpleName) * 31 + Objects.hashCode(this._namespace);
    }

    public String toString() {
        if (this._namespace == null) {
            return this._simpleName;
        }
        return "{" + this._namespace + "}" + this._simpleName;
    }
}

