/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.core.internal.shaded.fdp.v2_20_0;

import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.core.internal.shaded.fdp.v2_20_0.FastDoubleMath;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.core.internal.shaded.fdp.v2_20_0.FastIntegerMath;

final class FastFloatMath {
    private static final float[] FLOAT_POWER_OF_TEN = new float[]{1.0f, 10.0f, 100.0f, 1000.0f, 10000.0f, 100000.0f, 1000000.0f, 1.0E7f, 1.0E8f, 1.0E9f, 1.0E10f};

    static float tryDecFloatToFloatTruncated(boolean bl2, long l2, int n2, boolean bl3, int n3) {
        float f2;
        if (l2 == 0L) {
            return bl2 ? -0.0f : 0.0f;
        }
        if (bl3) {
            if (-45 <= n3 && n3 <= 38) {
                float f3 = FastFloatMath.tryDecToFloatWithFastAlgorithm(bl2, l2, n3);
                float f4 = FastFloatMath.tryDecToFloatWithFastAlgorithm(bl2, l2 + 1L, n3);
                if (f4 == f3) {
                    return f3;
                }
            }
            f2 = Float.NaN;
        } else {
            f2 = -45 <= n2 && n2 <= 38 ? FastFloatMath.tryDecToFloatWithFastAlgorithm(bl2, l2, n2) : Float.NaN;
        }
        return f2;
    }

    static float tryHexFloatToFloatTruncated(boolean bl2, long l2, int n2, boolean bl3, int n3) {
        int n4;
        int n5 = n4 = bl3 ? n3 : n2;
        if (-126 <= n4 && n4 <= 127) {
            float f2 = (float)l2 + (l2 < 0L ? 1.8446744E19f : 0.0f);
            f2 = FastFloatMath.fastScalb(f2, n4);
            return bl2 ? -f2 : f2;
        }
        return Float.NaN;
    }

    static float tryDecToFloatWithFastAlgorithm(boolean bl2, long l2, int n2) {
        if (-10 <= n2 && n2 <= 10 && Long.compareUnsigned(l2, 0xFFFFFFL) <= 0) {
            float f2 = l2;
            f2 = n2 < 0 ? (f2 /= FLOAT_POWER_OF_TEN[-n2]) : (f2 *= FLOAT_POWER_OF_TEN[n2]);
            return bl2 ? -f2 : f2;
        }
        long l3 = FastDoubleMath.MANTISSA_64[n2 - -325];
        long l4 = (217706L * (long)n2 >> 16) + 127L + 64L;
        int n3 = Long.numberOfLeadingZeros(l2);
        long l5 = l2 << n3;
        long l6 = FastIntegerMath.unsignedMultiplyHigh(l5, l3);
        long l7 = l6 >>> 63;
        long l8 = l6 >>> (int)(l7 + 38L);
        n3 += (int)(1L ^ l7);
        if ((l6 & 0x3FFFFFFFFFL) == 0x3FFFFFFFFFL || (l6 & 0x3FFFFFFFFFL) == 0L && (l8 & 3L) == 1L) {
            return Float.NaN;
        }
        ++l8;
        if ((l8 >>>= 1) >= 0x1000000L) {
            l8 = 0x800000L;
            --n3;
        }
        l8 &= 0xFFFFFFFFFF7FFFFFL;
        long l9 = l4 - (long)n3;
        if (l9 < 1L || l9 > 254L) {
            return Float.NaN;
        }
        int n4 = (int)(l8 | l9 << 23 | (bl2 ? 0x80000000L : 0L));
        return Float.intBitsToFloat(n4);
    }

    static float fastScalb(float f2, int n2) {
        return f2 * Float.intBitsToFloat(n2 + 127 << 23);
    }
}

