/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.com.ctc.wstx.util;

import com.gradle.maven.extension.internal.dep.com.ctc.wstx.util.ElementId;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.util.ExceptionUtil;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.util.PrefixedName;
import javax.xml.stream.Location;

public final class ElementIdMap {
    protected static final int DEFAULT_SIZE = 128;
    protected static final int MIN_SIZE = 16;
    protected static final int FILL_PCT = 80;
    protected ElementId[] mTable;
    protected int mSize;
    protected int mSizeThreshold;
    protected int mIndexMask;
    protected ElementId mHead;
    protected ElementId mTail;

    public ElementIdMap() {
        this(128);
    }

    public ElementIdMap(int n2) {
        int n3;
        for (n3 = 16; n3 < n2; n3 += n3) {
        }
        this.mTable = new ElementId[n3];
        this.mIndexMask = n3 - 1;
        this.mSize = 0;
        this.mSizeThreshold = n3 * 80 / 100;
        this.mTail = null;
        this.mHead = null;
    }

    public ElementId getFirstUndefined() {
        return this.mHead;
    }

    public ElementId addReferenced(char[] cArray, int n2, int n3, int n4, Location location, PrefixedName prefixedName, PrefixedName prefixedName2) {
        ElementId elementId;
        int n5 = n4 & this.mIndexMask;
        for (elementId = this.mTable[n5]; elementId != null; elementId = elementId.nextColliding()) {
            if (!elementId.idMatches(cArray, n2, n3)) continue;
            return elementId;
        }
        if (this.mSize >= this.mSizeThreshold) {
            this.rehash();
            n5 = n4 & this.mIndexMask;
        }
        ++this.mSize;
        String string = new String(cArray, n2, n3);
        elementId = new ElementId(string, location, false, prefixedName, prefixedName2);
        elementId.setNextColliding(this.mTable[n5]);
        this.mTable[n5] = elementId;
        if (this.mHead == null) {
            this.mHead = this.mTail = elementId;
        } else {
            this.mTail.linkUndefined(elementId);
            this.mTail = elementId;
        }
        return elementId;
    }

    public ElementId addReferenced(String string, Location location, PrefixedName prefixedName, PrefixedName prefixedName2) {
        ElementId elementId;
        int n2 = ElementIdMap.calcHash(string);
        int n3 = n2 & this.mIndexMask;
        for (elementId = this.mTable[n3]; elementId != null; elementId = elementId.nextColliding()) {
            if (!elementId.idMatches(string)) continue;
            return elementId;
        }
        if (this.mSize >= this.mSizeThreshold) {
            this.rehash();
            n3 = n2 & this.mIndexMask;
        }
        ++this.mSize;
        elementId = new ElementId(string, location, false, prefixedName, prefixedName2);
        elementId.setNextColliding(this.mTable[n3]);
        this.mTable[n3] = elementId;
        if (this.mHead == null) {
            this.mHead = this.mTail = elementId;
        } else {
            this.mTail.linkUndefined(elementId);
            this.mTail = elementId;
        }
        return elementId;
    }

    public ElementId addDefined(char[] cArray, int n2, int n3, int n4, Location location, PrefixedName prefixedName, PrefixedName prefixedName2) {
        ElementId elementId;
        int n5 = n4 & this.mIndexMask;
        for (elementId = this.mTable[n5]; elementId != null && !elementId.idMatches(cArray, n2, n3); elementId = elementId.nextColliding()) {
        }
        if (elementId == null) {
            if (this.mSize >= this.mSizeThreshold) {
                this.rehash();
                n5 = n4 & this.mIndexMask;
            }
            ++this.mSize;
            String string = new String(cArray, n2, n3);
            elementId = new ElementId(string, location, true, prefixedName, prefixedName2);
            elementId.setNextColliding(this.mTable[n5]);
            this.mTable[n5] = elementId;
        } else if (!elementId.isDefined()) {
            elementId.markDefined(location);
            if (elementId == this.mHead) {
                do {
                    this.mHead = this.mHead.nextUndefined();
                } while (this.mHead != null && this.mHead.isDefined());
                if (this.mHead == null) {
                    this.mTail = null;
                }
            }
        }
        return elementId;
    }

    public ElementId addDefined(String string, Location location, PrefixedName prefixedName, PrefixedName prefixedName2) {
        ElementId elementId;
        int n2 = ElementIdMap.calcHash(string);
        int n3 = n2 & this.mIndexMask;
        for (elementId = this.mTable[n3]; elementId != null && !elementId.idMatches(string); elementId = elementId.nextColliding()) {
        }
        if (elementId == null) {
            if (this.mSize >= this.mSizeThreshold) {
                this.rehash();
                n3 = n2 & this.mIndexMask;
            }
            ++this.mSize;
            elementId = new ElementId(string, location, true, prefixedName, prefixedName2);
            elementId.setNextColliding(this.mTable[n3]);
            this.mTable[n3] = elementId;
        } else if (!elementId.isDefined()) {
            elementId.markDefined(location);
            if (elementId == this.mHead) {
                do {
                    this.mHead = this.mHead.nextUndefined();
                } while (this.mHead != null && this.mHead.isDefined());
                if (this.mHead == null) {
                    this.mTail = null;
                }
            }
        }
        return elementId;
    }

    public static int calcHash(char[] cArray, int n2, int n3) {
        int n4 = cArray[n2];
        for (int i2 = 1; i2 < n3; ++i2) {
            n4 = n4 * 31 + cArray[n2 + i2];
        }
        return n4;
    }

    public static int calcHash(String string) {
        int n2 = string.charAt(0);
        int n3 = string.length();
        for (int i2 = 1; i2 < n3; ++i2) {
            n2 = n2 * 31 + string.charAt(i2);
        }
        return n2;
    }

    private void rehash() {
        int n2 = this.mTable.length;
        int n3 = n2 << 2;
        ElementId[] elementIdArray = this.mTable;
        this.mTable = new ElementId[n3];
        this.mIndexMask = n3 - 1;
        this.mSizeThreshold <<= 2;
        int n4 = 0;
        for (int i2 = 0; i2 < n2; ++i2) {
            ElementId elementId = elementIdArray[i2];
            while (elementId != null) {
                ++n4;
                int n5 = ElementIdMap.calcHash(elementId.getId()) & this.mIndexMask;
                ElementId elementId2 = elementId.nextColliding();
                elementId.setNextColliding(this.mTable[n5]);
                this.mTable[n5] = elementId;
                elementId = elementId2;
            }
        }
        if (n4 != this.mSize) {
            ExceptionUtil.throwInternal("on rehash(): had " + this.mSize + " entries; now have " + n4 + ".");
        }
    }
}

