/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.com.ctc.wstx.sw;

import com.gradle.maven.extension.internal.dep.com.ctc.wstx.api.EmptyElementHandler;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.api.WriterConfig;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.cfg.ErrorConsts;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.exc.WstxIOException;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.sw.SimpleOutputElement;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.sw.TypedStreamWriter;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.sw.XmlWriter;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.util.DefaultXmlSymbolTable;
import com.gradle.maven.extension.internal.dep.org.codehaus.stax2.ri.typed.AsciiValueEncoder;
import java.io.IOException;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.StartElement;

public abstract class BaseNsStreamWriter
extends TypedStreamWriter {
    protected static final String sPrefixXml = DefaultXmlSymbolTable.getXmlSymbol();
    protected static final String sPrefixXmlns = DefaultXmlSymbolTable.getXmlnsSymbol();
    protected static final String ERR_NSDECL_WRONG_STATE = "Trying to write a namespace declaration when there is no open start element.";
    protected final boolean mAutomaticNS;
    protected final EmptyElementHandler mEmptyElementHandler;
    protected SimpleOutputElement mCurrElem = SimpleOutputElement.createRoot();
    protected NamespaceContext mRootNsContext = null;
    protected SimpleOutputElement mOutputElemPool = null;
    static final int MAX_POOL_SIZE = 8;
    protected int mPoolSize = 0;

    public BaseNsStreamWriter(XmlWriter xmlWriter, String string, WriterConfig writerConfig, boolean bl2) {
        super(xmlWriter, string, writerConfig);
        this.mAutomaticNS = bl2;
        this.mEmptyElementHandler = writerConfig.getEmptyElementHandler();
    }

    @Override
    public NamespaceContext getNamespaceContext() {
        return this.mCurrElem;
    }

    @Override
    public String getPrefix(String string) {
        return this.mCurrElem.getPrefix(string);
    }

    @Override
    public abstract void setDefaultNamespace(String var1) throws XMLStreamException;

    @Override
    public void setNamespaceContext(NamespaceContext namespaceContext) throws XMLStreamException {
        if (this.mState != 1) {
            BaseNsStreamWriter.throwOutputError("Called setNamespaceContext() after having already output root element.");
        }
        this.mRootNsContext = namespaceContext;
        this.mCurrElem.setRootNsContext(namespaceContext);
    }

    @Override
    public void setPrefix(String string, String string2) throws XMLStreamException {
        if (string == null) {
            throw new NullPointerException("Can not pass null 'prefix' value");
        }
        if (string.length() == 0) {
            this.setDefaultNamespace(string2);
            return;
        }
        if (string2 == null) {
            throw new NullPointerException("Can not pass null 'uri' value");
        }
        if (string.equals(sPrefixXml)) {
            if (!string2.equals("http://www.w3.org/XML/1998/namespace")) {
                BaseNsStreamWriter.throwOutputError(ErrorConsts.ERR_NS_REDECL_XML, string2);
            }
        } else if (string.equals(sPrefixXmlns)) {
            if (!string2.equals("http://www.w3.org/2000/xmlns/")) {
                BaseNsStreamWriter.throwOutputError(ErrorConsts.ERR_NS_REDECL_XMLNS, string2);
            }
        } else if (string2.equals("http://www.w3.org/XML/1998/namespace")) {
            BaseNsStreamWriter.throwOutputError(ErrorConsts.ERR_NS_REDECL_XML_URI, string);
        } else if (string2.equals("http://www.w3.org/2000/xmlns/")) {
            BaseNsStreamWriter.throwOutputError(ErrorConsts.ERR_NS_REDECL_XMLNS_URI, string);
        }
        if (!this.mXml11 && string2.length() == 0) {
            BaseNsStreamWriter.throwOutputError(ErrorConsts.ERR_NS_EMPTY);
        }
        this.doSetPrefix(string, string2);
    }

    @Override
    public void writeAttribute(String string, String string2) throws XMLStreamException {
        if (!this.mStartElementOpen && this.mCheckStructure) {
            BaseNsStreamWriter.reportNwfStructure(ErrorConsts.WERR_ATTR_NO_ELEM);
        }
        this.doWriteAttr(string, null, null, string2);
    }

    @Override
    public abstract void writeAttribute(String var1, String var2, String var3) throws XMLStreamException;

    @Override
    public abstract void writeAttribute(String var1, String var2, String var3, String var4) throws XMLStreamException;

    @Override
    public void writeEmptyElement(String string) throws XMLStreamException {
        this.checkStartElement(string, null);
        if (this.mValidator != null) {
            this.mValidator.validateElementStart(string, "", "");
        }
        this.mEmptyElement = true;
        if (this.mOutputElemPool != null) {
            SimpleOutputElement simpleOutputElement = this.mOutputElemPool;
            this.mOutputElemPool = simpleOutputElement.reuseAsChild(this.mCurrElem, string);
            --this.mPoolSize;
            this.mCurrElem = simpleOutputElement;
        } else {
            this.mCurrElem = this.mCurrElem.createChild(string);
        }
        this.doWriteStartTag(string);
    }

    @Override
    public void writeEmptyElement(String string, String string2) throws XMLStreamException {
        this.writeStartOrEmpty(string2, string);
        this.mEmptyElement = true;
    }

    @Override
    public void writeEmptyElement(String string, String string2, String string3) throws XMLStreamException {
        this.writeStartOrEmpty(string, string2, string3);
        this.mEmptyElement = true;
    }

    @Override
    public void writeEndElement() throws XMLStreamException {
        this.doWriteEndTag(null, this.mCfgAutomaticEmptyElems);
    }

    @Override
    public void writeStartElement(String string) throws XMLStreamException {
        this.checkStartElement(string, null);
        if (this.mValidator != null) {
            this.mValidator.validateElementStart(string, "", "");
        }
        this.mEmptyElement = false;
        if (this.mOutputElemPool != null) {
            SimpleOutputElement simpleOutputElement = this.mOutputElemPool;
            this.mOutputElemPool = simpleOutputElement.reuseAsChild(this.mCurrElem, string);
            --this.mPoolSize;
            this.mCurrElem = simpleOutputElement;
        } else {
            this.mCurrElem = this.mCurrElem.createChild(string);
        }
        this.doWriteStartTag(string);
    }

    @Override
    public void writeStartElement(String string, String string2) throws XMLStreamException {
        this.writeStartOrEmpty(string2, string);
        this.mEmptyElement = false;
    }

    @Override
    public void writeStartElement(String string, String string2, String string3) throws XMLStreamException {
        this.writeStartOrEmpty(string, string2, string3);
        this.mEmptyElement = false;
    }

    @Override
    protected void writeTypedAttribute(String string, String string2, String string3, AsciiValueEncoder asciiValueEncoder) throws XMLStreamException {
        if (!this.mStartElementOpen) {
            BaseNsStreamWriter.throwOutputError(ErrorConsts.WERR_ATTR_NO_ELEM);
        }
        if (this.mCheckAttrs) {
            this.mCurrElem.checkAttrWrite(string2, string3);
        }
        try {
            if (this.mValidator == null) {
                if (string == null || string.length() == 0) {
                    this.mWriter.writeTypedAttribute(string3, asciiValueEncoder);
                } else {
                    this.mWriter.writeTypedAttribute(string, string3, asciiValueEncoder);
                }
            } else {
                this.mWriter.writeTypedAttribute(string, string3, string2, asciiValueEncoder, this.mValidator, this.getCopyBuffer());
            }
        }
        catch (IOException iOException) {
            throw new WstxIOException(iOException);
        }
    }

    @Override
    public void writeFullEndElement() throws XMLStreamException {
        this.doWriteEndTag(null, false);
    }

    @Override
    public QName getCurrentElementName() {
        return this.mCurrElem.getName();
    }

    @Override
    public String getNamespaceURI(String string) {
        return this.mCurrElem.getNamespaceURI(string);
    }

    @Override
    public void writeEndElement(QName qName) throws XMLStreamException {
        this.doWriteEndTag(this.mCheckStructure ? qName : null, this.mCfgAutomaticEmptyElems);
    }

    @Override
    protected void closeStartElement(boolean bl2) throws XMLStreamException {
        this.mStartElementOpen = false;
        try {
            if (bl2) {
                this.mWriter.writeStartTagEmptyEnd();
            } else {
                this.mWriter.writeStartTagEnd();
            }
        }
        catch (IOException iOException) {
            throw new WstxIOException(iOException);
        }
        if (this.mValidator != null) {
            this.mVldContent = this.mValidator.validateElementAndAttributes();
        }
        if (bl2) {
            SimpleOutputElement simpleOutputElement = this.mCurrElem;
            this.mCurrElem = simpleOutputElement.getParent();
            if (this.mCurrElem.isRoot()) {
                this.mState = 3;
            }
            if (this.mValidator != null) {
                this.mVldContent = this.mValidator.validateElementEnd(simpleOutputElement.getLocalName(), simpleOutputElement.getNamespaceURI(), simpleOutputElement.getPrefix());
            }
            if (this.mPoolSize < 8) {
                simpleOutputElement.addToPool(this.mOutputElemPool);
                this.mOutputElemPool = simpleOutputElement;
                ++this.mPoolSize;
            }
        }
    }

    @Override
    protected String getTopElementDesc() {
        return this.mCurrElem.getNameDesc();
    }

    protected void checkStartElement(String string, String string2) throws XMLStreamException {
        if (this.mStartElementOpen) {
            this.closeStartElement(this.mEmptyElement);
        } else if (this.mState == 1) {
            this.verifyRootElement(string, string2);
        } else if (this.mState == 3) {
            if (this.mCheckStructure) {
                String string3 = string2 == null || string2.length() == 0 ? string : string2 + ":" + string;
                BaseNsStreamWriter.reportNwfStructure(ErrorConsts.WERR_PROLOG_SECOND_ROOT, string3);
            }
            this.mState = 2;
        }
    }

    protected final void doWriteAttr(String string, String string2, String string3, String string4) throws XMLStreamException {
        if (this.mCheckAttrs) {
            this.mCurrElem.checkAttrWrite(string2, string);
        }
        if (this.mValidator != null) {
            this.mValidator.validateAttribute(string, string2, string3, string4);
        }
        try {
            int n2 = string4.length();
            if (n2 >= 12) {
                char[] cArray = this.mCopyBuffer;
                if (cArray == null) {
                    this.mCopyBuffer = cArray = this.mConfig.allocMediumCBuffer(512);
                }
                if (n2 <= cArray.length) {
                    string4.getChars(0, n2, cArray, 0);
                    if (string3 != null && string3.length() > 0) {
                        this.mWriter.writeAttribute(string3, string, cArray, 0, n2);
                    } else {
                        this.mWriter.writeAttribute(string, cArray, 0, n2);
                    }
                    return;
                }
            }
            if (string3 != null && string3.length() > 0) {
                this.mWriter.writeAttribute(string3, string, string4);
            } else {
                this.mWriter.writeAttribute(string, string4);
            }
        }
        catch (IOException iOException) {
            throw new WstxIOException(iOException);
        }
    }

    protected final void doWriteAttr(String string, String string2, String string3, char[] cArray, int n2, int n3) throws XMLStreamException {
        if (this.mCheckAttrs) {
            this.mCurrElem.checkAttrWrite(string2, string);
        }
        if (this.mValidator != null) {
            this.mValidator.validateAttribute(string, string2, string3, cArray, n2, n3);
        }
        try {
            if (string3 != null && string3.length() > 0) {
                this.mWriter.writeAttribute(string3, string, cArray, n2, n3);
            } else {
                this.mWriter.writeAttribute(string, cArray, n2, n3);
            }
        }
        catch (IOException iOException) {
            throw new WstxIOException(iOException);
        }
    }

    protected void doWriteNamespace(String string, String string2) throws XMLStreamException {
        try {
            int n2 = string2.length();
            if (n2 >= 12) {
                char[] cArray = this.mCopyBuffer;
                if (cArray == null) {
                    this.mCopyBuffer = cArray = this.mConfig.allocMediumCBuffer(512);
                }
                if (n2 <= cArray.length) {
                    string2.getChars(0, n2, cArray, 0);
                    this.mWriter.writeAttribute("xmlns", string, cArray, 0, n2);
                    return;
                }
            }
            this.mWriter.writeAttribute("xmlns", string, string2);
        }
        catch (IOException iOException) {
            throw new WstxIOException(iOException);
        }
    }

    protected void doWriteDefaultNs(String string) throws XMLStreamException {
        try {
            int n2;
            int n3 = n2 = string == null ? 0 : string.length();
            if (n2 >= 12) {
                char[] cArray = this.mCopyBuffer;
                if (cArray == null) {
                    this.mCopyBuffer = cArray = this.mConfig.allocMediumCBuffer(512);
                }
                if (n2 <= cArray.length) {
                    string.getChars(0, n2, cArray, 0);
                    this.mWriter.writeAttribute("xmlns", cArray, 0, n2);
                    return;
                }
            }
            this.mWriter.writeAttribute("xmlns", string);
        }
        catch (IOException iOException) {
            throw new WstxIOException(iOException);
        }
    }

    protected final void doWriteStartTag(String string) throws XMLStreamException {
        this.mAnyOutput = true;
        this.mStartElementOpen = true;
        try {
            this.mWriter.writeStartTagStart(string);
        }
        catch (IOException iOException) {
            throw new WstxIOException(iOException);
        }
    }

    protected final void doWriteStartTag(String string, String string2) throws XMLStreamException {
        this.mAnyOutput = true;
        this.mStartElementOpen = true;
        try {
            boolean bl2;
            boolean bl3 = bl2 = string != null && string.length() > 0;
            if (bl2) {
                this.mWriter.writeStartTagStart(string, string2);
            } else {
                this.mWriter.writeStartTagStart(string2);
            }
        }
        catch (IOException iOException) {
            throw new WstxIOException(iOException);
        }
    }

    protected void doWriteEndTag(QName qName, boolean bl2) throws XMLStreamException {
        if (this.mStartElementOpen && this.mEmptyElement) {
            this.mEmptyElement = false;
            this.closeStartElement(true);
        }
        if (this.mState != 2) {
            BaseNsStreamWriter.reportNwfStructure("No open start element, when trying to write end element");
        }
        SimpleOutputElement simpleOutputElement = this.mCurrElem;
        String string = simpleOutputElement.getPrefix();
        String string2 = simpleOutputElement.getLocalName();
        String string3 = simpleOutputElement.getNamespaceURI();
        this.mCurrElem = simpleOutputElement.getParent();
        if (this.mPoolSize < 8) {
            simpleOutputElement.addToPool(this.mOutputElemPool);
            this.mOutputElemPool = simpleOutputElement;
            ++this.mPoolSize;
        }
        if (this.mCheckStructure && qName != null && !string2.equals(qName.getLocalPart())) {
            BaseNsStreamWriter.reportNwfStructure("Mismatching close element local name, '" + string2 + "'; expected '" + qName.getLocalPart() + "'.");
        }
        if (this.mStartElementOpen) {
            if (this.mValidator != null) {
                this.mVldContent = this.mValidator.validateElementAndAttributes();
            }
            this.mStartElementOpen = false;
            try {
                if (this.mEmptyElementHandler != null) {
                    bl2 = this.mEmptyElementHandler.allowEmptyElement(string, string2, string3, bl2);
                }
                if (bl2) {
                    this.mWriter.writeStartTagEmptyEnd();
                    if (this.mCurrElem.isRoot()) {
                        this.mState = 3;
                    }
                    if (this.mValidator != null) {
                        this.mVldContent = this.mValidator.validateElementEnd(string2, string3, string);
                    }
                    return;
                }
                this.mWriter.writeStartTagEnd();
            }
            catch (IOException iOException) {
                throw new WstxIOException(iOException);
            }
        }
        try {
            this.mWriter.writeEndTag(string, string2);
        }
        catch (IOException iOException) {
            throw new WstxIOException(iOException);
        }
        if (this.mCurrElem.isRoot()) {
            this.mState = 3;
        }
        if (this.mValidator != null) {
            this.mVldContent = this.mValidator.validateElementEnd(string2, string3, string);
        }
    }

    public abstract void doSetPrefix(String var1, String var2) throws XMLStreamException;

    @Override
    public abstract void writeDefaultNamespace(String var1) throws XMLStreamException;

    @Override
    public abstract void writeNamespace(String var1, String var2) throws XMLStreamException;

    @Override
    public abstract void writeStartElement(StartElement var1) throws XMLStreamException;

    protected abstract void writeStartOrEmpty(String var1, String var2) throws XMLStreamException;

    protected abstract void writeStartOrEmpty(String var1, String var2, String var3) throws XMLStreamException;
}

