/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.reader.trex.ng;

import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv.org_isorelax.verifier.Schema;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv.relaxng_datatype.Datatype;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv.relaxng_datatype.DatatypeException;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv.relaxng_datatype.DatatypeLibrary;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv.relaxng_datatype.DatatypeLibraryFactory;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.datatype.ErrorDatatypeLibrary;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.datatype.xsd.StringType;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.grammar.Expression;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.grammar.ExpressionPool;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.grammar.ReferenceExp;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.grammar.trex.TREXGrammar;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.reader.ChoiceState;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.reader.GrammarReaderController;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.reader.State;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.reader.TerminalState;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.reader.trex.DivInGrammarState;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.reader.trex.IncludePatternState;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.reader.trex.NameClassChoiceState;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.reader.trex.RootState;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.reader.trex.TREXBaseReader;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.reader.trex.TREXSequencedStringChecker;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.reader.trex.ng.AttributeState;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.reader.trex.ng.DataParamState;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.reader.trex.ng.DataState;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.reader.trex.ng.DefaultDatatypeLibraryFactory;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.reader.trex.ng.DefineState;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.reader.trex.ng.ElementState;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.reader.trex.ng.GrammarState;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.reader.trex.ng.IncludeMergeState;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.reader.trex.ng.ListState;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.reader.trex.ng.NGNameState;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.reader.trex.ng.RefState;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.reader.trex.ng.RestrictionChecker;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.reader.trex.ng.StartState;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.reader.trex.ng.ValueState;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.util.LightStack;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.util.StartTagInfo;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.util.Util;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.verifier.jarv.RELAXNGFactoryImpl;
import java.io.Serializable;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.Stack;
import java.util.Vector;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

public class RELAXNGReader
extends TREXBaseReader {
    protected static Schema relaxNGSchema4Schema = null;
    private final Map<ReferenceExp, RefExpParseInfo> refExpParseInfos = new HashMap<ReferenceExp, RefExpParseInfo>();
    protected RefExpParseInfo currentNamedPattern = null;
    protected boolean directRefernce = true;
    public static final String RELAXNGNamespace = "http://relaxng.org/ns/structure/1.0";
    private DatatypeLibraryFactory datatypeLibraryFactory = new DefaultDatatypeLibraryFactory();
    protected final RestrictionChecker restrictionChecker = new RestrictionChecker(this);
    private DatatypeLibrary datatypeLib = this.resolveDataTypeLibrary("");
    protected String datatypeLibURI = "";
    private final LightStack dtLibStack = new LightStack();
    private final LightStack dtLibURIStack = new LightStack();
    public static final String ERR_BAD_FACET = "RELAXNGReader.BadFacet";
    public static final String ERR_INVALID_PARAMETERS = "RELAXNGReader.InvalidParameters";
    public static final String ERR_BAD_DATA_VALUE = "RELAXNGReader.BadDataValue";
    public static final String ERR_UNDEFINED_KEY = "RELAXNGReader.UndefinedKey";
    public static final String ERR_UNDEFINED_DATATYPE_1 = "RELAXNGReader.UndefinedDataType1";
    public static final String ERR_INCONSISTENT_KEY_TYPE = "RELAXNGReader.InconsistentKeyType";
    public static final String ERR_INCONSISTENT_COMBINE = "RELAXNGReader.InconsistentCombine";
    public static final String ERR_REDEFINING_UNDEFINED = "RELAXNGReader.RedefiningUndefined";
    public static final String ERR_UNKNOWN_DATATYPE_VOCABULARY_1 = "RELAXNGReader.UnknownDatatypeVocabulary1";
    public static final String ERR_MULTIPLE_EXCEPT = "RELAXNGReader.MultipleExcept";
    public static final String ERR_NOT_ABSOLUTE_URI = "RELAXNGReader.NotAbsoluteURI";
    public static final String ERR_INFOSET_URI_ATTRIBUTE = "RELAXNGReader.InfosetUriAttribute";
    public static final String ERR_XMLNS_ATTRIBUTE = "RELAXNGReader.XmlnsAttribute";
    public static final String ERR_NAKED_INFINITE_ATTRIBUTE_NAMECLASS = "RELAXNGReader.NakedInfiniteAttributeNameClass";

    public static TREXGrammar parse(String string, SAXParserFactory sAXParserFactory, GrammarReaderController grammarReaderController) {
        RELAXNGReader rELAXNGReader = new RELAXNGReader(grammarReaderController, sAXParserFactory);
        rELAXNGReader.parse(string);
        return rELAXNGReader.getResult();
    }

    public static TREXGrammar parse(InputSource inputSource, SAXParserFactory sAXParserFactory, GrammarReaderController grammarReaderController) {
        RELAXNGReader rELAXNGReader = new RELAXNGReader(grammarReaderController, sAXParserFactory);
        rELAXNGReader.parse(inputSource);
        return rELAXNGReader.getResult();
    }

    public RELAXNGReader(GrammarReaderController grammarReaderController) {
        this(grammarReaderController, RELAXNGReader.createParserFactory());
    }

    public RELAXNGReader(GrammarReaderController grammarReaderController, SAXParserFactory sAXParserFactory) {
        this(grammarReaderController, sAXParserFactory, new StateFactory(), new ExpressionPool());
    }

    public RELAXNGReader(GrammarReaderController grammarReaderController, SAXParserFactory sAXParserFactory, StateFactory stateFactory, ExpressionPool expressionPool) {
        super(grammarReaderController, sAXParserFactory, expressionPool, stateFactory, new RootState());
    }

    public static Schema getRELAXNGSchema4Schema() {
        if (relaxNGSchema4Schema == null) {
            try {
                relaxNGSchema4Schema = new RELAXNGFactoryImpl().compileSchema(RELAXNGReader.class.getResourceAsStream("relaxng.rng"));
            }
            catch (Exception exception) {
                exception.printStackTrace();
                throw new RuntimeException("unable to load schema-for-schema for RELAX NG");
            }
        }
        return relaxNGSchema4Schema;
    }

    @Override
    protected String localizeMessage(String string, Object[] objectArray) {
        String string2;
        try {
            string2 = ResourceBundle.getBundle("com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.reader.trex.ng.Messages").getString(string);
        }
        catch (Exception exception) {
            return super.localizeMessage(string, objectArray);
        }
        return MessageFormat.format(string2, objectArray);
    }

    protected TREXGrammar getGrammar() {
        return this.grammar;
    }

    protected RefExpParseInfo getRefExpParseInfo(ReferenceExp referenceExp) {
        RefExpParseInfo refExpParseInfo = this.refExpParseInfos.get(referenceExp);
        if (refExpParseInfo == null) {
            refExpParseInfo = new RefExpParseInfo();
            this.refExpParseInfos.put(referenceExp, refExpParseInfo);
        }
        return refExpParseInfo;
    }

    @Override
    protected boolean isGrammarElement(StartTagInfo startTagInfo) {
        return RELAXNGNamespace.equals(startTagInfo.namespaceURI) || "http://relaxng.org/ns/structure/0.9".equals(startTagInfo.namespaceURI);
    }

    public DatatypeLibraryFactory getDatatypeLibraryFactory() {
        return this.datatypeLibraryFactory;
    }

    public void setDatatypeLibraryFactory(DatatypeLibraryFactory datatypeLibraryFactory) {
        this.datatypeLibraryFactory = datatypeLibraryFactory;
    }

    protected StateFactory getStateFactory() {
        return (StateFactory)this.sfactory;
    }

    @Override
    protected State createNameClassChildState(State state, StartTagInfo startTagInfo) {
        if (startTagInfo.localName.equals("name")) {
            return this.sfactory.nsName(state, startTagInfo);
        }
        if (startTagInfo.localName.equals("anyName")) {
            return this.sfactory.nsAnyName(state, startTagInfo);
        }
        if (startTagInfo.localName.equals("nsName")) {
            return this.sfactory.nsNsName(state, startTagInfo);
        }
        if (startTagInfo.localName.equals("choice")) {
            return this.sfactory.nsChoice(state, startTagInfo);
        }
        return null;
    }

    @Override
    public State createExpressionChildState(State state, StartTagInfo startTagInfo) {
        if (startTagInfo.localName.equals("text")) {
            return this.getStateFactory().text(state, startTagInfo);
        }
        if (startTagInfo.localName.equals("data")) {
            return this.getStateFactory().data(state, startTagInfo);
        }
        if (startTagInfo.localName.equals("value")) {
            return this.getStateFactory().value(state, startTagInfo);
        }
        if (startTagInfo.localName.equals("list")) {
            return this.getStateFactory().list(state, startTagInfo);
        }
        if (startTagInfo.localName.equals("externalRef")) {
            return this.getStateFactory().externalRef(state, startTagInfo);
        }
        if (startTagInfo.localName.equals("parentRef")) {
            return this.getStateFactory().parentRef(state, startTagInfo);
        }
        return super.createExpressionChildState(state, startTagInfo);
    }

    public Datatype resolveDataType(String string) {
        try {
            return this.getCurrentDatatypeLibrary().createDatatype(string);
        }
        catch (DatatypeException datatypeException) {
            this.reportError(ERR_UNDEFINED_DATATYPE_1, (Object)string, (Object)datatypeException.getMessage());
            return StringType.theInstance;
        }
    }

    public DatatypeLibrary resolveDataTypeLibrary(String string) {
        try {
            DatatypeLibrary datatypeLibrary = this.datatypeLibraryFactory.createDatatypeLibrary(string);
            if (datatypeLibrary != null) {
                return datatypeLibrary;
            }
            this.reportError("TREXGrammarReader.UnknownDataTypeVocabulary", (Object)string);
        }
        catch (Throwable throwable) {
            this.reportError(ERR_UNKNOWN_DATATYPE_VOCABULARY_1, (Object)string, (Object)throwable.toString());
        }
        return ErrorDatatypeLibrary.theInstance;
    }

    private void checkRunawayExpression(ReferenceExp referenceExp, Stack<ReferenceExp> stack, Set<ReferenceExp> set) throws AbortException {
        Serializable serializable2;
        if (!set.add(referenceExp)) {
            return;
        }
        stack.push(referenceExp);
        for (Serializable serializable2 : this.getRefExpParseInfo((ReferenceExp)referenceExp).directRefs) {
            int n2 = stack.lastIndexOf(serializable2);
            if (n2 != -1) {
                String string = "";
                Vector<Locator> vector = new Vector<Locator>();
                while (n2 < stack.size()) {
                    ReferenceExp referenceExp2 = (ReferenceExp)stack.get(n2);
                    if (referenceExp2.name != null) {
                        if (string.length() != 0) {
                            string = string + " > ";
                        }
                        string = string + referenceExp2.name;
                        Locator locator = this.getDeclaredLocationOf(referenceExp2);
                        if (locator != null) {
                            vector.add(locator);
                        }
                    }
                    ++n2;
                }
                string = string + " > " + serializable2.name;
                this.reportError(vector.toArray(new Locator[vector.size()]), "GrammarReader.Abstract.RunAwayExpression", new Object[]{string});
                throw new AbortException();
            }
            this.checkRunawayExpression((ReferenceExp)serializable2, stack, set);
        }
        serializable2 = new Stack();
        Iterator<ReferenceExp> iterator = this.getRefExpParseInfo((ReferenceExp)referenceExp).indirectRefs.iterator();
        while (iterator.hasNext()) {
            this.checkRunawayExpression(iterator.next(), (Stack<ReferenceExp>)serializable2, set);
        }
        stack.pop();
    }

    @Override
    public void wrapUp() {
        try {
            this.checkRunawayExpression(this.grammar, new Stack<ReferenceExp>(), new HashSet<ReferenceExp>());
        }
        catch (AbortException abortException) {
            // empty catch block
        }
        if (!this.controller.hadError()) {
            this.grammar.visit(new TREXSequencedStringChecker(this, true));
        }
        if (!this.controller.hadError()) {
            this.restrictionChecker.check();
        }
    }

    public DatatypeLibrary getCurrentDatatypeLibrary() {
        if (this.datatypeLib == null) {
            this.datatypeLib = this.resolveDataTypeLibrary(this.datatypeLibURI);
            if (this.datatypeLib == null) {
                throw new Error();
            }
        }
        return this.datatypeLib;
    }

    @Override
    public String resolveNamespacePrefix(String string) {
        if (string.equals("")) {
            return this.targetNamespace;
        }
        return super.resolveNamespacePrefix(string);
    }

    @Override
    public void startDocument() throws SAXException {
        this.dtLibStack.push(this.datatypeLib);
        this.dtLibURIStack.push(this.datatypeLibURI);
        this.datatypeLib = this.resolveDataTypeLibrary("");
        this.datatypeLibURI = "";
        super.startDocument();
    }

    @Override
    public void endDocument() throws SAXException {
        super.endDocument();
        this.datatypeLib = (DatatypeLibrary)this.dtLibStack.pop();
        this.datatypeLibURI = (String)this.dtLibURIStack.pop();
    }

    @Override
    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        this.dtLibStack.push(this.datatypeLib);
        this.dtLibURIStack.push(this.datatypeLibURI);
        if (attributes.getIndex("datatypeLibrary") != -1) {
            this.datatypeLibURI = attributes.getValue("datatypeLibrary");
            this.datatypeLib = null;
            if (!Util.isAbsoluteURI(this.datatypeLibURI)) {
                this.reportError(ERR_NOT_ABSOLUTE_URI, (Object)this.datatypeLibURI);
            }
            if (this.datatypeLibURI.indexOf(35) >= 0) {
                this.reportError("GrammarReader.FragmentIdentifier", (Object)this.datatypeLibURI);
            }
        }
        super.startElement(string, string2, string3, attributes);
    }

    @Override
    public void endElement(String string, String string2, String string3) throws SAXException {
        super.endElement(string, string2, string3);
        this.datatypeLib = (DatatypeLibrary)this.dtLibStack.pop();
        this.datatypeLibURI = (String)this.dtLibURIStack.pop();
    }

    public static class StateFactory
    extends TREXBaseReader.StateFactory {
        @Override
        public State nsAnyName(State state, StartTagInfo startTagInfo) {
            return new NGNameState.AnyNameState();
        }

        @Override
        public State nsNsName(State state, StartTagInfo startTagInfo) {
            return new NGNameState.NsNameState();
        }

        public State nsExcept(State state, StartTagInfo startTagInfo) {
            return new NameClassChoiceState();
        }

        public State text(State state, StartTagInfo startTagInfo) {
            return new TerminalState(Expression.anyString);
        }

        public State data(State state, StartTagInfo startTagInfo) {
            return new DataState();
        }

        public State dataParam(State state, StartTagInfo startTagInfo) {
            return new DataParamState();
        }

        public State value(State state, StartTagInfo startTagInfo) {
            return new ValueState();
        }

        public State list(State state, StartTagInfo startTagInfo) {
            return new ListState();
        }

        @Override
        public State define(State state, StartTagInfo startTagInfo) {
            return new DefineState();
        }

        @Override
        public State start(State state, StartTagInfo startTagInfo) {
            return new StartState();
        }

        public State redefine(State state, StartTagInfo startTagInfo) {
            return new DefineState();
        }

        public State redefineStart(State state, StartTagInfo startTagInfo) {
            return new StartState();
        }

        @Override
        public State includeGrammar(State state, StartTagInfo startTagInfo) {
            return new IncludeMergeState();
        }

        public State externalRef(State state, StartTagInfo startTagInfo) {
            return new IncludePatternState();
        }

        @Override
        public State divInGrammar(State state, StartTagInfo startTagInfo) {
            return new DivInGrammarState();
        }

        public State dataExcept(State state, StartTagInfo startTagInfo) {
            return new ChoiceState();
        }

        @Override
        public State attribute(State state, StartTagInfo startTagInfo) {
            return new AttributeState();
        }

        @Override
        public State element(State state, StartTagInfo startTagInfo) {
            return new ElementState();
        }

        @Override
        public State grammar(State state, StartTagInfo startTagInfo) {
            return new GrammarState();
        }

        @Override
        public State ref(State state, StartTagInfo startTagInfo) {
            return new RefState(false);
        }

        public State parentRef(State state, StartTagInfo startTagInfo) {
            return new RefState(true);
        }

        protected final DatatypeLibrary getDatatypeLibrary(String string) throws Exception {
            throw new UnsupportedOperationException();
        }
    }

    protected static class RefExpParseInfo {
        public boolean haveHead = false;
        public String combineMethod = null;
        public static final RedefinitionStatus notBeingRedefined = new RedefinitionStatus();
        public static final RedefinitionStatus originalNotFoundYet = new RedefinitionStatus();
        public static final RedefinitionStatus originalFound = new RedefinitionStatus();
        public RedefinitionStatus redefinition = notBeingRedefined;
        public final Vector<ReferenceExp> directRefs = new Vector();
        public final Vector<ReferenceExp> indirectRefs = new Vector();

        protected RefExpParseInfo() {
        }

        public void set(RefExpParseInfo refExpParseInfo) {
            this.haveHead = refExpParseInfo.haveHead;
            this.combineMethod = refExpParseInfo.combineMethod;
            this.redefinition = refExpParseInfo.redefinition;
        }

        public static class RedefinitionStatus {
        }
    }

    private static class AbortException
    extends Exception {
        private AbortException() {
        }
    }
}

