/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.reader.relax.core.checker;

import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv.relaxng_datatype.Datatype;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.datatype.xsd.IDREFType;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.datatype.xsd.IDType;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.grammar.AttributeExp;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.grammar.ChoiceExp;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.grammar.ConcurExp;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.grammar.DataExp;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.grammar.ElementExp;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.grammar.Expression;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.grammar.InterleaveExp;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.grammar.ListExp;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.grammar.MixedExp;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.grammar.OneOrMoreExp;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.grammar.OtherExp;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.grammar.ReferenceExp;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.grammar.SequenceExp;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.grammar.SimpleNameClass;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.grammar.ValueExp;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.grammar.relax.AttPoolClause;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.grammar.relax.ElementRules;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.grammar.relax.HedgeRules;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.grammar.relax.RELAXExpressionVisitorVoid;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.grammar.relax.RELAXModule;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.grammar.relax.TagClause;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.reader.relax.core.RELAXCoreReader;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class IdAbuseChecker
implements RELAXExpressionVisitorVoid {
    private final Set<String> tagNames = new HashSet<String>();
    private final Set<String> overloadedNames = new HashSet<String>();
    private final Set<String> nonIdAttrNames = new HashSet<String>();
    private final Set<AttributeExp> idAttributes = new HashSet<AttributeExp>();
    private final RELAXModule module;
    private final RELAXCoreReader reader;
    private String currentTagName;

    private IdAbuseChecker(RELAXCoreReader rELAXCoreReader, RELAXModule rELAXModule) {
        this.reader = rELAXCoreReader;
        this.module = rELAXModule;
    }

    public static void check(RELAXCoreReader rELAXCoreReader, RELAXModule rELAXModule) {
        new IdAbuseChecker(rELAXCoreReader, rELAXModule).run();
    }

    private void run() {
        Object object;
        Iterator<Expression> iterator = this.module.tags.iterator();
        while (iterator.hasNext()) {
            TagClause expression2 = (TagClause)iterator.next();
            if (!(expression2.nameClass instanceof SimpleNameClass)) continue;
            object = (SimpleNameClass)expression2.nameClass;
            if (this.tagNames.contains(((SimpleNameClass)object).localName)) {
                this.overloadedNames.add(((SimpleNameClass)object).localName);
                continue;
            }
            this.tagNames.add(((SimpleNameClass)object).localName);
        }
        iterator = this.module.tags.iterator();
        while (iterator.hasNext()) {
            TagClause tagClause = (TagClause)iterator.next();
            this.currentTagName = tagClause.nameClass instanceof SimpleNameClass ? ((SimpleNameClass)tagClause.nameClass).localName : null;
            tagClause.exp.visit(this);
        }
        for (AttributeExp attributeExp : this.idAttributes) {
            if (attributeExp.nameClass instanceof SimpleNameClass) {
                object = ((SimpleNameClass)attributeExp.nameClass).localName;
                if (!this.nonIdAttrNames.contains(object)) continue;
                this.reader.reportError("RELAXReader.IdAbuse.1", object);
                continue;
            }
            this.reader.reportError("RELAXReader.IdAbuse");
        }
    }

    @Override
    public void onAttribute(AttributeExp attributeExp) {
        if (!(attributeExp.nameClass instanceof SimpleNameClass)) {
            return;
        }
        Expression expression = attributeExp.exp.getExpandedExp(this.reader.pool);
        if (!(expression instanceof DataExp)) {
            return;
        }
        SimpleNameClass simpleNameClass = (SimpleNameClass)attributeExp.nameClass;
        if (!simpleNameClass.namespaceURI.equals("")) {
            return;
        }
        Datatype datatype = ((DataExp)expression).dt;
        if (datatype == IDType.theInstance || datatype == IDREFType.theInstance) {
            if (this.currentTagName == null || this.overloadedNames.contains(this.currentTagName)) {
                this.idAttributes.add(attributeExp);
            }
        } else {
            this.nonIdAttrNames.add(simpleNameClass.localName);
        }
    }

    @Override
    public void onChoice(ChoiceExp choiceExp) {
        choiceExp.exp1.visit(this);
        choiceExp.exp2.visit(this);
    }

    @Override
    public void onElement(ElementExp elementExp) {
        throw new Error();
    }

    @Override
    public void onOneOrMore(OneOrMoreExp oneOrMoreExp) {
        oneOrMoreExp.exp.visit(this);
    }

    @Override
    public void onMixed(MixedExp mixedExp) {
        throw new Error();
    }

    @Override
    public void onRef(ReferenceExp referenceExp) {
        referenceExp.exp.visit(this);
    }

    @Override
    public void onOther(OtherExp otherExp) {
        otherExp.exp.visit(this);
    }

    @Override
    public void onEpsilon() {
    }

    @Override
    public void onNullSet() {
    }

    @Override
    public void onAnyString() {
    }

    @Override
    public void onSequence(SequenceExp sequenceExp) {
    }

    @Override
    public void onData(DataExp dataExp) {
        throw new Error();
    }

    @Override
    public void onValue(ValueExp valueExp) {
        throw new Error();
    }

    @Override
    public void onAttPool(AttPoolClause attPoolClause) {
        attPoolClause.exp.visit(this);
    }

    @Override
    public void onTag(TagClause tagClause) {
        throw new Error();
    }

    @Override
    public void onElementRules(ElementRules elementRules) {
        throw new Error();
    }

    @Override
    public void onHedgeRules(HedgeRules hedgeRules) {
        throw new Error();
    }

    @Override
    public void onInterleave(InterleaveExp interleaveExp) {
        throw new Error();
    }

    @Override
    public void onConcur(ConcurExp concurExp) {
        throw new Error();
    }

    @Override
    public void onList(ListExp listExp) {
        throw new Error();
    }
}

