/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.grammar;

import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.grammar.ChoiceExp;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.grammar.ExpressionPool;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.grammar.ExpressionVisitor;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.grammar.ExpressionVisitorBoolean;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.grammar.ExpressionVisitorExpression;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.grammar.ExpressionVisitorVoid;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.grammar.OneOrMoreExp;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.grammar.relax.RELAXExpressionVisitor;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.grammar.relax.RELAXExpressionVisitorBoolean;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.grammar.relax.RELAXExpressionVisitorExpression;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.grammar.relax.RELAXExpressionVisitorVoid;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.grammar.util.RefExpRemover;
import java.io.Serializable;

public abstract class Expression
implements Serializable {
    private Boolean epsilonReducibility;
    private Expression expandedExp = null;
    public transient Object verifierTag = null;
    private transient int cachedHashCode;
    public static final Expression epsilon = new EpsilonExpression();
    public static final Expression nullSet = new NullSetExpression();
    public static final Expression anyString = new AnyStringExpression();
    private static final long serialVersionUID = -569561418606215601L;

    public boolean isEpsilonReducible() {
        if (this.epsilonReducibility == null) {
            this.epsilonReducibility = this.calcEpsilonReducibility() ? Boolean.TRUE : Boolean.FALSE;
        }
        return this.epsilonReducibility;
    }

    protected abstract boolean calcEpsilonReducibility();

    public Expression getExpandedExp(ExpressionPool expressionPool) {
        if (this.expandedExp == null) {
            this.expandedExp = this.visit(new RefExpRemover(expressionPool, false));
        }
        return this.expandedExp;
    }

    public final Expression peelOccurence() {
        if (this instanceof ChoiceExp) {
            ChoiceExp choiceExp = (ChoiceExp)this;
            if (choiceExp.exp1 == epsilon) {
                return choiceExp.exp2.peelOccurence();
            }
            if (choiceExp.exp2 == epsilon) {
                return choiceExp.exp1.peelOccurence();
            }
        }
        if (this instanceof OneOrMoreExp) {
            return ((OneOrMoreExp)this).exp.peelOccurence();
        }
        return this;
    }

    protected Expression(int n2) {
        this.setHashCode(n2);
    }

    protected Expression() {
        this.cachedHashCode = System.identityHashCode(this);
    }

    public abstract Object visit(ExpressionVisitor var1);

    public abstract Expression visit(ExpressionVisitorExpression var1);

    public abstract boolean visit(ExpressionVisitorBoolean var1);

    public abstract void visit(ExpressionVisitorVoid var1);

    public Object visit(RELAXExpressionVisitor rELAXExpressionVisitor) {
        return this.visit((ExpressionVisitor)rELAXExpressionVisitor);
    }

    public Expression visit(RELAXExpressionVisitorExpression rELAXExpressionVisitorExpression) {
        return this.visit((ExpressionVisitorExpression)rELAXExpressionVisitorExpression);
    }

    public boolean visit(RELAXExpressionVisitorBoolean rELAXExpressionVisitorBoolean) {
        return this.visit((ExpressionVisitorBoolean)rELAXExpressionVisitorBoolean);
    }

    public void visit(RELAXExpressionVisitorVoid rELAXExpressionVisitorVoid) {
        this.visit((ExpressionVisitorVoid)rELAXExpressionVisitorVoid);
    }

    public final int hashCode() {
        return this.cachedHashCode;
    }

    private final void setHashCode(int n2) {
        this.cachedHashCode = n2 ^ this.getClass().hashCode();
    }

    protected abstract int calcHashCode();

    public abstract boolean equals(Object var1);

    protected static int hashCode(Object object, Object object2, int n2) {
        return object.hashCode() + object2.hashCode() + n2;
    }

    protected static int hashCode(Object object, int n2) {
        return object.hashCode() + n2;
    }

    protected Object readResolve() {
        this.setHashCode(this.calcHashCode());
        return this;
    }

    private static class EpsilonExpression
    extends Expression {
        private static final long serialVersionUID = 1L;

        EpsilonExpression() {
        }

        @Override
        protected final int calcHashCode() {
            return System.identityHashCode(this);
        }

        @Override
        public Object visit(ExpressionVisitor expressionVisitor) {
            return expressionVisitor.onEpsilon();
        }

        @Override
        public Expression visit(ExpressionVisitorExpression expressionVisitorExpression) {
            return expressionVisitorExpression.onEpsilon();
        }

        @Override
        public boolean visit(ExpressionVisitorBoolean expressionVisitorBoolean) {
            return expressionVisitorBoolean.onEpsilon();
        }

        @Override
        public void visit(ExpressionVisitorVoid expressionVisitorVoid) {
            expressionVisitorVoid.onEpsilon();
        }

        @Override
        protected boolean calcEpsilonReducibility() {
            return true;
        }

        @Override
        public boolean equals(Object object) {
            return this == object;
        }

        @Override
        protected Object readResolve() {
            return epsilon;
        }
    }

    private static class NullSetExpression
    extends Expression {
        private static final long serialVersionUID = 1L;

        NullSetExpression() {
        }

        @Override
        protected final int calcHashCode() {
            return System.identityHashCode(this);
        }

        @Override
        public Object visit(ExpressionVisitor expressionVisitor) {
            return expressionVisitor.onNullSet();
        }

        @Override
        public Expression visit(ExpressionVisitorExpression expressionVisitorExpression) {
            return expressionVisitorExpression.onNullSet();
        }

        @Override
        public boolean visit(ExpressionVisitorBoolean expressionVisitorBoolean) {
            return expressionVisitorBoolean.onNullSet();
        }

        @Override
        public void visit(ExpressionVisitorVoid expressionVisitorVoid) {
            expressionVisitorVoid.onNullSet();
        }

        @Override
        protected boolean calcEpsilonReducibility() {
            return false;
        }

        @Override
        public boolean equals(Object object) {
            return this == object;
        }

        @Override
        protected Object readResolve() {
            return nullSet;
        }
    }

    private static class AnyStringExpression
    extends Expression {
        private static final long serialVersionUID = 1L;

        AnyStringExpression() {
        }

        @Override
        protected final int calcHashCode() {
            return System.identityHashCode(this);
        }

        @Override
        public Object visit(ExpressionVisitor expressionVisitor) {
            return expressionVisitor.onAnyString();
        }

        @Override
        public Expression visit(ExpressionVisitorExpression expressionVisitorExpression) {
            return expressionVisitorExpression.onAnyString();
        }

        @Override
        public boolean visit(ExpressionVisitorBoolean expressionVisitorBoolean) {
            return expressionVisitorBoolean.onAnyString();
        }

        @Override
        public void visit(ExpressionVisitorVoid expressionVisitorVoid) {
            expressionVisitorVoid.onAnyString();
        }

        @Override
        protected boolean calcEpsilonReducibility() {
            return true;
        }

        @Override
        public boolean equals(Object object) {
            return this == object;
        }

        @Override
        protected Object readResolve() {
            return anyString;
        }
    }
}

