/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv.org_isorelax.verifier;

import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv.org_isorelax.verifier.Schema;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv.org_isorelax.verifier.Verifier;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv.org_isorelax.verifier.VerifierConfigurationException;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv.org_isorelax.verifier.VerifierFactoryLoader;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;

public abstract class VerifierFactory {
    private EntityResolver resolver = null;
    private static HashMap providerMap = new HashMap();

    public Verifier newVerifier(String string) throws VerifierConfigurationException, SAXException, IOException {
        return this.compileSchema(string).newVerifier();
    }

    public Verifier newVerifier(File file) throws VerifierConfigurationException, SAXException, IOException {
        return this.compileSchema(file).newVerifier();
    }

    public Verifier newVerifier(InputStream inputStream) throws VerifierConfigurationException, SAXException, IOException {
        return this.compileSchema(inputStream, null).newVerifier();
    }

    public Verifier newVerifier(InputStream inputStream, String string) throws VerifierConfigurationException, SAXException, IOException {
        return this.compileSchema(inputStream, string).newVerifier();
    }

    public Verifier newVerifier(InputSource inputSource) throws VerifierConfigurationException, SAXException, IOException {
        return this.compileSchema(inputSource).newVerifier();
    }

    public abstract Schema compileSchema(InputSource var1) throws VerifierConfigurationException, SAXException, IOException;

    public Schema compileSchema(String string) throws VerifierConfigurationException, SAXException, IOException {
        return this.compileSchema(new InputSource(string));
    }

    public Schema compileSchema(InputStream inputStream) throws VerifierConfigurationException, SAXException, IOException {
        return this.compileSchema(inputStream, null);
    }

    public Schema compileSchema(InputStream inputStream, String string) throws VerifierConfigurationException, SAXException, IOException {
        InputSource inputSource = new InputSource(inputStream);
        inputSource.setSystemId(string);
        return this.compileSchema(inputSource);
    }

    public Schema compileSchema(File file) throws VerifierConfigurationException, SAXException, IOException {
        String string = "file:" + file.getAbsolutePath();
        if (File.separatorChar == '\\') {
            string = string.replace('\\', '/');
        }
        return this.compileSchema(new InputSource(string));
    }

    public boolean isFeature(String string) throws SAXNotRecognizedException, SAXNotSupportedException {
        if ("http://www.iso-relax.org/verifier/handler".equals(string) || "http://www.iso-relax.org/verifier/filter".equals(string)) {
            return true;
        }
        throw new SAXNotRecognizedException(string);
    }

    public void setFeature(String string, boolean bl2) throws SAXNotRecognizedException, SAXNotSupportedException {
        throw new SAXNotRecognizedException(string);
    }

    public Object getProperty(String string) throws SAXNotRecognizedException, SAXNotSupportedException {
        throw new SAXNotRecognizedException(string);
    }

    public void setProperty(String string, Object object) throws SAXNotRecognizedException, SAXNotSupportedException {
        throw new SAXNotRecognizedException(string);
    }

    public void setEntityResolver(EntityResolver entityResolver) {
        this.resolver = entityResolver;
    }

    public EntityResolver getEntityResolver() {
        return this.resolver;
    }

    public static VerifierFactory newInstance() throws VerifierConfigurationException {
        return VerifierFactory.newInstance("http://www.xml.gr.jp/xmlns/relaxNamespace");
    }

    public static VerifierFactory newInstance(String string) throws VerifierConfigurationException {
        Iterator iterator = VerifierFactory.providers(VerifierFactoryLoader.class);
        while (iterator.hasNext()) {
            VerifierFactoryLoader verifierFactoryLoader = (VerifierFactoryLoader)iterator.next();
            try {
                VerifierFactory verifierFactory = verifierFactoryLoader.createFactory(string);
                if (verifierFactory == null) continue;
                return verifierFactory;
            }
            catch (Throwable throwable) {
            }
        }
        throw new VerifierConfigurationException("no validation engine available for: " + string);
    }

    private static synchronized Iterator providers(Class clazz) {
        Enumeration<URL> enumeration;
        ClassLoader classLoader = clazz.getClassLoader();
        String string = "META-INF/services/" + clazz.getName();
        Vector vector = (Vector)providerMap.get(string);
        if (vector != null) {
            return vector.iterator();
        }
        vector = new Vector();
        providerMap.put(string, vector);
        try {
            enumeration = classLoader.getResources(string);
        }
        catch (IOException iOException) {
            return vector.iterator();
        }
        while (enumeration.hasMoreElements()) {
            try {
                URL uRL = enumeration.nextElement();
                InputStream inputStream = uRL.openStream();
                InputStreamReader inputStreamReader = new InputStreamReader(inputStream, "UTF-8");
                BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
                String string2 = bufferedReader.readLine();
                while (string2 != null) {
                    try {
                        int n2 = string2.indexOf(35);
                        if (n2 != -1) {
                            string2 = string2.substring(0, n2);
                        }
                        if ((string2 = string2.trim()).length() == 0) {
                            string2 = bufferedReader.readLine();
                            continue;
                        }
                        Object obj = classLoader.loadClass(string2).newInstance();
                        vector.add(obj);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    string2 = bufferedReader.readLine();
                }
            }
            catch (Exception exception) {
            }
        }
        return vector.iterator();
    }
}

