/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.com.ctc.wstx.sax;

import com.gradle.maven.extension.internal.dep.com.ctc.wstx.api.ReaderConfig;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.dtd.DTDEventListener;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.exc.WstxIOException;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.io.DefaultInputResolver;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.io.InputBootstrapper;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.io.ReaderBootstrapper;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.io.StreamBootstrapper;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.io.SystemId;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.sax.SAXFeature;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.sax.SAXProperty;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.sax.WrappedSaxException;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.sr.AttributeCollector;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.sr.BasicStreamReader;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.sr.InputElementStack;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.stax.WstxInputFactory;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.util.ExceptionUtil;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.util.URLUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.URL;
import java.util.Locale;
import javax.xml.parsers.SAXParser;
import javax.xml.stream.Location;
import javax.xml.stream.XMLResolver;
import javax.xml.stream.XMLStreamException;
import org.xml.sax.AttributeList;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.DocumentHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.HandlerBase;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.Parser;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.ext.Attributes2;
import org.xml.sax.ext.DeclHandler;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.ext.Locator2;
import org.xml.sax.helpers.DefaultHandler;

public class WstxSAXParser
extends SAXParser
implements DTDEventListener,
Parser,
XMLReader,
Attributes2,
Locator2 {
    static final boolean FEAT_DEFAULT_NS_PREFIXES = false;
    protected final WstxInputFactory mStaxFactory;
    protected final ReaderConfig mConfig;
    protected boolean mFeatNsPrefixes;
    protected BasicStreamReader mScanner;
    protected AttributeCollector mAttrCollector;
    protected InputElementStack mElemStack;
    protected String mEncoding;
    protected String mXmlVersion;
    protected boolean mStandalone;
    protected ContentHandler mContentHandler;
    protected DTDHandler mDTDHandler;
    protected EntityResolver mEntityResolver;
    protected ErrorHandler mErrorHandler;
    protected LexicalHandler mLexicalHandler;
    protected DeclHandler mDeclHandler;
    protected int mAttrCount;
    protected int mNsCount = 0;

    public WstxSAXParser(WstxInputFactory wstxInputFactory, boolean bl2) {
        this.mStaxFactory = wstxInputFactory;
        this.mFeatNsPrefixes = bl2;
        this.mConfig = wstxInputFactory.createPrivateConfig();
        this.mConfig.doSupportDTDs(true);
        ResolverProxy resolverProxy = new ResolverProxy();
        this.mConfig.setDtdResolver(resolverProxy);
        this.mConfig.setEntityResolver(resolverProxy);
        this.mConfig.setDTDEventListener(this);
    }

    public WstxSAXParser() {
        this(new WstxInputFactory(), false);
    }

    @Override
    public final Parser getParser() {
        return this;
    }

    @Override
    public final XMLReader getXMLReader() {
        return this;
    }

    public final ReaderConfig getStaxConfig() {
        return this.mConfig;
    }

    @Override
    public boolean isNamespaceAware() {
        return this.mConfig.willSupportNamespaces();
    }

    @Override
    public boolean isValidating() {
        return this.mConfig.willValidateWithDTD();
    }

    @Override
    public Object getProperty(String string) throws SAXNotRecognizedException, SAXNotSupportedException {
        SAXProperty sAXProperty = SAXProperty.findByUri(string);
        if (sAXProperty == SAXProperty.DECLARATION_HANDLER) {
            return this.mDeclHandler;
        }
        if (sAXProperty == SAXProperty.DOCUMENT_XML_VERSION) {
            return this.mXmlVersion;
        }
        if (sAXProperty == SAXProperty.DOM_NODE) {
            return null;
        }
        if (sAXProperty == SAXProperty.LEXICAL_HANDLER) {
            return this.mLexicalHandler;
        }
        if (sAXProperty == SAXProperty.XML_STRING) {
            return null;
        }
        throw new SAXNotRecognizedException("Property '" + string + "' not recognized");
    }

    @Override
    public void setProperty(String string, Object object) throws SAXNotRecognizedException, SAXNotSupportedException {
        SAXProperty sAXProperty = SAXProperty.findByUri(string);
        if (sAXProperty == SAXProperty.DECLARATION_HANDLER) {
            this.mDeclHandler = (DeclHandler)object;
            return;
        }
        if (sAXProperty != SAXProperty.DOCUMENT_XML_VERSION && sAXProperty != SAXProperty.DOM_NODE) {
            if (sAXProperty == SAXProperty.LEXICAL_HANDLER) {
                this.mLexicalHandler = (LexicalHandler)object;
                return;
            }
            if (sAXProperty != SAXProperty.XML_STRING) {
                throw new SAXNotRecognizedException("Property '" + string + "' not recognized");
            }
        }
        throw new SAXNotSupportedException("Property '" + string + "' is read-only, can not be modified");
    }

    @Override
    public void parse(InputSource inputSource, HandlerBase handlerBase) throws SAXException, IOException {
        if (handlerBase != null) {
            if (this.mContentHandler == null) {
                this.setDocumentHandler(handlerBase);
            }
            if (this.mEntityResolver == null) {
                this.setEntityResolver(handlerBase);
            }
            if (this.mErrorHandler == null) {
                this.setErrorHandler(handlerBase);
            }
            if (this.mDTDHandler == null) {
                this.setDTDHandler(handlerBase);
            }
        }
        this.parse(inputSource);
    }

    @Override
    public void parse(InputSource inputSource, DefaultHandler defaultHandler) throws SAXException, IOException {
        if (defaultHandler != null) {
            if (this.mContentHandler == null) {
                this.setContentHandler(defaultHandler);
            }
            if (this.mEntityResolver == null) {
                this.setEntityResolver(defaultHandler);
            }
            if (this.mErrorHandler == null) {
                this.setErrorHandler(defaultHandler);
            }
            if (this.mDTDHandler == null) {
                this.setDTDHandler(defaultHandler);
            }
        }
        this.parse(inputSource);
    }

    @Override
    public ContentHandler getContentHandler() {
        return this.mContentHandler;
    }

    @Override
    public DTDHandler getDTDHandler() {
        return this.mDTDHandler;
    }

    @Override
    public EntityResolver getEntityResolver() {
        return this.mEntityResolver;
    }

    @Override
    public ErrorHandler getErrorHandler() {
        return this.mErrorHandler;
    }

    @Override
    public boolean getFeature(String string) throws SAXNotRecognizedException {
        SAXFeature sAXFeature = SAXFeature.findByUri(string);
        if (sAXFeature == SAXFeature.EXTERNAL_GENERAL_ENTITIES) {
            return this.mConfig.willSupportExternalEntities();
        }
        if (sAXFeature == SAXFeature.EXTERNAL_PARAMETER_ENTITIES) {
            return this.mConfig.willSupportExternalEntities();
        }
        if (sAXFeature == SAXFeature.IS_STANDALONE) {
            return this.mStandalone;
        }
        if (sAXFeature == SAXFeature.LEXICAL_HANDLER_PARAMETER_ENTITIES) {
            return false;
        }
        if (sAXFeature == SAXFeature.NAMESPACES) {
            return this.mConfig.willSupportNamespaces();
        }
        if (sAXFeature == SAXFeature.NAMESPACE_PREFIXES) {
            return !this.mConfig.willSupportNamespaces();
        }
        if (sAXFeature == SAXFeature.RESOLVE_DTD_URIS) {
            return false;
        }
        if (sAXFeature == SAXFeature.STRING_INTERNING) {
            return true;
        }
        if (sAXFeature == SAXFeature.UNICODE_NORMALIZATION_CHECKING) {
            return false;
        }
        if (sAXFeature == SAXFeature.USE_ATTRIBUTES2) {
            return true;
        }
        if (sAXFeature == SAXFeature.USE_LOCATOR2) {
            return true;
        }
        if (sAXFeature == SAXFeature.USE_ENTITY_RESOLVER2) {
            return true;
        }
        if (sAXFeature == SAXFeature.VALIDATION) {
            return this.mConfig.willValidateWithDTD();
        }
        if (sAXFeature == SAXFeature.XMLNS_URIS) {
            return true;
        }
        if (sAXFeature == SAXFeature.XML_1_1) {
            return true;
        }
        throw new SAXNotRecognizedException("Feature '" + string + "' not recognized");
    }

    @Override
    public void setContentHandler(ContentHandler contentHandler) {
        this.mContentHandler = contentHandler;
    }

    @Override
    public void setDTDHandler(DTDHandler dTDHandler) {
        this.mDTDHandler = dTDHandler;
    }

    @Override
    public void setEntityResolver(EntityResolver entityResolver) {
        this.mEntityResolver = entityResolver;
    }

    @Override
    public void setErrorHandler(ErrorHandler errorHandler) {
        this.mErrorHandler = errorHandler;
    }

    @Override
    public void setFeature(String string, boolean bl2) throws SAXNotRecognizedException, SAXNotSupportedException {
        boolean bl3 = false;
        boolean bl4 = false;
        SAXFeature sAXFeature = SAXFeature.findByUri(string);
        if (sAXFeature == SAXFeature.EXTERNAL_GENERAL_ENTITIES) {
            this.mConfig.doSupportExternalEntities(bl2);
        } else if (sAXFeature != SAXFeature.EXTERNAL_PARAMETER_ENTITIES) {
            if (sAXFeature == SAXFeature.IS_STANDALONE) {
                bl4 = true;
            } else if (sAXFeature != SAXFeature.LEXICAL_HANDLER_PARAMETER_ENTITIES) {
                if (sAXFeature == SAXFeature.NAMESPACES) {
                    this.mConfig.doSupportNamespaces(bl2);
                } else if (sAXFeature == SAXFeature.NAMESPACE_PREFIXES) {
                    this.mFeatNsPrefixes = bl2;
                } else if (sAXFeature != SAXFeature.RESOLVE_DTD_URIS) {
                    if (sAXFeature == SAXFeature.STRING_INTERNING) {
                        bl3 = !bl2;
                    } else if (sAXFeature == SAXFeature.UNICODE_NORMALIZATION_CHECKING) {
                        bl3 = bl2;
                    } else if (sAXFeature == SAXFeature.USE_ATTRIBUTES2) {
                        bl4 = true;
                    } else if (sAXFeature == SAXFeature.USE_LOCATOR2) {
                        bl4 = true;
                    } else if (sAXFeature == SAXFeature.USE_ENTITY_RESOLVER2) {
                        bl4 = true;
                    } else if (sAXFeature == SAXFeature.VALIDATION) {
                        this.mConfig.doValidateWithDTD(bl2);
                    } else if (sAXFeature == SAXFeature.XMLNS_URIS) {
                        bl3 = !bl2;
                    } else if (sAXFeature == SAXFeature.XML_1_1) {
                        bl4 = true;
                    } else {
                        throw new SAXNotRecognizedException("Feature '" + string + "' not recognized");
                    }
                }
            }
        }
        if (bl4) {
            throw new SAXNotSupportedException("Feature '" + string + "' is read-only, can not be modified");
        }
        if (bl3) {
            throw new SAXNotSupportedException("Trying to set invalid value for feature '" + string + "', '" + bl2 + "'");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void parse(InputSource inputSource) throws SAXException {
        this.mScanner = null;
        String string = inputSource.getSystemId();
        ReaderConfig readerConfig = this.mConfig;
        URL uRL = null;
        InputStream inputStream = null;
        Reader reader = inputSource.getCharacterStream();
        if (reader == null && (inputStream = inputSource.getByteStream()) == null) {
            if (string == null) {
                throw new SAXException("Invalid InputSource passed: neither character or byte stream passed, nor system id specified");
            }
            try {
                uRL = URLUtil.urlFromSystemId(string);
                inputStream = URLUtil.inputStreamFromURL(uRL);
            }
            catch (IOException iOException) {
                SAXException sAXException = new SAXException(iOException);
                ExceptionUtil.setInitCause(sAXException, iOException);
                throw sAXException;
            }
        }
        if (this.mContentHandler != null) {
            this.mContentHandler.setDocumentLocator(this);
            this.mContentHandler.startDocument();
        }
        readerConfig.resetState();
        try {
            String string2 = inputSource.getEncoding();
            String string3 = inputSource.getPublicId();
            if (reader == null && string2 != null && string2.length() > 0) {
                reader = DefaultInputResolver.constructOptimizedReader(readerConfig, inputStream, false, string2);
            }
            SystemId systemId = SystemId.construct(string, uRL);
            if (reader != null) {
                ReaderBootstrapper readerBootstrapper = ReaderBootstrapper.getInstance(string3, systemId, reader, string2);
                this.mScanner = (BasicStreamReader)this.mStaxFactory.createSR(readerConfig, systemId, (InputBootstrapper)readerBootstrapper, false, false);
            } else {
                StreamBootstrapper streamBootstrapper = StreamBootstrapper.getInstance(string3, systemId, inputStream);
                this.mScanner = (BasicStreamReader)this.mStaxFactory.createSR(readerConfig, systemId, (InputBootstrapper)streamBootstrapper, false, false);
            }
            String string4 = this.mScanner.getEncoding();
            if (string4 == null) {
                string4 = this.mScanner.getCharacterEncodingScheme();
            }
            this.mEncoding = string4;
            this.mXmlVersion = this.mScanner.getVersion();
            this.mStandalone = this.mScanner.standaloneSet();
            this.mAttrCollector = this.mScanner.getAttributeCollector();
            this.mElemStack = this.mScanner.getInputElementStack();
            this.fireEvents();
        }
        catch (Exception exception) {
            this.throwSaxException(exception);
        }
        finally {
            if (this.mScanner != null) {
                BasicStreamReader basicStreamReader = this.mScanner;
                this.mScanner = null;
                try {
                    basicStreamReader.close();
                }
                catch (XMLStreamException xMLStreamException) {}
            }
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException iOException) {}
            }
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
        if (this.mContentHandler != null) {
            this.mContentHandler.endDocument();
        }
    }

    @Override
    public void parse(String string) throws SAXException {
        InputSource inputSource = new InputSource(string);
        this.parse(inputSource);
    }

    private final void fireEvents() throws IOException, SAXException, XMLStreamException {
        int n2;
        this.mConfig.doParseLazily(false);
        while ((n2 = this.mScanner.next()) != 1) {
            this.fireAuxEvent(n2, false);
        }
        this.fireStartTag();
        int n3 = 1;
        while (true) {
            if ((n2 = this.mScanner.next()) == 1) {
                this.fireStartTag();
                ++n3;
                continue;
            }
            if (n2 == 2) {
                this.mScanner.fireSaxEndElement(this.mContentHandler);
                if (--n3 >= 1) continue;
                break;
            }
            if (n2 == 4) {
                this.mScanner.fireSaxCharacterEvents(this.mContentHandler);
                continue;
            }
            this.fireAuxEvent(n2, true);
        }
        while ((n2 = this.mScanner.next()) != 8) {
            if (n2 == 6) continue;
            this.fireAuxEvent(n2, false);
        }
    }

    private final void fireAuxEvent(int n2, boolean bl2) throws IOException, SAXException, XMLStreamException {
        switch (n2) {
            case 5: {
                this.mScanner.fireSaxCommentEvent(this.mLexicalHandler);
                break;
            }
            case 12: {
                if (this.mLexicalHandler != null) {
                    this.mLexicalHandler.startCDATA();
                    this.mScanner.fireSaxCharacterEvents(this.mContentHandler);
                    this.mLexicalHandler.endCDATA();
                    break;
                }
                this.mScanner.fireSaxCharacterEvents(this.mContentHandler);
                break;
            }
            case 11: {
                if (this.mLexicalHandler == null) break;
                String string = this.mScanner.getDTDRootName();
                String string2 = this.mScanner.getDTDSystemId();
                String string3 = this.mScanner.getDTDPublicId();
                this.mLexicalHandler.startDTD(string, string3, string2);
                try {
                    this.mScanner.getDTDInfo();
                }
                catch (WrappedSaxException wrappedSaxException) {
                    throw wrappedSaxException.getSaxException();
                }
                this.mLexicalHandler.endDTD();
                break;
            }
            case 3: {
                this.mScanner.fireSaxPIEvent(this.mContentHandler);
                break;
            }
            case 6: {
                if (!bl2) break;
                this.mScanner.fireSaxSpaceEvents(this.mContentHandler);
                break;
            }
            case 9: {
                if (this.mLexicalHandler != null) {
                    String string = this.mScanner.getText();
                    this.mLexicalHandler.startEntity(this.mScanner.getLocalName());
                    this.mContentHandler.characters(string.toCharArray(), 0, string.length());
                    this.mLexicalHandler.endEntity(this.mScanner.getLocalName());
                    break;
                }
                if (this.mContentHandler == null) break;
                this.mContentHandler.skippedEntity(this.mScanner.getLocalName());
                break;
            }
            default: {
                if (n2 == 8) {
                    this.throwSaxException("Unexpected end-of-input in " + (bl2 ? "tree" : "prolog"));
                }
                throw new RuntimeException("Internal error: unexpected type, " + n2);
            }
        }
    }

    private final void fireStartTag() throws SAXException {
        this.mAttrCount = this.mAttrCollector.getCount();
        if (this.mFeatNsPrefixes) {
            this.mNsCount = this.mElemStack.getCurrentNsCount();
        }
        this.mScanner.fireSaxStartElement(this.mContentHandler, this);
    }

    @Override
    public void setDocumentHandler(DocumentHandler documentHandler) {
        this.setContentHandler(new DocHandlerWrapper(documentHandler));
    }

    @Override
    public void setLocale(Locale locale) {
    }

    @Override
    public int getIndex(String string) {
        if (this.mElemStack == null) {
            return -1;
        }
        int n2 = this.mElemStack.findAttributeIndex(null, string);
        return n2;
    }

    @Override
    public int getIndex(String string, String string2) {
        if (this.mElemStack == null) {
            return -1;
        }
        int n2 = this.mElemStack.findAttributeIndex(string, string2);
        return n2;
    }

    @Override
    public int getLength() {
        return this.mAttrCount + this.mNsCount;
    }

    @Override
    public String getLocalName(int n2) {
        if (n2 < this.mAttrCount) {
            return n2 < 0 ? null : this.mAttrCollector.getLocalName(n2);
        }
        if ((n2 -= this.mAttrCount) < this.mNsCount) {
            String string = this.mElemStack.getLocalNsPrefix(n2);
            return string == null || string.length() == 0 ? "xmlns" : string;
        }
        return null;
    }

    @Override
    public String getQName(int n2) {
        if (n2 < this.mAttrCount) {
            if (n2 < 0) {
                return null;
            }
            String string = this.mAttrCollector.getPrefix(n2);
            String string2 = this.mAttrCollector.getLocalName(n2);
            return string == null || string.length() == 0 ? string2 : string + ":" + string2;
        }
        if ((n2 -= this.mAttrCount) < this.mNsCount) {
            String string = this.mElemStack.getLocalNsPrefix(n2);
            if (string == null || string.length() == 0) {
                return "xmlns";
            }
            return "xmlns:" + string;
        }
        return null;
    }

    @Override
    public String getType(int n2) {
        if (n2 < this.mAttrCount) {
            if (n2 < 0) {
                return null;
            }
            String string = this.mElemStack.getAttributeType(n2);
            if (string == "ENUMERATED") {
                string = "NMTOKEN";
            }
            return string;
        }
        if ((n2 -= this.mAttrCount) < this.mNsCount) {
            return "CDATA";
        }
        return null;
    }

    @Override
    public String getType(String string) {
        return this.getType(this.getIndex(string));
    }

    @Override
    public String getType(String string, String string2) {
        return this.getType(this.getIndex(string, string2));
    }

    @Override
    public String getURI(int n2) {
        if (n2 < this.mAttrCount) {
            if (n2 < 0) {
                return null;
            }
            String string = this.mAttrCollector.getURI(n2);
            return string == null ? "" : string;
        }
        if (n2 - this.mAttrCount < this.mNsCount) {
            return "http://www.w3.org/2000/xmlns/";
        }
        return null;
    }

    @Override
    public String getValue(int n2) {
        if (n2 < this.mAttrCount) {
            return n2 < 0 ? null : this.mAttrCollector.getValue(n2);
        }
        if ((n2 -= this.mAttrCount) < this.mNsCount) {
            String string = this.mElemStack.getLocalNsURI(n2);
            return string == null ? "" : string;
        }
        return null;
    }

    @Override
    public String getValue(String string) {
        return this.getValue(this.getIndex(string));
    }

    @Override
    public String getValue(String string, String string2) {
        return this.getValue(this.getIndex(string, string2));
    }

    @Override
    public boolean isDeclared(int n2) {
        if (n2 < this.mAttrCount ? n2 >= 0 : (n2 -= this.mAttrCount) < this.mNsCount) {
            return true;
        }
        this.throwNoSuchAttribute(n2);
        return false;
    }

    @Override
    public boolean isDeclared(String string) {
        return false;
    }

    @Override
    public boolean isDeclared(String string, String string2) {
        return false;
    }

    @Override
    public boolean isSpecified(int n2) {
        if (n2 < this.mAttrCount) {
            if (n2 >= 0) {
                return this.mAttrCollector.isSpecified(n2);
            }
        } else if ((n2 -= this.mAttrCount) < this.mNsCount) {
            return true;
        }
        this.throwNoSuchAttribute(n2);
        return false;
    }

    @Override
    public boolean isSpecified(String string) {
        int n2 = this.getIndex(string);
        if (n2 < 0) {
            throw new IllegalArgumentException("No attribute with qName '" + string + "'");
        }
        return this.isSpecified(n2);
    }

    @Override
    public boolean isSpecified(String string, String string2) {
        int n2 = this.getIndex(string, string2);
        if (n2 < 0) {
            throw new IllegalArgumentException("No attribute with uri " + string + ", local name '" + string2 + "'");
        }
        return this.isSpecified(n2);
    }

    @Override
    public int getColumnNumber() {
        if (this.mScanner != null) {
            Location location = this.mScanner.getLocation();
            return location.getColumnNumber();
        }
        return -1;
    }

    @Override
    public int getLineNumber() {
        if (this.mScanner != null) {
            Location location = this.mScanner.getLocation();
            return location.getLineNumber();
        }
        return -1;
    }

    @Override
    public String getPublicId() {
        if (this.mScanner != null) {
            Location location = this.mScanner.getLocation();
            return location.getPublicId();
        }
        return null;
    }

    @Override
    public String getSystemId() {
        if (this.mScanner != null) {
            Location location = this.mScanner.getLocation();
            return location.getSystemId();
        }
        return null;
    }

    @Override
    public String getEncoding() {
        return this.mEncoding;
    }

    @Override
    public String getXMLVersion() {
        return this.mXmlVersion;
    }

    @Override
    public boolean dtdReportComments() {
        return this.mLexicalHandler != null;
    }

    @Override
    public void dtdComment(char[] cArray, int n2, int n3) {
        if (this.mLexicalHandler != null) {
            try {
                this.mLexicalHandler.comment(cArray, n2, n3);
            }
            catch (SAXException sAXException) {
                throw new WrappedSaxException(sAXException);
            }
        }
    }

    @Override
    public void dtdProcessingInstruction(String string, String string2) {
        if (this.mContentHandler != null) {
            try {
                this.mContentHandler.processingInstruction(string, string2);
            }
            catch (SAXException sAXException) {
                throw new WrappedSaxException(sAXException);
            }
        }
    }

    @Override
    public void dtdSkippedEntity(String string) {
        if (this.mContentHandler != null) {
            try {
                this.mContentHandler.skippedEntity(string);
            }
            catch (SAXException sAXException) {
                throw new WrappedSaxException(sAXException);
            }
        }
    }

    @Override
    public void dtdNotationDecl(String string, String string2, String string3, URL uRL) throws XMLStreamException {
        if (this.mDTDHandler != null) {
            if (string3 != null && string3.indexOf(58) < 0) {
                try {
                    string3 = URLUtil.urlFromSystemId(string3, uRL).toExternalForm();
                }
                catch (IOException iOException) {
                    throw new WstxIOException(iOException);
                }
            }
            try {
                this.mDTDHandler.notationDecl(string, string2, string3);
            }
            catch (SAXException sAXException) {
                throw new WrappedSaxException(sAXException);
            }
        }
    }

    @Override
    public void dtdUnparsedEntityDecl(String string, String string2, String string3, String string4, URL uRL) throws XMLStreamException {
        if (this.mDTDHandler != null) {
            if (string3.indexOf(58) < 0) {
                try {
                    string3 = URLUtil.urlFromSystemId(string3, uRL).toExternalForm();
                }
                catch (IOException iOException) {
                    throw new WstxIOException(iOException);
                }
            }
            try {
                this.mDTDHandler.unparsedEntityDecl(string, string2, string3, string4);
            }
            catch (SAXException sAXException) {
                throw new WrappedSaxException(sAXException);
            }
        }
    }

    @Override
    public void attributeDecl(String string, String string2, String string3, String string4, String string5) {
        if (this.mDeclHandler != null) {
            try {
                this.mDeclHandler.attributeDecl(string, string2, string3, string4, string5);
            }
            catch (SAXException sAXException) {
                throw new WrappedSaxException(sAXException);
            }
        }
    }

    @Override
    public void dtdElementDecl(String string, String string2) {
        if (this.mDeclHandler != null) {
            try {
                this.mDeclHandler.elementDecl(string, string2);
            }
            catch (SAXException sAXException) {
                throw new WrappedSaxException(sAXException);
            }
        }
    }

    @Override
    public void dtdExternalEntityDecl(String string, String string2, String string3) {
        if (this.mDeclHandler != null) {
            try {
                this.mDeclHandler.externalEntityDecl(string, string2, string3);
            }
            catch (SAXException sAXException) {
                throw new WrappedSaxException(sAXException);
            }
        }
    }

    @Override
    public void dtdInternalEntityDecl(String string, String string2) {
        if (this.mDeclHandler != null) {
            try {
                this.mDeclHandler.internalEntityDecl(string, string2);
            }
            catch (SAXException sAXException) {
                throw new WrappedSaxException(sAXException);
            }
        }
    }

    private void throwSaxException(Exception exception) throws SAXException {
        SAXParseException sAXParseException;
        if (exception instanceof SAXParseException) {
            sAXParseException = (SAXParseException)exception;
        } else {
            sAXParseException = new SAXParseException(exception.getMessage(), this, exception);
            ExceptionUtil.setInitCause(sAXParseException, exception);
        }
        if (this.mErrorHandler != null) {
            this.mErrorHandler.fatalError(sAXParseException);
        }
        throw sAXParseException;
    }

    private void throwSaxException(String string) throws SAXException {
        SAXParseException sAXParseException = new SAXParseException(string, this);
        if (this.mErrorHandler != null) {
            this.mErrorHandler.fatalError(sAXParseException);
        }
        throw sAXParseException;
    }

    private void throwNoSuchAttribute(int n2) {
        throw new IllegalArgumentException("No attribute with index " + n2 + " (have " + (this.mAttrCount + this.mNsCount) + " attributes)");
    }

    static final class AttributesWrapper
    implements AttributeList {
        Attributes mAttrs;

        public void setAttributes(Attributes attributes) {
            this.mAttrs = attributes;
        }

        @Override
        public int getLength() {
            return this.mAttrs.getLength();
        }

        @Override
        public String getName(int n2) {
            String string = this.mAttrs.getQName(n2);
            return string == null ? this.mAttrs.getLocalName(n2) : string;
        }

        @Override
        public String getType(int n2) {
            return this.mAttrs.getType(n2);
        }

        @Override
        public String getType(String string) {
            return this.mAttrs.getType(string);
        }

        @Override
        public String getValue(int n2) {
            return this.mAttrs.getValue(n2);
        }

        @Override
        public String getValue(String string) {
            return this.mAttrs.getValue(string);
        }
    }

    static final class DocHandlerWrapper
    implements ContentHandler {
        final DocumentHandler mDocHandler;
        final AttributesWrapper mAttrWrapper = new AttributesWrapper();

        DocHandlerWrapper(DocumentHandler documentHandler) {
            this.mDocHandler = documentHandler;
        }

        @Override
        public void characters(char[] cArray, int n2, int n3) throws SAXException {
            this.mDocHandler.characters(cArray, n2, n3);
        }

        @Override
        public void endDocument() throws SAXException {
            this.mDocHandler.endDocument();
        }

        @Override
        public void endElement(String string, String string2, String string3) throws SAXException {
            if (string3 == null) {
                string3 = string2;
            }
            this.mDocHandler.endElement(string3);
        }

        @Override
        public void endPrefixMapping(String string) {
        }

        @Override
        public void ignorableWhitespace(char[] cArray, int n2, int n3) throws SAXException {
            this.mDocHandler.ignorableWhitespace(cArray, n2, n3);
        }

        @Override
        public void processingInstruction(String string, String string2) throws SAXException {
            this.mDocHandler.processingInstruction(string, string2);
        }

        @Override
        public void setDocumentLocator(Locator locator) {
            this.mDocHandler.setDocumentLocator(locator);
        }

        @Override
        public void skippedEntity(String string) {
        }

        @Override
        public void startDocument() throws SAXException {
            this.mDocHandler.startDocument();
        }

        @Override
        public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
            if (string3 == null) {
                string3 = string2;
            }
            this.mAttrWrapper.setAttributes(attributes);
            this.mDocHandler.startElement(string3, this.mAttrWrapper);
        }

        @Override
        public void startPrefixMapping(String string, String string2) {
        }
    }

    final class ResolverProxy
    implements XMLResolver {
        @Override
        public Object resolveEntity(String string, String string2, String string3, String string4) throws XMLStreamException {
            if (WstxSAXParser.this.mEntityResolver != null) {
                try {
                    URL uRL = new URL(string3);
                    String string5 = new URL(uRL, string2).toExternalForm();
                    InputSource inputSource = WstxSAXParser.this.mEntityResolver.resolveEntity(string, string5);
                    if (inputSource != null) {
                        InputStream inputStream = inputSource.getByteStream();
                        if (inputStream != null) {
                            return inputStream;
                        }
                        Reader reader = inputSource.getCharacterStream();
                        if (reader != null) {
                            return reader;
                        }
                    }
                    return null;
                }
                catch (IOException iOException) {
                    throw new WstxIOException(iOException);
                }
                catch (Exception exception) {
                    throw new XMLStreamException(exception.getMessage(), exception);
                }
            }
            return null;
        }
    }
}

