/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.idea.events;

import com.gradle.idea.events.c;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.core.JsonParser;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.DeserializationContext;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.JsonDeserializer;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.JsonNode;
import com.gradle.obfuscation.Keep;
import com.gradle.scan.agent.serialization.scan.a.i;
import com.gradle.scan.eventmodel.EventData;
import java.io.IOException;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

@Keep
class EventDataDeserializer
extends JsonDeserializer<EventData> {
    private static final Set<String> ALLOWED_EVENT_TYPES = Stream.concat(Stream.of(i.values()).map(i::e), Stream.of(c.values()).map(c::a)).map(Class::getName).collect(Collectors.toSet());

    EventDataDeserializer() {
    }

    @Override
    public EventData deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
        try {
            JsonNode jsonNode = (JsonNode)jsonParser.readValueAsTree();
            String string = jsonNode.get("clazz").asText();
            if (!ALLOWED_EVENT_TYPES.contains(string)) {
                throw new IllegalArgumentException("Unknown event type, cannot deserialize event: " + string);
            }
            Class<?> clazz = Class.forName(string);
            JsonNode jsonNode2 = jsonNode.get("object");
            return (EventData)jsonParser.getCodec().treeToValue(jsonNode2, clazz);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new RuntimeException(classNotFoundException);
        }
    }
}

