/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.caching.internal.controller;

import com.gradle.maven.extension.internal.dep.com.google.common.collect.ImmutableSortedMap;
import com.gradle.maven.extension.internal.dep.com.google.common.collect.Interner;
import com.gradle.maven.extension.internal.dep.com.google.common.io.Closer;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.time.Duration;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import org.gradle.caching.BuildCacheKey;
import org.gradle.caching.BuildCacheService;
import org.gradle.caching.internal.BuildCacheKeyInternal;
import org.gradle.caching.internal.CacheableEntity;
import org.gradle.caching.internal.controller.BuildCacheController;
import org.gradle.caching.internal.controller.BuildCacheOperationException;
import org.gradle.caching.internal.controller.operations.PackOperationDetails;
import org.gradle.caching.internal.controller.operations.PackOperationResult;
import org.gradle.caching.internal.controller.operations.UnpackOperationDetails;
import org.gradle.caching.internal.controller.operations.UnpackOperationResult;
import org.gradle.caching.internal.controller.service.BuildCacheLoadResult;
import org.gradle.caching.internal.controller.service.BuildCacheServiceRole;
import org.gradle.caching.internal.controller.service.BuildCacheServicesConfiguration;
import org.gradle.caching.internal.controller.service.LocalBuildCacheServiceHandle;
import org.gradle.caching.internal.controller.service.NullLocalBuildCacheServiceHandle;
import org.gradle.caching.internal.controller.service.NullRemoteBuildCacheServiceHandle;
import org.gradle.caching.internal.controller.service.OpFiringLocalBuildCacheServiceHandle;
import org.gradle.caching.internal.controller.service.OpFiringRemoteBuildCacheServiceHandle;
import org.gradle.caching.internal.controller.service.RemoteBuildCacheServiceHandle;
import org.gradle.caching.internal.origin.OriginMetadata;
import org.gradle.caching.internal.origin.OriginMetadataFactory;
import org.gradle.caching.internal.origin.OriginWriter;
import org.gradle.caching.internal.packaging.BuildCacheEntryPacker;
import org.gradle.caching.local.internal.BuildCacheTempFileStore;
import org.gradle.caching.local.internal.DefaultBuildCacheTempFileStore;
import org.gradle.caching.local.internal.LocalBuildCacheService;
import org.gradle.caching.local.internal.TemporaryFileFactory;
import org.gradle.internal.file.FileMetadata;
import org.gradle.internal.file.FileType;
import org.gradle.internal.file.TreeType;
import org.gradle.internal.hash.HashCode;
import org.gradle.internal.operations.BuildOperationContext;
import org.gradle.internal.operations.BuildOperationDescriptor;
import org.gradle.internal.operations.BuildOperationProgressEventEmitter;
import org.gradle.internal.operations.BuildOperationRunner;
import org.gradle.internal.operations.CallableBuildOperation;
import org.gradle.internal.operations.RunnableBuildOperation;
import org.gradle.internal.snapshot.FileSystemLocationSnapshot;
import org.gradle.internal.snapshot.FileSystemSnapshot;
import org.gradle.internal.snapshot.MissingFileSnapshot;

public class DefaultBuildCacheController
implements BuildCacheController {
    final RemoteBuildCacheServiceHandle remote;
    final LocalBuildCacheServiceHandle local;
    private final BuildCacheTempFileStore tmp;
    private final PackOperationExecutor packExecutor;
    private boolean closed;

    public DefaultBuildCacheController(BuildCacheServicesConfiguration buildCacheServicesConfiguration, BuildOperationRunner buildOperationRunner, BuildOperationProgressEventEmitter buildOperationProgressEventEmitter, TemporaryFileFactory temporaryFileFactory, boolean bl2, boolean bl3, BuildCacheEntryPacker buildCacheEntryPacker, OriginMetadataFactory originMetadataFactory, Interner<String> interner) {
        this.local = DefaultBuildCacheController.toLocalHandle(buildCacheServicesConfiguration.getLocal(), buildCacheServicesConfiguration.isLocalPush(), buildOperationRunner);
        this.remote = DefaultBuildCacheController.toRemoteHandle(buildCacheServicesConfiguration.getBuildPath(), buildCacheServicesConfiguration.getRemote(), buildCacheServicesConfiguration.isRemotePush(), buildOperationRunner, buildOperationProgressEventEmitter, bl2, bl3);
        this.tmp = DefaultBuildCacheController.toTempFileStore(buildCacheServicesConfiguration.getLocal(), temporaryFileFactory);
        this.packExecutor = new PackOperationExecutor(buildOperationRunner, buildCacheEntryPacker, originMetadataFactory, interner);
    }

    @Override
    public Optional<BuildCacheLoadResult> load(BuildCacheKey buildCacheKey, CacheableEntity cacheableEntity) {
        Optional<BuildCacheLoadResult> optional = this.loadLocal(buildCacheKey, cacheableEntity);
        if (optional.isPresent()) {
            return optional;
        }
        return this.loadRemoteAndStoreResultLocally(buildCacheKey, cacheableEntity);
    }

    private Optional<BuildCacheLoadResult> loadLocal(BuildCacheKey buildCacheKey, CacheableEntity cacheableEntity) {
        try {
            return this.local.maybeLoad(buildCacheKey, file -> this.packExecutor.unpack(buildCacheKey, cacheableEntity, (File)file));
        }
        catch (Exception exception) {
            throw new BuildCacheOperationException("Could not load from local cache: " + exception.getMessage(), exception);
        }
    }

    private Optional<BuildCacheLoadResult> loadRemoteAndStoreResultLocally(BuildCacheKey buildCacheKey, CacheableEntity cacheableEntity) {
        if (!this.remote.canLoad()) {
            return Optional.empty();
        }
        AtomicReference atomicReference = new AtomicReference(Optional.empty());
        this.tmp.withTempFile(((BuildCacheKeyInternal)buildCacheKey).getHashCodeInternal(), file2 -> {
            Optional<BuildCacheLoadResult> optional;
            try {
                optional = this.remote.maybeLoad(buildCacheKey, (File)file2, file -> this.packExecutor.unpack(buildCacheKey, cacheableEntity, (File)file));
            }
            catch (Exception exception) {
                throw new BuildCacheOperationException("Could not load from remote cache: " + exception.getMessage(), exception);
            }
            if (optional.isPresent()) {
                this.local.maybeStore(buildCacheKey, (File)file2);
                atomicReference.set(optional);
            }
        });
        return atomicReference.get();
    }

    @Override
    public void store(BuildCacheKey buildCacheKey, CacheableEntity cacheableEntity, Map<String, FileSystemSnapshot> map, Duration duration) {
        if (!this.local.canStore() && !this.remote.canStore()) {
            return;
        }
        this.tmp.withTempFile(((BuildCacheKeyInternal)buildCacheKey).getHashCodeInternal(), file -> {
            this.packExecutor.pack((File)file, buildCacheKey, cacheableEntity, map, duration);
            this.remote.maybeStore(buildCacheKey, (File)file);
            this.local.maybeStore(buildCacheKey, (File)file);
        });
    }

    @Override
    public void close() throws IOException {
        if (!this.closed) {
            this.closed = true;
            Closer closer = Closer.create();
            closer.register(this.local);
            closer.register(this.remote);
            closer.close();
        }
    }

    private static RemoteBuildCacheServiceHandle toRemoteHandle(String string, BuildCacheService buildCacheService, boolean bl2, BuildOperationRunner buildOperationRunner, BuildOperationProgressEventEmitter buildOperationProgressEventEmitter, boolean bl3, boolean bl4) {
        return buildCacheService == null ? NullRemoteBuildCacheServiceHandle.INSTANCE : new OpFiringRemoteBuildCacheServiceHandle(string, buildCacheService, bl2, BuildCacheServiceRole.REMOTE, buildOperationRunner, buildOperationProgressEventEmitter, bl3, bl4);
    }

    private static LocalBuildCacheServiceHandle toLocalHandle(LocalBuildCacheService localBuildCacheService, boolean bl2, BuildOperationRunner buildOperationRunner) {
        return localBuildCacheService == null ? NullLocalBuildCacheServiceHandle.INSTANCE : new OpFiringLocalBuildCacheServiceHandle(localBuildCacheService, bl2, buildOperationRunner);
    }

    private static BuildCacheTempFileStore toTempFileStore(LocalBuildCacheService localBuildCacheService, TemporaryFileFactory temporaryFileFactory) {
        return localBuildCacheService != null ? localBuildCacheService : new DefaultBuildCacheTempFileStore(temporaryFileFactory);
    }

    static class PackOperationExecutor {
        private final BuildOperationRunner buildOperationRunner;
        private final BuildCacheEntryPacker packer;
        private final OriginMetadataFactory originMetadataFactory;
        private final Interner<String> stringInterner;

        PackOperationExecutor(BuildOperationRunner buildOperationRunner, BuildCacheEntryPacker buildCacheEntryPacker, OriginMetadataFactory originMetadataFactory, Interner<String> interner) {
            this.buildOperationRunner = buildOperationRunner;
            this.packer = buildCacheEntryPacker;
            this.originMetadataFactory = originMetadataFactory;
            this.stringInterner = interner;
        }

        BuildCacheLoadResult unpack(final BuildCacheKey buildCacheKey, final CacheableEntity cacheableEntity, final File file) {
            return this.buildOperationRunner.call(new CallableBuildOperation<BuildCacheLoadResult>(){

                @Override
                public BuildCacheLoadResult call(BuildOperationContext buildOperationContext) throws IOException {
                    try (FileInputStream fileInputStream = new FileInputStream(file);){
                        BuildCacheLoadResult buildCacheLoadResult = this.doUnpack(cacheableEntity, fileInputStream);
                        buildOperationContext.setResult(new UnpackOperationResult(buildCacheLoadResult.getArtifactEntryCount()));
                        BuildCacheLoadResult buildCacheLoadResult2 = buildCacheLoadResult;
                        return buildCacheLoadResult2;
                    }
                }

                @Override
                public BuildOperationDescriptor.Builder description() {
                    return BuildOperationDescriptor.displayName("Unpack build cache entry " + buildCacheKey.getHashCode()).details(new UnpackOperationDetails(buildCacheKey, file.length())).progressDisplayName("Unpacking build cache entry");
                }
            });
        }

        private BuildCacheLoadResult doUnpack(CacheableEntity cacheableEntity, InputStream inputStream) throws IOException {
            final BuildCacheEntryPacker.UnpackResult unpackResult = this.packer.unpack(cacheableEntity, inputStream, this.originMetadataFactory.createReader());
            final ImmutableSortedMap<String, FileSystemSnapshot> immutableSortedMap = this.snapshotUnpackedData(cacheableEntity, unpackResult.getSnapshots());
            return new BuildCacheLoadResult(){

                @Override
                public long getArtifactEntryCount() {
                    return unpackResult.getEntries();
                }

                @Override
                public OriginMetadata getOriginMetadata() {
                    return unpackResult.getOriginMetadata();
                }

                @Override
                public ImmutableSortedMap<String, FileSystemSnapshot> getResultingSnapshots() {
                    return immutableSortedMap;
                }
            };
        }

        private ImmutableSortedMap<String, FileSystemSnapshot> snapshotUnpackedData(CacheableEntity cacheableEntity, Map<String, ? extends FileSystemLocationSnapshot> map) {
            ImmutableSortedMap.Builder builder = ImmutableSortedMap.naturalOrder();
            cacheableEntity.visitOutputTrees((string, treeType, file) -> {
                FileSystemLocationSnapshot fileSystemLocationSnapshot;
                FileSystemLocationSnapshot fileSystemLocationSnapshot2 = (FileSystemLocationSnapshot)map.get(string);
                if (fileSystemLocationSnapshot2 == null) {
                    String string2 = this.stringInterner.intern(file.getAbsolutePath());
                    fileSystemLocationSnapshot = new MissingFileSnapshot(string2, FileMetadata.AccessType.DIRECT);
                } else {
                    if (treeType == TreeType.FILE && fileSystemLocationSnapshot2.getType() != FileType.RegularFile) {
                        throw new IllegalStateException(String.format("Only a regular file should be produced by unpacking tree '%s', but saw a %s", new Object[]{string, fileSystemLocationSnapshot2.getType()}));
                    }
                    fileSystemLocationSnapshot = fileSystemLocationSnapshot2;
                }
                builder.put(string, fileSystemLocationSnapshot);
            });
            return builder.build();
        }

        void pack(final File file, final BuildCacheKey buildCacheKey, final CacheableEntity cacheableEntity, final Map<String, FileSystemSnapshot> map, final Duration duration) {
            this.buildOperationRunner.run(new RunnableBuildOperation(){

                @Override
                public void run(BuildOperationContext buildOperationContext) throws IOException {
                    try (FileOutputStream fileOutputStream = new FileOutputStream(file);){
                        HashCode hashCode = ((BuildCacheKeyInternal)buildCacheKey).getHashCodeInternal();
                        OriginWriter originWriter = originMetadataFactory.createWriter(cacheableEntity.getIdentity(), cacheableEntity.getType(), hashCode, duration);
                        BuildCacheEntryPacker.PackResult packResult = packer.pack(cacheableEntity, map, fileOutputStream, originWriter);
                        long l2 = packResult.getEntries();
                        buildOperationContext.setResult(new PackOperationResult(l2, file.length()));
                    }
                }

                @Override
                public BuildOperationDescriptor.Builder description() {
                    return BuildOperationDescriptor.displayName("Pack build cache entry " + buildCacheKey).details(new PackOperationDetails(buildCacheKey)).progressDisplayName("Packing build cache entry");
                }
            });
        }
    }
}

