/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.cache.internal;

import com.gradle.maven.extension.internal.dep.org.apache.commons.io.FileUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Map;
import java.util.Properties;
import java.util.function.Consumer;
import org.gradle.cache.CacheCleanupStrategy;
import org.gradle.cache.FileLock;
import org.gradle.cache.FileLockManager;
import org.gradle.cache.LockOptions;
import org.gradle.cache.PersistentCache;
import org.gradle.cache.internal.CacheInitializationAction;
import org.gradle.cache.internal.DefaultPersistentDirectoryStore;
import org.gradle.internal.concurrent.ExecutorFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultPersistentDirectoryCache
extends DefaultPersistentDirectoryStore {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultPersistentDirectoryCache.class);
    private final Properties properties = new Properties();
    private final Consumer<? super PersistentCache> initAction;

    public DefaultPersistentDirectoryCache(File file, String string, Map<String, ?> map, LockOptions lockOptions, Consumer<? super PersistentCache> consumer, CacheCleanupStrategy cacheCleanupStrategy, FileLockManager fileLockManager, ExecutorFactory executorFactory) {
        super(file, string, lockOptions, cacheCleanupStrategy, fileLockManager, executorFactory);
        this.initAction = consumer;
        this.properties.putAll(map);
    }

    @Override
    protected CacheInitializationAction getInitAction() {
        return new Initializer();
    }

    private class Initializer
    implements CacheInitializationAction {
        private Initializer() {
        }

        @Override
        public boolean requiresInitialization(FileLock fileLock) {
            if (!fileLock.getUnlockedCleanly()) {
                if (fileLock.getState().canDetectChanges() && !fileLock.getState().isInInitialState()) {
                    LOGGER.warn("Invalidating {} as it was not closed cleanly.", (Object)DefaultPersistentDirectoryCache.this);
                }
                return true;
            }
            if (!DefaultPersistentDirectoryCache.this.properties.isEmpty()) {
                if (!DefaultPersistentDirectoryCache.this.propertiesFile.exists()) {
                    LOGGER.debug("Invalidating {} as cache properties file {} is missing and cache properties are not empty.", (Object)DefaultPersistentDirectoryCache.this, (Object)DefaultPersistentDirectoryCache.this.propertiesFile.getAbsolutePath());
                    return true;
                }
                Properties properties = new Properties();
                try (FileInputStream fileInputStream = new FileInputStream(DefaultPersistentDirectoryCache.this.propertiesFile);){
                    properties.load(fileInputStream);
                }
                catch (IOException iOException) {
                    throw new UncheckedIOException(iOException);
                }
                for (Map.Entry entry : DefaultPersistentDirectoryCache.this.properties.entrySet()) {
                    String string = properties.getProperty(entry.getKey().toString());
                    String string2 = entry.getValue().toString();
                    if (string2.equals(string)) continue;
                    LOGGER.debug("Invalidating {} as cache property {} has changed from {} to {}.", new Object[]{DefaultPersistentDirectoryCache.this, entry.getKey(), string, string2});
                    return true;
                }
            }
            return false;
        }

        @Override
        public void initialize(FileLock fileLock) {
            try {
                File[] fileArray = DefaultPersistentDirectoryCache.this.getBaseDir().listFiles();
                if (fileArray == null) {
                    throw new IOException("Cannot list files in " + DefaultPersistentDirectoryCache.this.getBaseDir());
                }
                for (File file : fileArray) {
                    if (fileLock.isLockFile(file) || file.equals(DefaultPersistentDirectoryCache.this.propertiesFile)) continue;
                    FileUtils.forceDelete(file);
                }
                DefaultPersistentDirectoryCache.this.initAction.accept(DefaultPersistentDirectoryCache.this);
                try (FileOutputStream fileOutputStream = new FileOutputStream(DefaultPersistentDirectoryCache.this.propertiesFile);){
                    DefaultPersistentDirectoryCache.this.properties.store(fileOutputStream, null);
                }
            }
            catch (IOException iOException) {
                throw new UncheckedIOException(iOException);
            }
        }
    }
}

