/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.changedetection.state;

import com.gradle.maven.extension.internal.dep.org.apache.commons.io.input.CloseShieldInputStream;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Optional;
import org.gradle.internal.hash.HashCode;
import org.gradle.internal.hash.Hashing;
import org.gradle.internal.hash.PrimitiveHasher;

public class LineEndingNormalizingInputStreamHasher {
    private static final HashCode SIGNATURE = Hashing.signature(LineEndingNormalizingInputStreamHasher.class);

    public Optional<HashCode> hashContent(InputStream inputStream) throws IOException {
        return this.hash(inputStream);
    }

    public Optional<HashCode> hashContent(File file) throws IOException {
        try (FileInputStream fileInputStream = new FileInputStream(file);){
            Optional<HashCode> optional = this.hashContent(fileInputStream);
            return optional;
        }
    }

    private Optional<HashCode> hash(InputStream inputStream) throws IOException {
        PrimitiveHasher primitiveHasher = Hashing.newPrimitiveHasher();
        primitiveHasher.putHash(SIGNATURE);
        try (BufferedInputStream bufferedInputStream = new BufferedInputStream(CloseShieldInputStream.wrap(inputStream), 8192);){
            int n2 = -1;
            while (true) {
                int n3;
                if ((n3 = n2) != -1) {
                    n2 = -1;
                } else {
                    n3 = bufferedInputStream.read();
                }
                if (n3 == -1) {
                    break;
                }
                if (LineEndingNormalizingInputStreamHasher.isControlCharacter(n3)) {
                    Optional<HashCode> optional = Optional.empty();
                    return optional;
                }
                if (n3 == 13) {
                    n2 = bufferedInputStream.read();
                    if (n2 == 10) {
                        n2 = -1;
                    }
                    n3 = 10;
                }
                primitiveHasher.putByte((byte)n3);
            }
        }
        return Optional.of(primitiveHasher.hash());
    }

    private static boolean isControlCharacter(int n2) {
        return LineEndingNormalizingInputStreamHasher.isInControlRange(n2) && LineEndingNormalizingInputStreamHasher.isNotCommonTextChar(n2);
    }

    private static boolean isInControlRange(int n2) {
        return n2 >= 0 && n2 < 32;
    }

    private static boolean isNotCommonTextChar(int n2) {
        return !Character.isWhitespace(n2);
    }
}

