/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.oshi.software.common;

import com.gradle.maven.extension.internal.dep.oshi.software.os.OSProcess;
import com.gradle.maven.extension.internal.dep.oshi.util.Memoizer;
import java.util.function.Supplier;

public abstract class AbstractOSProcess
implements OSProcess {
    private final Supplier<Double> cumulativeCpuLoad = Memoizer.memoize(this::queryCumulativeCpuLoad, Memoizer.defaultExpiration());
    private int processID;

    protected AbstractOSProcess(int n2) {
        this.processID = n2;
    }

    @Override
    public int getProcessID() {
        return this.processID;
    }

    @Override
    public double getProcessCpuLoadCumulative() {
        return this.cumulativeCpuLoad.get();
    }

    private double queryCumulativeCpuLoad() {
        return (double)this.getUpTime() > 0.0 ? (double)(this.getKernelTime() + this.getUserTime()) / (double)this.getUpTime() : 0.0;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("OSProcess@");
        stringBuilder.append(Integer.toHexString(this.hashCode()));
        stringBuilder.append("[processID=").append(this.processID);
        stringBuilder.append(", name=").append(this.getName()).append(']');
        return stringBuilder.toString();
    }
}

