/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.oshi.hardware.common;

import com.gradle.maven.extension.internal.dep.oshi.driver.linux.proc.Auxv;
import com.gradle.maven.extension.internal.dep.oshi.hardware.CentralProcessor;
import com.gradle.maven.extension.internal.dep.oshi.util.Memoizer;
import com.gradle.maven.extension.internal.dep.oshi.util.ParseUtil;
import com.gradle.maven.extension.internal.dep.oshi.util.tuples.Quartet;
import com.sun.jna.Platform;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractCentralProcessor
implements CentralProcessor {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractCentralProcessor.class);
    private final Supplier<CentralProcessor.ProcessorIdentifier> cpuid = Memoizer.memoize(this::queryProcessorId);
    private final Supplier<Long> maxFreq = Memoizer.memoize(this::queryMaxFreq, Memoizer.defaultExpiration());
    private final Supplier<long[]> currentFreq = Memoizer.memoize(this::queryCurrentFreq, Memoizer.defaultExpiration() / 2L);
    private final Supplier<Long> contextSwitches = Memoizer.memoize(this::queryContextSwitches, Memoizer.defaultExpiration());
    private final Supplier<Long> interrupts = Memoizer.memoize(this::queryInterrupts, Memoizer.defaultExpiration());
    private final Supplier<long[]> systemCpuLoadTicks = Memoizer.memoize(this::querySystemCpuLoadTicks, Memoizer.defaultExpiration());
    private final Supplier<long[][]> processorCpuLoadTicks = Memoizer.memoize(this::queryProcessorCpuLoadTicks, Memoizer.defaultExpiration());
    private final int physicalPackageCount;
    private final int physicalProcessorCount;
    private final int logicalProcessorCount;
    private final List<CentralProcessor.LogicalProcessor> logicalProcessors;
    private final List<CentralProcessor.PhysicalProcessor> physicalProcessors;
    private final List<CentralProcessor.ProcessorCache> processorCaches;
    private final List<String> featureFlags;

    protected AbstractCentralProcessor() {
        Set set;
        Quartet<List<CentralProcessor.LogicalProcessor>, List<CentralProcessor.PhysicalProcessor>, List<CentralProcessor.ProcessorCache>, List<String>> quartet = this.initProcessorCounts();
        this.logicalProcessors = Collections.unmodifiableList(quartet.getA());
        if (quartet.getB() == null) {
            set = this.logicalProcessors.stream().map(logicalProcessor -> (logicalProcessor.getPhysicalPackageNumber() << 16) + logicalProcessor.getPhysicalProcessorNumber()).collect(Collectors.toSet());
            List list = set.stream().sorted().map(n2 -> new CentralProcessor.PhysicalProcessor(n2 >> 16, (int)(n2 & 0xFFFF))).collect(Collectors.toList());
            this.physicalProcessors = Collections.unmodifiableList(list);
        } else {
            this.physicalProcessors = Collections.unmodifiableList(quartet.getB());
        }
        this.processorCaches = quartet.getC() == null ? Collections.emptyList() : Collections.unmodifiableList(quartet.getC());
        set = new HashSet();
        for (CentralProcessor.LogicalProcessor logicalProcessor2 : this.logicalProcessors) {
            int n3 = logicalProcessor2.getPhysicalPackageNumber();
            set.add(n3);
        }
        this.logicalProcessorCount = this.logicalProcessors.size();
        this.physicalProcessorCount = this.physicalProcessors.size();
        this.physicalPackageCount = set.size();
        this.featureFlags = Collections.unmodifiableList(quartet.getD());
    }

    protected abstract Quartet<List<CentralProcessor.LogicalProcessor>, List<CentralProcessor.PhysicalProcessor>, List<CentralProcessor.ProcessorCache>, List<String>> initProcessorCounts();

    protected abstract CentralProcessor.ProcessorIdentifier queryProcessorId();

    public CentralProcessor.ProcessorIdentifier getProcessorIdentifier() {
        return this.cpuid.get();
    }

    public long getMaxFreq() {
        return this.maxFreq.get();
    }

    protected long queryMaxFreq() {
        return Arrays.stream(this.getCurrentFreq()).max().orElse(-1L);
    }

    public long[] getCurrentFreq() {
        long[] lArray = this.currentFreq.get();
        if (lArray.length == this.getLogicalProcessorCount()) {
            return lArray;
        }
        long[] lArray2 = new long[this.getLogicalProcessorCount()];
        Arrays.fill(lArray2, lArray[0]);
        return lArray2;
    }

    protected abstract long[] queryCurrentFreq();

    protected abstract long queryContextSwitches();

    protected abstract long queryInterrupts();

    @Override
    public List<CentralProcessor.LogicalProcessor> getLogicalProcessors() {
        return this.logicalProcessors;
    }

    public List<CentralProcessor.PhysicalProcessor> getPhysicalProcessors() {
        return this.physicalProcessors;
    }

    @Override
    public long[] getSystemCpuLoadTicks() {
        return this.systemCpuLoadTicks.get();
    }

    protected abstract long[] querySystemCpuLoadTicks();

    public long[][] getProcessorCpuLoadTicks() {
        return this.processorCpuLoadTicks.get();
    }

    protected abstract long[][] queryProcessorCpuLoadTicks();

    @Override
    public double getSystemCpuLoadBetweenTicks(long[] lArray) {
        if (lArray.length != CentralProcessor.TickType.values().length) {
            throw new IllegalArgumentException("Provited tick array length " + lArray.length + " should have " + CentralProcessor.TickType.values().length + " elements");
        }
        long[] lArray2 = this.getSystemCpuLoadTicks();
        long l2 = 0L;
        for (int i2 = 0; i2 < lArray2.length; ++i2) {
            l2 += lArray2[i2] - lArray[i2];
        }
        long l3 = lArray2[CentralProcessor.TickType.IDLE.getIndex()] + lArray2[CentralProcessor.TickType.IOWAIT.getIndex()] - lArray[CentralProcessor.TickType.IDLE.getIndex()] - lArray[CentralProcessor.TickType.IOWAIT.getIndex()];
        LOG.trace("Total ticks: {}  Idle ticks: {}", (Object)l2, (Object)l3);
        return l2 > 0L ? (double)(l2 - l3) / (double)l2 : 0.0;
    }

    public int getLogicalProcessorCount() {
        return this.logicalProcessorCount;
    }

    public int getPhysicalProcessorCount() {
        return this.physicalProcessorCount;
    }

    public int getPhysicalPackageCount() {
        return this.physicalPackageCount;
    }

    protected static String createProcessorID(String string, String string2, String string3, String[] stringArray) {
        long l2 = 0L;
        long l3 = ParseUtil.parseLongOrDefault(string, 0L);
        long l4 = ParseUtil.parseLongOrDefault(string2, 0L);
        long l5 = ParseUtil.parseLongOrDefault(string3, 0L);
        l2 |= l3 & 0xFL;
        l2 |= (l4 & 0xFL) << 4;
        l2 |= (l4 & 0xF0L) << 12;
        l2 |= (l5 & 0xFL) << 8;
        l2 |= (l5 & 0xFF0L) << 16;
        long l6 = 0L;
        if (Platform.isLinux()) {
            l6 = Auxv.queryAuxv().getOrDefault(16, 0L);
        }
        if (l6 > 0L) {
            l2 |= l6 << 32;
        } else {
            String[] stringArray2 = stringArray;
            int n2 = stringArray2.length;
            block64: for (int i2 = 0; i2 < n2; ++i2) {
                String string4;
                switch (string4 = stringArray2[i2]) {
                    case "fpu": {
                        l2 |= 0x100000000L;
                        continue block64;
                    }
                    case "vme": {
                        l2 |= 0x200000000L;
                        continue block64;
                    }
                    case "de": {
                        l2 |= 0x400000000L;
                        continue block64;
                    }
                    case "pse": {
                        l2 |= 0x800000000L;
                        continue block64;
                    }
                    case "tsc": {
                        l2 |= 0x1000000000L;
                        continue block64;
                    }
                    case "msr": {
                        l2 |= 0x2000000000L;
                        continue block64;
                    }
                    case "pae": {
                        l2 |= 0x4000000000L;
                        continue block64;
                    }
                    case "mce": {
                        l2 |= 0x8000000000L;
                        continue block64;
                    }
                    case "cx8": {
                        l2 |= 0x10000000000L;
                        continue block64;
                    }
                    case "apic": {
                        l2 |= 0x20000000000L;
                        continue block64;
                    }
                    case "sep": {
                        l2 |= 0x80000000000L;
                        continue block64;
                    }
                    case "mtrr": {
                        l2 |= 0x100000000000L;
                        continue block64;
                    }
                    case "pge": {
                        l2 |= 0x200000000000L;
                        continue block64;
                    }
                    case "mca": {
                        l2 |= 0x400000000000L;
                        continue block64;
                    }
                    case "cmov": {
                        l2 |= 0x800000000000L;
                        continue block64;
                    }
                    case "pat": {
                        l2 |= 0x1000000000000L;
                        continue block64;
                    }
                    case "pse-36": {
                        l2 |= 0x2000000000000L;
                        continue block64;
                    }
                    case "psn": {
                        l2 |= 0x4000000000000L;
                        continue block64;
                    }
                    case "clfsh": {
                        l2 |= 0x8000000000000L;
                        continue block64;
                    }
                    case "ds": {
                        l2 |= 0x20000000000000L;
                        continue block64;
                    }
                    case "acpi": {
                        l2 |= 0x40000000000000L;
                        continue block64;
                    }
                    case "mmx": {
                        l2 |= 0x80000000000000L;
                        continue block64;
                    }
                    case "fxsr": {
                        l2 |= 0x100000000000000L;
                        continue block64;
                    }
                    case "sse": {
                        l2 |= 0x200000000000000L;
                        continue block64;
                    }
                    case "sse2": {
                        l2 |= 0x400000000000000L;
                        continue block64;
                    }
                    case "ss": {
                        l2 |= 0x800000000000000L;
                        continue block64;
                    }
                    case "htt": {
                        l2 |= 0x1000000000000000L;
                        continue block64;
                    }
                    case "tm": {
                        l2 |= 0x2000000000000000L;
                        continue block64;
                    }
                    case "ia64": {
                        l2 |= 0x4000000000000000L;
                        continue block64;
                    }
                    case "pbe": {
                        l2 |= Long.MIN_VALUE;
                        continue block64;
                    }
                }
            }
        }
        return String.format(Locale.ROOT, "%016X", l2);
    }

    protected List<CentralProcessor.PhysicalProcessor> createProcListFromDmesg(List<CentralProcessor.LogicalProcessor> list, Map<Integer, String> map) {
        boolean bl2 = map.values().stream().distinct().count() > 1L;
        ArrayList<CentralProcessor.PhysicalProcessor> arrayList = new ArrayList<CentralProcessor.PhysicalProcessor>();
        HashSet<Integer> hashSet = new HashSet<Integer>();
        for (CentralProcessor.LogicalProcessor logicalProcessor : list) {
            int n2;
            int n3 = logicalProcessor.getPhysicalPackageNumber();
            int n4 = (n3 << 16) + (n2 = logicalProcessor.getPhysicalProcessorNumber());
            if (hashSet.contains(n4)) continue;
            hashSet.add(n4);
            String string = map.getOrDefault(logicalProcessor.getProcessorNumber(), "");
            int n5 = 0;
            if (bl2 && (string.startsWith("ARM Cortex") && ParseUtil.getFirstIntValue(string) >= 70 || string.startsWith("Apple") && (string.contains("Firestorm") || string.contains("Avalanche")))) {
                n5 = 1;
            }
            arrayList.add(new CentralProcessor.PhysicalProcessor(n3, n2, n5, string));
        }
        arrayList.sort(Comparator.comparingInt(CentralProcessor.PhysicalProcessor::getPhysicalPackageNumber).thenComparingInt(CentralProcessor.PhysicalProcessor::getPhysicalProcessorNumber));
        return arrayList;
    }

    public static List<CentralProcessor.ProcessorCache> orderedProcCaches(Set<CentralProcessor.ProcessorCache> set) {
        return set.stream().sorted(Comparator.comparing(processorCache -> -1000 * processorCache.getLevel() + 100 * processorCache.getType().ordinal() - Integer.highestOneBit(processorCache.getCacheSize()))).collect(Collectors.toList());
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(this.getProcessorIdentifier().getName());
        stringBuilder.append("\n ").append(this.getPhysicalPackageCount()).append(" physical CPU package(s)");
        stringBuilder.append("\n ").append(this.getPhysicalProcessorCount()).append(" physical CPU core(s)");
        HashMap<Integer, Integer> hashMap = new HashMap<Integer, Integer>();
        int n2 = 0;
        for (CentralProcessor.PhysicalProcessor physicalProcessor : this.getPhysicalProcessors()) {
            int n3 = physicalProcessor.getEfficiency();
            hashMap.merge(n3, 1, Integer::sum);
            if (n3 <= n2) continue;
            n2 = n3;
        }
        int n4 = hashMap.getOrDefault(n2, 0);
        int n5 = this.getPhysicalProcessorCount() - n4;
        if (n5 > 0) {
            stringBuilder.append(" (").append(n4).append(" performance + ").append(n5).append(" efficiency)");
        }
        stringBuilder.append("\n ").append(this.getLogicalProcessorCount()).append(" logical CPU(s)");
        stringBuilder.append('\n').append("Identifier: ").append(this.getProcessorIdentifier().getIdentifier());
        stringBuilder.append('\n').append("ProcessorID: ").append(this.getProcessorIdentifier().getProcessorID());
        stringBuilder.append('\n').append("Microarchitecture: ").append(this.getProcessorIdentifier().getMicroarchitecture());
        return stringBuilder.toString();
    }
}

