/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.org.springframework.core.convert.support;

import com.gradle.maven.extension.internal.dep.org.springframework.core.CollectionFactory;
import com.gradle.maven.extension.internal.dep.org.springframework.core.convert.ConversionService;
import com.gradle.maven.extension.internal.dep.org.springframework.core.convert.TypeDescriptor;
import com.gradle.maven.extension.internal.dep.org.springframework.core.convert.converter.ConditionalGenericConverter;
import com.gradle.maven.extension.internal.dep.org.springframework.core.convert.converter.GenericConverter;
import com.gradle.maven.extension.internal.dep.org.springframework.core.convert.support.ConversionUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.Set;

final class MapToMapConverter
implements ConditionalGenericConverter {
    private final ConversionService conversionService;

    public MapToMapConverter(ConversionService conversionService) {
        this.conversionService = conversionService;
    }

    @Override
    public Set<GenericConverter.ConvertiblePair> getConvertibleTypes() {
        return Collections.singleton(new GenericConverter.ConvertiblePair(Map.class, Map.class));
    }

    @Override
    public boolean matches(TypeDescriptor typeDescriptor, TypeDescriptor typeDescriptor2) {
        return this.canConvertKey(typeDescriptor, typeDescriptor2) && this.canConvertValue(typeDescriptor, typeDescriptor2);
    }

    @Override
    public Object convert(Object object, TypeDescriptor typeDescriptor, TypeDescriptor typeDescriptor2) {
        boolean bl2;
        if (object == null) {
            return null;
        }
        Map map = (Map)object;
        boolean bl3 = bl2 = !typeDescriptor2.getType().isInstance(object);
        if (!bl2 && map.isEmpty()) {
            return map;
        }
        TypeDescriptor typeDescriptor3 = typeDescriptor2.getMapKeyTypeDescriptor();
        TypeDescriptor typeDescriptor4 = typeDescriptor2.getMapValueTypeDescriptor();
        ArrayList<MapEntry> arrayList = new ArrayList<MapEntry>(map.size());
        for (Map.Entry object2 : map.entrySet()) {
            Object k2 = object2.getKey();
            Object v2 = object2.getValue();
            Object object3 = this.convertKey(k2, typeDescriptor, typeDescriptor3);
            Object object4 = this.convertValue(v2, typeDescriptor, typeDescriptor4);
            arrayList.add(new MapEntry(object3, object4));
            if (k2 == object3 && v2 == object4) continue;
            bl2 = true;
        }
        if (!bl2) {
            return map;
        }
        Map map2 = CollectionFactory.createMap(typeDescriptor2.getType(), typeDescriptor3 != null ? typeDescriptor3.getType() : null, map.size());
        for (MapEntry mapEntry : arrayList) {
            mapEntry.addToMap(map2);
        }
        return map2;
    }

    private boolean canConvertKey(TypeDescriptor typeDescriptor, TypeDescriptor typeDescriptor2) {
        return ConversionUtils.canConvertElements(typeDescriptor.getMapKeyTypeDescriptor(), typeDescriptor2.getMapKeyTypeDescriptor(), this.conversionService);
    }

    private boolean canConvertValue(TypeDescriptor typeDescriptor, TypeDescriptor typeDescriptor2) {
        return ConversionUtils.canConvertElements(typeDescriptor.getMapValueTypeDescriptor(), typeDescriptor2.getMapValueTypeDescriptor(), this.conversionService);
    }

    private Object convertKey(Object object, TypeDescriptor typeDescriptor, TypeDescriptor typeDescriptor2) {
        if (typeDescriptor2 == null) {
            return object;
        }
        return this.conversionService.convert(object, typeDescriptor.getMapKeyTypeDescriptor(object), typeDescriptor2);
    }

    private Object convertValue(Object object, TypeDescriptor typeDescriptor, TypeDescriptor typeDescriptor2) {
        if (typeDescriptor2 == null) {
            return object;
        }
        return this.conversionService.convert(object, typeDescriptor.getMapValueTypeDescriptor(object), typeDescriptor2);
    }

    private static class MapEntry {
        private final Object key;
        private final Object value;

        public MapEntry(Object object, Object object2) {
            this.key = object;
            this.value = object2;
        }

        public void addToMap(Map<Object, Object> map) {
            map.put(this.key, this.value);
        }
    }
}

