/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.org.springframework.core;

import com.gradle.maven.extension.internal.dep.org.springframework.core.MethodParameter;
import com.gradle.maven.extension.internal.dep.org.springframework.core.SerializableTypeWrapper;
import com.gradle.maven.extension.internal.dep.org.springframework.util.Assert;
import com.gradle.maven.extension.internal.dep.org.springframework.util.ClassUtils;
import com.gradle.maven.extension.internal.dep.org.springframework.util.ConcurrentReferenceHashMap;
import com.gradle.maven.extension.internal.dep.org.springframework.util.ObjectUtils;
import com.gradle.maven.extension.internal.dep.org.springframework.util.StringUtils;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.Arrays;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.StringJoiner;

public class ResolvableType
implements Serializable {
    public static final ResolvableType NONE = new ResolvableType(EmptyType.INSTANCE, null, null, 0);
    private static final ResolvableType[] EMPTY_TYPES_ARRAY = new ResolvableType[0];
    private static final ConcurrentReferenceHashMap<ResolvableType, ResolvableType> cache = new ConcurrentReferenceHashMap(256);
    private final Type type;
    private final SerializableTypeWrapper.TypeProvider typeProvider;
    private final VariableResolver variableResolver;
    private final ResolvableType componentType;
    private final Integer hash;
    private Class<?> resolved;
    private volatile ResolvableType superType;
    private volatile ResolvableType[] interfaces;
    private volatile ResolvableType[] generics;
    private volatile Boolean unresolvableGenerics;

    private ResolvableType(Type type, SerializableTypeWrapper.TypeProvider typeProvider, VariableResolver variableResolver) {
        this.type = type;
        this.typeProvider = typeProvider;
        this.variableResolver = variableResolver;
        this.componentType = null;
        this.hash = this.calculateHashCode();
        this.resolved = null;
    }

    private ResolvableType(Type type, SerializableTypeWrapper.TypeProvider typeProvider, VariableResolver variableResolver, Integer n2) {
        this.type = type;
        this.typeProvider = typeProvider;
        this.variableResolver = variableResolver;
        this.componentType = null;
        this.hash = n2;
        this.resolved = this.resolveClass();
    }

    private ResolvableType(Type type, SerializableTypeWrapper.TypeProvider typeProvider, VariableResolver variableResolver, ResolvableType resolvableType) {
        this.type = type;
        this.typeProvider = typeProvider;
        this.variableResolver = variableResolver;
        this.componentType = resolvableType;
        this.hash = null;
        this.resolved = this.resolveClass();
    }

    private ResolvableType(Class<?> clazz) {
        this.type = this.resolved = clazz != null ? clazz : Object.class;
        this.typeProvider = null;
        this.variableResolver = null;
        this.componentType = null;
        this.hash = null;
    }

    public Type getType() {
        return SerializableTypeWrapper.unwrap(this.type);
    }

    public Class<?> toClass() {
        return this.resolve(Object.class);
    }

    public boolean isAssignableFrom(ResolvableType resolvableType) {
        return this.isAssignableFrom(resolvableType, null);
    }

    private boolean isAssignableFrom(ResolvableType resolvableType, Map<Type, Type> map) {
        Object object;
        Type type;
        Assert.notNull((Object)resolvableType, "ResolvableType must not be null");
        if (this == NONE || resolvableType == NONE) {
            return false;
        }
        if (this.isArray()) {
            return resolvableType.isArray() && this.getComponentType().isAssignableFrom(resolvableType.getComponentType());
        }
        if (map != null && map.get(this.type) == resolvableType.type) {
            return true;
        }
        WildcardBounds wildcardBounds = WildcardBounds.get(this);
        WildcardBounds wildcardBounds2 = WildcardBounds.get(resolvableType);
        if (wildcardBounds2 != null) {
            return wildcardBounds != null && wildcardBounds.isSameKind(wildcardBounds2) && wildcardBounds.isAssignableFrom(wildcardBounds2.getBounds());
        }
        if (wildcardBounds != null) {
            return wildcardBounds.isAssignableFrom(resolvableType);
        }
        boolean bl2 = map != null;
        boolean bl3 = true;
        Class<?> clazz = null;
        if (this.type instanceof TypeVariable) {
            type = (TypeVariable)this.type;
            if (this.variableResolver != null && (object = this.variableResolver.resolveVariable((TypeVariable<?>)type)) != null) {
                clazz = ((ResolvableType)object).resolve();
            }
            if (clazz == null && resolvableType.variableResolver != null && (object = resolvableType.variableResolver.resolveVariable((TypeVariable<?>)type)) != null) {
                clazz = ((ResolvableType)object).resolve();
                bl3 = false;
            }
            if (clazz == null) {
                bl2 = false;
            }
        }
        if (clazz == null) {
            clazz = this.toClass();
        }
        type = resolvableType.toClass();
        if (bl2 ? !clazz.equals(type) : !ClassUtils.isAssignable(clazz, type)) {
            return false;
        }
        if (bl3) {
            ResolvableType[] resolvableTypeArray;
            object = this.getGenerics();
            if (((Object)object).length != (resolvableTypeArray = resolvableType.as(clazz).getGenerics()).length) {
                return false;
            }
            if (((Object)object).length > 0) {
                if (map == null) {
                    map = new IdentityHashMap<Type, Type>(1);
                }
                map.put(this.type, resolvableType.type);
                for (int i2 = 0; i2 < ((Object)object).length; ++i2) {
                    if (super.isAssignableFrom(resolvableTypeArray[i2], map)) continue;
                    return false;
                }
            }
        }
        return true;
    }

    public boolean isArray() {
        if (this == NONE) {
            return false;
        }
        return this.type instanceof Class && ((Class)this.type).isArray() || this.type instanceof GenericArrayType || this.resolveType().isArray();
    }

    public ResolvableType getComponentType() {
        if (this == NONE) {
            return NONE;
        }
        if (this.componentType != null) {
            return this.componentType;
        }
        if (this.type instanceof Class) {
            Class<?> clazz = ((Class)this.type).getComponentType();
            return ResolvableType.forType(clazz, this.variableResolver);
        }
        if (this.type instanceof GenericArrayType) {
            return ResolvableType.forType(((GenericArrayType)this.type).getGenericComponentType(), this.variableResolver);
        }
        return this.resolveType().getComponentType();
    }

    public ResolvableType asCollection() {
        return this.as(Collection.class);
    }

    public ResolvableType asMap() {
        return this.as(Map.class);
    }

    public ResolvableType as(Class<?> clazz) {
        if (this == NONE) {
            return NONE;
        }
        Class<?> clazz2 = this.resolve();
        if (clazz2 == null || clazz2 == clazz) {
            return this;
        }
        for (ResolvableType resolvableType : this.getInterfaces()) {
            ResolvableType resolvableType2 = resolvableType.as(clazz);
            if (resolvableType2 == NONE) continue;
            return resolvableType2;
        }
        return this.getSuperType().as(clazz);
    }

    public ResolvableType getSuperType() {
        Class<?> clazz = this.resolve();
        if (clazz == null) {
            return NONE;
        }
        try {
            Type type = clazz.getGenericSuperclass();
            if (type == null) {
                return NONE;
            }
            ResolvableType resolvableType = this.superType;
            if (resolvableType == null) {
                this.superType = resolvableType = ResolvableType.forType(type, this);
            }
            return resolvableType;
        }
        catch (TypeNotPresentException typeNotPresentException) {
            return NONE;
        }
    }

    public ResolvableType[] getInterfaces() {
        Class<?> clazz = this.resolve();
        if (clazz == null) {
            return EMPTY_TYPES_ARRAY;
        }
        ResolvableType[] resolvableTypeArray = this.interfaces;
        if (resolvableTypeArray == null) {
            Type[] typeArray = clazz.getGenericInterfaces();
            resolvableTypeArray = new ResolvableType[typeArray.length];
            for (int i2 = 0; i2 < typeArray.length; ++i2) {
                resolvableTypeArray[i2] = ResolvableType.forType(typeArray[i2], this);
            }
            this.interfaces = resolvableTypeArray;
        }
        return resolvableTypeArray;
    }

    public boolean hasGenerics() {
        return this.getGenerics().length > 0;
    }

    public boolean hasUnresolvableGenerics() {
        if (this == NONE) {
            return false;
        }
        Boolean bl2 = this.unresolvableGenerics;
        if (bl2 == null) {
            this.unresolvableGenerics = bl2 = Boolean.valueOf(this.determineUnresolvableGenerics());
        }
        return bl2;
    }

    private boolean determineUnresolvableGenerics() {
        ResolvableType[] resolvableTypeArray = this.getGenerics();
        for (ResolvableType resolvableType : resolvableTypeArray) {
            if (!resolvableType.isUnresolvableTypeVariable() && !resolvableType.isWildcardWithoutBounds()) continue;
            return true;
        }
        Class<?> clazz = this.resolve();
        if (clazz != null) {
            Object object;
            try {
                object = clazz.getGenericInterfaces();
                int n2 = ((Type[])object).length;
                for (int i2 = 0; i2 < n2; ++i2) {
                    Type type = object[i2];
                    if (!(type instanceof Class) || ((Class)type).getTypeParameters().length <= 0) continue;
                    return true;
                }
            }
            catch (TypeNotPresentException typeNotPresentException) {
                // empty catch block
            }
            if ((object = clazz.getSuperclass()) != null && object != Object.class) {
                return this.getSuperType().hasUnresolvableGenerics();
            }
        }
        return false;
    }

    private boolean isUnresolvableTypeVariable() {
        if (this.type instanceof TypeVariable) {
            if (this.variableResolver == null) {
                return true;
            }
            TypeVariable typeVariable = (TypeVariable)this.type;
            ResolvableType resolvableType = this.variableResolver.resolveVariable(typeVariable);
            if (resolvableType == null || resolvableType.isUnresolvableTypeVariable()) {
                return true;
            }
        }
        return false;
    }

    private boolean isWildcardWithoutBounds() {
        Type[] typeArray;
        WildcardType wildcardType;
        return this.type instanceof WildcardType && (wildcardType = (WildcardType)this.type).getLowerBounds().length == 0 && ((typeArray = wildcardType.getUpperBounds()).length == 0 || typeArray.length == 1 && Object.class == typeArray[0]);
    }

    public ResolvableType getNested(int n2, Map<Integer, Integer> map) {
        ResolvableType resolvableType = this;
        for (int i2 = 2; i2 <= n2; ++i2) {
            if (resolvableType.isArray()) {
                resolvableType = resolvableType.getComponentType();
                continue;
            }
            while (resolvableType != NONE && !resolvableType.hasGenerics()) {
                resolvableType = resolvableType.getSuperType();
            }
            Integer n3 = map != null ? map.get(i2) : null;
            n3 = n3 == null ? resolvableType.getGenerics().length - 1 : n3;
            resolvableType = resolvableType.getGeneric(n3);
        }
        return resolvableType;
    }

    public ResolvableType getGeneric(int ... nArray) {
        ResolvableType[] resolvableTypeArray = this.getGenerics();
        if (nArray == null || nArray.length == 0) {
            return resolvableTypeArray.length == 0 ? NONE : resolvableTypeArray[0];
        }
        ResolvableType resolvableType = this;
        for (int n2 : nArray) {
            resolvableTypeArray = resolvableType.getGenerics();
            if (n2 < 0 || n2 >= resolvableTypeArray.length) {
                return NONE;
            }
            resolvableType = resolvableTypeArray[n2];
        }
        return resolvableType;
    }

    public ResolvableType[] getGenerics() {
        if (this == NONE) {
            return EMPTY_TYPES_ARRAY;
        }
        ResolvableType[] resolvableTypeArray = this.generics;
        if (resolvableTypeArray == null) {
            if (this.type instanceof Class) {
                TypeVariable<Class<T>>[] typeVariableArray = ((Class)this.type).getTypeParameters();
                resolvableTypeArray = new ResolvableType[typeVariableArray.length];
                for (int i2 = 0; i2 < resolvableTypeArray.length; ++i2) {
                    resolvableTypeArray[i2] = ResolvableType.forType(typeVariableArray[i2], this);
                }
            } else if (this.type instanceof ParameterizedType) {
                Type[] typeArray = ((ParameterizedType)this.type).getActualTypeArguments();
                resolvableTypeArray = new ResolvableType[typeArray.length];
                for (int i3 = 0; i3 < typeArray.length; ++i3) {
                    resolvableTypeArray[i3] = ResolvableType.forType(typeArray[i3], this.variableResolver);
                }
            } else {
                resolvableTypeArray = this.resolveType().getGenerics();
            }
            this.generics = resolvableTypeArray;
        }
        return resolvableTypeArray;
    }

    public Class<?> resolve() {
        return this.resolved;
    }

    public Class<?> resolve(Class<?> clazz) {
        return this.resolved != null ? this.resolved : clazz;
    }

    private Class<?> resolveClass() {
        if (this.type == EmptyType.INSTANCE) {
            return null;
        }
        if (this.type instanceof Class) {
            return (Class)this.type;
        }
        if (this.type instanceof GenericArrayType) {
            Class<?> clazz = this.getComponentType().resolve();
            return clazz != null ? Array.newInstance(clazz, 0).getClass() : null;
        }
        return this.resolveType().resolve();
    }

    ResolvableType resolveType() {
        if (this.type instanceof ParameterizedType) {
            return ResolvableType.forType(((ParameterizedType)this.type).getRawType(), this.variableResolver);
        }
        if (this.type instanceof WildcardType) {
            Type type = this.resolveBounds(((WildcardType)this.type).getUpperBounds());
            if (type == null) {
                type = this.resolveBounds(((WildcardType)this.type).getLowerBounds());
            }
            return ResolvableType.forType(type, this.variableResolver);
        }
        if (this.type instanceof TypeVariable) {
            ResolvableType resolvableType;
            TypeVariable typeVariable = (TypeVariable)this.type;
            if (this.variableResolver != null && (resolvableType = this.variableResolver.resolveVariable(typeVariable)) != null) {
                return resolvableType;
            }
            return ResolvableType.forType(this.resolveBounds(typeVariable.getBounds()), this.variableResolver);
        }
        return NONE;
    }

    private Type resolveBounds(Type[] typeArray) {
        if (typeArray.length == 0 || typeArray[0] == Object.class) {
            return null;
        }
        return typeArray[0];
    }

    private ResolvableType resolveVariable(TypeVariable<?> typeVariable) {
        Object object;
        if (this.type instanceof TypeVariable) {
            return this.resolveType().resolveVariable(typeVariable);
        }
        if (this.type instanceof ParameterizedType) {
            object = (ParameterizedType)this.type;
            Class<?> clazz = this.resolve();
            if (clazz == null) {
                return null;
            }
            TypeVariable<Class<?>>[] typeVariableArray = clazz.getTypeParameters();
            for (int i2 = 0; i2 < typeVariableArray.length; ++i2) {
                if (!ObjectUtils.nullSafeEquals(typeVariableArray[i2].getName(), typeVariable.getName())) continue;
                Type type = object.getActualTypeArguments()[i2];
                return ResolvableType.forType(type, this.variableResolver);
            }
            Type type = object.getOwnerType();
            if (type != null) {
                return ResolvableType.forType(type, this.variableResolver).resolveVariable(typeVariable);
            }
        }
        if (this.type instanceof WildcardType && (object = this.resolveType().resolveVariable(typeVariable)) != null) {
            return object;
        }
        if (this.variableResolver != null) {
            return this.variableResolver.resolveVariable(typeVariable);
        }
        return null;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof ResolvableType)) {
            return false;
        }
        ResolvableType resolvableType = (ResolvableType)object;
        if (!ObjectUtils.nullSafeEquals(this.type, resolvableType.type)) {
            return false;
        }
        if (!(this.typeProvider == resolvableType.typeProvider || this.typeProvider != null && resolvableType.typeProvider != null && ObjectUtils.nullSafeEquals(this.typeProvider.getType(), resolvableType.typeProvider.getType()))) {
            return false;
        }
        if (!(this.variableResolver == resolvableType.variableResolver || this.variableResolver != null && resolvableType.variableResolver != null && ObjectUtils.nullSafeEquals(this.variableResolver.getSource(), resolvableType.variableResolver.getSource()))) {
            return false;
        }
        return ObjectUtils.nullSafeEquals(this.componentType, resolvableType.componentType);
    }

    public int hashCode() {
        return this.hash != null ? this.hash.intValue() : this.calculateHashCode();
    }

    private int calculateHashCode() {
        int n2 = ObjectUtils.nullSafeHashCode(this.type);
        if (this.typeProvider != null) {
            n2 = 31 * n2 + ObjectUtils.nullSafeHashCode(this.typeProvider.getType());
        }
        if (this.variableResolver != null) {
            n2 = 31 * n2 + ObjectUtils.nullSafeHashCode(this.variableResolver.getSource());
        }
        if (this.componentType != null) {
            n2 = 31 * n2 + ObjectUtils.nullSafeHashCode(this.componentType);
        }
        return n2;
    }

    VariableResolver asVariableResolver() {
        if (this == NONE) {
            return null;
        }
        return new DefaultVariableResolver(this);
    }

    public String toString() {
        if (this.isArray()) {
            return this.getComponentType() + "[]";
        }
        if (this.resolved == null) {
            return "?";
        }
        if (this.type instanceof TypeVariable) {
            TypeVariable typeVariable = (TypeVariable)this.type;
            if (this.variableResolver == null || this.variableResolver.resolveVariable(typeVariable) == null) {
                return "?";
            }
        }
        if (this.hasGenerics()) {
            return this.resolved.getName() + '<' + StringUtils.arrayToDelimitedString(this.getGenerics(), ", ") + '>';
        }
        return this.resolved.getName();
    }

    public static ResolvableType forClass(Class<?> clazz) {
        return new ResolvableType(clazz);
    }

    public static ResolvableType forClassWithGenerics(Class<?> clazz, ResolvableType ... resolvableTypeArray) {
        Assert.notNull(clazz, "Class must not be null");
        Assert.notNull((Object)resolvableTypeArray, "Generics array must not be null");
        TypeVariable<Class<?>>[] typeVariableArray = clazz.getTypeParameters();
        Assert.isTrue(typeVariableArray.length == resolvableTypeArray.length, () -> "Mismatched number of generics specified for " + clazz.toGenericString());
        Type[] typeArray = new Type[resolvableTypeArray.length];
        for (int i2 = 0; i2 < resolvableTypeArray.length; ++i2) {
            ResolvableType resolvableType = resolvableTypeArray[i2];
            Type type = resolvableType != null ? resolvableType.getType() : null;
            typeArray[i2] = type != null && !(type instanceof TypeVariable) ? type : typeVariableArray[i2];
        }
        SyntheticParameterizedType syntheticParameterizedType = new SyntheticParameterizedType(clazz, typeArray);
        return ResolvableType.forType((Type)syntheticParameterizedType, new TypeVariablesVariableResolver(typeVariableArray, resolvableTypeArray));
    }

    public static ResolvableType forField(Field field) {
        Assert.notNull((Object)field, "Field must not be null");
        return ResolvableType.forType(null, new SerializableTypeWrapper.FieldTypeProvider(field), null);
    }

    public static ResolvableType forMethodParameter(Method method, int n2, Class<?> clazz) {
        Assert.notNull((Object)method, "Method must not be null");
        MethodParameter methodParameter = new MethodParameter((Executable)method, n2, clazz);
        return ResolvableType.forMethodParameter(methodParameter);
    }

    public static ResolvableType forMethodParameter(MethodParameter methodParameter) {
        return ResolvableType.forMethodParameter(methodParameter, null);
    }

    public static ResolvableType forMethodParameter(MethodParameter methodParameter, Type type) {
        Assert.notNull((Object)methodParameter, "MethodParameter must not be null");
        return ResolvableType.forMethodParameter(methodParameter, type, methodParameter.getNestingLevel());
    }

    static ResolvableType forMethodParameter(MethodParameter methodParameter, Type type, int n2) {
        ResolvableType resolvableType = ResolvableType.forType(methodParameter.getContainingClass()).as(methodParameter.getDeclaringClass());
        return ResolvableType.forType(type, new SerializableTypeWrapper.MethodParameterTypeProvider(methodParameter), resolvableType.asVariableResolver()).getNested(n2, methodParameter.typeIndexesPerLevel);
    }

    public static ResolvableType forType(Type type) {
        return ResolvableType.forType(type, null, null);
    }

    public static ResolvableType forType(Type type, ResolvableType resolvableType) {
        VariableResolver variableResolver = null;
        if (resolvableType != null) {
            variableResolver = resolvableType.asVariableResolver();
        }
        return ResolvableType.forType(type, variableResolver);
    }

    static ResolvableType forType(Type type, VariableResolver variableResolver) {
        return ResolvableType.forType(type, null, variableResolver);
    }

    static ResolvableType forType(Type type, SerializableTypeWrapper.TypeProvider typeProvider, VariableResolver variableResolver) {
        if (type == null && typeProvider != null) {
            type = SerializableTypeWrapper.forTypeProvider(typeProvider);
        }
        if (type == null) {
            return NONE;
        }
        if (type instanceof Class) {
            return new ResolvableType(type, typeProvider, variableResolver, (ResolvableType)null);
        }
        cache.purgeUnreferencedEntries();
        ResolvableType resolvableType = new ResolvableType(type, typeProvider, variableResolver);
        ResolvableType resolvableType2 = cache.get(resolvableType);
        if (resolvableType2 == null) {
            resolvableType2 = new ResolvableType(type, typeProvider, variableResolver, resolvableType.hash);
            cache.put(resolvableType2, resolvableType2);
        }
        resolvableType.resolved = resolvableType2.resolved;
        return resolvableType;
    }

    static class EmptyType
    implements Serializable,
    Type {
        static final Type INSTANCE = new EmptyType();

        EmptyType() {
        }
    }

    private static class WildcardBounds {
        private final Kind kind;
        private final ResolvableType[] bounds;

        public WildcardBounds(Kind kind, ResolvableType[] resolvableTypeArray) {
            this.kind = kind;
            this.bounds = resolvableTypeArray;
        }

        public boolean isSameKind(WildcardBounds wildcardBounds) {
            return this.kind == wildcardBounds.kind;
        }

        public boolean isAssignableFrom(ResolvableType ... resolvableTypeArray) {
            for (ResolvableType resolvableType : this.bounds) {
                for (ResolvableType resolvableType2 : resolvableTypeArray) {
                    if (this.isAssignable(resolvableType, resolvableType2)) continue;
                    return false;
                }
            }
            return true;
        }

        private boolean isAssignable(ResolvableType resolvableType, ResolvableType resolvableType2) {
            return this.kind == Kind.UPPER ? resolvableType.isAssignableFrom(resolvableType2) : resolvableType2.isAssignableFrom(resolvableType);
        }

        public ResolvableType[] getBounds() {
            return this.bounds;
        }

        public static WildcardBounds get(ResolvableType resolvableType) {
            ResolvableType resolvableType2 = resolvableType;
            while (!(resolvableType2.getType() instanceof WildcardType)) {
                if (resolvableType2 == NONE) {
                    return null;
                }
                resolvableType2 = resolvableType2.resolveType();
            }
            WildcardType wildcardType = (WildcardType)resolvableType2.type;
            Kind kind = wildcardType.getLowerBounds().length > 0 ? Kind.LOWER : Kind.UPPER;
            Type[] typeArray = kind == Kind.UPPER ? wildcardType.getUpperBounds() : wildcardType.getLowerBounds();
            ResolvableType[] resolvableTypeArray = new ResolvableType[typeArray.length];
            for (int i2 = 0; i2 < typeArray.length; ++i2) {
                resolvableTypeArray[i2] = ResolvableType.forType(typeArray[i2], resolvableType.variableResolver);
            }
            return new WildcardBounds(kind, resolvableTypeArray);
        }

        static enum Kind {
            UPPER,
            LOWER;

        }
    }

    private static final class SyntheticParameterizedType
    implements Serializable,
    ParameterizedType {
        private final Type rawType;
        private final Type[] typeArguments;

        public SyntheticParameterizedType(Type type, Type[] typeArray) {
            this.rawType = type;
            this.typeArguments = typeArray;
        }

        @Override
        public String getTypeName() {
            String string = this.rawType.getTypeName();
            if (this.typeArguments.length > 0) {
                StringJoiner stringJoiner = new StringJoiner(", ", "<", ">");
                for (Type type : this.typeArguments) {
                    stringJoiner.add(type.getTypeName());
                }
                return string + stringJoiner;
            }
            return string;
        }

        @Override
        public Type getOwnerType() {
            return null;
        }

        @Override
        public Type getRawType() {
            return this.rawType;
        }

        @Override
        public Type[] getActualTypeArguments() {
            return this.typeArguments;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (!(object instanceof ParameterizedType)) {
                return false;
            }
            ParameterizedType parameterizedType = (ParameterizedType)object;
            return parameterizedType.getOwnerType() == null && this.rawType.equals(parameterizedType.getRawType()) && Arrays.equals(this.typeArguments, parameterizedType.getActualTypeArguments());
        }

        public int hashCode() {
            return this.rawType.hashCode() * 31 + Arrays.hashCode(this.typeArguments);
        }

        public String toString() {
            return this.getTypeName();
        }
    }

    private static class TypeVariablesVariableResolver
    implements VariableResolver {
        private final TypeVariable<?>[] variables;
        private final ResolvableType[] generics;

        public TypeVariablesVariableResolver(TypeVariable<?>[] typeVariableArray, ResolvableType[] resolvableTypeArray) {
            this.variables = typeVariableArray;
            this.generics = resolvableTypeArray;
        }

        @Override
        public ResolvableType resolveVariable(TypeVariable<?> typeVariable) {
            TypeVariable<?> typeVariable2 = SerializableTypeWrapper.unwrap(typeVariable);
            for (int i2 = 0; i2 < this.variables.length; ++i2) {
                TypeVariable<?> typeVariable3 = SerializableTypeWrapper.unwrap(this.variables[i2]);
                if (!ObjectUtils.nullSafeEquals(typeVariable3, typeVariable2)) continue;
                return this.generics[i2];
            }
            return null;
        }

        @Override
        public Object getSource() {
            return this.generics;
        }
    }

    private static class DefaultVariableResolver
    implements VariableResolver {
        private final ResolvableType source;

        DefaultVariableResolver(ResolvableType resolvableType) {
            this.source = resolvableType;
        }

        @Override
        public ResolvableType resolveVariable(TypeVariable<?> typeVariable) {
            return this.source.resolveVariable(typeVariable);
        }

        @Override
        public Object getSource() {
            return this.source;
        }
    }

    static interface VariableResolver
    extends Serializable {
        public Object getSource();

        public ResolvableType resolveVariable(TypeVariable<?> var1);
    }
}

