/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.org.codehaus.plexus.languages.java.jpms;

import com.gradle.maven.extension.internal.dep.org.codehaus.plexus.languages.java.jpms.ModuleNameExtractor;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.jar.JarFile;
import java.util.jar.Manifest;

class ManifestModuleNameExtractor
implements ModuleNameExtractor {
    ManifestModuleNameExtractor() {
    }

    @Override
    public String extract(Path path) throws IOException {
        Manifest manifest = this.extractManifest(path);
        String string = manifest != null ? manifest.getMainAttributes().getValue("Automatic-Module-Name") : null;
        return string;
    }

    private Manifest extractManifest(Path path) throws IOException {
        Manifest manifest;
        if (Files.isRegularFile(path, new LinkOption[0])) {
            try (JarFile jarFile = new JarFile(path.toFile());){
                manifest = jarFile.getManifest();
            }
        } else if (Files.exists(path.resolve("META-INF/MANIFEST.MF"), new LinkOption[0])) {
            try (InputStream inputStream = Files.newInputStream(path.resolve("META-INF/MANIFEST.MF"), new OpenOption[0]);){
                manifest = new Manifest(inputStream);
            }
        } else {
            manifest = null;
        }
        return manifest;
    }
}

