/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.org.apache.commons.io.serialization;

import com.gradle.maven.extension.internal.dep.org.apache.commons.io.serialization.ClassNameMatcher;
import com.gradle.maven.extension.internal.dep.org.apache.commons.io.serialization.FullClassNameMatcher;
import java.io.ObjectStreamClass;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Stream;

public class ObjectStreamClassPredicate
implements Predicate<ObjectStreamClass> {
    private final List<ClassNameMatcher> acceptMatchers = new ArrayList<ClassNameMatcher>();
    private final List<ClassNameMatcher> rejectMatchers = new ArrayList<ClassNameMatcher>();

    public ObjectStreamClassPredicate accept(Class<?> ... classArray) {
        Stream.of(classArray).map(clazz -> new FullClassNameMatcher(clazz.getName())).forEach(this.acceptMatchers::add);
        return this;
    }

    @Override
    public boolean test(ObjectStreamClass objectStreamClass) {
        return this.test(objectStreamClass.getName());
    }

    @Override
    public boolean test(String string) {
        for (ClassNameMatcher classNameMatcher : this.rejectMatchers) {
            if (!classNameMatcher.matches(string)) continue;
            return false;
        }
        for (ClassNameMatcher classNameMatcher : this.acceptMatchers) {
            if (!classNameMatcher.matches(string)) continue;
            return true;
        }
        return false;
    }
}

