/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.org.apache.commons.io.file.attribute;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileTime;
import java.time.Instant;
import java.util.concurrent.TimeUnit;

public final class FileTimes {
    public static final FileTime EPOCH = FileTime.from(Instant.EPOCH);
    private static final long HUNDRED_NANOS_PER_SECOND = TimeUnit.SECONDS.toNanos(1L) / 100L;
    static final long HUNDRED_NANOS_PER_MILLISECOND = TimeUnit.MILLISECONDS.toNanos(1L) / 100L;

    public static FileTime fromUnixTime(long l2) {
        return FileTime.from(l2, TimeUnit.SECONDS);
    }

    public static FileTime now() {
        return FileTime.from(Instant.now());
    }

    public static void setLastModifiedTime(Path path) throws IOException {
        Files.setLastModifiedTime(path, FileTimes.now());
    }

    public static long toUnixTime(FileTime fileTime) {
        return fileTime != null ? fileTime.to(TimeUnit.SECONDS) : 0L;
    }
}

