/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.it.unimi.dsi.fastutil.ints;

import com.gradle.maven.extension.internal.dep.it.unimi.dsi.fastutil.ints.IntComparator;
import java.io.Serializable;
import java.util.Comparator;

public final class IntComparators {
    public static final IntComparator NATURAL_COMPARATOR = new NaturalImplicitComparator();
    public static final IntComparator OPPOSITE_COMPARATOR = new OppositeImplicitComparator();

    public static IntComparator oppositeComparator(IntComparator intComparator) {
        if (intComparator instanceof OppositeComparator) {
            return ((OppositeComparator)intComparator).comparator;
        }
        return new OppositeComparator(intComparator);
    }

    public static IntComparator asIntComparator(final Comparator<? super Integer> comparator) {
        if (comparator == null || comparator instanceof IntComparator) {
            return (IntComparator)comparator;
        }
        return new IntComparator(){

            @Override
            public int compare(int n2, int n3) {
                return comparator.compare(n2, n3);
            }

            @Override
            public int compare(Integer n2, Integer n3) {
                return comparator.compare(n2, n3);
            }
        };
    }

    protected static class OppositeComparator
    implements IntComparator,
    Serializable {
        final IntComparator comparator;

        protected OppositeComparator(IntComparator intComparator) {
            this.comparator = intComparator;
        }

        @Override
        public final int compare(int n2, int n3) {
            return this.comparator.compare(n3, n2);
        }

        @Override
        public final IntComparator reversed() {
            return this.comparator;
        }
    }

    protected static class NaturalImplicitComparator
    implements IntComparator,
    Serializable {
        protected NaturalImplicitComparator() {
        }

        @Override
        public final int compare(int n2, int n3) {
            return Integer.compare(n2, n3);
        }

        @Override
        public IntComparator reversed() {
            return OPPOSITE_COMPARATOR;
        }
    }

    protected static class OppositeImplicitComparator
    implements IntComparator,
    Serializable {
        protected OppositeImplicitComparator() {
        }

        @Override
        public final int compare(int n2, int n3) {
            return -Integer.compare(n2, n3);
        }

        @Override
        public IntComparator reversed() {
            return NATURAL_COMPARATOR;
        }
    }
}

