/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.io.netty.channel;

import com.gradle.maven.extension.internal.dep.io.netty.buffer.ByteBufAllocator;
import com.gradle.maven.extension.internal.dep.io.netty.channel.AbstractChannel;
import com.gradle.maven.extension.internal.dep.io.netty.channel.Channel;
import com.gradle.maven.extension.internal.dep.io.netty.channel.ChannelDuplexHandler;
import com.gradle.maven.extension.internal.dep.io.netty.channel.ChannelFuture;
import com.gradle.maven.extension.internal.dep.io.netty.channel.ChannelHandler;
import com.gradle.maven.extension.internal.dep.io.netty.channel.ChannelHandlerContext;
import com.gradle.maven.extension.internal.dep.io.netty.channel.ChannelHandlerMask;
import com.gradle.maven.extension.internal.dep.io.netty.channel.ChannelInboundHandler;
import com.gradle.maven.extension.internal.dep.io.netty.channel.ChannelInboundHandlerAdapter;
import com.gradle.maven.extension.internal.dep.io.netty.channel.ChannelOutboundHandler;
import com.gradle.maven.extension.internal.dep.io.netty.channel.ChannelOutboundHandlerAdapter;
import com.gradle.maven.extension.internal.dep.io.netty.channel.ChannelPipeline;
import com.gradle.maven.extension.internal.dep.io.netty.channel.ChannelPromise;
import com.gradle.maven.extension.internal.dep.io.netty.channel.DefaultChannelPipeline;
import com.gradle.maven.extension.internal.dep.io.netty.channel.DefaultChannelPromise;
import com.gradle.maven.extension.internal.dep.io.netty.channel.FailedChannelFuture;
import com.gradle.maven.extension.internal.dep.io.netty.channel.VoidChannelPromise;
import com.gradle.maven.extension.internal.dep.io.netty.util.Attribute;
import com.gradle.maven.extension.internal.dep.io.netty.util.AttributeKey;
import com.gradle.maven.extension.internal.dep.io.netty.util.ReferenceCountUtil;
import com.gradle.maven.extension.internal.dep.io.netty.util.ResourceLeakHint;
import com.gradle.maven.extension.internal.dep.io.netty.util.concurrent.AbstractEventExecutor;
import com.gradle.maven.extension.internal.dep.io.netty.util.concurrent.EventExecutor;
import com.gradle.maven.extension.internal.dep.io.netty.util.concurrent.OrderedEventExecutor;
import com.gradle.maven.extension.internal.dep.io.netty.util.internal.ObjectPool;
import com.gradle.maven.extension.internal.dep.io.netty.util.internal.ObjectUtil;
import com.gradle.maven.extension.internal.dep.io.netty.util.internal.PromiseNotificationUtil;
import com.gradle.maven.extension.internal.dep.io.netty.util.internal.StringUtil;
import com.gradle.maven.extension.internal.dep.io.netty.util.internal.SystemPropertyUtil;
import com.gradle.maven.extension.internal.dep.io.netty.util.internal.ThrowableUtil;
import com.gradle.maven.extension.internal.dep.io.netty.util.internal.logging.InternalLogger;
import com.gradle.maven.extension.internal.dep.io.netty.util.internal.logging.InternalLoggerFactory;
import java.net.SocketAddress;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;

abstract class AbstractChannelHandlerContext
implements ChannelHandlerContext,
ResourceLeakHint {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(AbstractChannelHandlerContext.class);
    volatile AbstractChannelHandlerContext next;
    volatile AbstractChannelHandlerContext prev;
    private static final AtomicIntegerFieldUpdater<AbstractChannelHandlerContext> HANDLER_STATE_UPDATER = AtomicIntegerFieldUpdater.newUpdater(AbstractChannelHandlerContext.class, "handlerState");
    private final DefaultChannelPipeline pipeline;
    private final String name;
    private final boolean ordered;
    private final int executionMask;
    final EventExecutor executor;
    private Tasks invokeTasks;
    private volatile int handlerState = 0;

    AbstractChannelHandlerContext(DefaultChannelPipeline defaultChannelPipeline, EventExecutor eventExecutor, String string, Class<? extends ChannelHandler> clazz) {
        this.name = ObjectUtil.checkNotNull(string, "name");
        this.pipeline = defaultChannelPipeline;
        this.executor = eventExecutor;
        this.executionMask = ChannelHandlerMask.mask(clazz);
        this.ordered = eventExecutor == null || eventExecutor instanceof OrderedEventExecutor;
    }

    @Override
    public Channel channel() {
        return this.pipeline.channel();
    }

    @Override
    public ChannelPipeline pipeline() {
        return this.pipeline;
    }

    @Override
    public ByteBufAllocator alloc() {
        return this.channel().config().getAllocator();
    }

    @Override
    public EventExecutor executor() {
        if (this.executor == null) {
            return this.channel().eventLoop();
        }
        return this.executor;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public ChannelHandlerContext fireChannelRegistered() {
        AbstractChannelHandlerContext.invokeChannelRegistered(this.findContextInbound(2));
        return this;
    }

    static void invokeChannelRegistered(final AbstractChannelHandlerContext abstractChannelHandlerContext) {
        EventExecutor eventExecutor = abstractChannelHandlerContext.executor();
        if (eventExecutor.inEventLoop()) {
            abstractChannelHandlerContext.invokeChannelRegistered();
        } else {
            eventExecutor.execute(new Runnable(){

                @Override
                public void run() {
                    abstractChannelHandlerContext.invokeChannelRegistered();
                }
            });
        }
    }

    private void invokeChannelRegistered() {
        block6: {
            if (this.invokeHandler()) {
                try {
                    ChannelHandler channelHandler = this.handler();
                    DefaultChannelPipeline.HeadContext headContext = this.pipeline.head;
                    if (channelHandler == headContext) {
                        headContext.channelRegistered(this);
                        break block6;
                    }
                    if (channelHandler instanceof ChannelInboundHandlerAdapter) {
                        ((ChannelInboundHandlerAdapter)channelHandler).channelRegistered(this);
                        break block6;
                    }
                    ((ChannelInboundHandler)channelHandler).channelRegistered(this);
                }
                catch (Throwable throwable) {
                    this.invokeExceptionCaught(throwable);
                }
            } else {
                this.fireChannelRegistered();
            }
        }
    }

    @Override
    public ChannelHandlerContext fireChannelUnregistered() {
        AbstractChannelHandlerContext.invokeChannelUnregistered(this.findContextInbound(4));
        return this;
    }

    static void invokeChannelUnregistered(final AbstractChannelHandlerContext abstractChannelHandlerContext) {
        EventExecutor eventExecutor = abstractChannelHandlerContext.executor();
        if (eventExecutor.inEventLoop()) {
            abstractChannelHandlerContext.invokeChannelUnregistered();
        } else {
            eventExecutor.execute(new Runnable(){

                @Override
                public void run() {
                    abstractChannelHandlerContext.invokeChannelUnregistered();
                }
            });
        }
    }

    private void invokeChannelUnregistered() {
        block6: {
            if (this.invokeHandler()) {
                try {
                    ChannelHandler channelHandler = this.handler();
                    DefaultChannelPipeline.HeadContext headContext = this.pipeline.head;
                    if (channelHandler == headContext) {
                        headContext.channelUnregistered(this);
                        break block6;
                    }
                    if (channelHandler instanceof ChannelInboundHandlerAdapter) {
                        ((ChannelInboundHandlerAdapter)channelHandler).channelUnregistered(this);
                        break block6;
                    }
                    ((ChannelInboundHandler)channelHandler).channelUnregistered(this);
                }
                catch (Throwable throwable) {
                    this.invokeExceptionCaught(throwable);
                }
            } else {
                this.fireChannelUnregistered();
            }
        }
    }

    @Override
    public ChannelHandlerContext fireChannelActive() {
        AbstractChannelHandlerContext.invokeChannelActive(this.findContextInbound(8));
        return this;
    }

    static void invokeChannelActive(final AbstractChannelHandlerContext abstractChannelHandlerContext) {
        EventExecutor eventExecutor = abstractChannelHandlerContext.executor();
        if (eventExecutor.inEventLoop()) {
            abstractChannelHandlerContext.invokeChannelActive();
        } else {
            eventExecutor.execute(new Runnable(){

                @Override
                public void run() {
                    abstractChannelHandlerContext.invokeChannelActive();
                }
            });
        }
    }

    private void invokeChannelActive() {
        block6: {
            if (this.invokeHandler()) {
                try {
                    ChannelHandler channelHandler = this.handler();
                    DefaultChannelPipeline.HeadContext headContext = this.pipeline.head;
                    if (channelHandler == headContext) {
                        headContext.channelActive(this);
                        break block6;
                    }
                    if (channelHandler instanceof ChannelInboundHandlerAdapter) {
                        ((ChannelInboundHandlerAdapter)channelHandler).channelActive(this);
                        break block6;
                    }
                    ((ChannelInboundHandler)channelHandler).channelActive(this);
                }
                catch (Throwable throwable) {
                    this.invokeExceptionCaught(throwable);
                }
            } else {
                this.fireChannelActive();
            }
        }
    }

    @Override
    public ChannelHandlerContext fireChannelInactive() {
        AbstractChannelHandlerContext.invokeChannelInactive(this.findContextInbound(16));
        return this;
    }

    static void invokeChannelInactive(final AbstractChannelHandlerContext abstractChannelHandlerContext) {
        EventExecutor eventExecutor = abstractChannelHandlerContext.executor();
        if (eventExecutor.inEventLoop()) {
            abstractChannelHandlerContext.invokeChannelInactive();
        } else {
            eventExecutor.execute(new Runnable(){

                @Override
                public void run() {
                    abstractChannelHandlerContext.invokeChannelInactive();
                }
            });
        }
    }

    private void invokeChannelInactive() {
        block6: {
            if (this.invokeHandler()) {
                try {
                    ChannelHandler channelHandler = this.handler();
                    DefaultChannelPipeline.HeadContext headContext = this.pipeline.head;
                    if (channelHandler == headContext) {
                        headContext.channelInactive(this);
                        break block6;
                    }
                    if (channelHandler instanceof ChannelInboundHandlerAdapter) {
                        ((ChannelInboundHandlerAdapter)channelHandler).channelInactive(this);
                        break block6;
                    }
                    ((ChannelInboundHandler)channelHandler).channelInactive(this);
                }
                catch (Throwable throwable) {
                    this.invokeExceptionCaught(throwable);
                }
            } else {
                this.fireChannelInactive();
            }
        }
    }

    @Override
    public ChannelHandlerContext fireExceptionCaught(Throwable throwable) {
        AbstractChannelHandlerContext.invokeExceptionCaught(this.findContextInbound(1), throwable);
        return this;
    }

    static void invokeExceptionCaught(final AbstractChannelHandlerContext abstractChannelHandlerContext, final Throwable throwable) {
        block4: {
            ObjectUtil.checkNotNull(throwable, "cause");
            EventExecutor eventExecutor = abstractChannelHandlerContext.executor();
            if (eventExecutor.inEventLoop()) {
                abstractChannelHandlerContext.invokeExceptionCaught(throwable);
            } else {
                try {
                    eventExecutor.execute(new Runnable(){

                        @Override
                        public void run() {
                            abstractChannelHandlerContext.invokeExceptionCaught(throwable);
                        }
                    });
                }
                catch (Throwable throwable2) {
                    if (!logger.isWarnEnabled()) break block4;
                    logger.warn("Failed to submit an exceptionCaught() event.", throwable2);
                    logger.warn("The exceptionCaught() event that was failed to submit was:", throwable);
                }
            }
        }
    }

    private void invokeExceptionCaught(Throwable throwable) {
        if (this.invokeHandler()) {
            try {
                this.handler().exceptionCaught(this, throwable);
            }
            catch (Throwable throwable2) {
                if (logger.isDebugEnabled()) {
                    logger.debug("An exception {}was thrown by a user handler's exceptionCaught() method while handling the following exception:", (Object)ThrowableUtil.stackTraceToString(throwable2), (Object)throwable);
                } else if (logger.isWarnEnabled()) {
                    logger.warn("An exception '{}' [enable DEBUG level for full stacktrace] was thrown by a user handler's exceptionCaught() method while handling the following exception:", (Object)throwable2, (Object)throwable);
                }
            }
        } else {
            this.fireExceptionCaught(throwable);
        }
    }

    @Override
    public ChannelHandlerContext fireUserEventTriggered(Object object) {
        AbstractChannelHandlerContext.invokeUserEventTriggered(this.findContextInbound(128), object);
        return this;
    }

    static void invokeUserEventTriggered(final AbstractChannelHandlerContext abstractChannelHandlerContext, final Object object) {
        ObjectUtil.checkNotNull(object, "event");
        EventExecutor eventExecutor = abstractChannelHandlerContext.executor();
        if (eventExecutor.inEventLoop()) {
            abstractChannelHandlerContext.invokeUserEventTriggered(object);
        } else {
            eventExecutor.execute(new Runnable(){

                @Override
                public void run() {
                    abstractChannelHandlerContext.invokeUserEventTriggered(object);
                }
            });
        }
    }

    private void invokeUserEventTriggered(Object object) {
        block6: {
            if (this.invokeHandler()) {
                try {
                    ChannelHandler channelHandler = this.handler();
                    DefaultChannelPipeline.HeadContext headContext = this.pipeline.head;
                    if (channelHandler == headContext) {
                        headContext.userEventTriggered(this, object);
                        break block6;
                    }
                    if (channelHandler instanceof ChannelInboundHandlerAdapter) {
                        ((ChannelInboundHandlerAdapter)channelHandler).userEventTriggered(this, object);
                        break block6;
                    }
                    ((ChannelInboundHandler)channelHandler).userEventTriggered(this, object);
                }
                catch (Throwable throwable) {
                    this.invokeExceptionCaught(throwable);
                }
            } else {
                this.fireUserEventTriggered(object);
            }
        }
    }

    @Override
    public ChannelHandlerContext fireChannelRead(Object object) {
        AbstractChannelHandlerContext.invokeChannelRead(this.findContextInbound(32), object);
        return this;
    }

    static void invokeChannelRead(final AbstractChannelHandlerContext abstractChannelHandlerContext, Object object) {
        final Object object2 = abstractChannelHandlerContext.pipeline.touch(ObjectUtil.checkNotNull(object, "msg"), abstractChannelHandlerContext);
        EventExecutor eventExecutor = abstractChannelHandlerContext.executor();
        if (eventExecutor.inEventLoop()) {
            abstractChannelHandlerContext.invokeChannelRead(object2);
        } else {
            eventExecutor.execute(new Runnable(){

                @Override
                public void run() {
                    abstractChannelHandlerContext.invokeChannelRead(object2);
                }
            });
        }
    }

    private void invokeChannelRead(Object object) {
        block6: {
            if (this.invokeHandler()) {
                try {
                    ChannelHandler channelHandler = this.handler();
                    DefaultChannelPipeline.HeadContext headContext = this.pipeline.head;
                    if (channelHandler == headContext) {
                        headContext.channelRead(this, object);
                        break block6;
                    }
                    if (channelHandler instanceof ChannelDuplexHandler) {
                        ((ChannelDuplexHandler)channelHandler).channelRead(this, object);
                        break block6;
                    }
                    ((ChannelInboundHandler)channelHandler).channelRead(this, object);
                }
                catch (Throwable throwable) {
                    this.invokeExceptionCaught(throwable);
                }
            } else {
                this.fireChannelRead(object);
            }
        }
    }

    @Override
    public ChannelHandlerContext fireChannelReadComplete() {
        AbstractChannelHandlerContext.invokeChannelReadComplete(this.findContextInbound(64));
        return this;
    }

    static void invokeChannelReadComplete(AbstractChannelHandlerContext abstractChannelHandlerContext) {
        EventExecutor eventExecutor = abstractChannelHandlerContext.executor();
        if (eventExecutor.inEventLoop()) {
            abstractChannelHandlerContext.invokeChannelReadComplete();
        } else {
            Tasks tasks = abstractChannelHandlerContext.invokeTasks;
            if (tasks == null) {
                abstractChannelHandlerContext.invokeTasks = tasks = new Tasks(abstractChannelHandlerContext);
            }
            eventExecutor.execute(tasks.invokeChannelReadCompleteTask);
        }
    }

    private void invokeChannelReadComplete() {
        block6: {
            if (this.invokeHandler()) {
                try {
                    ChannelHandler channelHandler = this.handler();
                    DefaultChannelPipeline.HeadContext headContext = this.pipeline.head;
                    if (channelHandler == headContext) {
                        headContext.channelReadComplete(this);
                        break block6;
                    }
                    if (channelHandler instanceof ChannelDuplexHandler) {
                        ((ChannelDuplexHandler)channelHandler).channelReadComplete(this);
                        break block6;
                    }
                    ((ChannelInboundHandler)channelHandler).channelReadComplete(this);
                }
                catch (Throwable throwable) {
                    this.invokeExceptionCaught(throwable);
                }
            } else {
                this.fireChannelReadComplete();
            }
        }
    }

    @Override
    public ChannelHandlerContext fireChannelWritabilityChanged() {
        AbstractChannelHandlerContext.invokeChannelWritabilityChanged(this.findContextInbound(256));
        return this;
    }

    static void invokeChannelWritabilityChanged(AbstractChannelHandlerContext abstractChannelHandlerContext) {
        EventExecutor eventExecutor = abstractChannelHandlerContext.executor();
        if (eventExecutor.inEventLoop()) {
            abstractChannelHandlerContext.invokeChannelWritabilityChanged();
        } else {
            Tasks tasks = abstractChannelHandlerContext.invokeTasks;
            if (tasks == null) {
                abstractChannelHandlerContext.invokeTasks = tasks = new Tasks(abstractChannelHandlerContext);
            }
            eventExecutor.execute(tasks.invokeChannelWritableStateChangedTask);
        }
    }

    private void invokeChannelWritabilityChanged() {
        block6: {
            if (this.invokeHandler()) {
                try {
                    ChannelHandler channelHandler = this.handler();
                    DefaultChannelPipeline.HeadContext headContext = this.pipeline.head;
                    if (channelHandler == headContext) {
                        headContext.channelWritabilityChanged(this);
                        break block6;
                    }
                    if (channelHandler instanceof ChannelInboundHandlerAdapter) {
                        ((ChannelInboundHandlerAdapter)channelHandler).channelWritabilityChanged(this);
                        break block6;
                    }
                    ((ChannelInboundHandler)channelHandler).channelWritabilityChanged(this);
                }
                catch (Throwable throwable) {
                    this.invokeExceptionCaught(throwable);
                }
            } else {
                this.fireChannelWritabilityChanged();
            }
        }
    }

    @Override
    public ChannelFuture close() {
        return this.close(this.newPromise());
    }

    @Override
    public ChannelFuture bind(final SocketAddress socketAddress, final ChannelPromise channelPromise) {
        ObjectUtil.checkNotNull(socketAddress, "localAddress");
        if (this.isNotValidPromise(channelPromise, false)) {
            return channelPromise;
        }
        final AbstractChannelHandlerContext abstractChannelHandlerContext = this.findContextOutbound(512);
        EventExecutor eventExecutor = abstractChannelHandlerContext.executor();
        if (eventExecutor.inEventLoop()) {
            abstractChannelHandlerContext.invokeBind(socketAddress, channelPromise);
        } else {
            AbstractChannelHandlerContext.safeExecute(eventExecutor, new Runnable(){

                @Override
                public void run() {
                    abstractChannelHandlerContext.invokeBind(socketAddress, channelPromise);
                }
            }, channelPromise, null, false);
        }
        return channelPromise;
    }

    private void invokeBind(SocketAddress socketAddress, ChannelPromise channelPromise) {
        block7: {
            if (this.invokeHandler()) {
                try {
                    ChannelHandler channelHandler = this.handler();
                    DefaultChannelPipeline.HeadContext headContext = this.pipeline.head;
                    if (channelHandler == headContext) {
                        headContext.bind(this, socketAddress, channelPromise);
                        break block7;
                    }
                    if (channelHandler instanceof ChannelDuplexHandler) {
                        ((ChannelDuplexHandler)channelHandler).bind(this, socketAddress, channelPromise);
                        break block7;
                    }
                    if (channelHandler instanceof ChannelOutboundHandlerAdapter) {
                        ((ChannelOutboundHandlerAdapter)channelHandler).bind(this, socketAddress, channelPromise);
                        break block7;
                    }
                    ((ChannelOutboundHandler)channelHandler).bind(this, socketAddress, channelPromise);
                }
                catch (Throwable throwable) {
                    AbstractChannelHandlerContext.notifyOutboundHandlerException(throwable, channelPromise);
                }
            } else {
                this.bind(socketAddress, channelPromise);
            }
        }
    }

    @Override
    public ChannelFuture connect(SocketAddress socketAddress, ChannelPromise channelPromise) {
        return this.connect(socketAddress, null, channelPromise);
    }

    @Override
    public ChannelFuture connect(final SocketAddress socketAddress, final SocketAddress socketAddress2, final ChannelPromise channelPromise) {
        ObjectUtil.checkNotNull(socketAddress, "remoteAddress");
        if (this.isNotValidPromise(channelPromise, false)) {
            return channelPromise;
        }
        final AbstractChannelHandlerContext abstractChannelHandlerContext = this.findContextOutbound(1024);
        EventExecutor eventExecutor = abstractChannelHandlerContext.executor();
        if (eventExecutor.inEventLoop()) {
            abstractChannelHandlerContext.invokeConnect(socketAddress, socketAddress2, channelPromise);
        } else {
            AbstractChannelHandlerContext.safeExecute(eventExecutor, new Runnable(){

                @Override
                public void run() {
                    abstractChannelHandlerContext.invokeConnect(socketAddress, socketAddress2, channelPromise);
                }
            }, channelPromise, null, false);
        }
        return channelPromise;
    }

    private void invokeConnect(SocketAddress socketAddress, SocketAddress socketAddress2, ChannelPromise channelPromise) {
        block7: {
            if (this.invokeHandler()) {
                try {
                    ChannelHandler channelHandler = this.handler();
                    DefaultChannelPipeline.HeadContext headContext = this.pipeline.head;
                    if (channelHandler == headContext) {
                        headContext.connect(this, socketAddress, socketAddress2, channelPromise);
                        break block7;
                    }
                    if (channelHandler instanceof ChannelDuplexHandler) {
                        ((ChannelDuplexHandler)channelHandler).connect(this, socketAddress, socketAddress2, channelPromise);
                        break block7;
                    }
                    if (channelHandler instanceof ChannelOutboundHandlerAdapter) {
                        ((ChannelOutboundHandlerAdapter)channelHandler).connect(this, socketAddress, socketAddress2, channelPromise);
                        break block7;
                    }
                    ((ChannelOutboundHandler)channelHandler).connect(this, socketAddress, socketAddress2, channelPromise);
                }
                catch (Throwable throwable) {
                    AbstractChannelHandlerContext.notifyOutboundHandlerException(throwable, channelPromise);
                }
            } else {
                this.connect(socketAddress, socketAddress2, channelPromise);
            }
        }
    }

    @Override
    public ChannelFuture disconnect(final ChannelPromise channelPromise) {
        if (!this.channel().metadata().hasDisconnect()) {
            return this.close(channelPromise);
        }
        if (this.isNotValidPromise(channelPromise, false)) {
            return channelPromise;
        }
        final AbstractChannelHandlerContext abstractChannelHandlerContext = this.findContextOutbound(2048);
        EventExecutor eventExecutor = abstractChannelHandlerContext.executor();
        if (eventExecutor.inEventLoop()) {
            abstractChannelHandlerContext.invokeDisconnect(channelPromise);
        } else {
            AbstractChannelHandlerContext.safeExecute(eventExecutor, new Runnable(){

                @Override
                public void run() {
                    abstractChannelHandlerContext.invokeDisconnect(channelPromise);
                }
            }, channelPromise, null, false);
        }
        return channelPromise;
    }

    private void invokeDisconnect(ChannelPromise channelPromise) {
        block7: {
            if (this.invokeHandler()) {
                try {
                    ChannelHandler channelHandler = this.handler();
                    DefaultChannelPipeline.HeadContext headContext = this.pipeline.head;
                    if (channelHandler == headContext) {
                        headContext.disconnect(this, channelPromise);
                        break block7;
                    }
                    if (channelHandler instanceof ChannelDuplexHandler) {
                        ((ChannelDuplexHandler)channelHandler).disconnect(this, channelPromise);
                        break block7;
                    }
                    if (channelHandler instanceof ChannelOutboundHandlerAdapter) {
                        ((ChannelOutboundHandlerAdapter)channelHandler).disconnect(this, channelPromise);
                        break block7;
                    }
                    ((ChannelOutboundHandler)channelHandler).disconnect(this, channelPromise);
                }
                catch (Throwable throwable) {
                    AbstractChannelHandlerContext.notifyOutboundHandlerException(throwable, channelPromise);
                }
            } else {
                this.disconnect(channelPromise);
            }
        }
    }

    @Override
    public ChannelFuture close(final ChannelPromise channelPromise) {
        if (this.isNotValidPromise(channelPromise, false)) {
            return channelPromise;
        }
        final AbstractChannelHandlerContext abstractChannelHandlerContext = this.findContextOutbound(4096);
        EventExecutor eventExecutor = abstractChannelHandlerContext.executor();
        if (eventExecutor.inEventLoop()) {
            abstractChannelHandlerContext.invokeClose(channelPromise);
        } else {
            AbstractChannelHandlerContext.safeExecute(eventExecutor, new Runnable(){

                @Override
                public void run() {
                    abstractChannelHandlerContext.invokeClose(channelPromise);
                }
            }, channelPromise, null, false);
        }
        return channelPromise;
    }

    private void invokeClose(ChannelPromise channelPromise) {
        block7: {
            if (this.invokeHandler()) {
                try {
                    ChannelHandler channelHandler = this.handler();
                    DefaultChannelPipeline.HeadContext headContext = this.pipeline.head;
                    if (channelHandler == headContext) {
                        headContext.close(this, channelPromise);
                        break block7;
                    }
                    if (channelHandler instanceof ChannelDuplexHandler) {
                        ((ChannelDuplexHandler)channelHandler).close(this, channelPromise);
                        break block7;
                    }
                    if (channelHandler instanceof ChannelOutboundHandlerAdapter) {
                        ((ChannelOutboundHandlerAdapter)channelHandler).close(this, channelPromise);
                        break block7;
                    }
                    ((ChannelOutboundHandler)channelHandler).close(this, channelPromise);
                }
                catch (Throwable throwable) {
                    AbstractChannelHandlerContext.notifyOutboundHandlerException(throwable, channelPromise);
                }
            } else {
                this.close(channelPromise);
            }
        }
    }

    @Override
    public ChannelFuture deregister(final ChannelPromise channelPromise) {
        if (this.isNotValidPromise(channelPromise, false)) {
            return channelPromise;
        }
        final AbstractChannelHandlerContext abstractChannelHandlerContext = this.findContextOutbound(8192);
        EventExecutor eventExecutor = abstractChannelHandlerContext.executor();
        if (eventExecutor.inEventLoop()) {
            abstractChannelHandlerContext.invokeDeregister(channelPromise);
        } else {
            AbstractChannelHandlerContext.safeExecute(eventExecutor, new Runnable(){

                @Override
                public void run() {
                    abstractChannelHandlerContext.invokeDeregister(channelPromise);
                }
            }, channelPromise, null, false);
        }
        return channelPromise;
    }

    private void invokeDeregister(ChannelPromise channelPromise) {
        block7: {
            if (this.invokeHandler()) {
                try {
                    ChannelHandler channelHandler = this.handler();
                    DefaultChannelPipeline.HeadContext headContext = this.pipeline.head;
                    if (channelHandler == headContext) {
                        headContext.deregister(this, channelPromise);
                        break block7;
                    }
                    if (channelHandler instanceof ChannelDuplexHandler) {
                        ((ChannelDuplexHandler)channelHandler).deregister(this, channelPromise);
                        break block7;
                    }
                    if (channelHandler instanceof ChannelOutboundHandlerAdapter) {
                        ((ChannelOutboundHandlerAdapter)channelHandler).deregister(this, channelPromise);
                        break block7;
                    }
                    ((ChannelOutboundHandler)channelHandler).deregister(this, channelPromise);
                }
                catch (Throwable throwable) {
                    AbstractChannelHandlerContext.notifyOutboundHandlerException(throwable, channelPromise);
                }
            } else {
                this.deregister(channelPromise);
            }
        }
    }

    @Override
    public ChannelHandlerContext read() {
        AbstractChannelHandlerContext abstractChannelHandlerContext = this.findContextOutbound(16384);
        EventExecutor eventExecutor = abstractChannelHandlerContext.executor();
        if (eventExecutor.inEventLoop()) {
            abstractChannelHandlerContext.invokeRead();
        } else {
            Tasks tasks = abstractChannelHandlerContext.invokeTasks;
            if (tasks == null) {
                abstractChannelHandlerContext.invokeTasks = tasks = new Tasks(abstractChannelHandlerContext);
            }
            eventExecutor.execute(tasks.invokeReadTask);
        }
        return this;
    }

    private void invokeRead() {
        block7: {
            if (this.invokeHandler()) {
                try {
                    ChannelHandler channelHandler = this.handler();
                    DefaultChannelPipeline.HeadContext headContext = this.pipeline.head;
                    if (channelHandler == headContext) {
                        headContext.read(this);
                        break block7;
                    }
                    if (channelHandler instanceof ChannelDuplexHandler) {
                        ((ChannelDuplexHandler)channelHandler).read(this);
                        break block7;
                    }
                    if (channelHandler instanceof ChannelOutboundHandlerAdapter) {
                        ((ChannelOutboundHandlerAdapter)channelHandler).read(this);
                        break block7;
                    }
                    ((ChannelOutboundHandler)channelHandler).read(this);
                }
                catch (Throwable throwable) {
                    this.invokeExceptionCaught(throwable);
                }
            } else {
                this.read();
            }
        }
    }

    @Override
    public ChannelFuture write(Object object) {
        return this.write(object, this.newPromise());
    }

    @Override
    public ChannelFuture write(Object object, ChannelPromise channelPromise) {
        this.write(object, false, channelPromise);
        return channelPromise;
    }

    void invokeWrite(Object object, ChannelPromise channelPromise) {
        if (this.invokeHandler()) {
            this.invokeWrite0(object, channelPromise);
        } else {
            this.write(object, channelPromise);
        }
    }

    private void invokeWrite0(Object object, ChannelPromise channelPromise) {
        try {
            ChannelHandler channelHandler = this.handler();
            DefaultChannelPipeline.HeadContext headContext = this.pipeline.head;
            if (channelHandler == headContext) {
                headContext.write(this, object, channelPromise);
            } else if (channelHandler instanceof ChannelDuplexHandler) {
                ((ChannelDuplexHandler)channelHandler).write(this, object, channelPromise);
            } else if (channelHandler instanceof ChannelOutboundHandlerAdapter) {
                ((ChannelOutboundHandlerAdapter)channelHandler).write(this, object, channelPromise);
            } else {
                ((ChannelOutboundHandler)channelHandler).write(this, object, channelPromise);
            }
        }
        catch (Throwable throwable) {
            AbstractChannelHandlerContext.notifyOutboundHandlerException(throwable, channelPromise);
        }
    }

    @Override
    public ChannelHandlerContext flush() {
        AbstractChannelHandlerContext abstractChannelHandlerContext = this.findContextOutbound(65536);
        EventExecutor eventExecutor = abstractChannelHandlerContext.executor();
        if (eventExecutor.inEventLoop()) {
            abstractChannelHandlerContext.invokeFlush();
        } else {
            Tasks tasks = abstractChannelHandlerContext.invokeTasks;
            if (tasks == null) {
                abstractChannelHandlerContext.invokeTasks = tasks = new Tasks(abstractChannelHandlerContext);
            }
            AbstractChannelHandlerContext.safeExecute(eventExecutor, tasks.invokeFlushTask, this.channel().voidPromise(), null, false);
        }
        return this;
    }

    private void invokeFlush() {
        if (this.invokeHandler()) {
            this.invokeFlush0();
        } else {
            this.flush();
        }
    }

    private void invokeFlush0() {
        try {
            ChannelHandler channelHandler = this.handler();
            DefaultChannelPipeline.HeadContext headContext = this.pipeline.head;
            if (channelHandler == headContext) {
                headContext.flush(this);
            } else if (channelHandler instanceof ChannelDuplexHandler) {
                ((ChannelDuplexHandler)channelHandler).flush(this);
            } else if (channelHandler instanceof ChannelOutboundHandlerAdapter) {
                ((ChannelOutboundHandlerAdapter)channelHandler).flush(this);
            } else {
                ((ChannelOutboundHandler)channelHandler).flush(this);
            }
        }
        catch (Throwable throwable) {
            this.invokeExceptionCaught(throwable);
        }
    }

    public ChannelFuture writeAndFlush(Object object, ChannelPromise channelPromise) {
        this.write(object, true, channelPromise);
        return channelPromise;
    }

    void invokeWriteAndFlush(Object object, ChannelPromise channelPromise) {
        if (this.invokeHandler()) {
            this.invokeWrite0(object, channelPromise);
            this.invokeFlush0();
        } else {
            this.writeAndFlush(object, channelPromise);
        }
    }

    private void write(Object object, boolean bl2, ChannelPromise channelPromise) {
        ObjectUtil.checkNotNull(object, "msg");
        try {
            if (this.isNotValidPromise(channelPromise, true)) {
                ReferenceCountUtil.release(object);
                return;
            }
        }
        catch (RuntimeException runtimeException) {
            ReferenceCountUtil.release(object);
            throw runtimeException;
        }
        AbstractChannelHandlerContext abstractChannelHandlerContext = this.findContextOutbound(bl2 ? 98304 : 32768);
        Object object2 = this.pipeline.touch(object, abstractChannelHandlerContext);
        EventExecutor eventExecutor = abstractChannelHandlerContext.executor();
        if (eventExecutor.inEventLoop()) {
            if (bl2) {
                abstractChannelHandlerContext.invokeWriteAndFlush(object2, channelPromise);
            } else {
                abstractChannelHandlerContext.invokeWrite(object2, channelPromise);
            }
        } else {
            WriteTask writeTask = WriteTask.newInstance(abstractChannelHandlerContext, object2, channelPromise, bl2);
            if (!AbstractChannelHandlerContext.safeExecute(eventExecutor, writeTask, channelPromise, object2, !bl2)) {
                writeTask.cancel();
            }
        }
    }

    @Override
    public ChannelFuture writeAndFlush(Object object) {
        return this.writeAndFlush(object, this.newPromise());
    }

    private static void notifyOutboundHandlerException(Throwable throwable, ChannelPromise channelPromise) {
        PromiseNotificationUtil.tryFailure(channelPromise, throwable, channelPromise instanceof VoidChannelPromise ? null : logger);
    }

    @Override
    public ChannelPromise newPromise() {
        return new DefaultChannelPromise(this.channel(), this.executor());
    }

    @Override
    public ChannelFuture newFailedFuture(Throwable throwable) {
        return new FailedChannelFuture(this.channel(), this.executor(), throwable);
    }

    private boolean isNotValidPromise(ChannelPromise channelPromise, boolean bl2) {
        ObjectUtil.checkNotNull(channelPromise, "promise");
        if (channelPromise.isDone()) {
            if (channelPromise.isCancelled()) {
                return true;
            }
            throw new IllegalArgumentException("promise already done: " + channelPromise);
        }
        if (channelPromise.channel() != this.channel()) {
            throw new IllegalArgumentException(String.format("promise.channel does not match: %s (expected: %s)", channelPromise.channel(), this.channel()));
        }
        if (channelPromise.getClass() == DefaultChannelPromise.class) {
            return false;
        }
        if (!bl2 && channelPromise instanceof VoidChannelPromise) {
            throw new IllegalArgumentException(StringUtil.simpleClassName(VoidChannelPromise.class) + " not allowed for this operation");
        }
        if (channelPromise instanceof AbstractChannel.CloseFuture) {
            throw new IllegalArgumentException(StringUtil.simpleClassName(AbstractChannel.CloseFuture.class) + " not allowed in a pipeline");
        }
        return false;
    }

    private AbstractChannelHandlerContext findContextInbound(int n2) {
        AbstractChannelHandlerContext abstractChannelHandlerContext = this;
        EventExecutor eventExecutor = this.executor();
        while (AbstractChannelHandlerContext.skipContext(abstractChannelHandlerContext = abstractChannelHandlerContext.next, eventExecutor, n2, 510)) {
        }
        return abstractChannelHandlerContext;
    }

    private AbstractChannelHandlerContext findContextOutbound(int n2) {
        AbstractChannelHandlerContext abstractChannelHandlerContext = this;
        EventExecutor eventExecutor = this.executor();
        while (AbstractChannelHandlerContext.skipContext(abstractChannelHandlerContext = abstractChannelHandlerContext.prev, eventExecutor, n2, 130560)) {
        }
        return abstractChannelHandlerContext;
    }

    private static boolean skipContext(AbstractChannelHandlerContext abstractChannelHandlerContext, EventExecutor eventExecutor, int n2, int n3) {
        return (abstractChannelHandlerContext.executionMask & (n3 | n2)) == 0 || abstractChannelHandlerContext.executor() == eventExecutor && (abstractChannelHandlerContext.executionMask & n2) == 0;
    }

    @Override
    public ChannelPromise voidPromise() {
        return this.channel().voidPromise();
    }

    final void setRemoved() {
        this.handlerState = 3;
    }

    final boolean setAddComplete() {
        int n2;
        do {
            if ((n2 = this.handlerState) != 3) continue;
            return false;
        } while (!HANDLER_STATE_UPDATER.compareAndSet(this, n2, 2));
        return true;
    }

    final void setAddPending() {
        boolean bl2 = HANDLER_STATE_UPDATER.compareAndSet(this, 0, 1);
        assert (bl2);
    }

    final void callHandlerAdded() throws Exception {
        if (this.setAddComplete()) {
            this.handler().handlerAdded(this);
        }
    }

    final void callHandlerRemoved() throws Exception {
        try {
            if (this.handlerState == 2) {
                this.handler().handlerRemoved(this);
            }
        }
        finally {
            this.setRemoved();
        }
    }

    private boolean invokeHandler() {
        int n2 = this.handlerState;
        return n2 == 2 || !this.ordered && n2 == 1;
    }

    @Override
    public boolean isRemoved() {
        return this.handlerState == 3;
    }

    @Override
    public <T> Attribute<T> attr(AttributeKey<T> attributeKey) {
        return this.channel().attr(attributeKey);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean safeExecute(EventExecutor eventExecutor, Runnable runnable, ChannelPromise channelPromise, Object object, boolean bl2) {
        try {
            if (bl2 && eventExecutor instanceof AbstractEventExecutor) {
                ((AbstractEventExecutor)eventExecutor).lazyExecute(runnable);
            } else {
                eventExecutor.execute(runnable);
            }
            return true;
        }
        catch (Throwable throwable) {
            try {
                if (object != null) {
                    ReferenceCountUtil.release(object);
                }
            }
            finally {
                channelPromise.setFailure(throwable);
            }
            return false;
        }
    }

    @Override
    public String toHintString() {
        return '\'' + this.name + "' will handle the message from this point.";
    }

    public String toString() {
        return StringUtil.simpleClassName(ChannelHandlerContext.class) + '(' + this.name + ", " + this.channel() + ')';
    }

    private static final class Tasks {
        private final AbstractChannelHandlerContext next;
        private final Runnable invokeChannelReadCompleteTask = new Runnable(){

            @Override
            public void run() {
                Tasks.this.next.invokeChannelReadComplete();
            }
        };
        private final Runnable invokeReadTask = new Runnable(){

            @Override
            public void run() {
                Tasks.this.next.invokeRead();
            }
        };
        private final Runnable invokeChannelWritableStateChangedTask = new Runnable(){

            @Override
            public void run() {
                Tasks.this.next.invokeChannelWritabilityChanged();
            }
        };
        private final Runnable invokeFlushTask = new Runnable(){

            @Override
            public void run() {
                Tasks.this.next.invokeFlush();
            }
        };

        Tasks(AbstractChannelHandlerContext abstractChannelHandlerContext) {
            this.next = abstractChannelHandlerContext;
        }
    }

    static final class WriteTask
    implements Runnable {
        private static final ObjectPool<WriteTask> RECYCLER = ObjectPool.newPool(new ObjectPool.ObjectCreator<WriteTask>(){

            @Override
            public WriteTask newObject(ObjectPool.Handle<WriteTask> handle) {
                return new WriteTask(handle);
            }
        });
        private static final boolean ESTIMATE_TASK_SIZE_ON_SUBMIT = SystemPropertyUtil.getBoolean("com.gradle.maven.extension.internal.dep.io.netty.transport.estimateSizeOnSubmit", true);
        private static final int WRITE_TASK_OVERHEAD = SystemPropertyUtil.getInt("com.gradle.maven.extension.internal.dep.io.netty.transport.writeTaskSizeOverhead", 32);
        private final ObjectPool.Handle<WriteTask> handle;
        private AbstractChannelHandlerContext ctx;
        private Object msg;
        private ChannelPromise promise;
        private int size;

        static WriteTask newInstance(AbstractChannelHandlerContext abstractChannelHandlerContext, Object object, ChannelPromise channelPromise, boolean bl2) {
            WriteTask writeTask = RECYCLER.get();
            WriteTask.init(writeTask, abstractChannelHandlerContext, object, channelPromise, bl2);
            return writeTask;
        }

        private WriteTask(ObjectPool.Handle<? extends WriteTask> handle) {
            this.handle = handle;
        }

        protected static void init(WriteTask writeTask, AbstractChannelHandlerContext abstractChannelHandlerContext, Object object, ChannelPromise channelPromise, boolean bl2) {
            writeTask.ctx = abstractChannelHandlerContext;
            writeTask.msg = object;
            writeTask.promise = channelPromise;
            if (ESTIMATE_TASK_SIZE_ON_SUBMIT) {
                writeTask.size = abstractChannelHandlerContext.pipeline.estimatorHandle().size(object) + WRITE_TASK_OVERHEAD;
                abstractChannelHandlerContext.pipeline.incrementPendingOutboundBytes(writeTask.size);
            } else {
                writeTask.size = 0;
            }
            if (bl2) {
                writeTask.size |= Integer.MIN_VALUE;
            }
        }

        @Override
        public void run() {
            try {
                this.decrementPendingOutboundBytes();
                if (this.size >= 0) {
                    this.ctx.invokeWrite(this.msg, this.promise);
                } else {
                    this.ctx.invokeWriteAndFlush(this.msg, this.promise);
                }
            }
            finally {
                this.recycle();
            }
        }

        void cancel() {
            try {
                this.decrementPendingOutboundBytes();
            }
            finally {
                this.recycle();
            }
        }

        private void decrementPendingOutboundBytes() {
            if (ESTIMATE_TASK_SIZE_ON_SUBMIT) {
                this.ctx.pipeline.decrementPendingOutboundBytes(this.size & Integer.MAX_VALUE);
            }
        }

        private void recycle() {
            this.ctx = null;
            this.msg = null;
            this.promise = null;
            this.handle.recycle(this);
        }
    }
}

