/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.io.netty.buffer;

import com.gradle.maven.extension.internal.dep.io.netty.buffer.ByteBuf;
import com.gradle.maven.extension.internal.dep.io.netty.buffer.ByteBufAllocator;
import com.gradle.maven.extension.internal.dep.io.netty.buffer.Unpooled;
import com.gradle.maven.extension.internal.dep.io.netty.util.ByteProcessor;
import com.gradle.maven.extension.internal.dep.io.netty.util.internal.EmptyArrays;
import com.gradle.maven.extension.internal.dep.io.netty.util.internal.ObjectUtil;
import com.gradle.maven.extension.internal.dep.io.netty.util.internal.PlatformDependent;
import com.gradle.maven.extension.internal.dep.io.netty.util.internal.StringUtil;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.ReadOnlyBufferException;
import java.nio.channels.GatheringByteChannel;
import java.nio.channels.ScatteringByteChannel;
import java.nio.charset.Charset;

public final class EmptyByteBuf
extends ByteBuf {
    private static final ByteBuffer EMPTY_BYTE_BUFFER = ByteBuffer.allocateDirect(0);
    private static final long EMPTY_BYTE_BUFFER_ADDRESS;
    private final ByteBufAllocator alloc;
    private final ByteOrder order;
    private final String str;
    private EmptyByteBuf swapped;

    public EmptyByteBuf(ByteBufAllocator byteBufAllocator) {
        this(byteBufAllocator, ByteOrder.BIG_ENDIAN);
    }

    private EmptyByteBuf(ByteBufAllocator byteBufAllocator, ByteOrder byteOrder) {
        this.alloc = ObjectUtil.checkNotNull(byteBufAllocator, "alloc");
        this.order = byteOrder;
        this.str = StringUtil.simpleClassName(this) + (byteOrder == ByteOrder.BIG_ENDIAN ? "BE" : "LE");
    }

    @Override
    public int capacity() {
        return 0;
    }

    @Override
    public ByteBuf capacity(int n2) {
        throw new ReadOnlyBufferException();
    }

    @Override
    public ByteBufAllocator alloc() {
        return this.alloc;
    }

    @Override
    public ByteOrder order() {
        return this.order;
    }

    @Override
    public ByteBuf unwrap() {
        return null;
    }

    @Override
    public ByteBuf asReadOnly() {
        return Unpooled.unmodifiableBuffer(this);
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    @Override
    public boolean isDirect() {
        return true;
    }

    @Override
    public int maxCapacity() {
        return 0;
    }

    @Override
    public ByteBuf order(ByteOrder byteOrder) {
        if (ObjectUtil.checkNotNull(byteOrder, "endianness") == this.order()) {
            return this;
        }
        EmptyByteBuf emptyByteBuf = this.swapped;
        if (emptyByteBuf != null) {
            return emptyByteBuf;
        }
        this.swapped = emptyByteBuf = new EmptyByteBuf(this.alloc(), byteOrder);
        return emptyByteBuf;
    }

    @Override
    public int readerIndex() {
        return 0;
    }

    @Override
    public ByteBuf readerIndex(int n2) {
        return this.checkIndex(n2);
    }

    @Override
    public int writerIndex() {
        return 0;
    }

    @Override
    public ByteBuf writerIndex(int n2) {
        return this.checkIndex(n2);
    }

    @Override
    public ByteBuf setIndex(int n2, int n3) {
        this.checkIndex(n2);
        this.checkIndex(n3);
        return this;
    }

    @Override
    public int readableBytes() {
        return 0;
    }

    @Override
    public int writableBytes() {
        return 0;
    }

    @Override
    public int maxWritableBytes() {
        return 0;
    }

    @Override
    public boolean isReadable() {
        return false;
    }

    @Override
    public boolean isWritable() {
        return false;
    }

    @Override
    public ByteBuf clear() {
        return this;
    }

    @Override
    public ByteBuf markReaderIndex() {
        return this;
    }

    @Override
    public ByteBuf resetReaderIndex() {
        return this;
    }

    @Override
    public ByteBuf discardSomeReadBytes() {
        return this;
    }

    @Override
    public ByteBuf ensureWritable(int n2) {
        ObjectUtil.checkPositiveOrZero(n2, "minWritableBytes");
        if (n2 != 0) {
            throw new IndexOutOfBoundsException();
        }
        return this;
    }

    @Override
    public int ensureWritable(int n2, boolean bl2) {
        ObjectUtil.checkPositiveOrZero(n2, "minWritableBytes");
        if (n2 == 0) {
            return 0;
        }
        return 1;
    }

    @Override
    public byte getByte(int n2) {
        throw new IndexOutOfBoundsException();
    }

    @Override
    public short getUnsignedByte(int n2) {
        throw new IndexOutOfBoundsException();
    }

    @Override
    public short getShort(int n2) {
        throw new IndexOutOfBoundsException();
    }

    @Override
    public short getShortLE(int n2) {
        throw new IndexOutOfBoundsException();
    }

    @Override
    public int getUnsignedShort(int n2) {
        throw new IndexOutOfBoundsException();
    }

    @Override
    public int getMedium(int n2) {
        throw new IndexOutOfBoundsException();
    }

    @Override
    public int getMediumLE(int n2) {
        throw new IndexOutOfBoundsException();
    }

    @Override
    public int getUnsignedMedium(int n2) {
        throw new IndexOutOfBoundsException();
    }

    @Override
    public int getUnsignedMediumLE(int n2) {
        throw new IndexOutOfBoundsException();
    }

    @Override
    public int getInt(int n2) {
        throw new IndexOutOfBoundsException();
    }

    @Override
    public int getIntLE(int n2) {
        throw new IndexOutOfBoundsException();
    }

    @Override
    public long getUnsignedInt(int n2) {
        throw new IndexOutOfBoundsException();
    }

    @Override
    public long getUnsignedIntLE(int n2) {
        throw new IndexOutOfBoundsException();
    }

    @Override
    public long getLong(int n2) {
        throw new IndexOutOfBoundsException();
    }

    @Override
    public long getLongLE(int n2) {
        throw new IndexOutOfBoundsException();
    }

    @Override
    public ByteBuf getBytes(int n2, ByteBuf byteBuf, int n3, int n4) {
        return this.checkIndex(n2, n4);
    }

    @Override
    public ByteBuf getBytes(int n2, byte[] byArray) {
        return this.checkIndex(n2, byArray.length);
    }

    @Override
    public ByteBuf getBytes(int n2, byte[] byArray, int n3, int n4) {
        return this.checkIndex(n2, n4);
    }

    @Override
    public ByteBuf getBytes(int n2, ByteBuffer byteBuffer) {
        return this.checkIndex(n2, byteBuffer.remaining());
    }

    @Override
    public int getBytes(int n2, GatheringByteChannel gatheringByteChannel, int n3) {
        this.checkIndex(n2, n3);
        return 0;
    }

    @Override
    public ByteBuf setByte(int n2, int n3) {
        throw new IndexOutOfBoundsException();
    }

    @Override
    public ByteBuf setShort(int n2, int n3) {
        throw new IndexOutOfBoundsException();
    }

    @Override
    public ByteBuf setMedium(int n2, int n3) {
        throw new IndexOutOfBoundsException();
    }

    @Override
    public ByteBuf setInt(int n2, int n3) {
        throw new IndexOutOfBoundsException();
    }

    @Override
    public ByteBuf setLong(int n2, long l2) {
        throw new IndexOutOfBoundsException();
    }

    @Override
    public ByteBuf setBytes(int n2, ByteBuf byteBuf, int n3, int n4) {
        return this.checkIndex(n2, n4);
    }

    @Override
    public ByteBuf setBytes(int n2, byte[] byArray, int n3, int n4) {
        return this.checkIndex(n2, n4);
    }

    @Override
    public ByteBuf setBytes(int n2, ByteBuffer byteBuffer) {
        return this.checkIndex(n2, byteBuffer.remaining());
    }

    @Override
    public int setBytes(int n2, InputStream inputStream, int n3) {
        this.checkIndex(n2, n3);
        return 0;
    }

    @Override
    public int setBytes(int n2, ScatteringByteChannel scatteringByteChannel, int n3) {
        this.checkIndex(n2, n3);
        return 0;
    }

    @Override
    public ByteBuf setZero(int n2, int n3) {
        return this.checkIndex(n2, n3);
    }

    @Override
    public int setCharSequence(int n2, CharSequence charSequence, Charset charset) {
        throw new IndexOutOfBoundsException();
    }

    @Override
    public byte readByte() {
        throw new IndexOutOfBoundsException();
    }

    @Override
    public short readUnsignedByte() {
        throw new IndexOutOfBoundsException();
    }

    @Override
    public short readShort() {
        throw new IndexOutOfBoundsException();
    }

    @Override
    public short readShortLE() {
        throw new IndexOutOfBoundsException();
    }

    @Override
    public int readUnsignedShort() {
        throw new IndexOutOfBoundsException();
    }

    @Override
    public int readUnsignedShortLE() {
        throw new IndexOutOfBoundsException();
    }

    @Override
    public int readMediumLE() {
        throw new IndexOutOfBoundsException();
    }

    @Override
    public int readUnsignedMediumLE() {
        throw new IndexOutOfBoundsException();
    }

    @Override
    public int readInt() {
        throw new IndexOutOfBoundsException();
    }

    @Override
    public int readIntLE() {
        throw new IndexOutOfBoundsException();
    }

    @Override
    public long readLong() {
        throw new IndexOutOfBoundsException();
    }

    @Override
    public ByteBuf readBytes(int n2) {
        return this.checkLength(n2);
    }

    @Override
    public ByteBuf readSlice(int n2) {
        return this.checkLength(n2);
    }

    @Override
    public ByteBuf readRetainedSlice(int n2) {
        return this.checkLength(n2);
    }

    @Override
    public ByteBuf readBytes(ByteBuf byteBuf) {
        return this.checkLength(byteBuf.writableBytes());
    }

    @Override
    public ByteBuf readBytes(ByteBuf byteBuf, int n2) {
        return this.checkLength(n2);
    }

    @Override
    public ByteBuf readBytes(byte[] byArray) {
        return this.checkLength(byArray.length);
    }

    @Override
    public ByteBuf readBytes(byte[] byArray, int n2, int n3) {
        return this.checkLength(n3);
    }

    @Override
    public ByteBuf readBytes(ByteBuffer byteBuffer) {
        return this.checkLength(byteBuffer.remaining());
    }

    @Override
    public int readBytes(GatheringByteChannel gatheringByteChannel, int n2) {
        this.checkLength(n2);
        return 0;
    }

    @Override
    public ByteBuf skipBytes(int n2) {
        return this.checkLength(n2);
    }

    @Override
    public ByteBuf writeBoolean(boolean bl2) {
        throw new IndexOutOfBoundsException();
    }

    @Override
    public ByteBuf writeByte(int n2) {
        throw new IndexOutOfBoundsException();
    }

    @Override
    public ByteBuf writeShort(int n2) {
        throw new IndexOutOfBoundsException();
    }

    @Override
    public ByteBuf writeMedium(int n2) {
        throw new IndexOutOfBoundsException();
    }

    @Override
    public ByteBuf writeInt(int n2) {
        throw new IndexOutOfBoundsException();
    }

    @Override
    public ByteBuf writeLong(long l2) {
        throw new IndexOutOfBoundsException();
    }

    @Override
    public ByteBuf writeChar(int n2) {
        throw new IndexOutOfBoundsException();
    }

    @Override
    public ByteBuf writeFloat(float f2) {
        throw new IndexOutOfBoundsException();
    }

    @Override
    public ByteBuf writeDouble(double d2) {
        throw new IndexOutOfBoundsException();
    }

    @Override
    public ByteBuf writeBytes(ByteBuf byteBuf) {
        return this.checkLength(byteBuf.readableBytes());
    }

    @Override
    public ByteBuf writeBytes(ByteBuf byteBuf, int n2) {
        return this.checkLength(n2);
    }

    @Override
    public ByteBuf writeBytes(ByteBuf byteBuf, int n2, int n3) {
        return this.checkLength(n3);
    }

    @Override
    public ByteBuf writeBytes(byte[] byArray) {
        return this.checkLength(byArray.length);
    }

    @Override
    public ByteBuf writeBytes(byte[] byArray, int n2, int n3) {
        return this.checkLength(n3);
    }

    @Override
    public ByteBuf writeBytes(ByteBuffer byteBuffer) {
        return this.checkLength(byteBuffer.remaining());
    }

    @Override
    public int writeBytes(InputStream inputStream, int n2) {
        this.checkLength(n2);
        return 0;
    }

    @Override
    public int writeBytes(ScatteringByteChannel scatteringByteChannel, int n2) {
        this.checkLength(n2);
        return 0;
    }

    @Override
    public int writeCharSequence(CharSequence charSequence, Charset charset) {
        throw new IndexOutOfBoundsException();
    }

    @Override
    public int indexOf(int n2, int n3, byte by2) {
        this.checkIndex(n2);
        this.checkIndex(n3);
        return -1;
    }

    @Override
    public int forEachByte(ByteProcessor byteProcessor) {
        return -1;
    }

    @Override
    public int forEachByte(int n2, int n3, ByteProcessor byteProcessor) {
        this.checkIndex(n2, n3);
        return -1;
    }

    @Override
    public ByteBuf slice() {
        return this;
    }

    @Override
    public ByteBuf retainedSlice() {
        return this;
    }

    @Override
    public ByteBuf slice(int n2, int n3) {
        return this.checkIndex(n2, n3);
    }

    @Override
    public ByteBuf duplicate() {
        return this;
    }

    @Override
    public ByteBuf retainedDuplicate() {
        return this;
    }

    @Override
    public int nioBufferCount() {
        return 1;
    }

    @Override
    public ByteBuffer nioBuffer() {
        return EMPTY_BYTE_BUFFER;
    }

    @Override
    public ByteBuffer nioBuffer(int n2, int n3) {
        this.checkIndex(n2, n3);
        return this.nioBuffer();
    }

    @Override
    public ByteBuffer[] nioBuffers() {
        return new ByteBuffer[]{EMPTY_BYTE_BUFFER};
    }

    @Override
    public ByteBuffer[] nioBuffers(int n2, int n3) {
        this.checkIndex(n2, n3);
        return this.nioBuffers();
    }

    @Override
    public ByteBuffer internalNioBuffer(int n2, int n3) {
        return EMPTY_BYTE_BUFFER;
    }

    @Override
    public boolean hasArray() {
        return true;
    }

    @Override
    public byte[] array() {
        return EmptyArrays.EMPTY_BYTES;
    }

    @Override
    public int arrayOffset() {
        return 0;
    }

    @Override
    public boolean hasMemoryAddress() {
        return EMPTY_BYTE_BUFFER_ADDRESS != 0L;
    }

    @Override
    public long memoryAddress() {
        if (this.hasMemoryAddress()) {
            return EMPTY_BYTE_BUFFER_ADDRESS;
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isContiguous() {
        return true;
    }

    @Override
    public String toString(Charset charset) {
        return "";
    }

    @Override
    public String toString(int n2, int n3, Charset charset) {
        this.checkIndex(n2, n3);
        return this.toString(charset);
    }

    @Override
    public int hashCode() {
        return 1;
    }

    @Override
    public boolean equals(Object object) {
        return object instanceof ByteBuf && !((ByteBuf)object).isReadable();
    }

    @Override
    public int compareTo(ByteBuf byteBuf) {
        return byteBuf.isReadable() ? -1 : 0;
    }

    @Override
    public String toString() {
        return this.str;
    }

    @Override
    public boolean isWritable(int n2) {
        return false;
    }

    @Override
    public int refCnt() {
        return 1;
    }

    @Override
    public ByteBuf retain() {
        return this;
    }

    @Override
    public ByteBuf touch() {
        return this;
    }

    @Override
    public ByteBuf touch(Object object) {
        return this;
    }

    @Override
    public boolean release() {
        return false;
    }

    private ByteBuf checkIndex(int n2) {
        if (n2 != 0) {
            throw new IndexOutOfBoundsException();
        }
        return this;
    }

    private ByteBuf checkIndex(int n2, int n3) {
        ObjectUtil.checkPositiveOrZero(n3, "length");
        if (n2 != 0 || n3 != 0) {
            throw new IndexOutOfBoundsException();
        }
        return this;
    }

    private ByteBuf checkLength(int n2) {
        ObjectUtil.checkPositiveOrZero(n2, "length");
        if (n2 != 0) {
            throw new IndexOutOfBoundsException();
        }
        return this;
    }

    static {
        long l2 = 0L;
        try {
            if (PlatformDependent.hasUnsafe()) {
                l2 = PlatformDependent.directBufferAddress(EMPTY_BYTE_BUFFER);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        EMPTY_BYTE_BUFFER_ADDRESS = l2;
    }
}

