/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.com.thoughtworks.qdox.model.impl;

import com.gradle.maven.extension.internal.dep.com.thoughtworks.qdox.model.JavaClass;
import com.gradle.maven.extension.internal.dep.com.thoughtworks.qdox.model.JavaMethod;
import com.gradle.maven.extension.internal.dep.com.thoughtworks.qdox.model.JavaParameter;
import com.gradle.maven.extension.internal.dep.com.thoughtworks.qdox.model.JavaType;
import com.gradle.maven.extension.internal.dep.com.thoughtworks.qdox.model.JavaTypeVariable;
import com.gradle.maven.extension.internal.dep.com.thoughtworks.qdox.model.impl.DefaultJavaExecutable;
import com.gradle.maven.extension.internal.dep.com.thoughtworks.qdox.model.impl.DefaultJavaType;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class DefaultJavaMethod
extends DefaultJavaExecutable
implements JavaMethod {
    private boolean defaultMethod;
    private JavaClass returns;
    private List<JavaTypeVariable<JavaMethod>> typeParameters = Collections.emptyList();

    public void setDefault(boolean bl2) {
        this.defaultMethod = bl2;
    }

    public JavaClass getReturns() {
        return this.returns;
    }

    public void setTypeParameters(List<JavaTypeVariable<JavaMethod>> list) {
        this.typeParameters = list;
    }

    public List<JavaTypeVariable<JavaMethod>> getTypeParameters() {
        return this.typeParameters;
    }

    public void setReturns(JavaClass javaClass) {
        this.returns = javaClass;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof JavaMethod)) {
            return false;
        }
        JavaMethod javaMethod = (JavaMethod)object;
        if (javaMethod.getDeclaringClass() != null ? !javaMethod.getDeclaringClass().equals(this.getDeclaringClass()) : this.getDeclaringClass() != null) {
            return false;
        }
        if (javaMethod.getName() != null ? !javaMethod.getName().equals(this.getName()) : this.getName() != null) {
            return false;
        }
        if (javaMethod.getReturnType() != null ? !javaMethod.getReturnType().equals(this.getReturns()) : this.getReturns() != null) {
            return false;
        }
        List<JavaParameter> list = this.getParameters();
        List<JavaParameter> list2 = javaMethod.getParameters();
        if (list2.size() != list.size()) {
            return false;
        }
        for (int i2 = 0; i2 < list.size(); ++i2) {
            if (list2.get(i2).equals(list.get(i2))) continue;
            return false;
        }
        return this.isVarArgs() == javaMethod.isVarArgs();
    }

    public int hashCode() {
        int n2 = 7;
        if (this.getDeclaringClass() != null) {
            n2 *= 31 + this.getDeclaringClass().hashCode();
        }
        if (this.getName() != null) {
            n2 *= 37 + this.getName().hashCode();
        }
        n2 *= 41 + this.getParameters().hashCode();
        if (this.returns != null) {
            n2 *= 43 + this.returns.hashCode();
        }
        return n2;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.isPrivate()) {
            stringBuilder.append("private ");
        } else if (this.isProtected()) {
            stringBuilder.append("protected ");
        } else if (this.isPublic()) {
            stringBuilder.append("public ");
        }
        if (this.isAbstract()) {
            stringBuilder.append("abstract ");
        }
        if (this.isStatic()) {
            stringBuilder.append("static ");
        }
        if (this.isFinal()) {
            stringBuilder.append("final ");
        }
        if (this.isSynchronized()) {
            stringBuilder.append("synchronized ");
        }
        if (this.isNative()) {
            stringBuilder.append("native ");
        }
        stringBuilder.append(this.getReturns().getFullyQualifiedName()).append(' ');
        if (this.getDeclaringClass() != null) {
            stringBuilder.append(this.getDeclaringClass().getBinaryName());
            stringBuilder.append(".");
        }
        stringBuilder.append(this.getName());
        stringBuilder.append("(");
        for (int i2 = 0; i2 < this.getParameters().size(); ++i2) {
            JavaType javaType;
            JavaTypeVariable javaTypeVariable;
            if (i2 > 0) {
                stringBuilder.append(",");
            }
            stringBuilder.append((javaTypeVariable = DefaultJavaType.resolve(javaType = this.getParameters().get(i2).getType(), this.getTypeParameters())) == null ? javaType.getFullyQualifiedName() : javaTypeVariable.getBounds().get(0).getFullyQualifiedName());
        }
        stringBuilder.append(")");
        if (this.getExceptions().size() > 0) {
            stringBuilder.append(" throws ");
            Iterator<JavaClass> iterator = this.getExceptions().iterator();
            while (iterator.hasNext()) {
                stringBuilder.append(iterator.next().getFullyQualifiedName());
                if (!iterator.hasNext()) continue;
                stringBuilder.append(",");
            }
        }
        return stringBuilder.toString();
    }

    @Override
    public JavaType getReturnType() {
        return this.getReturnType(false);
    }

    public JavaType getReturnType(boolean bl2) {
        return this.returns;
    }

    @Override
    public boolean signatureMatches(String string, List<JavaType> list, boolean bl2) {
        if (!string.equals(this.getName())) {
            return false;
        }
        return this.signatureMatches(list, bl2);
    }
}

