/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.com.google.common.collect;

import com.gradle.maven.extension.internal.dep.com.google.common.base.Preconditions;
import com.gradle.maven.extension.internal.dep.com.google.common.base.Supplier;
import com.gradle.maven.extension.internal.dep.com.google.common.collect.CollectPreconditions;
import com.gradle.maven.extension.internal.dep.com.google.common.collect.Multimaps;
import com.gradle.maven.extension.internal.dep.com.google.common.collect.Platform;
import com.gradle.maven.extension.internal.dep.com.google.common.collect.SetMultimap;
import java.io.Serializable;
import java.util.Collection;
import java.util.EnumMap;
import java.util.Map;
import java.util.Set;

public abstract class MultimapBuilder<K0, V0> {
    private MultimapBuilder() {
    }

    public static <K0 extends Enum<K0>> MultimapBuilderWithKeys<K0> enumKeys(final Class<K0> clazz) {
        Preconditions.checkNotNull(clazz);
        return new MultimapBuilderWithKeys<K0>(){

            @Override
            <K extends K0, V> Map<K, Collection<V>> createMap() {
                return new EnumMap(clazz);
            }
        };
    }

    public static abstract class MultimapBuilderWithKeys<K0> {
        MultimapBuilderWithKeys() {
        }

        abstract <K extends K0, V> Map<K, Collection<V>> createMap();

        public SetMultimapBuilder<K0, Object> hashSetValues() {
            return this.hashSetValues(2);
        }

        public SetMultimapBuilder<K0, Object> hashSetValues(final int n2) {
            CollectPreconditions.checkNonnegative(n2, "expectedValuesPerKey");
            return new SetMultimapBuilder<K0, Object>(this){
                final /* synthetic */ MultimapBuilderWithKeys this$0;
                {
                    this.this$0 = multimapBuilderWithKeys;
                }

                @Override
                public <K extends K0, V> SetMultimap<K, V> build() {
                    return Multimaps.newSetMultimap(this.this$0.createMap(), new HashSetSupplier(n2));
                }
            };
        }
    }

    public static abstract class SetMultimapBuilder<K0, V0>
    extends MultimapBuilder<K0, V0> {
        SetMultimapBuilder() {
        }

        public abstract <K extends K0, V extends V0> SetMultimap<K, V> build();
    }

    private static final class HashSetSupplier<V>
    implements Supplier<Set<V>>,
    Serializable {
        private final int expectedValuesPerKey;

        HashSetSupplier(int n2) {
            this.expectedValuesPerKey = CollectPreconditions.checkNonnegative(n2, "expectedValuesPerKey");
        }

        @Override
        public Set<V> get() {
            return Platform.newHashSetWithExpectedSize(this.expectedValuesPerKey);
        }
    }
}

