/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.ser.impl;

import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.annotation.JsonInclude;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.core.JsonGenerator;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.core.JsonToken;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.core.type.WritableTypeId;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.BeanProperty;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.JavaType;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.JsonMappingException;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.JsonSerializer;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.SerializerProvider;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.annotation.JacksonStdImpl;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.introspect.AnnotatedMember;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.ser.ContainerSerializer;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.ser.ContextualSerializer;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.ser.impl.PropertySerializerMap;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.util.ArrayBuilders;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.util.BeanUtil;
import java.io.IOException;
import java.util.Map;

@JacksonStdImpl
public class MapEntrySerializer
extends ContainerSerializer<Map.Entry<?, ?>>
implements ContextualSerializer {
    public static final Object MARKER_FOR_EMPTY = JsonInclude.Include.NON_EMPTY;
    protected final BeanProperty _property;
    protected final boolean _valueTypeIsStatic;
    protected final JavaType _entryType;
    protected final JavaType _keyType;
    protected final JavaType _valueType;
    protected JsonSerializer<Object> _keySerializer;
    protected JsonSerializer<Object> _valueSerializer;
    protected final TypeSerializer _valueTypeSerializer;
    protected PropertySerializerMap _dynamicValueSerializers;
    protected final Object _suppressableValue;
    protected final boolean _suppressNulls;

    public MapEntrySerializer(JavaType javaType, JavaType javaType2, JavaType javaType3, boolean bl2, TypeSerializer typeSerializer, BeanProperty beanProperty) {
        super(javaType);
        this._entryType = javaType;
        this._keyType = javaType2;
        this._valueType = javaType3;
        this._valueTypeIsStatic = bl2;
        this._valueTypeSerializer = typeSerializer;
        this._property = beanProperty;
        this._dynamicValueSerializers = PropertySerializerMap.emptyForProperties();
        this._suppressableValue = null;
        this._suppressNulls = false;
    }

    protected MapEntrySerializer(MapEntrySerializer mapEntrySerializer, BeanProperty beanProperty, TypeSerializer typeSerializer, JsonSerializer<?> jsonSerializer, JsonSerializer<?> jsonSerializer2, Object object, boolean bl2) {
        super(Map.class, false);
        this._entryType = mapEntrySerializer._entryType;
        this._keyType = mapEntrySerializer._keyType;
        this._valueType = mapEntrySerializer._valueType;
        this._valueTypeIsStatic = mapEntrySerializer._valueTypeIsStatic;
        this._valueTypeSerializer = mapEntrySerializer._valueTypeSerializer;
        this._keySerializer = jsonSerializer;
        this._valueSerializer = jsonSerializer2;
        this._dynamicValueSerializers = PropertySerializerMap.emptyForProperties();
        this._property = mapEntrySerializer._property;
        this._suppressableValue = object;
        this._suppressNulls = bl2;
    }

    @Override
    public ContainerSerializer<?> _withValueTypeSerializer(TypeSerializer typeSerializer) {
        return new MapEntrySerializer(this, this._property, typeSerializer, this._keySerializer, this._valueSerializer, this._suppressableValue, this._suppressNulls);
    }

    public MapEntrySerializer withResolved(BeanProperty beanProperty, JsonSerializer<?> jsonSerializer, JsonSerializer<?> jsonSerializer2, Object object, boolean bl2) {
        return new MapEntrySerializer(this, beanProperty, this._valueTypeSerializer, jsonSerializer, jsonSerializer2, object, bl2);
    }

    public MapEntrySerializer withContentInclusion(Object object, boolean bl2) {
        if (this._suppressableValue == object && this._suppressNulls == bl2) {
            return this;
        }
        return new MapEntrySerializer(this, this._property, this._valueTypeSerializer, this._keySerializer, this._valueSerializer, object, bl2);
    }

    @Override
    public JsonSerializer<?> createContextual(SerializerProvider serializerProvider, BeanProperty beanProperty) throws JsonMappingException {
        JsonInclude.Include include;
        JsonInclude.Value value;
        Object object;
        AnnotatedMember annotatedMember;
        JsonSerializer<Object> jsonSerializer = null;
        JsonSerializer<Object> jsonSerializer2 = null;
        AnnotationIntrospector annotationIntrospector = serializerProvider.getAnnotationIntrospector();
        AnnotatedMember annotatedMember2 = annotatedMember = beanProperty == null ? null : beanProperty.getMember();
        if (annotatedMember != null && annotationIntrospector != null) {
            object = annotationIntrospector.findKeySerializer(annotatedMember);
            if (object != null) {
                jsonSerializer2 = serializerProvider.serializerInstance(annotatedMember, object);
            }
            if ((object = annotationIntrospector.findContentSerializer(annotatedMember)) != null) {
                jsonSerializer = serializerProvider.serializerInstance(annotatedMember, object);
            }
        }
        if (jsonSerializer == null) {
            jsonSerializer = this._valueSerializer;
        }
        if ((jsonSerializer = this.findContextualConvertingSerializer(serializerProvider, beanProperty, jsonSerializer)) == null && this._valueTypeIsStatic && !this._valueType.isJavaLangObject()) {
            jsonSerializer = serializerProvider.findContentValueSerializer(this._valueType, beanProperty);
        }
        if (jsonSerializer2 == null) {
            jsonSerializer2 = this._keySerializer;
        }
        jsonSerializer2 = jsonSerializer2 == null ? serializerProvider.findKeySerializer(this._keyType, beanProperty) : serializerProvider.handleSecondaryContextualization(jsonSerializer2, beanProperty);
        object = this._suppressableValue;
        boolean bl2 = this._suppressNulls;
        if (beanProperty != null && (value = beanProperty.findPropertyInclusion(serializerProvider.getConfig(), null)) != null && (include = value.getContentInclusion()) != JsonInclude.Include.USE_DEFAULTS) {
            switch (include) {
                case NON_DEFAULT: {
                    object = BeanUtil.getDefaultValue(this._valueType);
                    bl2 = true;
                    if (object == null || !object.getClass().isArray()) break;
                    object = ArrayBuilders.getArrayComparator(object);
                    break;
                }
                case NON_ABSENT: {
                    bl2 = true;
                    object = this._valueType.isReferenceType() ? MARKER_FOR_EMPTY : null;
                    break;
                }
                case NON_EMPTY: {
                    bl2 = true;
                    object = MARKER_FOR_EMPTY;
                    break;
                }
                case CUSTOM: {
                    object = serializerProvider.includeFilterInstance(null, value.getContentFilter());
                    if (object == null) {
                        bl2 = true;
                        break;
                    }
                    bl2 = serializerProvider.includeFilterSuppressNulls(object);
                    break;
                }
                case NON_NULL: {
                    object = null;
                    bl2 = true;
                    break;
                }
                default: {
                    object = null;
                    bl2 = false;
                }
            }
        }
        return this.withResolved(beanProperty, jsonSerializer2, jsonSerializer, object, bl2);
    }

    public JavaType getContentType() {
        return this._valueType;
    }

    @Override
    public boolean hasSingleElement(Map.Entry<?, ?> entry) {
        return true;
    }

    @Override
    public boolean isEmpty(SerializerProvider serializerProvider, Map.Entry<?, ?> entry) {
        Class<?> clazz;
        Object obj = entry.getValue();
        if (obj == null) {
            return this._suppressNulls;
        }
        if (this._suppressableValue == null) {
            return false;
        }
        JsonSerializer<Object> jsonSerializer = this._valueSerializer;
        if (jsonSerializer == null && (jsonSerializer = this._dynamicValueSerializers.serializerFor(clazz = obj.getClass())) == null) {
            try {
                jsonSerializer = this._findAndAddDynamic(this._dynamicValueSerializers, clazz, serializerProvider);
            }
            catch (JsonMappingException jsonMappingException) {
                return false;
            }
        }
        if (this._suppressableValue == MARKER_FOR_EMPTY) {
            return jsonSerializer.isEmpty(serializerProvider, obj);
        }
        return this._suppressableValue.equals(obj);
    }

    @Override
    public void serialize(Map.Entry<?, ?> entry, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
        jsonGenerator.writeStartObject(entry);
        this.serializeDynamic(entry, jsonGenerator, serializerProvider);
        jsonGenerator.writeEndObject();
    }

    @Override
    public void serializeWithType(Map.Entry<?, ?> entry, JsonGenerator jsonGenerator, SerializerProvider serializerProvider, TypeSerializer typeSerializer) throws IOException {
        jsonGenerator.assignCurrentValue(entry);
        WritableTypeId writableTypeId = typeSerializer.writeTypePrefix(jsonGenerator, typeSerializer.typeId(entry, JsonToken.START_OBJECT));
        this.serializeDynamic(entry, jsonGenerator, serializerProvider);
        typeSerializer.writeTypeSuffix(jsonGenerator, writableTypeId);
    }

    protected void serializeDynamic(Map.Entry<?, ?> entry, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
        JsonSerializer<Object> jsonSerializer;
        TypeSerializer typeSerializer = this._valueTypeSerializer;
        Object obj = entry.getKey();
        JsonSerializer<Object> jsonSerializer2 = obj == null ? serializerProvider.findNullKeySerializer(this._keyType, this._property) : this._keySerializer;
        Object obj2 = entry.getValue();
        if (obj2 == null) {
            if (this._suppressNulls) {
                return;
            }
            jsonSerializer = serializerProvider.getDefaultNullValueSerializer();
        } else {
            Class<?> clazz;
            jsonSerializer = this._valueSerializer;
            if (jsonSerializer == null && (jsonSerializer = this._dynamicValueSerializers.serializerFor(clazz = obj2.getClass())) == null) {
                jsonSerializer = this._valueType.hasGenericTypes() ? this._findAndAddDynamic(this._dynamicValueSerializers, serializerProvider.constructSpecializedType(this._valueType, clazz), serializerProvider) : this._findAndAddDynamic(this._dynamicValueSerializers, clazz, serializerProvider);
            }
            if (this._suppressableValue != null) {
                if (this._suppressableValue == MARKER_FOR_EMPTY && jsonSerializer.isEmpty(serializerProvider, obj2)) {
                    return;
                }
                if (this._suppressableValue.equals(obj2)) {
                    return;
                }
            }
        }
        jsonSerializer2.serialize(obj, jsonGenerator, serializerProvider);
        try {
            if (typeSerializer == null) {
                jsonSerializer.serialize(obj2, jsonGenerator, serializerProvider);
            } else {
                jsonSerializer.serializeWithType(obj2, jsonGenerator, serializerProvider, typeSerializer);
            }
        }
        catch (Exception exception) {
            String string = "" + obj;
            this.wrapAndThrow(serializerProvider, (Throwable)exception, entry, string);
        }
    }

    protected final JsonSerializer<Object> _findAndAddDynamic(PropertySerializerMap propertySerializerMap, Class<?> clazz, SerializerProvider serializerProvider) throws JsonMappingException {
        PropertySerializerMap.SerializerAndMapResult serializerAndMapResult = propertySerializerMap.findAndAddSecondarySerializer(clazz, serializerProvider, this._property);
        if (propertySerializerMap != serializerAndMapResult.map) {
            this._dynamicValueSerializers = serializerAndMapResult.map;
        }
        return serializerAndMapResult.serializer;
    }

    protected final JsonSerializer<Object> _findAndAddDynamic(PropertySerializerMap propertySerializerMap, JavaType javaType, SerializerProvider serializerProvider) throws JsonMappingException {
        PropertySerializerMap.SerializerAndMapResult serializerAndMapResult = propertySerializerMap.findAndAddSecondarySerializer(javaType, serializerProvider, this._property);
        if (propertySerializerMap != serializerAndMapResult.map) {
            this._dynamicValueSerializers = serializerAndMapResult.map;
        }
        return serializerAndMapResult.serializer;
    }
}

