/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.com.ctc.wstx.sr;

import com.gradle.maven.extension.internal.dep.com.ctc.wstx.api.ReaderConfig;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.cfg.ErrorConsts;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.sr.Attribute;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.sr.ElemAttrs;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.sr.InputProblemReporter;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.sw.XmlWriter;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.util.DataUtil;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.util.InternCache;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.util.StringUtil;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.util.StringVector;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.util.TextBuilder;
import com.gradle.maven.extension.internal.dep.org.codehaus.stax2.ri.typed.CharArrayBase64Decoder;
import com.gradle.maven.extension.internal.dep.org.codehaus.stax2.ri.typed.ValueDecoderFactory;
import com.gradle.maven.extension.internal.dep.org.codehaus.stax2.typed.Base64Variant;
import com.gradle.maven.extension.internal.dep.org.codehaus.stax2.typed.TypedArrayDecoder;
import com.gradle.maven.extension.internal.dep.org.codehaus.stax2.typed.TypedValueDecoder;
import com.gradle.maven.extension.internal.dep.org.codehaus.stax2.typed.TypedXMLStreamException;
import com.gradle.maven.extension.internal.dep.org.codehaus.stax2.validation.XMLValidator;
import java.io.IOException;
import java.util.Arrays;
import javax.xml.namespace.QName;
import javax.xml.stream.Location;
import javax.xml.stream.XMLStreamException;

public final class AttributeCollector {
    protected static final int INT_SPACE = 32;
    protected static final int LONG_ATTR_LIST_LEN = 4;
    protected static final int EXP_ATTR_COUNT = 12;
    protected static final int EXP_NS_COUNT = 6;
    protected static final int XMLID_IX_DISABLED = -2;
    protected static final int XMLID_IX_NONE = -1;
    protected static final InternCache sInternCache = InternCache.getInstance();
    protected final String mXmlIdPrefix;
    protected final String mXmlIdLocalName;
    protected Attribute[] mAttributes;
    protected int mAttrCount;
    protected int mNonDefCount;
    protected Attribute[] mNamespaces;
    protected int mNsCount;
    protected boolean mDefaultNsDeclared = false;
    protected int mXmlIdAttrIndex;
    protected TextBuilder mValueBuilder = null;
    private final TextBuilder mNamespaceBuilder = new TextBuilder(6);
    protected int[] mAttrMap = null;
    protected int mAttrHashSize;
    protected int mAttrSpillEnd;
    protected int mMaxAttributesPerElement;

    protected AttributeCollector(ReaderConfig readerConfig, boolean bl2) {
        int n2 = this.mXmlIdAttrIndex = readerConfig.willDoXmlIdTyping() ? -1 : -2;
        if (bl2) {
            this.mXmlIdPrefix = "xml";
            this.mXmlIdLocalName = "id";
        } else {
            this.mXmlIdPrefix = null;
            this.mXmlIdLocalName = "xml:id";
        }
        this.mMaxAttributesPerElement = readerConfig.getMaxAttributesPerElement();
    }

    public void reset() {
        if (this.mNsCount > 0) {
            this.mNamespaceBuilder.reset();
            this.mDefaultNsDeclared = false;
            this.mNsCount = 0;
        }
        if (this.mAttrCount > 0) {
            this.mValueBuilder.reset();
            this.mAttrCount = 0;
            if (this.mXmlIdAttrIndex >= 0) {
                this.mXmlIdAttrIndex = -1;
            }
        }
    }

    public void normalizeSpacesInValue(int n2) {
        char[] cArray = this.mValueBuilder.getCharBuffer();
        String string = StringUtil.normalizeSpaces(cArray, this.getValueStartOffset(n2), this.getValueStartOffset(n2 + 1));
        if (string != null) {
            this.mAttributes[n2].setValue(string);
        }
    }

    protected int getNsCount() {
        return this.mNsCount;
    }

    public boolean hasDefaultNs() {
        return this.mDefaultNsDeclared;
    }

    public final int getCount() {
        return this.mAttrCount;
    }

    public int getSpecifiedCount() {
        return this.mNonDefCount;
    }

    public String getNsPrefix(int n2) {
        if (n2 < 0 || n2 >= this.mNsCount) {
            this.throwIndex(n2);
        }
        return this.mNamespaces[n2].mLocalName;
    }

    public String getNsURI(int n2) {
        if (n2 < 0 || n2 >= this.mNsCount) {
            this.throwIndex(n2);
        }
        return this.mNamespaces[n2].mNamespaceURI;
    }

    public String getPrefix(int n2) {
        if (n2 < 0 || n2 >= this.mAttrCount) {
            this.throwIndex(n2);
        }
        return this.mAttributes[n2].mPrefix;
    }

    public String getLocalName(int n2) {
        if (n2 < 0 || n2 >= this.mAttrCount) {
            this.throwIndex(n2);
        }
        return this.mAttributes[n2].mLocalName;
    }

    public String getURI(int n2) {
        if (n2 < 0 || n2 >= this.mAttrCount) {
            this.throwIndex(n2);
        }
        return this.mAttributes[n2].mNamespaceURI;
    }

    public QName getQName(int n2) {
        if (n2 < 0 || n2 >= this.mAttrCount) {
            this.throwIndex(n2);
        }
        return this.mAttributes[n2].getQName();
    }

    public final String getValue(int n2) {
        if (n2 < 0 || n2 >= this.mAttrCount) {
            this.throwIndex(n2);
        }
        String string = this.mValueBuilder.getAllValues();
        Attribute attribute = this.mAttributes[n2];
        if (++n2 < this.mAttrCount) {
            int n3 = this.mAttributes[n2].mValueStartOffset;
            return attribute.getValue(string, n3);
        }
        return attribute.getValue(string);
    }

    public String getValue(String string, String string2) {
        int n2;
        int n3 = this.mAttrHashSize;
        if (n3 == 0) {
            return null;
        }
        int n4 = string2.hashCode();
        if (string != null) {
            if (string.length() == 0) {
                string = null;
            } else {
                n4 ^= string.hashCode();
            }
        }
        if ((n2 = this.mAttrMap[n4 & n3 - 1]) == 0) {
            return null;
        }
        if (this.mAttributes[--n2].hasQName(string, string2)) {
            return this.getValue(n2);
        }
        int n5 = this.mAttrSpillEnd;
        for (int i2 = n3; i2 < n5; i2 += 2) {
            if (this.mAttrMap[i2] != n4 || !this.mAttributes[n2 = this.mAttrMap[i2 + 1]].hasQName(string, string2)) continue;
            return this.getValue(n2);
        }
        return null;
    }

    public String getValueByLocalName(String string) {
        switch (this.mAttrCount) {
            case 4: {
                if (this.mAttributes[0].hasLocalName(string)) {
                    return this.getValue(0);
                }
                if (this.mAttributes[1].hasLocalName(string)) {
                    return this.getValue(1);
                }
                if (this.mAttributes[2].hasLocalName(string)) {
                    return this.getValue(2);
                }
                if (this.mAttributes[3].hasLocalName(string)) {
                    return this.getValue(3);
                }
                return null;
            }
            case 3: {
                if (this.mAttributes[0].hasLocalName(string)) {
                    return this.getValue(0);
                }
                if (this.mAttributes[1].hasLocalName(string)) {
                    return this.getValue(1);
                }
                if (this.mAttributes[2].hasLocalName(string)) {
                    return this.getValue(2);
                }
                return null;
            }
            case 2: {
                if (this.mAttributes[0].hasLocalName(string)) {
                    return this.getValue(0);
                }
                if (this.mAttributes[1].hasLocalName(string)) {
                    return this.getValue(1);
                }
                return null;
            }
            case 1: {
                if (this.mAttributes[0].hasLocalName(string)) {
                    return this.getValue(0);
                }
                return null;
            }
            case 0: {
                return null;
            }
        }
        int n2 = this.mAttrCount;
        for (int i2 = 0; i2 < n2; ++i2) {
            if (!this.mAttributes[i2].hasLocalName(string)) continue;
            return this.getValue(i2);
        }
        return null;
    }

    public int getMaxAttributesPerElement() {
        return this.mMaxAttributesPerElement;
    }

    public void setMaxAttributesPerElement(int n2) {
        this.mMaxAttributesPerElement = n2;
    }

    public int findIndex(String string) {
        return this.findIndex(null, string);
    }

    public int findIndex(String string, String string2) {
        int n2;
        int n3 = this.mAttrHashSize;
        if (n3 == 0) {
            return -1;
        }
        int n4 = string2.hashCode();
        if (string != null) {
            if (string.length() == 0) {
                string = null;
            } else {
                n4 ^= string.hashCode();
            }
        }
        if ((n2 = this.mAttrMap[n4 & n3 - 1]) == 0) {
            return -1;
        }
        if (this.mAttributes[--n2].hasQName(string, string2)) {
            return n2;
        }
        int n5 = this.mAttrSpillEnd;
        for (int i2 = n3; i2 < n5; i2 += 2) {
            if (this.mAttrMap[i2] != n4 || !this.mAttributes[n2 = this.mAttrMap[i2 + 1]].hasQName(string, string2)) continue;
            return n2;
        }
        return -1;
    }

    public final boolean isSpecified(int n2) {
        return n2 < this.mNonDefCount;
    }

    public final int getXmlIdAttrIndex() {
        return this.mXmlIdAttrIndex;
    }

    public final void decodeValue(int n2, TypedValueDecoder typedValueDecoder) throws IllegalArgumentException {
        if (n2 < 0 || n2 >= this.mAttrCount) {
            this.throwIndex(n2);
        }
        char[] cArray = this.mValueBuilder.getCharBuffer();
        int n3 = this.mAttributes[n2].mValueStartOffset;
        int n4 = this.getValueStartOffset(n2 + 1);
        while (true) {
            if (n3 >= n4) {
                typedValueDecoder.handleEmptyValue();
                return;
            }
            if (!StringUtil.isSpace(cArray[n3])) break;
            ++n3;
        }
        while (--n4 > n3 && StringUtil.isSpace(cArray[n4])) {
        }
        typedValueDecoder.decode(cArray, n3, n4 + 1);
    }

    public final int decodeValues(int n2, TypedArrayDecoder typedArrayDecoder, InputProblemReporter inputProblemReporter) throws XMLStreamException {
        if (n2 < 0 || n2 >= this.mAttrCount) {
            this.throwIndex(n2);
        }
        return AttributeCollector.decodeValues(typedArrayDecoder, inputProblemReporter, this.mValueBuilder.getCharBuffer(), this.mAttributes[n2].mValueStartOffset, this.getValueStartOffset(n2 + 1));
    }

    public final byte[] decodeBinary(int n2, Base64Variant base64Variant, CharArrayBase64Decoder charArrayBase64Decoder, InputProblemReporter inputProblemReporter) throws XMLStreamException {
        if (n2 < 0 || n2 >= this.mAttrCount) {
            this.throwIndex(n2);
        }
        Attribute attribute = this.mAttributes[n2];
        char[] cArray = this.mValueBuilder.getCharBuffer();
        int n3 = attribute.mValueStartOffset;
        int n4 = this.getValueStartOffset(n2 + 1);
        int n5 = n4 - n3;
        charArrayBase64Decoder.init(base64Variant, true, cArray, n3, n5, null);
        try {
            return charArrayBase64Decoder.decodeCompletely();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            String string = new String(cArray, n3, n5);
            throw new TypedXMLStreamException(string, illegalArgumentException.getMessage(), inputProblemReporter.getLocation(), illegalArgumentException);
        }
    }

    private static final int decodeValues(TypedArrayDecoder typedArrayDecoder, InputProblemReporter inputProblemReporter, char[] cArray, int n2, int n3) throws XMLStreamException {
        int n4;
        block5: {
            int n5 = n2;
            n4 = 0;
            try {
                while (n2 < n3) {
                    while (cArray[n2] <= ' ') {
                        if (++n2 < n3) continue;
                        break block5;
                    }
                    n5 = n2++;
                    while (n2 < n3 && cArray[n2] > ' ') {
                        ++n2;
                    }
                    int n6 = n2++;
                    ++n4;
                    if (!typedArrayDecoder.decodeValue(cArray, n5, n6) || AttributeCollector.checkExpand(typedArrayDecoder)) continue;
                    break;
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                Location location = inputProblemReporter.getLocation();
                String string = new String(cArray, n5, n2 - n5);
                throw new TypedXMLStreamException(string, illegalArgumentException.getMessage(), location, illegalArgumentException);
            }
        }
        return n4;
    }

    private static final boolean checkExpand(TypedArrayDecoder typedArrayDecoder) {
        if (typedArrayDecoder instanceof ValueDecoderFactory.BaseArrayDecoder) {
            ((ValueDecoderFactory.BaseArrayDecoder)typedArrayDecoder).expand();
            return true;
        }
        return false;
    }

    protected int getValueStartOffset(int n2) {
        if (n2 < this.mAttrCount) {
            return this.mAttributes[n2].mValueStartOffset;
        }
        return this.mValueBuilder.getCharSize();
    }

    protected char[] getSharedValueBuffer() {
        return this.mValueBuilder.getCharBuffer();
    }

    protected Attribute resolveNamespaceDecl(int n2, boolean bl2) {
        String string;
        Attribute attribute = this.mNamespaces[n2];
        String string2 = this.mNamespaceBuilder.getAllValues();
        if (this.mNsCount == 0) {
            string = string2;
        } else if (++n2 < this.mNsCount) {
            int n3 = this.mNamespaces[n2].mValueStartOffset;
            string = attribute.getValue(string2, n3);
        } else {
            string = attribute.getValue(string2);
        }
        if (bl2 && string.length() > 0) {
            string = sInternCache.intern(string);
        }
        attribute.mNamespaceURI = string;
        return attribute;
    }

    public ElemAttrs buildAttrOb() {
        Object object;
        int n2;
        int n3 = this.mAttrCount;
        if (n3 == 0) {
            return null;
        }
        String[] stringArray = new String[n3 << 2];
        for (n2 = 0; n2 < n3; ++n2) {
            object = this.mAttributes[n2];
            int n4 = n2 << 2;
            stringArray[n4] = ((Attribute)object).mLocalName;
            stringArray[n4 + 1] = ((Attribute)object).mNamespaceURI;
            stringArray[n4 + 2] = ((Attribute)object).mPrefix;
            stringArray[n4 + 3] = this.getValue(n2);
        }
        if (n3 < 4) {
            return new ElemAttrs(stringArray, this.mNonDefCount);
        }
        n2 = this.mAttrMap.length;
        object = new int[n2];
        System.arraycopy(this.mAttrMap, 0, object, 0, n2);
        return new ElemAttrs(stringArray, this.mNonDefCount, (int[])object, this.mAttrHashSize, this.mAttrSpillEnd);
    }

    protected void validateAttribute(int n2, XMLValidator xMLValidator) throws XMLStreamException {
        Attribute attribute = this.mAttributes[n2];
        String string = xMLValidator.validateAttribute(attribute.mLocalName, attribute.mNamespaceURI, attribute.mPrefix, this.mValueBuilder.getCharBuffer(), this.getValueStartOffset(n2), this.getValueStartOffset(n2 + 1));
        if (string != null) {
            attribute.setValue(string);
        }
    }

    public final TextBuilder getAttrBuilder(String string, String string2) throws XMLStreamException {
        if (this.mAttrCount == 0) {
            if (this.mAttributes == null) {
                this.allocBuffers();
            }
            this.mAttributes[0] = new Attribute(string, string2, 0);
        } else {
            Attribute attribute;
            int n2 = this.mValueBuilder.getCharSize();
            if (this.mAttrCount >= this.mAttributes.length) {
                if (this.mAttrCount + this.mNsCount >= this.mMaxAttributesPerElement) {
                    throw new XMLStreamException("Attribute limit (" + this.mMaxAttributesPerElement + ") exceeded");
                }
                this.mAttributes = (Attribute[])DataUtil.growArrayToAtMost(this.mAttributes, this.mMaxAttributesPerElement);
            }
            if ((attribute = this.mAttributes[this.mAttrCount]) == null) {
                this.mAttributes[this.mAttrCount] = new Attribute(string, string2, n2);
            } else {
                attribute.reset(string, string2, n2);
            }
        }
        ++this.mAttrCount;
        if (string2 == this.mXmlIdLocalName && string == this.mXmlIdPrefix && this.mXmlIdAttrIndex != -2) {
            this.mXmlIdAttrIndex = this.mAttrCount - 1;
        }
        return this.mValueBuilder;
    }

    public int addDefaultAttribute(String string, String string2, String string3, String string4) throws XMLStreamException {
        int n2;
        int[] nArray;
        int n3 = this.mAttrCount;
        if (n3 < 1) {
            this.initHashArea();
        }
        int n4 = string.hashCode();
        if (string2 != null && string2.length() > 0) {
            n4 ^= string2.hashCode();
        }
        if ((nArray = this.mAttrMap)[n2 = n4 & this.mAttrHashSize - 1] == 0) {
            nArray[n2] = n3 + 1;
        } else {
            int n5 = nArray[n2] - 1;
            int n6 = this.mAttrSpillEnd;
            if ((nArray = this.spillAttr(string2, string, nArray, n5, n6, n4, this.mAttrHashSize)) == null) {
                return -1;
            }
            nArray[++n6] = n3;
            this.mAttrMap = nArray;
            this.mAttrSpillEnd = ++n6;
        }
        this.getAttrBuilder(string3, string);
        Attribute attribute = this.mAttributes[this.mAttrCount - 1];
        attribute.mNamespaceURI = string2;
        attribute.setValue(string4);
        return this.mAttrCount - 1;
    }

    public final void setNormalizedValue(int n2, String string) {
        this.mAttributes[n2].setValue(string);
    }

    public TextBuilder getDefaultNsBuilder() throws XMLStreamException {
        if (this.mDefaultNsDeclared) {
            return null;
        }
        this.mDefaultNsDeclared = true;
        return this.getNsBuilder(null);
    }

    public TextBuilder getNsBuilder(String string) throws XMLStreamException {
        if (this.mNsCount == 0) {
            if (this.mNamespaces == null) {
                this.mNamespaces = new Attribute[Math.min(6, this.mMaxAttributesPerElement)];
            }
            this.mNamespaces[0] = new Attribute(null, string, 0);
        } else {
            int n2;
            int n3 = this.mNsCount;
            if (string != null) {
                for (n2 = 0; n2 < n3; ++n2) {
                    if (string != this.mNamespaces[n2].mLocalName) continue;
                    return null;
                }
            }
            if (n3 >= this.mNamespaces.length) {
                if (this.mAttrCount + this.mNsCount >= this.mMaxAttributesPerElement) {
                    throw new XMLStreamException("Attribute limit (" + this.mMaxAttributesPerElement + ") exceeded");
                }
                this.mNamespaces = (Attribute[])DataUtil.growArrayToAtMost(this.mNamespaces, this.mMaxAttributesPerElement);
            }
            n2 = this.mNamespaceBuilder.getCharSize();
            Attribute attribute = this.mNamespaces[n3];
            if (attribute == null) {
                this.mNamespaces[n3] = new Attribute(null, string, n2);
            } else {
                attribute.reset(null, string, n2);
            }
        }
        ++this.mNsCount;
        return this.mNamespaceBuilder;
    }

    public int resolveNamespaces(InputProblemReporter inputProblemReporter, StringVector stringVector) throws XMLStreamException {
        int n2;
        int n3;
        this.mNonDefCount = n3 = this.mAttrCount;
        if (n3 < 1) {
            this.mAttrSpillEnd = 0;
            this.mAttrHashSize = 0;
            return this.mXmlIdAttrIndex;
        }
        for (int i2 = 0; i2 < n3; ++i2) {
            Attribute attribute = this.mAttributes[i2];
            String string = attribute.mPrefix;
            if (string == null) continue;
            if (string == "xml") {
                attribute.mNamespaceURI = "http://www.w3.org/XML/1998/namespace";
                continue;
            }
            String string2 = stringVector.findLastFromMap(string);
            if (string2 == null) {
                inputProblemReporter.throwParseError(ErrorConsts.ERR_NS_UNDECLARED_FOR_ATTR, string, attribute.mLocalName);
            }
            attribute.mNamespaceURI = string2;
        }
        int[] nArray = this.mAttrMap;
        int n4 = n3 + (n3 >> 2);
        for (n2 = 4; n2 < n4; n2 += n2) {
        }
        this.mAttrHashSize = n2;
        n4 = n2 + (n2 >> 4);
        if (nArray == null || nArray.length < n4) {
            nArray = new int[n4];
        } else {
            Arrays.fill(nArray, 0, n2, 0);
        }
        n4 = n2 - 1;
        int n5 = n2;
        for (int i3 = 0; i3 < n3; ++i3) {
            int n6;
            Attribute attribute = this.mAttributes[i3];
            String string = attribute.mLocalName;
            int n7 = string.hashCode();
            String string3 = attribute.mNamespaceURI;
            if (string3 != null) {
                n7 ^= string3.hashCode();
            }
            if (nArray[n6 = n7 & n4] == 0) {
                nArray[n6] = i3 + 1;
                continue;
            }
            int n8 = nArray[n6] - 1;
            if ((nArray = this.spillAttr(string3, string, nArray, n8, n5, n7, n2)) == null) {
                this.throwDupAttr(inputProblemReporter, n8);
                continue;
            }
            nArray[++n5] = i3;
            ++n5;
        }
        this.mAttrSpillEnd = n5;
        this.mAttrMap = nArray;
        return this.mXmlIdAttrIndex;
    }

    protected void throwIndex(int n2) {
        throw new IllegalArgumentException("Invalid index " + n2 + "; current element has only " + this.getCount() + " attributes");
    }

    @Deprecated
    public void writeAttribute(int n2, XmlWriter xmlWriter) throws IOException, XMLStreamException {
        this.writeAttribute(n2, xmlWriter, null);
    }

    public void writeAttribute(int n2, XmlWriter xmlWriter, XMLValidator xMLValidator) throws IOException, XMLStreamException {
        Attribute attribute = this.mAttributes[n2];
        String string = attribute.mLocalName;
        String string2 = attribute.mPrefix;
        String string3 = this.getValue(n2);
        if (string2 == null || string2.length() == 0) {
            xmlWriter.writeAttribute(string, string3);
        } else {
            xmlWriter.writeAttribute(string2, string, string3);
        }
        if (xMLValidator != null) {
            xMLValidator.validateAttribute(string, attribute.mNamespaceURI, string2, string3);
        }
    }

    protected final void allocBuffers() {
        if (this.mAttributes == null) {
            this.mAttributes = new Attribute[Math.min(8, this.mMaxAttributesPerElement)];
        }
        if (this.mValueBuilder == null) {
            this.mValueBuilder = new TextBuilder(12);
        }
    }

    private int[] spillAttr(String string, String string2, int[] nArray, int n2, int n3, int n4, int n5) {
        String string3;
        Attribute attribute = this.mAttributes[n2];
        if (attribute.mLocalName == string2 && ((string3 = attribute.mNamespaceURI) == string || string3 != null && string3.equals(string))) {
            return null;
        }
        if (n3 + 1 >= nArray.length) {
            nArray = DataUtil.growArrayBy(nArray, 8);
        }
        for (int i2 = n5; i2 < n3; i2 += 2) {
            String string4;
            if (nArray[i2] != n4) continue;
            n2 = nArray[i2 + 1];
            Attribute attribute2 = this.mAttributes[n2];
            if (attribute2.mLocalName != string2 || (string4 = attribute2.mNamespaceURI) != string && (string4 == null || !string4.equals(string))) continue;
            return null;
        }
        nArray[n3] = n4;
        return nArray;
    }

    private void initHashArea() {
        this.mAttrSpillEnd = 4;
        this.mAttrHashSize = 4;
        if (this.mAttrMap == null || this.mAttrMap.length < this.mAttrHashSize) {
            this.mAttrMap = new int[this.mAttrHashSize + 1];
        }
        this.mAttrMap[3] = 0;
        this.mAttrMap[2] = 0;
        this.mAttrMap[1] = 0;
        this.mAttrMap[0] = 0;
        this.allocBuffers();
    }

    protected void throwDupAttr(InputProblemReporter inputProblemReporter, int n2) throws XMLStreamException {
        inputProblemReporter.throwParseError("Duplicate attribute '" + this.getQName(n2) + "'.");
    }
}

