/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.verifier.regexp;

import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.datatype.xsd.XSDatatype;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.grammar.AttributeExp;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.grammar.BinaryExp;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.grammar.ChoiceExp;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.grammar.ConcurExp;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.grammar.DataExp;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.grammar.ElementExp;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.grammar.Expression;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.grammar.ExpressionVisitor;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.grammar.InterleaveExp;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.grammar.ListExp;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.grammar.MixedExp;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.grammar.OneOrMoreExp;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.grammar.OtherExp;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.grammar.ReferenceExp;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.grammar.SequenceExp;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.grammar.ValueExp;

public class StringCareLevelCalculator
implements ExpressionVisitor {
    protected static final StringCareLevelCalculator theInstance = new StringCareLevelCalculator();
    private static final String ANY_STRING = "anyString";
    private static final String NO_STRING = "noString";
    private static final String SOME_STRING = "someString";

    protected StringCareLevelCalculator() {
    }

    @Override
    public Object onAttribute(AttributeExp attributeExp) {
        return NO_STRING;
    }

    @Override
    public Object onElement(ElementExp elementExp) {
        return NO_STRING;
    }

    @Override
    public Object onMixed(MixedExp mixedExp) {
        return ANY_STRING;
    }

    @Override
    public Object onList(ListExp listExp) {
        return SOME_STRING;
    }

    @Override
    public Object onAnyString() {
        return ANY_STRING;
    }

    @Override
    public Object onData(DataExp dataExp) {
        XSDatatype xSDatatype;
        if (dataExp.except == Expression.nullSet && dataExp.dt instanceof XSDatatype && (xSDatatype = (XSDatatype)dataExp.dt).isAlwaysValid()) {
            return ANY_STRING;
        }
        return SOME_STRING;
    }

    @Override
    public Object onValue(ValueExp valueExp) {
        return SOME_STRING;
    }

    @Override
    public Object onChoice(ChoiceExp choiceExp) {
        return this.doChoice(choiceExp);
    }

    private Object doChoice(BinaryExp binaryExp) {
        Object object = binaryExp.exp1.visit(this);
        Object object2 = binaryExp.exp2.visit(this);
        if (object == ANY_STRING && object2 == ANY_STRING) {
            return ANY_STRING;
        }
        if (object == NO_STRING && object2 == NO_STRING) {
            return NO_STRING;
        }
        return SOME_STRING;
    }

    @Override
    public Object onOneOrMore(OneOrMoreExp oneOrMoreExp) {
        return oneOrMoreExp.exp.visit(this);
    }

    @Override
    public Object onRef(ReferenceExp referenceExp) {
        return referenceExp.exp.visit(this);
    }

    @Override
    public Object onOther(OtherExp otherExp) {
        return otherExp.exp.visit(this);
    }

    @Override
    public Object onEpsilon() {
        return NO_STRING;
    }

    @Override
    public Object onNullSet() {
        return NO_STRING;
    }

    @Override
    public Object onSequence(SequenceExp sequenceExp) {
        if (!sequenceExp.exp1.isEpsilonReducible()) {
            return sequenceExp.exp1.visit(this);
        }
        return this.doChoice(sequenceExp);
    }

    @Override
    public Object onConcur(ConcurExp concurExp) {
        Object object = concurExp.exp1.visit(this);
        Object object2 = concurExp.exp2.visit(this);
        if (object == ANY_STRING && object2 == ANY_STRING) {
            return ANY_STRING;
        }
        if (object == NO_STRING || object2 == NO_STRING) {
            return NO_STRING;
        }
        return SOME_STRING;
    }

    @Override
    public Object onInterleave(InterleaveExp interleaveExp) {
        return this.doChoice(interleaveExp);
    }

    public static int calc(Expression expression) {
        Object object = expression.visit(theInstance);
        if (object == ANY_STRING) {
            return 1;
        }
        if (object == NO_STRING) {
            return 0;
        }
        return 2;
    }
}

