/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.reader.util;

import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv.org_isorelax.verifier.Schema;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv.org_isorelax.verifier.Verifier;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv.org_isorelax.verifier.VerifierConfigurationException;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv.org_isorelax.verifier.VerifierFilter;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.grammar.ExpressionPool;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.grammar.Grammar;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.grammar.xmlschema.XMLSchemaGrammar;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.reader.Controller;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.reader.GrammarReader;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.reader.GrammarReaderController;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.reader.dtd.DTDReader;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.reader.relax.core.RELAXCoreReader;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.reader.trex.classic.TREXGrammarReader;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.reader.trex.ng.comp.RELAXNGCompReader;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.reader.xmlschema.XMLSchemaReader;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.relaxns.reader.RELAXNSReader;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.util.Util;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.verifier.jaxp.SAXParserFactoryImpl;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.verifier.regexp.REDocumentDeclaration;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.verifier.regexp.xmlschema.XSREDocDecl;
import java.io.IOException;
import java.util.Vector;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class GrammarLoader {
    private SAXParserFactory factory;
    private Controller controller;
    private ExpressionPool pool;
    private boolean strictCheck = false;

    public static REDocumentDeclaration loadVGM(String string, GrammarReaderController grammarReaderController, SAXParserFactory sAXParserFactory) throws SAXException, ParserConfigurationException, IOException {
        Grammar grammar = GrammarLoader.loadSchema(string, grammarReaderController, sAXParserFactory);
        if (grammar != null) {
            return GrammarLoader.wrapByVGM(grammar);
        }
        return null;
    }

    public static REDocumentDeclaration loadVGM(InputSource inputSource, GrammarReaderController grammarReaderController, SAXParserFactory sAXParserFactory) throws SAXException, ParserConfigurationException, IOException {
        Grammar grammar = GrammarLoader.loadSchema(inputSource, grammarReaderController, sAXParserFactory);
        if (grammar != null) {
            return GrammarLoader.wrapByVGM(grammar);
        }
        return null;
    }

    private static REDocumentDeclaration wrapByVGM(Grammar grammar) {
        if (grammar instanceof XMLSchemaGrammar) {
            return new XSREDocDecl((XMLSchemaGrammar)grammar);
        }
        return new REDocumentDeclaration(grammar);
    }

    public static REDocumentDeclaration loadVGM(String string) throws SAXException, ParserConfigurationException, IOException {
        try {
            return GrammarLoader.loadVGM(string, (GrammarReaderController)new ThrowController(), null);
        }
        catch (GrammarLoaderException grammarLoaderException) {
            throw grammarLoaderException.e;
        }
    }

    public static REDocumentDeclaration loadVGM(InputSource inputSource) throws SAXException, ParserConfigurationException, IOException {
        try {
            return GrammarLoader.loadVGM(inputSource, (GrammarReaderController)new ThrowController(), null);
        }
        catch (GrammarLoaderException grammarLoaderException) {
            throw grammarLoaderException.e;
        }
    }

    public static Grammar loadSchema(String string, GrammarReaderController grammarReaderController, SAXParserFactory sAXParserFactory) throws SAXException, ParserConfigurationException, IOException {
        GrammarLoader grammarLoader = new GrammarLoader();
        grammarLoader.setController(grammarReaderController);
        grammarLoader.setSAXParserFactory(sAXParserFactory);
        return grammarLoader.parse(string);
    }

    public static Grammar loadSchema(InputSource inputSource, GrammarReaderController grammarReaderController, SAXParserFactory sAXParserFactory) throws SAXException, ParserConfigurationException, IOException {
        GrammarLoader grammarLoader = new GrammarLoader();
        grammarLoader.setController(grammarReaderController);
        grammarLoader.setSAXParserFactory(sAXParserFactory);
        return grammarLoader.parse(inputSource);
    }

    public static Grammar loadSchema(String string, GrammarReaderController grammarReaderController) throws SAXException, ParserConfigurationException, IOException {
        GrammarLoader grammarLoader = new GrammarLoader();
        grammarLoader.setController(grammarReaderController);
        return grammarLoader.parse(string);
    }

    public static Grammar loadSchema(InputSource inputSource, GrammarReaderController grammarReaderController) throws SAXException, ParserConfigurationException, IOException {
        GrammarLoader grammarLoader = new GrammarLoader();
        grammarLoader.setController(grammarReaderController);
        return grammarLoader.parse(inputSource);
    }

    public static Grammar loadSchema(String string) throws SAXException, ParserConfigurationException, IOException {
        try {
            return GrammarLoader.loadSchema(string, (GrammarReaderController)new ThrowController(), null);
        }
        catch (GrammarLoaderException grammarLoaderException) {
            throw grammarLoaderException.e;
        }
    }

    public static Grammar loadSchema(InputSource inputSource) throws SAXException, ParserConfigurationException, IOException {
        try {
            return GrammarLoader.loadSchema(inputSource, (GrammarReaderController)new ThrowController(), null);
        }
        catch (GrammarLoaderException grammarLoaderException) {
            throw grammarLoaderException.e;
        }
    }

    public void setSAXParserFactory(SAXParserFactory sAXParserFactory) {
        this.factory = sAXParserFactory;
    }

    public SAXParserFactory getSAXParserFactory() {
        if (this.factory == null) {
            this.factory = SAXParserFactory.newInstance();
            this.factory.setNamespaceAware(true);
        }
        return this.factory;
    }

    public void setController(GrammarReaderController grammarReaderController) {
        this.controller = new Controller(grammarReaderController);
    }

    public Controller getController() {
        if (this.controller == null) {
            this.controller = new Controller(new GrammarReaderController(){

                @Override
                public void warning(Locator[] locatorArray, String string) {
                }

                @Override
                public void error(Locator[] locatorArray, String string, Exception exception) {
                }

                @Override
                public InputSource resolveEntity(String string, String string2) {
                    return null;
                }
            });
        }
        return this.controller;
    }

    public void setPool(ExpressionPool expressionPool) {
        this.pool = expressionPool;
    }

    public ExpressionPool getPool() {
        if (this.pool == null) {
            return new ExpressionPool();
        }
        return this.pool;
    }

    public void setStrictCheck(boolean bl2) {
        this.strictCheck = bl2;
    }

    public boolean getStrictCheck() {
        return this.strictCheck;
    }

    public Grammar parse(InputSource inputSource) throws SAXException, ParserConfigurationException, IOException {
        return this._loadSchema(inputSource);
    }

    public Grammar parse(String string) throws SAXException, ParserConfigurationException, IOException {
        return this._loadSchema(string);
    }

    public REDocumentDeclaration parseVGM(String string) throws SAXException, ParserConfigurationException, IOException {
        Grammar grammar = this._loadSchema(string);
        if (grammar == null) {
            return null;
        }
        return new REDocumentDeclaration(grammar);
    }

    public REDocumentDeclaration parseVGM(InputSource inputSource) throws SAXException, ParserConfigurationException, IOException {
        Grammar grammar = this._loadSchema(inputSource);
        if (grammar == null) {
            return null;
        }
        return new REDocumentDeclaration(grammar);
    }

    private boolean hasDTDextension(String string) {
        if (string == null) {
            return false;
        }
        int n2 = string.length() - 4;
        if (n2 < 0) {
            return false;
        }
        return string.substring(n2).equalsIgnoreCase(".dtd");
    }

    private Grammar _loadSchema(Object object) throws SAXException, ParserConfigurationException, IOException {
        boolean bl2 = false;
        if (object instanceof String && this.hasDTDextension((String)object)) {
            bl2 = true;
        }
        if (object instanceof InputSource && this.hasDTDextension(((InputSource)object).getSystemId())) {
            bl2 = true;
        }
        if (bl2) {
            if (object instanceof String) {
                object = Util.getInputSource((String)object);
            }
            return DTDReader.parse((InputSource)object, this.getController());
        }
        final GrammarReader[] grammarReaderArray = new GrammarReader[1];
        final XMLReader xMLReader = this.getSAXParserFactory().newSAXParser().getXMLReader();
        xMLReader.setContentHandler(new DefaultHandler(){
            private Locator locator;
            private Vector<String[]> prefixes = new Vector();

            @Override
            public void setDocumentLocator(Locator locator) {
                this.locator = locator;
            }

            @Override
            public void startPrefixMapping(String string, String string2) {
                this.prefixes.add(new String[]{string, string2});
            }

            private ContentHandler setupPipeline(Schema schema) throws SAXException {
                try {
                    Verifier verifier = schema.newVerifier();
                    verifier.setErrorHandler(GrammarLoader.this.getController());
                    verifier.setEntityResolver(GrammarLoader.this.getController());
                    VerifierFilter verifierFilter = verifier.getVerifierFilter();
                    verifierFilter.setContentHandler(grammarReaderArray[0]);
                    return (ContentHandler)((Object)verifierFilter);
                }
                catch (VerifierConfigurationException verifierConfigurationException) {
                    throw new SAXException(verifierConfigurationException);
                }
            }

            @Override
            public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
                ContentHandler contentHandler;
                Schema schema;
                if (string2.equals("module")) {
                    if (GrammarLoader.this.strictCheck) {
                        schema = RELAXCoreReader.getRELAXCoreSchema4Schema();
                        grammarReaderArray[0] = new RELAXCoreReader(GrammarLoader.this.getController(), new SAXParserFactoryImpl(GrammarLoader.this.getSAXParserFactory(), schema), GrammarLoader.this.getPool());
                        contentHandler = this.setupPipeline(schema);
                    } else {
                        grammarReaderArray[0] = new RELAXCoreReader(GrammarLoader.this.getController(), GrammarLoader.this.getSAXParserFactory(), GrammarLoader.this.getPool());
                        contentHandler = grammarReaderArray[0];
                    }
                } else if (string2.equals("schema")) {
                    if (GrammarLoader.this.strictCheck) {
                        schema = XMLSchemaReader.getXmlSchemaForXmlSchema();
                        grammarReaderArray[0] = new XMLSchemaReader(GrammarLoader.this.getController(), new SAXParserFactoryImpl(GrammarLoader.this.getSAXParserFactory(), schema), GrammarLoader.this.getPool());
                        contentHandler = this.setupPipeline(schema);
                    } else {
                        grammarReaderArray[0] = new XMLSchemaReader(GrammarLoader.this.getController(), GrammarLoader.this.getSAXParserFactory(), GrammarLoader.this.getPool());
                        contentHandler = grammarReaderArray[0];
                    }
                } else if ("http://www.xml.gr.jp/xmlns/relaxNamespace".equals(string)) {
                    grammarReaderArray[0] = new RELAXNSReader(GrammarLoader.this.getController(), GrammarLoader.this.getSAXParserFactory(), GrammarLoader.this.getPool());
                    contentHandler = grammarReaderArray[0];
                } else if ("http://www.thaiopensource.com/trex".equals(string) || string.equals("")) {
                    grammarReaderArray[0] = new TREXGrammarReader(GrammarLoader.this.getController(), GrammarLoader.this.getSAXParserFactory(), GrammarLoader.this.getPool());
                    contentHandler = grammarReaderArray[0];
                } else if (GrammarLoader.this.strictCheck) {
                    schema = RELAXNGCompReader.getRELAXNGSchema4Schema();
                    grammarReaderArray[0] = new RELAXNGCompReader(GrammarLoader.this.getController(), new SAXParserFactoryImpl(GrammarLoader.this.getSAXParserFactory(), schema), GrammarLoader.this.getPool());
                    contentHandler = this.setupPipeline(schema);
                } else {
                    grammarReaderArray[0] = new RELAXNGCompReader(GrammarLoader.this.getController(), GrammarLoader.this.getSAXParserFactory(), GrammarLoader.this.getPool());
                    contentHandler = grammarReaderArray[0];
                }
                contentHandler.setDocumentLocator(this.locator);
                contentHandler.startDocument();
                for (int i2 = 0; i2 < this.prefixes.size(); ++i2) {
                    String[] stringArray = this.prefixes.get(i2);
                    contentHandler.startPrefixMapping(stringArray[0], stringArray[1]);
                }
                contentHandler.startElement(string, string2, string3, attributes);
                xMLReader.setContentHandler(contentHandler);
            }
        });
        xMLReader.setErrorHandler(this.getController());
        xMLReader.setEntityResolver(this.getController());
        if (object instanceof String) {
            xMLReader.parse((String)object);
        } else {
            xMLReader.parse((InputSource)object);
        }
        if (this.getController().hadError()) {
            return null;
        }
        return grammarReaderArray[0].getResultAsGrammar();
    }

    private static class ThrowController
    implements GrammarReaderController {
        private ThrowController() {
        }

        @Override
        public void warning(Locator[] locatorArray, String string) {
        }

        @Override
        public void error(Locator[] locatorArray, String string, Exception exception) {
            for (int i2 = 0; i2 < locatorArray.length; ++i2) {
                if (locatorArray[i2] == null) continue;
                throw new GrammarLoaderException(new SAXParseException(string, locatorArray[i2], exception));
            }
            throw new GrammarLoaderException(new SAXException(string, exception));
        }

        @Override
        public InputSource resolveEntity(String string, String string2) {
            return null;
        }
    }

    private static class GrammarLoaderException
    extends RuntimeException {
        public final SAXException e;

        GrammarLoaderException(SAXException sAXException) {
            super(sAXException.getMessage());
            this.e = sAXException;
        }
    }
}

