/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.reader.dtd;

import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv.relaxng_datatype.Datatype;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv.relaxng_datatype.DatatypeException;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv.relaxng_datatype.DatatypeLibrary;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.datatype.xsd.ngimpl.DataTypeLibraryImpl;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.grammar.ChoiceNameClass;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.grammar.Expression;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.grammar.ExpressionPool;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.grammar.NameClass;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.grammar.ReferenceExp;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.grammar.SimpleNameClass;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.grammar.dtd.LocalNameClass;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.grammar.trex.ElementPattern;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.grammar.trex.TREXGrammar;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.reader.Controller;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.reader.GrammarReaderController;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.reader.dtd.Localizer;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.scanner.dtd.DTDEventListener;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.scanner.dtd.DTDParser;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.scanner.dtd.InputEntity;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.util.StringPair;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.LocatorImpl;

public class DTDReader
implements DTDEventListener {
    protected final Controller controller;
    private DatatypeLibrary datatypeLibrary = new DataTypeLibraryImpl();
    protected final Map<String, Set<String>> namespaces = DTDReader.createInitialNamespaceMap();
    protected static final String ABANDON_URI_SNIFFING = "*";
    protected final TREXGrammar grammar;
    protected Locator locator;
    protected final Map<String, Object> elementDecls = new HashMap<String, Object>();
    protected final Map<String, Map<String, Object>> attributeDecls = new HashMap<String, Map<String, Object>>();
    protected Context contextStack;
    protected Expression contentModel;
    protected short connectorType;
    protected final short CONNECTOR_UNKNOWN = (short)-999;
    private boolean reportedXmlnsWarning = false;
    private final Map<Object, Locator> declaredLocations = new HashMap<Object, Locator>();
    public static final String ERR_UNDEFINED_ELEMENT = "DTDReader.UndefinedElement";
    public static final String WRN_ATTEMPT_TO_USE_NAMESPACE = "DTDReader.Warning.AttemptToUseNamespace";
    public static final String ERR_UNDECLARED_PREFIX = "DTDReader.UndeclaredPrefix";

    public DTDReader(GrammarReaderController grammarReaderController, ExpressionPool expressionPool) {
        this.controller = new Controller(grammarReaderController);
        this.grammar = new TREXGrammar(expressionPool);
    }

    public static TREXGrammar parse(InputSource inputSource, GrammarReaderController grammarReaderController) {
        return DTDReader.parse(inputSource, grammarReaderController, new ExpressionPool());
    }

    public static TREXGrammar parse(InputSource inputSource, GrammarReaderController grammarReaderController, ExpressionPool expressionPool) {
        try {
            DTDReader dTDReader = new DTDReader(grammarReaderController, expressionPool);
            DTDParser dTDParser = new DTDParser();
            dTDParser.setDtdHandler(dTDReader);
            dTDParser.setEntityResolver(grammarReaderController);
            dTDParser.parse(inputSource);
            return dTDReader.getResult();
        }
        catch (SAXParseException sAXParseException) {
            return null;
        }
        catch (Exception exception) {
            grammarReaderController.error(new Locator[0], exception.getMessage(), exception);
            return null;
        }
    }

    public void setDatatypeLibrary(DatatypeLibrary datatypeLibrary) {
        this.datatypeLibrary = datatypeLibrary;
    }

    public Datatype createDatatype(String string) {
        try {
            if ("CDATA".equals(string)) {
                return this.datatypeLibrary.createDatatype("normalizedString");
            }
            if ("ENUMERATION".equals(string)) {
                return this.datatypeLibrary.createDatatype("token");
            }
            return this.datatypeLibrary.createDatatype(string);
        }
        catch (DatatypeException datatypeException) {
            datatypeException.printStackTrace();
            throw new InternalError();
        }
    }

    protected static final Map<String, Set<String>> createInitialNamespaceMap() {
        HashMap<String, Set<String>> hashMap = new HashMap<String, Set<String>>();
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add("http://www.w3.org/XML/1998/namespace");
        hashMap.put("xml", hashSet);
        return hashMap;
    }

    protected NameClass getNameClass(String string, boolean bl2) {
        String[] stringArray = this.splitQName(string);
        if (stringArray[0].length() == 0 && bl2) {
            return new SimpleNameClass(stringArray[0], stringArray[1]);
        }
        Set<String> set = this.namespaces.get(stringArray[0]);
        if (set == null) {
            if (stringArray[0].equals("")) {
                return new SimpleNameClass("", stringArray[1]);
            }
            this.controller.error(new Locator[]{this.locator}, Localizer.localize(ERR_UNDECLARED_PREFIX, stringArray[0]), null);
            return new LocalNameClass(stringArray[1]);
        }
        if (set.contains(ABANDON_URI_SNIFFING)) {
            return new LocalNameClass(stringArray[1]);
        }
        String[] stringArray2 = set.toArray(new String[set.size()]);
        NameClass nameClass = new SimpleNameClass(stringArray2[0], stringArray[1]);
        for (int i2 = 1; i2 < set.size(); ++i2) {
            nameClass = new ChoiceNameClass(nameClass, new SimpleNameClass(stringArray2[i2], stringArray[1]));
        }
        return nameClass;
    }

    protected String[] splitQName(String string) {
        int n2 = string.indexOf(58);
        if (n2 < 0) {
            return new String[]{"", string};
        }
        return new String[]{string.substring(0, n2), string.substring(n2 + 1)};
    }

    public TREXGrammar getResult() {
        if (this.controller.hadError()) {
            return null;
        }
        return this.grammar;
    }

    @Override
    public void setDocumentLocator(Locator locator) {
        this.locator = locator;
    }

    @Override
    public void startContentModel(String string, short s2) {
        if (this.contentModel != null) {
            throw new Error();
        }
        if (s2 == 2) {
            this.contentModel = Expression.nullSet;
        }
        if (s2 == 1) {
            this.contentModel = this.getAnyExp();
        }
        if (s2 == 0) {
            this.contentModel = Expression.epsilon;
        }
    }

    protected final ReferenceExp getAnyExp() {
        return this.grammar.namedPatterns.getOrCreate("$  all  $");
    }

    @Override
    public void endContentModel(String string, short s2) {
        if (this.contentModel == null) {
            throw new Error();
        }
        switch (s2) {
            case 1: 
            case 3: {
                break;
            }
            case 0: {
                this.contentModel = Expression.epsilon;
                break;
            }
            case 2: {
                this.contentModel = this.contentModel != Expression.nullSet ? this.grammar.pool.createMixed(this.grammar.pool.createZeroOrMore(this.contentModel)) : Expression.anyString;
            }
        }
        this.setDeclaredLocationOf(this.grammar.namedPatterns.getOrCreate(string));
        this.elementDecls.put(string, this.contentModel);
        this.contentModel = null;
    }

    protected Expression processOccurs(Expression expression, short s2) {
        switch (s2) {
            case 3: {
                return expression;
            }
            case 1: {
                return this.grammar.pool.createOneOrMore(expression);
            }
            case 0: {
                return this.grammar.pool.createZeroOrMore(expression);
            }
            case 2: {
                return this.grammar.pool.createOptional(expression);
            }
        }
        throw new Error();
    }

    @Override
    public void childElement(String string, short s2) {
        Expression expression = this.processOccurs(this.grammar.namedPatterns.getOrCreate(string), s2);
        if (this.connectorType == -999) {
            if (this.contentModel != null) {
                throw new Error();
            }
            this.contentModel = expression;
        } else {
            this.combineToContentModel(expression);
        }
    }

    protected void combineToContentModel(Expression expression) {
        switch (this.connectorType) {
            case 0: {
                this.contentModel = this.grammar.pool.createChoice(this.contentModel, expression);
                break;
            }
            case 1: {
                this.contentModel = this.grammar.pool.createSequence(this.contentModel, expression);
                break;
            }
            default: {
                throw new Error();
            }
        }
    }

    @Override
    public void mixedElement(String string) {
        if (this.contentModel == null) {
            throw new Error();
        }
        this.contentModel = this.grammar.pool.createChoice(this.contentModel, this.grammar.namedPatterns.getOrCreate(string));
    }

    @Override
    public void startModelGroup() {
        this.contextStack = new Context(this.contextStack, this.contentModel, this.connectorType);
        this.contentModel = null;
        this.connectorType = (short)-999;
    }

    @Override
    public void endModelGroup(short s2) {
        Expression expression = this.processOccurs(this.contentModel, s2);
        this.contentModel = this.contextStack.exp;
        this.connectorType = this.contextStack.connectorType;
        this.contextStack = this.contextStack.previous;
        if (this.contentModel == null) {
            this.contentModel = expression;
        } else {
            this.combineToContentModel(expression);
        }
    }

    @Override
    public void connector(short s2) throws SAXException {
        if (this.connectorType == -999) {
            this.connectorType = s2;
        } else if (this.connectorType != s2) {
            throw new Error();
        }
    }

    private Set<String> getPossibleNamespaces(String string) {
        Set<String> set = this.namespaces.get(string);
        if (set == null) {
            set = new HashSet<String>();
            this.namespaces.put(string, set);
        }
        return set;
    }

    @Override
    public void attributeDecl(String string, String string2, String string3, String[] stringArray, short s2, String string4) throws SAXException {
        if (string2.startsWith("xmlns")) {
            if (!this.reportedXmlnsWarning) {
                this.controller.warning(new Locator[]{this.locator}, Localizer.localize(WRN_ATTEMPT_TO_USE_NAMESPACE));
            }
            this.reportedXmlnsWarning = true;
            if (string4 == null) {
                string4 = ABANDON_URI_SNIFFING;
            }
            Set<String> set = string2.equals("xmlns") ? this.getPossibleNamespaces("") : this.getPossibleNamespaces(string2.substring(6));
            set.add(string4);
            return;
        }
        Map<String, Object> map = this.attributeDecls.get(string);
        if (map == null) {
            map = new HashMap<String, Object>();
            this.attributeDecls.put(string, map);
        }
        Expression expression = this.createAttributeBody(string, string2, string3, stringArray, s2, string4);
        AttModel attModel = new AttModel(expression, s2 == 3);
        this.setDeclaredLocationOf(attModel);
        map.put(string2, attModel);
    }

    protected Expression createAttributeBody(String string, String string2, String string3, String[] stringArray, short s2, String string4) throws SAXException {
        Datatype datatype = this.createDatatype(string3);
        StringPair stringPair = new StringPair("", string3);
        if (stringArray != null) {
            Expression expression = Expression.nullSet;
            for (int i2 = 0; i2 < stringArray.length; ++i2) {
                expression = this.grammar.pool.createChoice(expression, this.grammar.pool.createValue(datatype, stringPair, datatype.createValue(stringArray[i2], null)));
            }
            return expression;
        }
        if (s2 == 2) {
            return this.grammar.pool.createValue(datatype, stringPair, datatype.createValue(string4, null));
        }
        return this.grammar.pool.createData(datatype, stringPair);
    }

    protected ReferenceExp createElementDeclaration(String string) {
        Map<String, Object> map = this.attributeDecls.get(string);
        Expression expression = Expression.epsilon;
        if (map != null) {
            for (String string2 : map.keySet()) {
                AttModel attModel = (AttModel)map.get(string2);
                Expression expression2 = this.grammar.pool.createAttribute(this.getNameClass(string2, true), attModel.value, null);
                if (!attModel.required) {
                    expression2 = this.grammar.pool.createOptional(expression2);
                }
                expression = this.grammar.pool.createSequence(expression, expression2);
            }
        }
        ReferenceExp referenceExp = this.grammar.namedPatterns.getOrCreate(string);
        referenceExp.exp = new ElementPattern(this.getNameClass(string, false), this.grammar.pool.createSequence(expression, (Expression)this.elementDecls.get(string)));
        this.declaredLocations.put(referenceExp.exp, this.getDeclaredLocationOf(referenceExp));
        return referenceExp;
    }

    protected Expression createElementDeclarations() {
        Expression expression = Expression.nullSet;
        Iterator<String> iterator = this.elementDecls.keySet().iterator();
        while (iterator.hasNext()) {
            ReferenceExp referenceExp = this.createElementDeclaration(iterator.next());
            expression = this.grammar.pool.createChoice(expression, referenceExp);
        }
        return expression;
    }

    @Override
    public void endDTD() throws SAXException {
        Expression expression = this.createElementDeclarations();
        this.getAnyExp().exp = this.grammar.pool.createMixed(this.grammar.pool.createZeroOrMore(expression));
        this.grammar.exp = expression;
        ReferenceExp[] referenceExpArray = this.grammar.namedPatterns.getAll();
        for (int i2 = 0; i2 < referenceExpArray.length; ++i2) {
            if (referenceExpArray[i2].exp != null) continue;
            this.controller.error(new Locator[]{this.locator}, Localizer.localize(ERR_UNDEFINED_ELEMENT, new Object[]{referenceExpArray[i2].name}), null);
        }
    }

    @Override
    public void fatalError(SAXParseException sAXParseException) throws SAXException {
        this.controller.fatalError(sAXParseException);
    }

    @Override
    public void error(SAXParseException sAXParseException) throws SAXException {
        this.controller.error(sAXParseException);
    }

    @Override
    public void warning(SAXParseException sAXParseException) throws SAXException {
        this.controller.warning(sAXParseException);
    }

    public void setDeclaredLocationOf(Object object) {
        this.declaredLocations.put(object, new LocatorImpl(this.locator));
    }

    public Locator getDeclaredLocationOf(Object object) {
        return this.declaredLocations.get(object);
    }

    public boolean isUnparsedEntity(String string) {
        return true;
    }

    public String resolveNamespacePrefix(String string) {
        throw new Error();
    }

    @Override
    public void processingInstruction(String string, String string2) throws SAXException {
    }

    @Override
    public void notationDecl(String string, String string2, String string3) throws SAXException {
    }

    @Override
    public void unparsedEntityDecl(String string, String string2, String string3, String string4) throws SAXException {
    }

    @Override
    public void externalGeneralEntityDecl(String string, String string2, String string3) throws SAXException {
    }

    @Override
    public void internalGeneralEntityDecl(String string, String string2) throws SAXException {
    }

    @Override
    public void externalParameterEntityDecl(String string, String string2, String string3) throws SAXException {
    }

    @Override
    public void internalParameterEntityDecl(String string, String string2) throws SAXException {
    }

    @Override
    public void startDTD(InputEntity inputEntity) throws SAXException {
    }

    @Override
    public void comment(String string) throws SAXException {
    }

    @Override
    public void characters(char[] cArray, int n2, int n3) throws SAXException {
    }

    @Override
    public void ignorableWhitespace(char[] cArray, int n2, int n3) throws SAXException {
    }

    @Override
    public void startCDATA() throws SAXException {
    }

    @Override
    public void endCDATA() throws SAXException {
    }

    protected class Context {
        final Expression exp;
        final short connectorType;
        final Context previous;

        Context(Context context, Expression expression, short s2) {
            this.exp = expression;
            this.connectorType = s2;
            this.previous = context;
        }
    }

    private static class AttModel {
        Expression value;
        boolean required;

        AttModel(Expression expression, boolean bl2) {
            this.value = expression;
            this.required = bl2;
        }
    }
}

