/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.com.ctc.wstx.io;

import com.gradle.maven.extension.internal.dep.com.ctc.wstx.io.SystemId;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.util.StringUtil;
import com.gradle.maven.extension.internal.dep.org.codehaus.stax2.XMLStreamLocation2;
import java.io.Serializable;

public class WstxInputLocation
implements Serializable,
XMLStreamLocation2 {
    private static final long serialVersionUID = 1L;
    private static final WstxInputLocation sEmptyLocation = new WstxInputLocation(null, "", "", -1L, -1, -1);
    protected final WstxInputLocation mContext;
    protected final String mPublicId;
    protected final String mSystemId;
    protected final long mCharOffset;
    protected final int mCol;
    protected final int mRow;
    protected transient String mDesc = null;

    public WstxInputLocation(WstxInputLocation wstxInputLocation, String string, String string2, long l2, int n2, int n3) {
        this.mContext = wstxInputLocation;
        this.mPublicId = string;
        this.mSystemId = string2;
        this.mCharOffset = l2;
        this.mCol = n3;
        this.mRow = n2;
    }

    public WstxInputLocation(WstxInputLocation wstxInputLocation, String string, SystemId systemId, long l2, int n2, int n3) {
        this.mContext = wstxInputLocation;
        this.mPublicId = string;
        this.mSystemId = systemId == null ? "N/A" : systemId.toString();
        this.mCharOffset = l2;
        this.mCol = n3;
        this.mRow = n2;
    }

    public static WstxInputLocation getEmptyLocation() {
        return sEmptyLocation;
    }

    public long getCharacterOffsetLong() {
        return this.mCharOffset;
    }

    @Override
    public int getCharacterOffset() {
        return (int)this.mCharOffset;
    }

    @Override
    public int getColumnNumber() {
        return this.mCol;
    }

    @Override
    public int getLineNumber() {
        return this.mRow;
    }

    @Override
    public String getPublicId() {
        return this.mPublicId;
    }

    @Override
    public String getSystemId() {
        return this.mSystemId;
    }

    @Override
    public XMLStreamLocation2 getContext() {
        return this.mContext;
    }

    public String toString() {
        if (this.mDesc == null) {
            StringBuilder stringBuilder = this.mContext != null ? new StringBuilder(200) : new StringBuilder(80);
            this.appendDesc(stringBuilder);
            this.mDesc = stringBuilder.toString();
        }
        return this.mDesc;
    }

    public int hashCode() {
        return (int)this.mCharOffset ^ (int)(0xFFFFFFFFFFFFFFFFL & this.mCharOffset >> 32) ^ this.mRow ^ this.mCol + (this.mCol << 3);
    }

    public boolean equals(Object object) {
        if (!(object instanceof WstxInputLocation)) {
            return false;
        }
        WstxInputLocation wstxInputLocation = (WstxInputLocation)object;
        if (wstxInputLocation.getCharacterOffsetLong() != this.getCharacterOffsetLong()) {
            return false;
        }
        String string = wstxInputLocation.getPublicId();
        if (string == null) {
            string = "";
        }
        if (!string.equals(this.mPublicId)) {
            return false;
        }
        String string2 = wstxInputLocation.getSystemId();
        if (string2 == null) {
            string2 = "";
        }
        return string2.equals(this.mSystemId);
    }

    private void appendDesc(StringBuilder stringBuilder) {
        String string;
        if (this.mSystemId != null) {
            stringBuilder.append("[row,col,system-id]: ");
            string = this.mSystemId;
        } else if (this.mPublicId != null) {
            stringBuilder.append("[row,col,public-id]: ");
            string = this.mPublicId;
        } else {
            stringBuilder.append("[row,col {unknown-source}]: ");
            string = null;
        }
        stringBuilder.append('[');
        stringBuilder.append(this.mRow);
        stringBuilder.append(',');
        stringBuilder.append(this.mCol);
        if (string != null) {
            stringBuilder.append(',');
            stringBuilder.append('\"');
            stringBuilder.append(string);
            stringBuilder.append('\"');
        }
        stringBuilder.append(']');
        if (this.mContext != null) {
            StringUtil.appendLF(stringBuilder);
            stringBuilder.append(" from ");
            this.mContext.appendDesc(stringBuilder);
        }
    }
}

